/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.scene.web;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.util.Utils;
import javafx.scene.Node;
import javafx.scene.web.WebView;

public class WebViewHelper
extends ParentHelper {
    private static final WebViewHelper theInstance = new WebViewHelper();
    private static WebViewAccessor webViewAccessor;

    private static WebViewHelper getInstance() {
        return theInstance;
    }

    public static void initHelper(WebView webView) {
        WebViewHelper.setHelper((Node)webView, (NodeHelper)WebViewHelper.getInstance());
    }

    protected NGNode createPeerImpl(Node node) {
        return webViewAccessor.doCreatePeer(node);
    }

    protected void updatePeerImpl(Node node) {
        super.updatePeerImpl(node);
        webViewAccessor.doUpdatePeer(node);
    }

    protected void transformsChangedImpl(Node node) {
        super.transformsChangedImpl(node);
        webViewAccessor.doTransformsChanged(node);
    }

    protected BaseBounds computeGeomBoundsImpl(Node node, BaseBounds bounds, BaseTransform tx) {
        return webViewAccessor.doComputeGeomBounds(node, bounds, tx);
    }

    protected boolean computeContainsImpl(Node node, double localX, double localY) {
        return webViewAccessor.doComputeContains(node, localX, localY);
    }

    protected void pickNodeLocalImpl(Node node, PickRay localPickRay, PickResultChooser result) {
        webViewAccessor.doPickNodeLocal(node, localPickRay, result);
    }

    public static void setWebViewAccessor(WebViewAccessor newAccessor) {
        if (webViewAccessor != null) {
            throw new IllegalStateException();
        }
        webViewAccessor = newAccessor;
    }

    static {
        Utils.forceInit(WebView.class);
    }

    public static interface WebViewAccessor {
        public NGNode doCreatePeer(Node var1);

        public void doUpdatePeer(Node var1);

        public void doTransformsChanged(Node var1);

        public BaseBounds doComputeGeomBounds(Node var1, BaseBounds var2, BaseTransform var3);

        public boolean doComputeContains(Node var1, double var2, double var4);

        public void doPickNodeLocal(Node var1, PickRay var2, PickResultChooser var3);
    }
}

