/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit;

import com.sun.javafx.tk.Toolkit;
import com.sun.webkit.Pasteboard;
import com.sun.webkit.graphics.WCImage;
import com.sun.webkit.graphics.WCImageFrame;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javafx.scene.image.Image;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javax.imageio.ImageIO;

final class PasteboardImpl
implements Pasteboard {
    private final Clipboard clipboard = Clipboard.getSystemClipboard();

    PasteboardImpl() {
    }

    @Override
    public String getPlainText() {
        return this.clipboard.getString();
    }

    @Override
    public String getHtml() {
        return this.clipboard.getHtml();
    }

    @Override
    public void writePlainText(String text) {
        ClipboardContent content = new ClipboardContent();
        content.putString(text);
        this.clipboard.setContent((Map)content);
    }

    @Override
    public void writeSelection(boolean canSmartCopyOrDelete, String text, String html) {
        ClipboardContent content = new ClipboardContent();
        content.putString(text);
        content.putHtml(html);
        this.clipboard.setContent((Map)content);
    }

    @Override
    public void writeImage(WCImageFrame frame) {
        Image fxImage;
        WCImage img = frame.getFrame();
        Image image = fxImage = img != null && !img.isNull() ? Toolkit.getImageAccessor().fromPlatformImage(img.getPlatformImage()) : null;
        if (fxImage != null) {
            ClipboardContent content = new ClipboardContent();
            content.putImage(fxImage);
            String fileExtension = img.getFileExtension();
            try {
                File imageDump = File.createTempFile("jfx", "." + fileExtension);
                imageDump.deleteOnExit();
                ImageIO.write((RenderedImage)img.toBufferedImage(), fileExtension, imageDump);
                content.putFiles(Arrays.asList(imageDump));
            }
            catch (IOException | SecurityException exception) {
                // empty catch block
            }
            this.clipboard.setContent((Map)content);
        }
    }

    @Override
    public void writeUrl(String url, String markup) {
        ClipboardContent content = new ClipboardContent();
        content.putString(url);
        content.putHtml(markup);
        content.putUrl(url);
        this.clipboard.setContent((Map)content);
    }
}

