/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGRectangle;
import com.sun.javafx.sg.prism.NodeEffectInput;
import com.sun.javafx.webkit.prism.PrismGraphicsManager;
import com.sun.javafx.webkit.prism.PrismImage;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext;
import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.scenario.effect.DropShadow;
import com.sun.scenario.effect.Effect;
import com.sun.webkit.graphics.WCImage;
import com.sun.webkit.graphics.WCTransform;

final class WCBufferedContext
extends WCGraphicsPrismContext {
    private final PrismImage img;
    private boolean isInitialized;
    private final RectBounds TEMP_BOUNDS = new RectBounds();
    private final NGRectangle TEMP_NGRECT = new NGRectangle();
    private final RoundRectangle2D TEMP_RECT = new RoundRectangle2D();
    private final float[] TEMP_COORDS = new float[6];

    WCBufferedContext(PrismImage img) {
        this.img = img;
    }

    @Override
    public WCGraphicsPrismContext.Type type() {
        return WCGraphicsPrismContext.Type.DEDICATED;
    }

    @Override
    public WCImage getImage() {
        return this.img;
    }

    @Override
    Graphics getGraphics(boolean checkClip) {
        this.init();
        if (this.baseGraphics == null) {
            this.baseGraphics = this.img.getGraphics();
        }
        return super.getGraphics(checkClip);
    }

    @Override
    protected boolean shouldCalculateIntersection() {
        return this.baseGraphics == null;
    }

    @Override
    protected boolean shouldRenderRect(float x, float y, float w, float h, DropShadow shadow, BasicStroke stroke) {
        if (!this.shouldCalculateIntersection()) {
            return true;
        }
        if (shadow != null) {
            this.TEMP_RECT.setFrame(x, y, w, h);
            return this.shouldRenderShape((Shape)this.TEMP_RECT, shadow, stroke);
        }
        if (stroke != null) {
            float s = 0.0f;
            float sx2 = 0.0f;
            switch (stroke.getType()) {
                case 0: {
                    sx2 = stroke.getLineWidth();
                    s = sx2 / 2.0f;
                    break;
                }
                case 2: {
                    s = stroke.getLineWidth();
                    sx2 = s * 2.0f;
                    break;
                }
                case 1: {
                    break;
                }
            }
            x -= s;
            y -= s;
            w += sx2;
            h += sx2;
        }
        this.TEMP_BOUNDS.setBounds(x, y, x + w, y + h);
        return this.trIntersectsClip(this.TEMP_BOUNDS, (BaseTransform)this.getTransformNoClone());
    }

    @Override
    protected boolean shouldRenderShape(Shape shape, DropShadow shadow, BasicStroke stroke) {
        if (!this.shouldCalculateIntersection()) {
            return true;
        }
        BaseTransform accumTX = shadow != null ? BaseTransform.IDENTITY_TRANSFORM : this.getTransformNoClone();
        this.TEMP_COORDS[1] = Float.POSITIVE_INFINITY;
        this.TEMP_COORDS[0] = Float.POSITIVE_INFINITY;
        this.TEMP_COORDS[3] = Float.NEGATIVE_INFINITY;
        this.TEMP_COORDS[2] = Float.NEGATIVE_INFINITY;
        if (stroke == null) {
            Shape.accumulate((float[])this.TEMP_COORDS, (Shape)shape, (BaseTransform)accumTX);
        } else {
            stroke.accumulateShapeBounds(this.TEMP_COORDS, shape, accumTX);
        }
        this.TEMP_BOUNDS.setBounds(this.TEMP_COORDS[0], this.TEMP_COORDS[1], this.TEMP_COORDS[2], this.TEMP_COORDS[3]);
        Affine3D tx = null;
        if (shadow != null) {
            this.TEMP_NGRECT.updateRectangle(this.TEMP_BOUNDS.getMinX(), this.TEMP_BOUNDS.getMinY(), this.TEMP_BOUNDS.getWidth(), this.TEMP_BOUNDS.getHeight(), 0.0f, 0.0f);
            this.TEMP_NGRECT.setContentBounds((BaseBounds)this.TEMP_BOUNDS);
            BaseBounds bb = shadow.getBounds(BaseTransform.IDENTITY_TRANSFORM, (Effect)new NodeEffectInput((NGNode)this.TEMP_NGRECT));
            assert (bb.getBoundsType() == BaseBounds.BoundsType.RECTANGLE);
            this.TEMP_BOUNDS.setBounds((RectBounds)bb);
            tx = this.getTransformNoClone();
        }
        return this.trIntersectsClip(this.TEMP_BOUNDS, (BaseTransform)tx);
    }

    private boolean trIntersectsClip(RectBounds bounds, BaseTransform tx) {
        Rectangle clip;
        if (tx != null && !tx.isIdentity()) {
            tx.transform((BaseBounds)bounds, (BaseBounds)bounds);
        }
        if ((clip = this.getClipRectNoClone()) != null) {
            return bounds.intersects((float)clip.x, (float)clip.y, (float)(clip.x + clip.width), (float)(clip.y + clip.height));
        }
        if (this.img != null) {
            return bounds.intersects(0.0f, 0.0f, (float)this.img.getWidth() * this.img.getPixelScale(), (float)this.img.getHeight() * this.img.getPixelScale());
        }
        return false;
    }

    @Override
    public void saveState() {
        this.init();
        super.saveState();
    }

    @Override
    public void scale(float sx, float sy) {
        this.init();
        super.scale(sx, sy);
    }

    @Override
    public void setTransform(WCTransform tm) {
        this.init();
        super.setTransform(tm);
    }

    private void init() {
        if (!this.isInitialized) {
            BaseTransform t = PrismGraphicsManager.getPixelScaleTransform();
            this.initBaseTransform(t);
            this.setClip(0, 0, this.img.getWidth(), this.img.getHeight());
            this.isInitialized = true;
        }
    }

    @Override
    public void dispose() {
    }
}

