/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.glass.ui.Screen;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Line2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.sg.prism.NGImageView;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGPath;
import com.sun.javafx.sg.prism.NGRectangle;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.javafx.sg.prism.NGText;
import com.sun.javafx.text.TextRun;
import com.sun.javafx.webkit.prism.PrismImage;
import com.sun.javafx.webkit.prism.TextUtilities;
import com.sun.javafx.webkit.prism.WCLinearGradient;
import com.sun.javafx.webkit.prism.WCPathImpl;
import com.sun.javafx.webkit.prism.WCRadialGradient;
import com.sun.javafx.webkit.prism.WCStrokeImpl;
import com.sun.prism.BasicStroke;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.MaskTextureGraphics;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackGraphics;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.Paint;
import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.DropShadow;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrEffectHelper;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.scenario.effect.impl.prism.PrRenderer;
import com.sun.webkit.graphics.Ref;
import com.sun.webkit.graphics.RenderTheme;
import com.sun.webkit.graphics.ScrollBarTheme;
import com.sun.webkit.graphics.WCFont;
import com.sun.webkit.graphics.WCGradient;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCIcon;
import com.sun.webkit.graphics.WCImage;
import com.sun.webkit.graphics.WCPath;
import com.sun.webkit.graphics.WCPoint;
import com.sun.webkit.graphics.WCRectangle;
import com.sun.webkit.graphics.WCSize;
import com.sun.webkit.graphics.WCTransform;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;

class WCGraphicsPrismContext
extends WCGraphicsContext {
    private static final PlatformLogger log = PlatformLogger.getLogger((String)WCGraphicsPrismContext.class.getName());
    private static final boolean DEBUG_DRAW_CLIP_SHAPE = Boolean.valueOf(AccessController.doPrivileged(() -> System.getProperty("com.sun.webkit.debugDrawClipShape", "false")));
    Graphics baseGraphics;
    private BaseTransform baseTransform;
    private final List<ContextState> states = new ArrayList<ContextState>();
    private ContextState state = new ContextState();
    private Graphics cachedGraphics = null;
    private int fontSmoothingType;
    private boolean isRootLayerValid = false;
    private static final BasicStroke focusRingStroke = new BasicStroke(1.1f, 0, 1, 0.0f, new float[]{1.0f}, 0.0f);

    WCGraphicsPrismContext(Graphics g) {
        this.state.setClip(g.getClipRect());
        this.state.setAlpha(g.getExtraAlpha());
        this.baseGraphics = g;
        this.initBaseTransform(g.getTransformNoClone());
    }

    WCGraphicsPrismContext() {
    }

    public Type type() {
        return Type.PRIMARY;
    }

    final void initBaseTransform(BaseTransform t) {
        this.baseTransform = new Affine3D(t);
        this.state.setTransform((Affine3D)this.baseTransform);
    }

    private void resetCachedGraphics() {
        this.cachedGraphics = null;
    }

    @Override
    public Object getPlatformGraphics() {
        return this.getGraphics(false);
    }

    @Override
    public boolean isValid() {
        Object platformGraphics = this.getPlatformGraphics();
        if (!(platformGraphics instanceof Graphics)) {
            return false;
        }
        Graphics g = (Graphics)platformGraphics;
        return !g.getResourceFactory().isDisposed();
    }

    Graphics getGraphics(boolean checkClip) {
        if (this.cachedGraphics == null) {
            Layer l = this.state.getLayerNoClone();
            this.cachedGraphics = l != null ? l.getGraphics() : this.baseGraphics;
            ResourceFactory rf = this.cachedGraphics.getResourceFactory();
            if (!rf.isDisposed()) {
                this.state.apply(this.cachedGraphics);
            }
            if (log.isLoggable(PlatformLogger.Level.FINE)) {
                log.fine("getPlatformGraphics for " + this + " : " + this.cachedGraphics);
            }
        }
        Rectangle clip = this.cachedGraphics.getClipRectNoClone();
        return checkClip && clip != null && clip.isEmpty() ? null : this.cachedGraphics;
    }

    @Override
    public void saveState() {
        this.state.markAsRestorePoint();
        this.saveStateInternal();
    }

    private void saveStateInternal() {
        this.states.add(this.state);
        this.state = this.state.clone();
    }

    private void startNewLayer(Layer layer) {
        this.saveStateInternal();
        Rectangle clip = this.state.getClipNoClone();
        Affine3D newTr = new Affine3D(BaseTransform.getTranslateInstance((double)(-clip.x), (double)(-clip.y)));
        newTr.concatenate((BaseTransform)this.state.getTransformNoClone());
        clip.x = 0;
        clip.y = 0;
        Graphics g = this.getGraphics(true);
        if (g != null && g != this.baseGraphics) {
            layer.init(g);
        }
        this.state.setTransform(newTr);
        this.state.setLayer(layer);
        this.resetCachedGraphics();
    }

    private void renderLayer(Layer layer) {
        WCTransform cur = this.getTransform();
        this.setTransform(new WCTransform(1.0, 0.0, 0.0, 1.0, layer.getX(), layer.getY()));
        Graphics g = this.getGraphics(true);
        if (g != null) {
            layer.render(g);
        }
        this.setTransform(cur);
    }

    private void restoreStateInternal() {
        int size = this.states.size();
        if (size == 0) {
            assert (false) : "Unbalanced restoreState";
            return;
        }
        Layer layer = this.state.getLayerNoClone();
        this.state = this.states.remove(size - 1);
        if (layer != this.state.getLayerNoClone()) {
            this.renderLayer(layer);
            layer.dispose();
            if (log.isLoggable(PlatformLogger.Level.FINE)) {
                log.fine("Popped layer " + layer);
            }
        } else {
            this.resetCachedGraphics();
        }
    }

    @Override
    public void restoreState() {
        log.fine("restoring state");
        do {
            this.restoreStateInternal();
        } while (!this.state.isRestorePoint());
    }

    private void flushAllLayers() {
        if (this.state == null) {
            return;
        }
        if (this.isRootLayerValid) {
            log.fine("FlushAllLayers: root layer is valid, skipping");
            return;
        }
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("FlushAllLayers");
        }
        ContextState currentState = this.state;
        for (int i = this.states.size() - 1; i >= 0; --i) {
            Layer layer = this.state.getLayerNoClone();
            this.state = this.states.get(i);
            if (layer != this.state.getLayerNoClone()) {
                this.renderLayer(layer);
                continue;
            }
            this.resetCachedGraphics();
        }
        Layer layer = this.state.getLayerNoClone();
        if (layer != null) {
            this.renderLayer(layer);
        }
        this.state = currentState;
        this.isRootLayerValid = true;
    }

    @Override
    public void dispose() {
        if (!this.states.isEmpty()) {
            log.fine("Unbalanced saveState/restoreState");
        }
        for (ContextState state : this.states) {
            if (state.getLayerNoClone() == null) continue;
            state.getLayerNoClone().dispose();
        }
        this.states.clear();
        if (this.state != null && this.state.getLayerNoClone() != null) {
            this.state.getLayerNoClone().dispose();
        }
        this.state = null;
    }

    @Override
    public void setClip(WCPath path, boolean isOut) {
        Affine3D tr = new Affine3D(this.state.getTransformNoClone());
        path.transform(tr.getMxx(), tr.getMyx(), tr.getMxy(), tr.getMyy(), tr.getMxt(), tr.getMyt());
        if (!isOut) {
            WCRectangle pathBounds = path.getBounds();
            int pixelX = (int)Math.floor(pathBounds.getX());
            int pixelY = (int)Math.floor(pathBounds.getY());
            int pixelW = (int)Math.ceil(pathBounds.getMaxX()) - pixelX;
            int pixelH = (int)Math.ceil(pathBounds.getMaxY()) - pixelY;
            this.state.clip(new Rectangle(pixelX, pixelY, pixelW, pixelH));
        }
        Rectangle clip = this.state.getClipNoClone();
        if (isOut) {
            path.addRect(clip.x, clip.y, clip.width, clip.height);
        }
        path.translate(-clip.x, -clip.y);
        ClipLayer layer = new ClipLayer(this.getGraphics(false), clip, path, this.type() == Type.DEDICATED);
        this.startNewLayer(layer);
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setClip(WCPath " + path.getID() + ")");
            log.fine("Pushed layer " + layer);
        }
    }

    private Rectangle transformClip(Rectangle localClip) {
        if (localClip == null) {
            return null;
        }
        float[] points = new float[]{localClip.x, localClip.y, localClip.x + localClip.width, localClip.y, localClip.x, localClip.y + localClip.height, localClip.x + localClip.width, localClip.y + localClip.height};
        this.state.getTransformNoClone().transform(points, 0, points, 0, 4);
        float minX = Math.min(points[0], Math.min(points[2], Math.min(points[4], points[6])));
        float maxX = Math.max(points[0], Math.max(points[2], Math.max(points[4], points[6])));
        float minY = Math.min(points[1], Math.min(points[3], Math.min(points[5], points[7])));
        float maxY = Math.max(points[1], Math.max(points[3], Math.max(points[5], points[7])));
        return new Rectangle((BaseBounds)new RectBounds(minX, minY, maxX, maxY));
    }

    private void setClip(Rectangle shape) {
        Affine3D tr = this.state.getTransformNoClone();
        if (tr.getMxy() == 0.0 && tr.getMxz() == 0.0 && tr.getMyx() == 0.0 && tr.getMyz() == 0.0 && tr.getMzx() == 0.0 && tr.getMzy() == 0.0) {
            Rectangle rc;
            this.state.clip(this.transformClip(shape));
            if (log.isLoggable(PlatformLogger.Level.FINE)) {
                log.fine("setClip({0})", new Object[]{shape});
            }
            if (DEBUG_DRAW_CLIP_SHAPE && (rc = this.state.getClipNoClone()) != null && rc.width >= 2 && rc.height >= 2) {
                WCTransform cur = this.getTransform();
                this.setTransform(new WCTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0));
                Graphics g2d = this.getGraphics(true);
                if (g2d != null) {
                    float fbase = (float)Math.random();
                    g2d.setPaint((Paint)new Color(fbase, 1.0f - fbase, 0.5f, 0.1f));
                    g2d.setStroke(new BasicStroke());
                    g2d.fillRect((float)rc.x, (float)rc.y, (float)rc.width, (float)rc.height);
                    g2d.setPaint((Paint)new Color(1.0f - fbase, fbase, 0.5f, 1.0f));
                    g2d.drawRect((float)rc.x, (float)rc.y, (float)rc.width, (float)rc.height);
                }
                this.setTransform(cur);
                this.state.clip(new Rectangle(rc.x + 1, rc.y + 1, rc.width - 2, rc.height - 2));
            }
            if (this.cachedGraphics != null) {
                this.cachedGraphics.setClipRect(this.state.getClipNoClone());
            }
        } else {
            WCPathImpl path = new WCPathImpl();
            ((WCPath)path).addRect(shape.x, shape.y, shape.width, shape.height);
            this.setClip(path, false);
        }
    }

    @Override
    public void setClip(int cx, int cy, int cw, int ch) {
        this.setClip(new Rectangle(cx, cy, cw, ch));
    }

    @Override
    public void setClip(WCRectangle c) {
        this.setClip(new Rectangle((int)c.getX(), (int)c.getY(), (int)c.getWidth(), (int)c.getHeight()));
    }

    @Override
    public WCRectangle getClip() {
        Rectangle r = this.state.getClipNoClone();
        return r == null ? null : new WCRectangle(r.x, r.y, r.width, r.height);
    }

    protected Rectangle getClipRectNoClone() {
        return this.state.getClipNoClone();
    }

    protected Affine3D getTransformNoClone() {
        return this.state.getTransformNoClone();
    }

    @Override
    public void translate(float x, float y) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("translate({0},{1})", new Object[]{Float.valueOf(x), Float.valueOf(y)});
        }
        this.state.translate(x, y);
        if (this.cachedGraphics != null) {
            this.cachedGraphics.translate(x, y);
        }
    }

    @Override
    public void scale(float sx, float sy) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("scale(" + sx + " " + sy + ")");
        }
        this.state.scale(sx, sy);
        if (this.cachedGraphics != null) {
            this.cachedGraphics.scale(sx, sy);
        }
    }

    @Override
    public void rotate(float radians) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("rotate(" + radians + ")");
        }
        this.state.rotate(radians);
        if (this.cachedGraphics != null) {
            this.cachedGraphics.setTransform((BaseTransform)this.state.getTransformNoClone());
        }
    }

    protected boolean shouldRenderRect(float x, float y, float w, float h, DropShadow shadow, BasicStroke stroke) {
        return true;
    }

    protected boolean shouldRenderShape(Shape shape, DropShadow shadow, BasicStroke stroke) {
        return true;
    }

    protected boolean shouldCalculateIntersection() {
        return false;
    }

    @Override
    public void fillRect(final float x, final float y, final float w, final float h, final Color color) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            String format = "fillRect(%f, %f, %f, %f, %s)";
            log.fine(String.format(format, Float.valueOf(x), Float.valueOf(y), Float.valueOf(w), Float.valueOf(h), color));
        }
        if (!this.shouldRenderRect(x, y, w, h, this.state.getShadowNoClone(), null)) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics g) {
                Color paint = color != null ? color : WCGraphicsPrismContext.this.state.getPaintNoClone();
                DropShadow shadow = WCGraphicsPrismContext.this.state.getShadowNoClone();
                if (shadow != null || !WCGraphicsPrismContext.this.state.getPerspectiveTransformNoClone().isIdentity()) {
                    NGRectangle node = new NGRectangle();
                    node.updateRectangle(x, y, w, h, 0.0f, 0.0f);
                    WCGraphicsPrismContext.this.render(g, (Effect)shadow, (Paint)paint, null, (NGNode)node);
                } else {
                    g.setPaint((Paint)paint);
                    g.fillRect(x, y, w, h);
                }
            }
        }.paint();
    }

    @Override
    public void fillRoundedRect(final float x, final float y, final float w, final float h, final float topLeftW, final float topLeftH, final float topRightW, final float topRightH, final float bottomLeftW, final float bottomLeftH, final float bottomRightW, final float bottomRightH, final Color color) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("fillRoundedRect(%f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %s)", Float.valueOf(x), Float.valueOf(y), Float.valueOf(w), Float.valueOf(h), Float.valueOf(topLeftW), Float.valueOf(topLeftH), Float.valueOf(topRightW), Float.valueOf(topRightH), Float.valueOf(bottomLeftW), Float.valueOf(bottomLeftH), Float.valueOf(bottomRightW), Float.valueOf(bottomRightH), color));
        }
        if (!this.shouldRenderRect(x, y, w, h, this.state.getShadowNoClone(), null)) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics g) {
                float arcW = (topLeftW + topRightW + bottomLeftW + bottomRightW) / 2.0f;
                float arcH = (topLeftH + topRightH + bottomLeftH + bottomRightH) / 2.0f;
                DropShadow shadow = WCGraphicsPrismContext.this.state.getShadowNoClone();
                if (shadow != null) {
                    NGRectangle node = new NGRectangle();
                    node.updateRectangle(x, y, w, h, arcW, arcH);
                    WCGraphicsPrismContext.this.render(g, (Effect)shadow, (Paint)color, null, (NGNode)node);
                } else {
                    g.setPaint((Paint)color);
                    g.fillRoundRect(x, y, w, h, arcW, arcH);
                }
            }
        }.paint();
    }

    @Override
    public void clearRect(final float x, final float y, final float w, final float h) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("clearRect(%f, %f, %f, %f)", Float.valueOf(x), Float.valueOf(y), Float.valueOf(w), Float.valueOf(h)));
        }
        if (this.shouldCalculateIntersection()) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics g) {
                g.clearQuad(x, y, x + w, y + h);
            }
        }.paint();
    }

    @Override
    public void setFillColor(Color color) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("setFillColor(%s)", color));
        }
        this.state.setPaint((Paint)color);
    }

    @Override
    public void setFillGradient(WCGradient gradient) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setFillGradient(" + gradient + ")");
        }
        this.state.setPaint((Paint)((Gradient)gradient.getPlatformGradient()));
    }

    @Override
    public void setTextMode(boolean fill, boolean stroke, boolean clip) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setTextMode(fill:" + fill + ",stroke:" + stroke + ",clip:" + clip + ")");
        }
        this.state.setTextMode(fill, stroke, clip);
    }

    @Override
    public void setFontSmoothingType(int fontSmoothingType) {
        this.fontSmoothingType = fontSmoothingType;
    }

    @Override
    public int getFontSmoothingType() {
        return this.fontSmoothingType;
    }

    @Override
    public void setStrokeStyle(int style) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setStrokeStyle({0})", new Object[]{style});
        }
        this.state.getStrokeNoClone().setStyle(style);
    }

    @Override
    public void setStrokeColor(Color color) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("setStrokeColor(%s)", color));
        }
        this.state.getStrokeNoClone().setPaint(color);
    }

    @Override
    public void setStrokeWidth(float width) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setStrokeWidth({0})", new Object[]{Float.valueOf(width)});
        }
        this.state.getStrokeNoClone().setThickness(width);
    }

    @Override
    public void setStrokeGradient(WCGradient gradient) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setStrokeGradient(" + gradient + ")");
        }
        this.state.getStrokeNoClone().setPaint((Gradient)gradient.getPlatformGradient());
    }

    @Override
    public void setLineDash(float offset, float ... sizes) {
        int i;
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            StringBuilder s = new StringBuilder("[");
            for (i = 0; i < sizes.length; ++i) {
                s.append(sizes[i]).append(',');
            }
            s.append(']');
            log.fine("setLineDash({0},{1}", new Object[]{Float.valueOf(offset), s});
        }
        this.state.getStrokeNoClone().setDashOffset(offset);
        if (sizes != null) {
            boolean allZero = true;
            for (i = 0; i < sizes.length; ++i) {
                if (sizes[i] == 0.0f) continue;
                allZero = false;
                break;
            }
            if (allZero) {
                sizes = null;
            }
        }
        this.state.getStrokeNoClone().setDashSizes(sizes);
    }

    @Override
    public void setLineCap(int lineCap) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setLineCap(" + lineCap + ")");
        }
        this.state.getStrokeNoClone().setLineCap(lineCap);
    }

    @Override
    public void setLineJoin(int lineJoin) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setLineJoin(" + lineJoin + ")");
        }
        this.state.getStrokeNoClone().setLineJoin(lineJoin);
    }

    @Override
    public void setMiterLimit(float miterLimit) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setMiterLimit(" + miterLimit + ")");
        }
        this.state.getStrokeNoClone().setMiterLimit(miterLimit);
    }

    @Override
    public void setShadow(float dx, float dy, float blur, Color color) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            String format = "setShadow(%f, %f, %f, %s)";
            log.fine(String.format(format, Float.valueOf(dx), Float.valueOf(dy), Float.valueOf(blur), color));
        }
        this.state.setShadow(this.createShadow(dx, dy, blur, color));
    }

    @Override
    public void drawPolygon(final WCPath path, boolean shouldAntialias) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("drawPolygon({0})", new Object[]{shouldAntialias});
        }
        if (!this.shouldRenderShape((Shape)((WCPathImpl)path).getPlatformPath(), null, this.state.getStrokeNoClone().getPlatformStroke())) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics g) {
                Path2D p2d = (Path2D)path.getPlatformPath();
                g.setPaint(WCGraphicsPrismContext.this.state.getPaintNoClone());
                g.fill((Shape)p2d);
                if (WCGraphicsPrismContext.this.state.getStrokeNoClone().apply(g)) {
                    g.draw((Shape)p2d);
                }
            }
        }.paint();
    }

    @Override
    public void drawLine(final int x0, final int y0, final int x1, final int y1) {
        Line2D line;
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("drawLine({0}, {1}, {2}, {3})", new Object[]{x0, y0, x1, y1});
        }
        if (!this.shouldRenderShape((Shape)(line = new Line2D((float)x0, (float)y0, (float)x1, (float)y1)), null, this.state.getStrokeNoClone().getPlatformStroke())) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics g) {
                if (WCGraphicsPrismContext.this.state.getStrokeNoClone().apply(g)) {
                    g.drawLine((float)x0, (float)y0, (float)x1, (float)y1);
                }
            }
        }.paint();
    }

    @Override
    public void drawPattern(final WCImage texture, final WCRectangle srcRect, final WCTransform patternTransform, final WCPoint phase, final WCRectangle destRect) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("drawPattern({0}, {1}, {2}, {3})", new Object[]{destRect.getIntX(), destRect.getIntY(), destRect.getIntWidth(), destRect.getIntHeight()});
        }
        if (!this.shouldRenderRect(destRect.getX(), destRect.getY(), destRect.getWidth(), destRect.getHeight(), null, null)) {
            return;
        }
        if (texture != null) {
            new Composite(){

                @Override
                void doPaint(Graphics g) {
                    Image img = ((PrismImage)texture).getImage();
                    if (!srcRect.contains(new WCRectangle(0.0f, 0.0f, texture.getWidth(), texture.getHeight()))) {
                        img = img.createSubImage(srcRect.getIntX(), srcRect.getIntY(), (int)Math.ceil(srcRect.getWidth()), (int)Math.ceil(srcRect.getHeight()));
                    }
                    double[] m = patternTransform.getMatrix();
                    Affine3D at = new Affine3D();
                    at.translate((double)phase.getX(), (double)phase.getY());
                    at.concatenate(m[0], m[2], m[4], m[1], m[3], m[5]);
                    g.setPaint((Paint)new ImagePattern(img, srcRect.getX(), srcRect.getY(), srcRect.getWidth(), srcRect.getHeight(), (BaseTransform)at, false, false));
                    g.fillRect(destRect.getX(), destRect.getY(), destRect.getWidth(), destRect.getHeight());
                }
            }.paint();
        }
    }

    @Override
    public void drawImage(final WCImage img, final float dstx, final float dsty, final float dstw, final float dsth, final float srcx, final float srcy, final float srcw, final float srch) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("drawImage(img, dst({0},{1},{2},{3}), src({4},{5},{6},{7}))", new Object[]{Float.valueOf(dstx), Float.valueOf(dsty), Float.valueOf(dstw), Float.valueOf(dsth), Float.valueOf(srcx), Float.valueOf(srcy), Float.valueOf(srcw), Float.valueOf(srch)});
        }
        if (!this.shouldRenderRect(dstx, dsty, dstw, dsth, this.state.getShadowNoClone(), null)) {
            return;
        }
        if (img instanceof PrismImage) {
            new Composite(){

                @Override
                void doPaint(Graphics g) {
                    PrismImage pi = (PrismImage)img;
                    DropShadow shadow = WCGraphicsPrismContext.this.state.getShadowNoClone();
                    if (shadow != null) {
                        NGImageView node = new NGImageView();
                        node.setImage((Object)pi.getImage());
                        node.setX(dstx);
                        node.setY(dsty);
                        node.setViewport(srcx, srcy, srcw, srch, dstw, dsth);
                        node.setContentBounds((BaseBounds)new RectBounds(dstx, dsty, dstx + dstw, dsty + dsth));
                        WCGraphicsPrismContext.this.render(g, (Effect)shadow, null, null, (NGNode)node);
                    } else {
                        pi.draw(g, (int)dstx, (int)dsty, (int)(dstx + dstw), (int)(dsty + dsth), (int)srcx, (int)srcy, (int)(srcx + srcw), (int)(srcy + srch));
                    }
                }
            }.paint();
        }
    }

    @Override
    public void drawBitmapImage(final ByteBuffer image, final int x, final int y, final int w, final int h) {
        if (!this.shouldRenderRect(x, y, w, h, null, null)) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics g) {
                ResourceFactory rf = g.getResourceFactory();
                if (rf.isDisposed()) {
                    log.fine("WCGraphicsPrismContext::doPaint skip because device has been disposed");
                    return;
                }
                image.order(ByteOrder.nativeOrder());
                Image img = Image.fromByteBgraPreData((ByteBuffer)image, (int)w, (int)h);
                Texture txt = rf.createTexture(img, Texture.Usage.STATIC, Texture.WrapMode.REPEAT);
                g.drawTexture(txt, (float)x, (float)y, (float)(x + w), (float)(y + h), 0.0f, 0.0f, (float)w, (float)h);
                txt.dispose();
            }
        }.paint();
    }

    @Override
    public void drawIcon(WCIcon icon, int x, int y) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("UNIMPLEMENTED drawIcon ({0}, {1})", new Object[]{x, y});
        }
    }

    @Override
    public void drawRect(final int x, final int y, final int w, final int h) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("drawRect({0}, {1}, {2}, {3})", new Object[]{x, y, w, h});
        }
        if (!this.shouldRenderRect(x, y, w, h, null, this.state.getStrokeNoClone().getPlatformStroke())) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics g) {
                Paint c = WCGraphicsPrismContext.this.state.getPaintNoClone();
                if (c != null && c.isOpaque()) {
                    g.setPaint(c);
                    g.fillRect((float)x, (float)y, (float)w, (float)h);
                }
                if (WCGraphicsPrismContext.this.state.getStrokeNoClone().apply(g)) {
                    g.drawRect((float)x, (float)y, (float)w, (float)h);
                }
            }
        }.paint();
    }

    @Override
    public void drawString(WCFont f, int[] glyphs, float[] advances, final float x, final float y) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("Drawing %d glyphs @(%.1f, %.1f)", glyphs.length, Float.valueOf(x), Float.valueOf(y)));
        }
        final PGFont font = (PGFont)f.getPlatformFont();
        final TextRun gl = TextUtilities.createGlyphList(glyphs, advances, x, y);
        final DropShadow shadow = this.state.getShadowNoClone();
        final BasicStroke stroke = this.state.isTextStroke() ? this.state.getStrokeNoClone().getPlatformStroke() : null;
        final FontStrike strike = font.getStrike((BaseTransform)this.getTransformNoClone(), this.getFontSmoothingType());
        if (this.shouldCalculateIntersection()) {
            Metrics m = strike.getMetrics();
            gl.setMetrics(m.getAscent(), m.getDescent(), m.getLineGap());
            if (!this.shouldRenderRect(x, y, gl.getWidth(), gl.getHeight(), shadow, stroke)) {
                return;
            }
        }
        new Composite(){

            @Override
            void doPaint(Graphics g) {
                Paint paint;
                Paint paint2 = paint = WCGraphicsPrismContext.this.state.isTextFill() ? WCGraphicsPrismContext.this.state.getPaintNoClone() : null;
                if (shadow != null) {
                    NGText span = new NGText();
                    span.setGlyphs((Object[])new GlyphList[]{gl});
                    span.setFont((Object)font);
                    span.setFontSmoothingType(WCGraphicsPrismContext.this.fontSmoothingType);
                    WCGraphicsPrismContext.this.render(g, (Effect)shadow, paint, stroke, (NGNode)span);
                } else {
                    if (paint != null) {
                        g.setPaint(paint);
                        g.drawString((GlyphList)gl, strike, x, y, null, 0, 0);
                    }
                    if (stroke != null && (paint = (Paint)WCGraphicsPrismContext.this.state.getStrokeNoClone().getPaint()) != null) {
                        g.setPaint(paint);
                        g.setStroke(stroke);
                        g.draw(strike.getOutline((GlyphList)gl, BaseTransform.getTranslateInstance((double)x, (double)y)));
                    }
                }
            }
        }.paint();
    }

    @Override
    public void drawString(WCFont f, String str, boolean rtl, int from, int to, float x, float y) {
        GlyphList[] runs;
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("str='%s' (length=%d), from=%d, to=%d, rtl=%b, @(%.1f, %.1f)", str, str.length(), from, to, rtl, Float.valueOf(x), Float.valueOf(y)));
        }
        TextLayout layout = TextUtilities.createLayout(str.substring(from, to), f.getPlatformFont());
        int count = 0;
        for (GlyphList run : runs = layout.getRuns()) {
            count += run.getGlyphCount();
        }
        int[] glyphs = new int[count];
        float[] adv = new float[count];
        count = 0;
        for (GlyphList run : layout.getRuns()) {
            int gc = run.getGlyphCount();
            for (int i = 0; i < gc; ++i) {
                glyphs[count] = run.getGlyphCode(i);
                adv[count] = run.getPosX(i + 1) - run.getPosX(i);
                ++count;
            }
        }
        x = rtl ? (x += TextUtilities.getLayoutWidth(str.substring(from), f.getPlatformFont()) - layout.getBounds().getWidth()) : (x += TextUtilities.getLayoutWidth(str.substring(0, from), f.getPlatformFont()));
        this.drawString(f, glyphs, adv, x, y);
    }

    @Override
    public void setComposite(int composite) {
        log.fine("setComposite({0})", new Object[]{composite});
        this.state.setCompositeOperation(composite);
    }

    @Override
    public void drawEllipse(final int x, final int y, final int w, final int h) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("drawEllipse({0}, {1}, {2}, {3})", new Object[]{x, y, w, h});
        }
        if (!this.shouldRenderRect(x, y, w, h, null, this.state.getStrokeNoClone().getPlatformStroke())) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics g) {
                g.setPaint(WCGraphicsPrismContext.this.state.getPaintNoClone());
                g.fillEllipse((float)x, (float)y, (float)w, (float)h);
                if (WCGraphicsPrismContext.this.state.getStrokeNoClone().apply(g)) {
                    g.drawEllipse((float)x, (float)y, (float)w, (float)h);
                }
            }
        }.paint();
    }

    @Override
    public void drawFocusRing(final int x, final int y, final int w, final int h, final Color color) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("drawFocusRing: %d, %d, %d, %d, %s", x, y, w, h, color));
        }
        if (!this.shouldRenderRect(x, y, w, h, null, focusRingStroke)) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics g) {
                g.setPaint((Paint)color);
                BasicStroke stroke = g.getStroke();
                g.setStroke(focusRingStroke);
                g.drawRoundRect((float)x, (float)y, (float)w, (float)h, 4.0f, 4.0f);
                g.setStroke(stroke);
            }
        }.paint();
    }

    @Override
    public void setAlpha(float alpha) {
        log.fine("setAlpha({0})", new Object[]{Float.valueOf(alpha)});
        this.state.setAlpha(alpha);
        if (null != this.cachedGraphics) {
            this.cachedGraphics.setExtraAlpha(this.state.getAlpha());
        }
    }

    @Override
    public float getAlpha() {
        return this.state.getAlpha();
    }

    @Override
    public void beginTransparencyLayer(float opacity) {
        TransparencyLayer layer = new TransparencyLayer(this.getGraphics(false), this.state.getClipNoClone(), opacity);
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("beginTransparencyLayer(%s)", layer));
        }
        this.state.markAsRestorePoint();
        this.startNewLayer(layer);
    }

    @Override
    public void endTransparencyLayer() {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("endTransparencyLayer(%s)", this.state.getLayerNoClone()));
        }
        this.restoreState();
    }

    @Override
    public void drawWidget(final RenderTheme theme, final Ref widget, final int x, final int y) {
        WCSize s = theme.getWidgetSize(widget);
        if (!this.shouldRenderRect(x, y, s.getWidth(), s.getHeight(), null, null)) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics g) {
                theme.drawWidget(WCGraphicsPrismContext.this, widget, x, y);
            }
        }.paint();
    }

    @Override
    public void drawScrollbar(final ScrollBarTheme theme, final Ref widget, final int x, final int y, final int pressedPart, final int hoveredPart) {
        WCSize s;
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("drawScrollbar(%s, %s, x = %d, y = %d)", theme, widget, x, y));
        }
        if (!this.shouldRenderRect(x, y, (s = theme.getWidgetSize(widget)).getWidth(), s.getHeight(), null, null)) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics g) {
                theme.paint(WCGraphicsPrismContext.this, widget, x, y, pressedPart, hoveredPart);
            }
        }.paint();
    }

    private static Rectangle intersect(Rectangle what, Rectangle with) {
        if (what == null) {
            return with;
        }
        RectBounds b = what.toRectBounds();
        b.intersectWith(with);
        what.setBounds((BaseBounds)b);
        return what;
    }

    private static Color4f createColor4f(Color color) {
        return new Color4f(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private DropShadow createShadow(float dx, float dy, float blur, Color color) {
        if (dx == 0.0f && dy == 0.0f && blur == 0.0f) {
            return null;
        }
        DropShadow shadow = new DropShadow();
        shadow.setOffsetX((int)dx);
        shadow.setOffsetY((int)dy);
        shadow.setRadius(blur < 0.0f ? 0.0f : (blur > 127.0f ? 127.0f : blur));
        shadow.setColor(WCGraphicsPrismContext.createColor4f(color));
        return shadow;
    }

    private void render(Graphics g, Effect effect, Paint paint, BasicStroke stroke, NGNode node) {
        if (node instanceof NGShape) {
            NGShape shape = (NGShape)node;
            Shape realShape = shape.getShape();
            Paint strokePaint = (Paint)this.state.getStrokeNoClone().getPaint();
            if (stroke != null && strokePaint != null) {
                realShape = stroke.createStrokedShape(realShape);
                shape.setDrawStroke(stroke);
                shape.setDrawPaint((Object)strokePaint);
                shape.setMode(paint == null ? NGShape.Mode.STROKE : NGShape.Mode.STROKE_FILL);
            } else {
                shape.setMode(paint == null ? NGShape.Mode.EMPTY : NGShape.Mode.FILL);
            }
            shape.setFillPaint((Object)paint);
            shape.setContentBounds((BaseBounds)realShape.getBounds());
        }
        boolean culling = g.hasPreCullingBits();
        g.setHasPreCullingBits(false);
        node.setEffect(effect);
        node.render(g);
        g.setHasPreCullingBits(culling);
    }

    private static FilterContext getFilterContext(Graphics g) {
        Screen screen = g.getAssociatedScreen();
        if (screen == null) {
            ResourceFactory factory = g.getResourceFactory();
            return PrFilterContext.getPrinterContext((Object)factory);
        }
        return PrFilterContext.getInstance((Screen)screen);
    }

    @Override
    public void strokeArc(int x, int y, int w, int h, int startAngle, int angleSpan) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("strokeArc(%d, %d, %d, %d, %d, %d)", x, y, w, h, startAngle, angleSpan));
        }
        final Arc2D arc = new Arc2D((float)x, (float)y, (float)w, (float)h, (float)startAngle, (float)angleSpan, 0);
        if (this.state.getStrokeNoClone().isApplicable() && !this.shouldRenderShape((Shape)arc, null, this.state.getStrokeNoClone().getPlatformStroke())) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics g) {
                if (WCGraphicsPrismContext.this.state.getStrokeNoClone().apply(g)) {
                    g.draw((Shape)arc);
                }
            }
        }.paint();
    }

    @Override
    public WCImage getImage() {
        return null;
    }

    @Override
    public void strokeRect(final float x, final float y, final float w, final float h, float lineWidth) {
        BasicStroke stroke;
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("strokeRect_FFFFF(%f, %f, %f, %f, %f)", Float.valueOf(x), Float.valueOf(y), Float.valueOf(w), Float.valueOf(h), Float.valueOf(lineWidth)));
        }
        if (!this.shouldRenderRect(x, y, w, h, null, stroke = new BasicStroke(lineWidth, 0, 0, Math.max(1.0f, lineWidth), this.state.getStrokeNoClone().getDashSizes(), this.state.getStrokeNoClone().getDashOffset()))) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics g) {
                g.setStroke(stroke);
                Paint paint = (Paint)WCGraphicsPrismContext.this.state.getStrokeNoClone().getPaint();
                if (paint == null) {
                    paint = WCGraphicsPrismContext.this.state.getPaintNoClone();
                }
                g.setPaint(paint);
                g.drawRect(x, y, w, h);
            }
        }.paint();
    }

    @Override
    public void strokePath(WCPath path) {
        log.fine("strokePath");
        if (path != null) {
            final BasicStroke stroke = this.state.getStrokeNoClone().getPlatformStroke();
            final DropShadow shadow = this.state.getShadowNoClone();
            final Path2D p2d = (Path2D)path.getPlatformPath();
            if (stroke == null && shadow == null || !this.shouldRenderShape((Shape)p2d, shadow, stroke)) {
                return;
            }
            new Composite(){

                @Override
                void doPaint(Graphics g) {
                    if (shadow != null) {
                        NGPath node = new NGPath();
                        node.updateWithPath2d(p2d);
                        WCGraphicsPrismContext.this.render(g, (Effect)shadow, null, stroke, (NGNode)node);
                    } else if (stroke != null) {
                        Paint paint = (Paint)WCGraphicsPrismContext.this.state.getStrokeNoClone().getPaint();
                        if (paint == null) {
                            paint = WCGraphicsPrismContext.this.state.getPaintNoClone();
                        }
                        g.setPaint(paint);
                        g.setStroke(stroke);
                        g.draw((Shape)p2d);
                    }
                }
            }.paint();
        }
    }

    @Override
    public void fillPath(final WCPath path) {
        log.fine("fillPath");
        if (path != null) {
            if (!this.shouldRenderShape((Shape)((WCPathImpl)path).getPlatformPath(), this.state.getShadowNoClone(), null)) {
                return;
            }
            new Composite(){

                @Override
                void doPaint(Graphics g) {
                    Path2D p2d = (Path2D)path.getPlatformPath();
                    Paint paint = WCGraphicsPrismContext.this.state.getPaintNoClone();
                    DropShadow shadow = WCGraphicsPrismContext.this.state.getShadowNoClone();
                    if (shadow != null) {
                        NGPath node = new NGPath();
                        node.updateWithPath2d(p2d);
                        WCGraphicsPrismContext.this.render(g, (Effect)shadow, paint, null, (NGNode)node);
                    } else {
                        g.setPaint(paint);
                        g.fill((Shape)p2d);
                    }
                }
            }.paint();
        }
    }

    @Override
    public void setPerspectiveTransform(WCTransform tm) {
        GeneralTransform3D at = new GeneralTransform3D().set(tm.getMatrix());
        this.state.setPerspectiveTransform(at);
        this.resetCachedGraphics();
    }

    @Override
    public void setTransform(WCTransform tm) {
        double[] m = tm.getMatrix();
        Affine3D at = new Affine3D((BaseTransform)new Affine2D(m[0], m[1], m[2], m[3], m[4], m[5]));
        if (this.state.getLayerNoClone() == null) {
            at.preConcatenate(this.baseTransform);
        }
        this.state.setTransform(at);
        this.resetCachedGraphics();
    }

    @Override
    public WCTransform getTransform() {
        Affine3D xf = this.state.getTransformNoClone();
        return new WCTransform(xf.getMxx(), xf.getMyx(), xf.getMxy(), xf.getMyy(), xf.getMxt(), xf.getMyt());
    }

    @Override
    public void concatTransform(WCTransform tm) {
        double[] m = tm.getMatrix();
        Affine3D at = new Affine3D((BaseTransform)new Affine2D(m[0], m[1], m[2], m[3], m[4], m[5]));
        this.state.concatTransform(at);
        this.resetCachedGraphics();
    }

    @Override
    public void flush() {
        if (!this.isValid()) {
            log.fine("WCGraphicsPrismContext::flush : GC is invalid");
            return;
        }
        this.flushAllLayers();
    }

    @Override
    public WCGradient createLinearGradient(WCPoint p1, WCPoint p2) {
        return new WCLinearGradient(p1, p2);
    }

    @Override
    public WCGradient createRadialGradient(WCPoint p1, float r1, WCPoint p2, float r2) {
        return new WCRadialGradient(p1, r1, p2, r2);
    }

    private static final class ContextState {
        private final WCStrokeImpl stroke = new WCStrokeImpl();
        private Rectangle clip;
        private Paint paint;
        private float alpha;
        private boolean textFill = true;
        private boolean textStroke = false;
        private boolean textClip = false;
        private boolean restorePoint = false;
        private DropShadow shadow;
        private Affine3D xform;
        private GeneralTransform3D perspectiveTransform;
        private Layer layer;
        private int compositeOperation;

        private ContextState() {
            this.clip = null;
            this.paint = Color.BLACK;
            this.stroke.setPaint(Color.BLACK);
            this.alpha = 1.0f;
            this.xform = new Affine3D();
            this.perspectiveTransform = new GeneralTransform3D();
            this.compositeOperation = 2;
        }

        private ContextState(ContextState state) {
            this.stroke.copyFrom(state.getStrokeNoClone());
            this.setPaint(state.getPaintNoClone());
            this.clip = state.getClipNoClone();
            if (this.clip != null) {
                this.clip = new Rectangle(this.clip);
            }
            this.xform = new Affine3D(state.getTransformNoClone());
            this.perspectiveTransform = new GeneralTransform3D().set(state.getPerspectiveTransformNoClone());
            this.setShadow(state.getShadowNoClone());
            this.setLayer(state.getLayerNoClone());
            this.setAlpha(state.getAlpha());
            this.setTextMode(state.isTextFill(), state.isTextStroke(), state.isTextClip());
            this.setCompositeOperation(state.getCompositeOperation());
        }

        protected ContextState clone() {
            return new ContextState(this);
        }

        private void apply(Graphics g) {
            g.setTransform((BaseTransform)this.getTransformNoClone());
            g.setPerspectiveTransform(this.getPerspectiveTransformNoClone());
            g.setClipRect(this.getClipNoClone());
            g.setExtraAlpha(this.getAlpha());
        }

        private int getCompositeOperation() {
            return this.compositeOperation;
        }

        private void setCompositeOperation(int compositeOperation) {
            this.compositeOperation = compositeOperation;
        }

        private WCStrokeImpl getStrokeNoClone() {
            return this.stroke;
        }

        private Paint getPaintNoClone() {
            return this.paint;
        }

        private void setPaint(Paint paint) {
            this.paint = paint;
        }

        private Rectangle getClipNoClone() {
            return this.clip;
        }

        private Layer getLayerNoClone() {
            return this.layer;
        }

        private void setLayer(Layer layer) {
            this.layer = layer;
        }

        private void setClip(Rectangle area) {
            this.clip = area;
        }

        private void clip(Rectangle area) {
            if (null == this.clip) {
                this.clip = area;
            } else {
                this.clip.intersectWith(area);
            }
        }

        private void setAlpha(float alpha) {
            this.alpha = alpha;
        }

        private float getAlpha() {
            return this.alpha;
        }

        private void setTextMode(boolean fill, boolean stroke, boolean clip) {
            this.textFill = fill;
            this.textStroke = stroke;
            this.textClip = clip;
        }

        private boolean isTextFill() {
            return this.textFill;
        }

        private boolean isTextStroke() {
            return this.textStroke;
        }

        private boolean isTextClip() {
            return this.textClip;
        }

        private void markAsRestorePoint() {
            this.restorePoint = true;
        }

        private boolean isRestorePoint() {
            return this.restorePoint;
        }

        private void setShadow(DropShadow shadow) {
            this.shadow = shadow;
        }

        private DropShadow getShadowNoClone() {
            return this.shadow;
        }

        private Affine3D getTransformNoClone() {
            return this.xform;
        }

        private GeneralTransform3D getPerspectiveTransformNoClone() {
            return this.perspectiveTransform;
        }

        private void setTransform(Affine3D at) {
            this.xform.setTransform((BaseTransform)at);
        }

        private void setPerspectiveTransform(GeneralTransform3D gt) {
            this.perspectiveTransform.set(gt);
        }

        private void concatTransform(Affine3D at) {
            this.xform.concatenate((BaseTransform)at);
        }

        private void translate(double dx, double dy) {
            this.xform.translate(dx, dy);
        }

        private void scale(double sx, double sy) {
            this.xform.scale(sx, sy);
        }

        private void rotate(double radians) {
            this.xform.rotate(radians);
        }
    }

    public static enum Type {
        PRIMARY,
        DEDICATED;

    }

    private static abstract class Layer {
        FilterContext fctx;
        PrDrawable buffer;
        Graphics graphics;
        final Rectangle bounds;
        boolean permanent;

        Layer(Graphics g, Rectangle bounds, boolean permanent) {
            this.bounds = new Rectangle(bounds);
            this.permanent = permanent;
            int w = Math.max(bounds.width, 1);
            int h = Math.max(bounds.height, 1);
            this.fctx = WCGraphicsPrismContext.getFilterContext(g);
            if (permanent) {
                ResourceFactory f = GraphicsPipeline.getDefaultResourceFactory();
                if (f != null && !f.isDisposed()) {
                    RTTexture rtt = f.createRTTexture(w, h, Texture.WrapMode.CLAMP_NOT_NEEDED);
                    rtt.makePermanent();
                    this.buffer = ((PrRenderer)Renderer.getRenderer((FilterContext)this.fctx)).createDrawable(rtt);
                } else {
                    log.fine("Layer :: cannot construct RTT because device disposed or not ready");
                    this.fctx = null;
                    this.buffer = null;
                }
            } else {
                this.buffer = (PrDrawable)Effect.getCompatibleImage((FilterContext)this.fctx, (int)w, (int)h);
            }
        }

        Graphics getGraphics() {
            if (this.graphics == null && this.buffer != null) {
                this.graphics = this.buffer.createGraphics();
            }
            return this.graphics;
        }

        abstract void init(Graphics var1);

        abstract void render(Graphics var1);

        private void dispose() {
            if (this.buffer != null) {
                if (this.permanent) {
                    this.buffer.flush();
                } else {
                    Effect.releaseCompatibleImage((FilterContext)this.fctx, (Filterable)this.buffer);
                }
                this.fctx = null;
                this.buffer = null;
            }
        }

        private double getX() {
            return this.bounds.x;
        }

        private double getY() {
            return this.bounds.y;
        }
    }

    private static final class ClipLayer
    extends Layer {
        private final WCPath normalizedToClipPath;
        private boolean srcover;

        private ClipLayer(Graphics g, Rectangle bounds, WCPath normalizedToClipPath, boolean permanent) {
            super(g, bounds, permanent);
            this.normalizedToClipPath = normalizedToClipPath;
            this.srcover = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void init(Graphics g) {
            RTTexture texture = null;
            ReadbackGraphics readbackGraphics = null;
            try {
                readbackGraphics = (ReadbackGraphics)g;
                texture = readbackGraphics.readBack(this.bounds);
                this.getGraphics().drawTexture((Texture)texture, 0.0f, 0.0f, (float)this.bounds.width, (float)this.bounds.height);
            }
            finally {
                if (readbackGraphics != null && texture != null) {
                    readbackGraphics.releaseReadBackBuffer(texture);
                }
            }
            this.srcover = false;
        }

        @Override
        void render(Graphics g) {
            Path2D p2d = ((WCPathImpl)this.normalizedToClipPath).getPlatformPath();
            PrDrawable bufferImg = (PrDrawable)Effect.getCompatibleImage((FilterContext)this.fctx, (int)this.bounds.width, (int)this.bounds.height);
            Graphics bufferGraphics = bufferImg.createGraphics();
            bufferGraphics.setPaint((Paint)Color.BLACK);
            bufferGraphics.fill((Shape)p2d);
            if (g instanceof MaskTextureGraphics && !(g instanceof PrinterGraphics)) {
                MaskTextureGraphics mg = (MaskTextureGraphics)g;
                if (this.srcover) {
                    mg.drawPixelsMasked((RTTexture)this.buffer.getTextureObject(), (RTTexture)bufferImg.getTextureObject(), this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, 0, 0, 0, 0);
                } else {
                    mg.maskInterpolatePixels((RTTexture)this.buffer.getTextureObject(), (RTTexture)bufferImg.getTextureObject(), this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, 0, 0, 0, 0);
                }
            } else {
                Blend blend = new Blend(Blend.Mode.SRC_IN, (Effect)new PassThrough(bufferImg, this.bounds.width, this.bounds.height), (Effect)new PassThrough(this.buffer, this.bounds.width, this.bounds.height));
                Affine3D tx = new Affine3D(g.getTransformNoClone());
                g.setTransform(BaseTransform.IDENTITY_TRANSFORM);
                PrEffectHelper.render((Effect)blend, (Graphics)g, (float)this.bounds.x, (float)this.bounds.y, null);
                g.setTransform((BaseTransform)tx);
            }
            Effect.releaseCompatibleImage((FilterContext)this.fctx, (Filterable)bufferImg);
        }

        public String toString() {
            return String.format("ClipLayer[%d,%d + %dx%d, path %s]", this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, this.normalizedToClipPath);
        }
    }

    private final class TransparencyLayer
    extends Layer {
        private final float opacity;

        private TransparencyLayer(Graphics g, Rectangle bounds, float opacity) {
            super(g, bounds, false);
            this.opacity = opacity;
        }

        @Override
        void init(Graphics g) {
            WCGraphicsPrismContext.this.state.setCompositeOperation(2);
        }

        @Override
        void render(Graphics g) {
            new Composite(){

                @Override
                void doPaint(Graphics g) {
                    float op = g.getExtraAlpha();
                    g.setExtraAlpha(TransparencyLayer.this.opacity);
                    Affine3D tx = new Affine3D(g.getTransformNoClone());
                    g.setTransform(BaseTransform.IDENTITY_TRANSFORM);
                    g.drawTexture(TransparencyLayer.this.buffer.getTextureObject(), (float)TransparencyLayer.this.bounds.x, (float)TransparencyLayer.this.bounds.y, (float)TransparencyLayer.this.bounds.width, (float)TransparencyLayer.this.bounds.height);
                    g.setTransform((BaseTransform)tx);
                    g.setExtraAlpha(op);
                }
            }.paint(g);
        }

        public String toString() {
            return String.format("TransparencyLayer[%d,%d + %dx%d, opacity %.2f]", this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, Float.valueOf(this.opacity));
        }
    }

    private static final class PassThrough
    extends Effect {
        private final PrDrawable img;
        private final int width;
        private final int height;

        private PassThrough(PrDrawable img, int width, int height) {
            this.img = img;
            this.width = width;
            this.height = height;
        }

        public ImageData filter(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
            this.img.lock();
            ImageData imgData = new ImageData(fctx, (Filterable)this.img, new Rectangle((int)transform.getMxt(), (int)transform.getMyt(), this.width, this.height));
            imgData.setReusable(true);
            return imgData;
        }

        public RectBounds getBounds(BaseTransform transform, Effect defaultInput) {
            return null;
        }

        public Effect.AccelType getAccelType(FilterContext fctx) {
            return Effect.AccelType.INTRINSIC;
        }

        public boolean reducesOpaquePixels() {
            return false;
        }

        public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
            return null;
        }
    }

    private abstract class Composite {
        private Composite() {
        }

        abstract void doPaint(Graphics var1);

        void paint() {
            this.paint(WCGraphicsPrismContext.this.getGraphics(true));
        }

        void paint(Graphics g) {
            if (g != null) {
                CompositeMode oldCompositeMode = g.getCompositeMode();
                switch (WCGraphicsPrismContext.this.state.getCompositeOperation()) {
                    case 1: {
                        g.setCompositeMode(CompositeMode.SRC);
                        this.doPaint(g);
                        g.setCompositeMode(oldCompositeMode);
                        break;
                    }
                    case 2: {
                        g.setCompositeMode(CompositeMode.SRC_OVER);
                        this.doPaint(g);
                        g.setCompositeMode(oldCompositeMode);
                        break;
                    }
                    default: {
                        this.blend(g);
                    }
                }
                WCGraphicsPrismContext.this.isRootLayerValid = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void blend(Graphics g) {
            RTTexture texture;
            ReadbackGraphics readBackGraphics;
            PrDrawable dstImg;
            FilterContext fctx;
            block11: {
                fctx = WCGraphicsPrismContext.getFilterContext(g);
                dstImg = null;
                PrDrawable srcImg = null;
                readBackGraphics = null;
                texture = null;
                Rectangle clip = WCGraphicsPrismContext.this.state.getClipNoClone();
                WCImage image = WCGraphicsPrismContext.this.getImage();
                try {
                    if (image != null && image instanceof PrismImage) {
                        dstImg = (PrDrawable)Effect.getCompatibleImage((FilterContext)fctx, (int)clip.width, (int)clip.height);
                        Graphics dstG = dstImg.createGraphics();
                        WCGraphicsPrismContext.this.state.apply(dstG);
                        ((PrismImage)image).draw(dstG, 0, 0, clip.width, clip.height, clip.x, clip.y, clip.width, clip.height);
                    } else {
                        readBackGraphics = (ReadbackGraphics)g;
                        texture = readBackGraphics.readBack(clip);
                        dstImg = PrDrawable.create((FilterContext)fctx, (RTTexture)texture);
                    }
                    srcImg = (PrDrawable)Effect.getCompatibleImage((FilterContext)fctx, (int)clip.width, (int)clip.height);
                    Graphics srcG = srcImg.createGraphics();
                    WCGraphicsPrismContext.this.state.apply(srcG);
                    this.doPaint(srcG);
                    g.clear();
                    PrEffectHelper.render((Effect)this.createEffect(dstImg, srcImg, clip.width, clip.height), (Graphics)g, (float)0.0f, (float)0.0f, null);
                    if (srcImg == null) break block11;
                }
                catch (Throwable throwable) {
                    if (srcImg != null) {
                        Effect.releaseCompatibleImage((FilterContext)fctx, srcImg);
                    }
                    if (dstImg != null) {
                        if (readBackGraphics != null && texture != null) {
                            readBackGraphics.releaseReadBackBuffer(texture);
                        } else {
                            Effect.releaseCompatibleImage((FilterContext)fctx, dstImg);
                        }
                    }
                    throw throwable;
                }
                Effect.releaseCompatibleImage((FilterContext)fctx, (Filterable)srcImg);
            }
            if (dstImg != null) {
                if (readBackGraphics != null && texture != null) {
                    readBackGraphics.releaseReadBackBuffer(texture);
                } else {
                    Effect.releaseCompatibleImage((FilterContext)fctx, (Filterable)dstImg);
                }
            }
        }

        private Effect createBlend(Blend.Mode mode, PrDrawable dstImg, PrDrawable srcImg, int width, int height) {
            return new Blend(mode, (Effect)new PassThrough(dstImg, width, height), (Effect)new PassThrough(srcImg, width, height));
        }

        private Effect createEffect(PrDrawable dstImg, PrDrawable srcImg, int width, int height) {
            switch (WCGraphicsPrismContext.this.state.getCompositeOperation()) {
                case 0: 
                case 10: {
                    return new Blend(Blend.Mode.SRC_OVER, this.createBlend(Blend.Mode.SRC_OUT, dstImg, srcImg, width, height), this.createBlend(Blend.Mode.SRC_OUT, srcImg, dstImg, width, height));
                }
                case 3: {
                    return this.createBlend(Blend.Mode.SRC_IN, dstImg, srcImg, width, height);
                }
                case 4: {
                    return this.createBlend(Blend.Mode.SRC_OUT, dstImg, srcImg, width, height);
                }
                case 5: {
                    return this.createBlend(Blend.Mode.SRC_ATOP, dstImg, srcImg, width, height);
                }
                case 6: {
                    return this.createBlend(Blend.Mode.SRC_OVER, srcImg, dstImg, width, height);
                }
                case 7: {
                    return this.createBlend(Blend.Mode.SRC_IN, srcImg, dstImg, width, height);
                }
                case 8: {
                    return this.createBlend(Blend.Mode.SRC_OUT, srcImg, dstImg, width, height);
                }
                case 9: {
                    return this.createBlend(Blend.Mode.SRC_ATOP, srcImg, dstImg, width, height);
                }
                case 12: {
                    return this.createBlend(Blend.Mode.ADD, dstImg, srcImg, width, height);
                }
            }
            return this.createBlend(Blend.Mode.SRC_OVER, dstImg, srcImg, width, height);
        }
    }
}

