/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import com.sun.webkit.graphics.WCCamera;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCGraphicsManager;
import com.sun.webkit.graphics.WCPageBackBuffer;
import java.lang.ref.WeakReference;

final class WCPageBackBufferImpl
extends WCPageBackBuffer
implements ResourceFactoryListener {
    private RTTexture texture;
    private WeakReference<ResourceFactory> registeredWithFactory = null;
    private boolean firstValidate = true;
    private float pixelScale;
    private static final PlatformLogger log = PlatformLogger.getLogger((String)WCPageBackBufferImpl.class.getName());

    WCPageBackBufferImpl(float pixelScale) {
        this.pixelScale = pixelScale;
    }

    private static RTTexture createTexture(int w, int h) {
        return GraphicsPipeline.getDefaultResourceFactory().createRTTexture(w, h, Texture.WrapMode.CLAMP_NOT_NEEDED);
    }

    @Override
    public WCGraphicsContext createGraphics() {
        Graphics g = this.texture.createGraphics();
        g.setCamera(WCCamera.INSTANCE);
        g.scale(this.pixelScale, this.pixelScale);
        return WCGraphicsManager.getGraphicsManager().createGraphicsContext(g);
    }

    @Override
    public void disposeGraphics(WCGraphicsContext gc) {
        gc.dispose();
    }

    @Override
    public void flush(WCGraphicsContext gc, int x, int y, int w, int h) {
        int x2 = x + w;
        int y2 = y + h;
        ((Graphics)gc.getPlatformGraphics()).drawTexture((Texture)this.texture, (float)x, (float)y, (float)x2, (float)y2, (float)x * this.pixelScale, (float)y * this.pixelScale, (float)x2 * this.pixelScale, (float)y2 * this.pixelScale);
        this.texture.unlock();
    }

    @Override
    protected void copyArea(int x, int y, int w, int h, int dx, int dy) {
        x = (int)((float)x * this.pixelScale);
        y = (int)((float)y * this.pixelScale);
        w = (int)Math.ceil((float)w * this.pixelScale);
        h = (int)Math.ceil((float)h * this.pixelScale);
        dx = (int)((float)dx * this.pixelScale);
        dy = (int)((float)dy * this.pixelScale);
        RTTexture aux = WCPageBackBufferImpl.createTexture(w, h);
        aux.createGraphics().drawTexture((Texture)this.texture, 0.0f, 0.0f, (float)w, (float)h, (float)x, (float)y, (float)(x + w), (float)(y + h));
        this.texture.createGraphics().drawTexture((Texture)aux, (float)(x + dx), (float)(y + dy), (float)(x + w + dx), (float)(y + h + dy), 0.0f, 0.0f, (float)w, (float)h);
        aux.dispose();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean validate(int width, int height) {
        ResourceFactory factory = GraphicsPipeline.getDefaultResourceFactory();
        if (factory == null || factory.isDisposed()) {
            log.fine("WCPageBackBufferImpl::validate : device disposed or not ready");
            return false;
        }
        width = (int)Math.ceil((float)width * this.pixelScale);
        height = (int)Math.ceil((float)height * this.pixelScale);
        if (this.texture != null) {
            this.texture.lock();
            if (this.texture.isSurfaceLost()) {
                this.texture.dispose();
                this.texture = null;
            }
        }
        if (this.texture == null) {
            this.texture = WCPageBackBufferImpl.createTexture(width, height);
            this.texture.contentsUseful();
            if (this.registeredWithFactory == null || this.registeredWithFactory.get() != factory) {
                factory.addFactoryListener((ResourceFactoryListener)this);
                this.registeredWithFactory = new WeakReference<ResourceFactory>(factory);
            }
            if (this.firstValidate) {
                this.firstValidate = false;
                return true;
            }
            this.texture.unlock();
            return false;
        }
        int tw = this.texture.getContentWidth();
        int th = this.texture.getContentHeight();
        if (tw == width) {
            if (th == height) return true;
        }
        RTTexture newTexture = WCPageBackBufferImpl.createTexture(width, height);
        newTexture.contentsUseful();
        newTexture.createGraphics().drawTexture((Texture)this.texture, 0.0f, 0.0f, (float)Math.min(width, tw), (float)Math.min(height, th));
        this.texture.dispose();
        this.texture = newTexture;
        return true;
    }

    public void factoryReset() {
        if (this.texture != null) {
            this.texture.dispose();
            this.texture = null;
        }
    }

    public void factoryReleased() {
        log.fine("WCPageBackBufferImpl: resource factory released");
        if (this.texture != null) {
            this.texture.dispose();
            this.texture = null;
        }
    }
}

