/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.theme;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.webkit.theme.ContextMenuImpl;
import com.sun.webkit.Invoker;
import com.sun.webkit.PopupMenu;
import com.sun.webkit.WebPage;
import com.sun.webkit.WebPageClient;
import com.sun.webkit.graphics.WCFont;
import com.sun.webkit.graphics.WCPoint;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.web.WebView;

public final class PopupMenuImpl
extends PopupMenu {
    private static final PlatformLogger log = PlatformLogger.getLogger((String)PopupMenuImpl.class.getName());
    private final ContextMenu popupMenu = new ContextMenu();

    public PopupMenuImpl() {
        this.popupMenu.setOnHidden(t1 -> {
            log.finer("onHidden");
            Invoker.getInvoker().postOnEventThread(() -> {
                log.finer("onHidden: notifying");
                this.notifyPopupClosed();
            });
        });
        this.popupMenu.setOnAction(t -> {
            MenuItem item = (MenuItem)t.getTarget();
            log.fine("onAction: item={0}", new Object[]{item});
            this.notifySelectionCommited(this.popupMenu.getItems().indexOf((Object)item));
        });
    }

    @Override
    protected void show(WebPage page, int x, int y, int width) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("show at [{0}, {1}], width={2}", new Object[]{x, y, width});
        }
        this.popupMenu.setPrefWidth((double)width);
        this.popupMenu.setPrefHeight(this.popupMenu.getHeight());
        PopupMenuImpl.doShow(this.popupMenu, page, x, y);
    }

    @Override
    protected void hide() {
        log.fine("hiding");
        this.popupMenu.hide();
    }

    @Override
    protected void appendItem(String itemText, boolean isLabel, boolean isSeparator, boolean isEnabled, int bgColor, int fgColor, WCFont font) {
        ContextMenuImpl.SeparatorImpl item;
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("itemText={0}, isLabel={1}, isSeparator={2}, isEnabled={3}, bgColor={4}, fgColor={5}, font={6}", new Object[]{itemText, isLabel, isSeparator, isEnabled, bgColor, fgColor, font});
        }
        if (isSeparator) {
            item = new ContextMenuImpl.SeparatorImpl(null);
        } else {
            item = new MenuItem(itemText);
            item.setDisable(!isEnabled);
        }
        item.setMnemonicParsing(false);
        this.popupMenu.getItems().add((Object)item);
    }

    @Override
    protected void setSelectedItem(int index) {
        log.finest("index={0}", new Object[]{index});
    }

    static void doShow(ContextMenu popup, WebPage page, int anchorX, int anchorY) {
        WebPageClient client = page.getPageClient();
        assert (client != null);
        WCPoint pt = client.windowToScreen(new WCPoint(anchorX, anchorY));
        popup.show(((WebView)((Object)client.getContainer())).getScene().getWindow(), (double)pt.getX(), (double)pt.getY());
    }
}

