/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit;

import com.sun.javafx.reflect.MethodUtil;
import com.sun.javafx.reflect.ReflectUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;

public class MethodHelper {
    private static final boolean logAccessErrors = AccessController.doPrivileged(() -> Boolean.getBoolean("sun.reflect.debugModuleAccessChecks"));
    private static final Module trampolineModule = MethodUtil.getTrampolineModule();

    public static Object invoke(Method m, Object obj, Object[] params) throws InvocationTargetException, IllegalAccessException {
        Class<?> clazz = m.getDeclaringClass();
        String packageName = clazz.getPackage().getName();
        Module module = clazz.getModule();
        Module thisModule = MethodHelper.class.getModule();
        try {
            if (!module.isExported(packageName)) {
                if (!module.isOpen(packageName, thisModule)) {
                    throw new IllegalAccessException("module " + thisModule.getName() + " cannot access class " + clazz.getName() + " (in module " + module.getName() + ") because module " + module.getName() + " does not open " + packageName + " to " + thisModule.getName());
                }
                if (!module.isOpen(packageName, trampolineModule)) {
                    ReflectUtil.checkPackageAccess((String)packageName);
                    module.addOpens(packageName, trampolineModule);
                }
            }
        }
        catch (IllegalAccessException ex) {
            if (logAccessErrors) {
                ex.printStackTrace(System.err);
            }
            throw ex;
        }
        return MethodUtil.invoke((Method)m, (Object)obj, (Object[])params);
    }

    private MethodHelper() {
    }
}

