/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.webkit.WebPage;
import com.sun.webkit.WebPageClient;
import com.sun.webkit.graphics.WCRectangle;

class WCWidget {
    private static final PlatformLogger log = PlatformLogger.getLogger((String)WCWidget.class.getName());
    private int x;
    private int y;
    private int width;
    private int height;
    private final WebPage page;

    WCWidget(WebPage page) {
        this.page = page;
    }

    WebPage getPage() {
        return this.page;
    }

    WCRectangle getBounds() {
        return new WCRectangle(this.x, this.y, this.width, this.height);
    }

    void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    protected void destroy() {
    }

    protected void requestFocus() {
    }

    protected void setCursor(long cursorID) {
    }

    protected void setVisible(boolean visible) {
    }

    private void fwkDestroy() {
        log.finer("destroy");
        this.destroy();
    }

    private void fwkSetBounds(int x, int y, int w, int h) {
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("setBounds({0}, {1}, {2}, {3})", new Object[]{x, y, w, h});
        }
        this.setBounds(x, y, w, h);
    }

    private void fwkRequestFocus() {
        log.finer("requestFocus");
        this.requestFocus();
    }

    private void fwkSetCursor(long cursorID) {
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("setCursor({0})", new Object[]{cursorID});
        }
        this.setCursor(cursorID);
    }

    private void fwkSetVisible(boolean visible) {
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("setVisible({0})", new Object[]{visible});
        }
        this.setVisible(visible);
    }

    protected int fwkGetScreenDepth() {
        log.finer("getScreenDepth");
        WebPageClient pageClient = this.page.getPageClient();
        return pageClient != null ? pageClient.getScreenDepth() : 24;
    }

    protected WCRectangle fwkGetScreenRect(boolean available) {
        WebPageClient pageClient;
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("getScreenRect({0})", new Object[]{available});
        }
        return (pageClient = this.page.getPageClient()) != null ? pageClient.getScreenBounds(available) : null;
    }

    private static native void initIDs();

    static {
        WCWidget.initIDs();
    }
}

