/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.graphics;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.prism.paint.Color;
import com.sun.webkit.graphics.BufferData;
import com.sun.webkit.graphics.RenderMediaControls;
import com.sun.webkit.graphics.RenderTheme;
import com.sun.webkit.graphics.ScrollBarTheme;
import com.sun.webkit.graphics.WCFont;
import com.sun.webkit.graphics.WCGradient;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCGraphicsManager;
import com.sun.webkit.graphics.WCIcon;
import com.sun.webkit.graphics.WCImage;
import com.sun.webkit.graphics.WCMediaPlayer;
import com.sun.webkit.graphics.WCPageBackBuffer;
import com.sun.webkit.graphics.WCPath;
import com.sun.webkit.graphics.WCPoint;
import com.sun.webkit.graphics.WCRectangle;
import com.sun.webkit.graphics.WCRenderQueue;
import com.sun.webkit.graphics.WCTransform;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class GraphicsDecoder {
    public static final int FILLRECT_FFFFI = 0;
    public static final int SETFILLCOLOR = 1;
    public static final int SETSTROKESTYLE = 2;
    public static final int SETSTROKECOLOR = 3;
    public static final int SETSTROKEWIDTH = 4;
    public static final int DRAWPOLYGON = 6;
    public static final int DRAWLINE = 7;
    public static final int DRAWIMAGE = 8;
    public static final int DRAWICON = 9;
    public static final int DRAWPATTERN = 10;
    public static final int TRANSLATE = 11;
    public static final int SAVESTATE = 12;
    public static final int RESTORESTATE = 13;
    public static final int CLIP_PATH = 14;
    public static final int SETCLIP_IIII = 15;
    public static final int DRAWRECT = 16;
    public static final int SETCOMPOSITE = 17;
    public static final int STROKEARC = 18;
    public static final int DRAWELLIPSE = 19;
    public static final int DRAWFOCUSRING = 20;
    public static final int SETALPHA = 21;
    public static final int BEGINTRANSPARENCYLAYER = 22;
    public static final int ENDTRANSPARENCYLAYER = 23;
    public static final int STROKE_PATH = 24;
    public static final int FILL_PATH = 25;
    public static final int GETIMAGE = 26;
    public static final int SCALE = 27;
    public static final int SETSHADOW = 28;
    public static final int DRAWSTRING = 29;
    public static final int DRAWSTRING_FAST = 31;
    public static final int DRAWWIDGET = 33;
    public static final int DRAWSCROLLBAR = 34;
    public static final int CLEARRECT_FFFF = 36;
    public static final int STROKERECT_FFFFF = 37;
    public static final int RENDERMEDIAPLAYER = 38;
    public static final int CONCATTRANSFORM_FFFFFF = 39;
    public static final int COPYREGION = 40;
    public static final int DECODERQ = 41;
    public static final int SET_TRANSFORM = 42;
    public static final int ROTATE = 43;
    public static final int RENDERMEDIACONTROL = 44;
    public static final int RENDERMEDIA_TIMETRACK = 45;
    public static final int RENDERMEDIA_VOLUMETRACK = 46;
    public static final int FILLRECT_FFFF = 47;
    public static final int FILL_ROUNDED_RECT = 48;
    public static final int SET_FILL_GRADIENT = 49;
    public static final int SET_STROKE_GRADIENT = 50;
    public static final int SET_LINE_DASH = 51;
    public static final int SET_LINE_CAP = 52;
    public static final int SET_LINE_JOIN = 53;
    public static final int SET_MITER_LIMIT = 54;
    public static final int SET_TEXT_MODE = 55;
    public static final int SET_PERSPECTIVE_TRANSFORM = 56;
    private static final PlatformLogger log = PlatformLogger.getLogger((String)GraphicsDecoder.class.getName());

    static void decode(WCGraphicsManager gm, WCGraphicsContext gc, BufferData bdata) {
        if (gc == null || !gc.isValid()) {
            log.fine("GraphicsDecoder::decode : GC is " + (gc == null ? "null" : " invalid"));
            return;
        }
        ByteBuffer buf = bdata.getBuffer();
        buf.order(ByteOrder.nativeOrder());
        block54: while (buf.remaining() > 0) {
            int op = buf.getInt();
            switch (op) {
                case 47: {
                    gc.fillRect(buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), null);
                    continue block54;
                }
                case 0: {
                    gc.fillRect(buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), GraphicsDecoder.getColor(buf));
                    continue block54;
                }
                case 48: {
                    gc.fillRoundedRect(buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), GraphicsDecoder.getColor(buf));
                    continue block54;
                }
                case 36: {
                    gc.clearRect(buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat());
                    continue block54;
                }
                case 37: {
                    gc.strokeRect(buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat());
                    continue block54;
                }
                case 1: {
                    gc.setFillColor(GraphicsDecoder.getColor(buf));
                    continue block54;
                }
                case 55: {
                    gc.setTextMode(GraphicsDecoder.getBoolean(buf), GraphicsDecoder.getBoolean(buf), GraphicsDecoder.getBoolean(buf));
                    continue block54;
                }
                case 2: {
                    gc.setStrokeStyle(buf.getInt());
                    continue block54;
                }
                case 3: {
                    gc.setStrokeColor(GraphicsDecoder.getColor(buf));
                    continue block54;
                }
                case 4: {
                    gc.setStrokeWidth(buf.getFloat());
                    continue block54;
                }
                case 49: {
                    gc.setFillGradient(GraphicsDecoder.getGradient(gc, buf));
                    continue block54;
                }
                case 50: {
                    gc.setStrokeGradient(GraphicsDecoder.getGradient(gc, buf));
                    continue block54;
                }
                case 51: {
                    gc.setLineDash(buf.getFloat(), GraphicsDecoder.getFloatArray(buf));
                    continue block54;
                }
                case 52: {
                    gc.setLineCap(buf.getInt());
                    continue block54;
                }
                case 53: {
                    gc.setLineJoin(buf.getInt());
                    continue block54;
                }
                case 54: {
                    gc.setMiterLimit(buf.getFloat());
                    continue block54;
                }
                case 6: {
                    gc.drawPolygon(GraphicsDecoder.getPath(gm, buf), buf.getInt() == -1);
                    continue block54;
                }
                case 7: {
                    gc.drawLine(buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt());
                    continue block54;
                }
                case 8: {
                    GraphicsDecoder.drawImage(gc, gm.getRef(buf.getInt()), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat());
                    continue block54;
                }
                case 9: {
                    gc.drawIcon((WCIcon)gm.getRef(buf.getInt()), buf.getInt(), buf.getInt());
                    continue block54;
                }
                case 10: {
                    GraphicsDecoder.drawPattern(gc, gm.getRef(buf.getInt()), GraphicsDecoder.getRectangle(buf), (WCTransform)gm.getRef(buf.getInt()), GraphicsDecoder.getPoint(buf), GraphicsDecoder.getRectangle(buf));
                    continue block54;
                }
                case 11: {
                    gc.translate(buf.getFloat(), buf.getFloat());
                    continue block54;
                }
                case 27: {
                    gc.scale(buf.getFloat(), buf.getFloat());
                    continue block54;
                }
                case 12: {
                    gc.saveState();
                    continue block54;
                }
                case 13: {
                    gc.restoreState();
                    continue block54;
                }
                case 14: {
                    gc.setClip(GraphicsDecoder.getPath(gm, buf), buf.getInt() > 0);
                    continue block54;
                }
                case 15: {
                    gc.setClip(buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt());
                    continue block54;
                }
                case 16: {
                    gc.drawRect(buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt());
                    continue block54;
                }
                case 17: {
                    gc.setComposite(buf.getInt());
                    continue block54;
                }
                case 18: {
                    gc.strokeArc(buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt());
                    continue block54;
                }
                case 19: {
                    gc.drawEllipse(buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt());
                    continue block54;
                }
                case 20: {
                    gc.drawFocusRing(buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt(), GraphicsDecoder.getColor(buf));
                    continue block54;
                }
                case 21: {
                    gc.setAlpha(buf.getFloat());
                    continue block54;
                }
                case 22: {
                    gc.beginTransparencyLayer(buf.getFloat());
                    continue block54;
                }
                case 23: {
                    gc.endTransparencyLayer();
                    continue block54;
                }
                case 24: {
                    gc.strokePath(GraphicsDecoder.getPath(gm, buf));
                    continue block54;
                }
                case 25: {
                    gc.fillPath(GraphicsDecoder.getPath(gm, buf));
                    continue block54;
                }
                case 28: {
                    gc.setShadow(buf.getFloat(), buf.getFloat(), buf.getFloat(), GraphicsDecoder.getColor(buf));
                    continue block54;
                }
                case 29: {
                    gc.drawString((WCFont)gm.getRef(buf.getInt()), bdata.getString(buf.getInt()), buf.getInt() == -1, buf.getInt(), buf.getInt(), buf.getFloat(), buf.getFloat());
                    continue block54;
                }
                case 31: {
                    gc.drawString((WCFont)gm.getRef(buf.getInt()), bdata.getIntArray(buf.getInt()), bdata.getFloatArray(buf.getInt()), buf.getFloat(), buf.getFloat());
                    continue block54;
                }
                case 33: {
                    gc.drawWidget((RenderTheme)gm.getRef(buf.getInt()), gm.getRef(buf.getInt()), buf.getInt(), buf.getInt());
                    continue block54;
                }
                case 34: {
                    gc.drawScrollbar((ScrollBarTheme)gm.getRef(buf.getInt()), gm.getRef(buf.getInt()), buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt());
                    continue block54;
                }
                case 38: {
                    WCMediaPlayer mp = (WCMediaPlayer)gm.getRef(buf.getInt());
                    mp.render(gc, buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt());
                    continue block54;
                }
                case 39: {
                    gc.concatTransform(new WCTransform(buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat()));
                    continue block54;
                }
                case 56: {
                    gc.setPerspectiveTransform(new WCTransform(buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat()));
                    continue block54;
                }
                case 42: {
                    gc.setTransform(new WCTransform(buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat()));
                    continue block54;
                }
                case 40: {
                    WCPageBackBuffer buffer = (WCPageBackBuffer)gm.getRef(buf.getInt());
                    buffer.copyArea(buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt());
                    continue block54;
                }
                case 41: {
                    WCRenderQueue _rq = (WCRenderQueue)gm.getRef(buf.getInt());
                    _rq.decode(gc.getFontSmoothingType());
                    continue block54;
                }
                case 43: {
                    gc.rotate(buf.getFloat());
                    continue block54;
                }
                case 44: {
                    RenderMediaControls.paintControl(gc, buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt());
                    continue block54;
                }
                case 45: {
                    int n = buf.getInt();
                    float[] buffered = new float[n * 2];
                    buf.asFloatBuffer().get(buffered);
                    buf.position(buf.position() + n * 4 * 2);
                    RenderMediaControls.paintTimeSliderTrack(gc, buf.getFloat(), buf.getFloat(), buffered, buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt());
                    continue block54;
                }
                case 46: {
                    RenderMediaControls.paintVolumeTrack(gc, buf.getFloat(), buf.getInt() != 0, buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt());
                    continue block54;
                }
            }
            log.fine("ERROR. Unknown primitive found");
        }
    }

    private static void drawPattern(WCGraphicsContext gc, Object imgFrame, WCRectangle srcRect, WCTransform patternTransform, WCPoint phase, WCRectangle destRect) {
        WCImage img = WCImage.getImage(imgFrame);
        if (img != null) {
            try {
                gc.drawPattern(img, srcRect, patternTransform, phase, destRect);
            }
            catch (OutOfMemoryError error) {
                error.printStackTrace();
            }
        }
    }

    private static void drawImage(WCGraphicsContext gc, Object imgFrame, float dstx, float dsty, float dstw, float dsth, float srcx, float srcy, float srcw, float srch) {
        WCImage img = WCImage.getImage(imgFrame);
        if (img != null) {
            try {
                gc.drawImage(img, dstx, dsty, dstw, dsth, srcx, srcy, srcw, srch);
            }
            catch (OutOfMemoryError error) {
                error.printStackTrace();
            }
        }
    }

    private static boolean getBoolean(ByteBuffer buf) {
        return 0 != buf.getInt();
    }

    private static float[] getFloatArray(ByteBuffer buf) {
        float[] array = new float[buf.getInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = buf.getFloat();
        }
        return array;
    }

    private static WCPath getPath(WCGraphicsManager gm, ByteBuffer buf) {
        WCPath path = (WCPath)gm.getRef(buf.getInt());
        path.setWindingRule(buf.getInt());
        return path;
    }

    private static WCPoint getPoint(ByteBuffer buf) {
        return new WCPoint(buf.getFloat(), buf.getFloat());
    }

    private static WCRectangle getRectangle(ByteBuffer buf) {
        return new WCRectangle(buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat());
    }

    private static Color getColor(ByteBuffer buf) {
        return new Color(buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat());
    }

    private static WCGradient getGradient(WCGraphicsContext gc, ByteBuffer buf) {
        WCPoint p1 = GraphicsDecoder.getPoint(buf);
        WCPoint p2 = GraphicsDecoder.getPoint(buf);
        WCGradient gradient = GraphicsDecoder.getBoolean(buf) ? gc.createRadialGradient(p1, buf.getFloat(), p2, buf.getFloat()) : gc.createLinearGradient(p1, p2);
        boolean proportional = GraphicsDecoder.getBoolean(buf);
        int spreadMethod = buf.getInt();
        if (gradient != null) {
            gradient.setProportional(proportional);
            gradient.setSpreadMethod(spreadMethod);
        }
        int count = buf.getInt();
        for (int i = 0; i < count; ++i) {
            Color color = GraphicsDecoder.getColor(buf);
            float offset = buf.getFloat();
            if (gradient == null) continue;
            gradient.addStop(color, offset);
        }
        return gradient;
    }
}

