/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.webkit.network.ByteBufferAllocator;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;

final class ByteBufferPool {
    private final Queue<ByteBuffer> byteBuffers = new ConcurrentLinkedQueue<ByteBuffer>();
    private final int bufferSize;

    private ByteBufferPool(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    static ByteBufferPool newInstance(int bufferSize) {
        return new ByteBufferPool(bufferSize);
    }

    ByteBufferAllocator newAllocator(int maxBufferCount) {
        return new ByteBufferAllocatorImpl(maxBufferCount);
    }

    private final class ByteBufferAllocatorImpl
    implements ByteBufferAllocator {
        private final Semaphore semaphore;

        private ByteBufferAllocatorImpl(int maxBufferCount) {
            this.semaphore = new Semaphore(maxBufferCount);
        }

        @Override
        public ByteBuffer allocate() throws InterruptedException {
            this.semaphore.acquire();
            ByteBuffer byteBuffer = ByteBufferPool.this.byteBuffers.poll();
            if (byteBuffer == null) {
                byteBuffer = ByteBuffer.allocateDirect(ByteBufferPool.this.bufferSize);
            }
            return byteBuffer;
        }

        @Override
        public void release(ByteBuffer byteBuffer) {
            byteBuffer.clear();
            ByteBufferPool.this.byteBuffers.add(byteBuffer);
            this.semaphore.release();
        }
    }
}

