/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.webkit.network.Cookie;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

final class CookieStore {
    private static final PlatformLogger logger = PlatformLogger.getLogger((String)CookieStore.class.getName());
    private static final int MAX_BUCKET_SIZE = 50;
    private static final int TOTAL_COUNT_LOWER_THRESHOLD = 3000;
    private static final int TOTAL_COUNT_UPPER_THRESHOLD = 4000;
    private final Map<String, Map<Cookie, Cookie>> buckets = new HashMap<String, Map<Cookie, Cookie>>();
    private int totalCount = 0;

    CookieStore() {
    }

    Cookie get(Cookie cookie) {
        Map<Cookie, Cookie> bucket = this.buckets.get(cookie.getDomain());
        if (bucket == null) {
            return null;
        }
        Cookie storedCookie = bucket.get(cookie);
        if (storedCookie == null) {
            return null;
        }
        if (storedCookie.hasExpired()) {
            bucket.remove(storedCookie);
            --this.totalCount;
            this.log("Expired cookie removed by get", storedCookie, bucket);
            return null;
        }
        return storedCookie;
    }

    List<Cookie> get(String hostname, String path, boolean secureProtocol, boolean httpApi) {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("hostname: [{0}], path: [{1}], secureProtocol: [{2}], httpApi: [{3}]", new Object[]{hostname, path, secureProtocol, httpApi});
        }
        ArrayList<Cookie> result = new ArrayList<Cookie>();
        String domain = hostname;
        while (domain.length() > 0) {
            int nextPoint;
            Map<Cookie, Cookie> bucket = this.buckets.get(domain);
            if (bucket != null) {
                this.find(result, bucket, hostname, path, secureProtocol, httpApi);
            }
            if ((nextPoint = domain.indexOf(46)) == -1) break;
            domain = domain.substring(nextPoint + 1);
        }
        Collections.sort(result, new GetComparator());
        long currentTime = System.currentTimeMillis();
        for (Cookie cookie : result) {
            cookie.setLastAccessTime(currentTime);
        }
        logger.finest("result: {0}", new Object[]{result});
        return result;
    }

    private void find(List<Cookie> list, Map<Cookie, Cookie> bucket, String hostname, String path, boolean secureProtocol, boolean httpApi) {
        Iterator<Cookie> it = bucket.values().iterator();
        while (it.hasNext()) {
            Cookie cookie = it.next();
            if (cookie.hasExpired()) {
                it.remove();
                --this.totalCount;
                this.log("Expired cookie removed by find", cookie, bucket);
                continue;
            }
            if (!cookie.getHostOnly() ? !Cookie.domainMatches(hostname, cookie.getDomain()) : !hostname.equalsIgnoreCase(cookie.getDomain())) continue;
            if (!Cookie.pathMatches(path, cookie.getPath()) || cookie.getSecureOnly() && !secureProtocol || cookie.getHttpOnly() && !httpApi) continue;
            list.add(cookie);
        }
    }

    void put(Cookie cookie) {
        Map<Cookie, Cookie> bucket = this.buckets.get(cookie.getDomain());
        if (bucket == null) {
            bucket = new LinkedHashMap<Cookie, Cookie>(20);
            this.buckets.put(cookie.getDomain(), bucket);
        }
        if (cookie.hasExpired()) {
            this.log("Cookie expired", cookie, bucket);
            if (bucket.remove(cookie) != null) {
                --this.totalCount;
                this.log("Expired cookie removed by put", cookie, bucket);
            }
        } else if (bucket.put(cookie, cookie) == null) {
            ++this.totalCount;
            this.log("Cookie added", cookie, bucket);
            if (bucket.size() > 50) {
                this.purge(bucket);
            }
            if (this.totalCount > 4000) {
                this.purge();
            }
        } else {
            this.log("Cookie updated", cookie, bucket);
        }
    }

    private void purge(Map<Cookie, Cookie> bucket) {
        logger.finest("Purging bucket: {0}", new Object[]{bucket.values()});
        Cookie earliestCookie = null;
        Iterator<Cookie> it = bucket.values().iterator();
        while (it.hasNext()) {
            Cookie cookie = it.next();
            if (cookie.hasExpired()) {
                it.remove();
                --this.totalCount;
                this.log("Expired cookie removed", cookie, bucket);
                continue;
            }
            if (earliestCookie != null && cookie.getLastAccessTime() >= earliestCookie.getLastAccessTime()) continue;
            earliestCookie = cookie;
        }
        if (bucket.size() > 50) {
            bucket.remove(earliestCookie);
            --this.totalCount;
            this.log("Excess cookie removed", earliestCookie, bucket);
        }
    }

    private void purge() {
        logger.finest("Purging store");
        PriorityQueue<Cookie> removalQueue = new PriorityQueue<Cookie>(this.totalCount / 2, new RemovalComparator());
        for (Map.Entry<String, Map<Cookie, Cookie>> entry : this.buckets.entrySet()) {
            Map<Cookie, Cookie> bucket = entry.getValue();
            Iterator<Cookie> it = bucket.values().iterator();
            while (it.hasNext()) {
                Cookie cookie = it.next();
                if (cookie.hasExpired()) {
                    it.remove();
                    --this.totalCount;
                    this.log("Expired cookie removed", cookie, bucket);
                    continue;
                }
                removalQueue.add(cookie);
            }
        }
        while (this.totalCount > 3000) {
            Cookie cookie = (Cookie)removalQueue.remove();
            Map<Cookie, Cookie> bucket = this.buckets.get(cookie.getDomain());
            if (bucket == null) continue;
            bucket.remove(cookie);
            --this.totalCount;
            this.log("Excess cookie removed", cookie, bucket);
        }
    }

    private void log(String message, Cookie cookie, Map<Cookie, Cookie> bucket) {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("{0}: {1}, bucket size: {2}, total count: {3}", new Object[]{message, cookie, bucket.size(), this.totalCount});
        }
    }

    private static final class GetComparator
    implements Comparator<Cookie> {
        private GetComparator() {
        }

        @Override
        public int compare(Cookie c1, Cookie c2) {
            int d = c2.getPath().length() - c1.getPath().length();
            if (d != 0) {
                return d;
            }
            return c1.getCreationTime().compareTo(c2.getCreationTime());
        }
    }

    private static final class RemovalComparator
    implements Comparator<Cookie> {
        private RemovalComparator() {
        }

        @Override
        public int compare(Cookie c1, Cookie c2) {
            return (int)(c1.getLastAccessTime() - c2.getLastAccessTime());
        }
    }
}

