/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.tk.Toolkit;
import com.sun.webkit.Invoker;
import com.sun.webkit.WebPage;
import com.sun.webkit.network.ByteBufferPool;
import com.sun.webkit.network.FormDataElement;
import com.sun.webkit.network.URLLoader;
import com.sun.webkit.network.URLLoaderBase;
import com.sun.webkit.network.URLs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.ConnectException;
import java.net.CookieHandler;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLHandshakeException;

final class HTTP2Loader
extends URLLoaderBase {
    private static final PlatformLogger logger = PlatformLogger.getLogger((String)URLLoader.class.getName());
    private final WebPage webPage;
    private final boolean asynchronous;
    private String url;
    private String method;
    private final String headers;
    private FormDataElement[] formDataElements;
    private final long data;
    private volatile boolean canceled = false;
    private final CompletableFuture<Void> response;
    private static final HttpClient HTTP_CLIENT = AccessController.doPrivileged(() -> HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NEVER).connectTimeout(Duration.ofSeconds(30L)).cookieHandler(CookieHandler.getDefault()).build());
    private static final int DEFAULT_BUFSIZE = 40960;
    private static final ByteBuffer BUFFER;

    static HTTP2Loader create(WebPage webPage, ByteBufferPool byteBufferPool, boolean asynchronous, String url, String method, String headers, FormDataElement[] formDataElements, long data) {
        if (url.startsWith("http://") || url.startsWith("https://")) {
            return new HTTP2Loader(webPage, byteBufferPool, asynchronous, url, method, headers, formDataElements, data);
        }
        return null;
    }

    private String[] getCustomHeaders() {
        Locale loc = Locale.getDefault();
        Object lang = "";
        if (!loc.equals(Locale.US) && !loc.equals(Locale.ENGLISH)) {
            lang = loc.getCountry().isEmpty() ? loc.getLanguage() + "," : loc.getLanguage() + "-" + loc.getCountry() + ",";
        }
        return new String[]{"Accept-Language", ((String)lang).toLowerCase() + "en-us;q=0.8,en;q=0.7", "Accept-Encoding", "gzip, inflate", "Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7"};
    }

    private String[] getRequestHeaders() {
        return (String[])Arrays.stream(this.headers.split("\n")).flatMap(s -> Stream.of(s.split(":", 2))).toArray(String[]::new);
    }

    private URI toURI() throws MalformedURLException {
        URI uriObj;
        try {
            uriObj = new URI(this.url);
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            try {
                URL urlObj = URLs.newURL(this.url);
                uriObj = new URI(urlObj.getProtocol(), urlObj.getUserInfo(), urlObj.getHost(), urlObj.getPort(), urlObj.getPath(), urlObj.getQuery(), urlObj.getRef());
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException ex) {
                throw new MalformedURLException(this.url);
            }
        }
        return uriObj;
    }

    private HttpRequest.BodyPublisher getFormDataPublisher() {
        if (this.formDataElements == null) {
            return HttpRequest.BodyPublishers.noBody();
        }
        Vector<InputStream> formDataElementsStream = new Vector<InputStream>();
        final AtomicLong length = new AtomicLong();
        for (FormDataElement formData : this.formDataElements) {
            try {
                formData.open();
                length.addAndGet(formData.getSize());
                formDataElementsStream.add(formData.getInputStream());
            }
            catch (IOException ex) {
                return null;
            }
        }
        SequenceInputStream stream = new SequenceInputStream(formDataElementsStream.elements());
        final HttpRequest.BodyPublisher streamBodyPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> stream);
        HttpRequest.BodyPublisher formDataPublisher = new HttpRequest.BodyPublisher(){

            @Override
            public long contentLength() {
                return length.longValue() <= Integer.MAX_VALUE ? length.longValue() : -1L;
            }

            @Override
            public void subscribe(final Flow.Subscriber<? super ByteBuffer> subscriber) {
                streamBodyPublisher.subscribe(new Flow.Subscriber<ByteBuffer>(){

                    @Override
                    public void onComplete() {
                        subscriber.onComplete();
                    }

                    @Override
                    public void onError(Throwable th) {
                        subscriber.onError(th);
                    }

                    @Override
                    public void onNext(ByteBuffer bytes) {
                        subscriber.onNext(bytes);
                        HTTP2Loader.this.didSendData(bytes.limit(), length.longValue());
                    }

                    @Override
                    public void onSubscribe(Flow.Subscription subscription) {
                        subscriber.onSubscribe(subscription);
                    }
                });
            }
        };
        return formDataPublisher;
    }

    private InputStream createZIPStream(String type, InputStream in) throws IOException {
        if ("gzip".equalsIgnoreCase(type)) {
            return new GZIPInputStream(in);
        }
        if ("deflate".equalsIgnoreCase(type)) {
            return new InflaterInputStream(in);
        }
        return in;
    }

    private HttpResponse.BodySubscriber<Void> createZIPEncodedBodySubscriber(String contentEncoding) {
        if (!"gzip".equalsIgnoreCase(contentEncoding) && !"inflate".equalsIgnoreCase(contentEncoding)) {
            logger.severe(String.format("Unknown encoding type '%s' found, discarding", contentEncoding));
            return HttpResponse.BodySubscribers.discarding();
        }
        final HttpResponse.BodySubscriber<InputStream> streamSubscriber = HttpResponse.BodySubscribers.ofInputStream();
        final CompletionStage<Void> unzipTask = streamSubscriber.getBody().thenAcceptAsync(is -> {
            try (InputStream stream = is;
                 InputStream in = this.createZIPStream(contentEncoding, stream);){
                while (!this.canceled) {
                    byte[] buf = new byte[8192];
                    int read = in.read(buf);
                    if (read < 0) {
                        this.didFinishLoading();
                        break;
                    }
                    this.didReceiveData(buf, read);
                }
            }
            catch (IOException ex) {
                this.didFail(ex);
            }
        });
        return new HttpResponse.BodySubscriber<Void>(){

            @Override
            public void onComplete() {
                streamSubscriber.onComplete();
            }

            @Override
            public void onError(Throwable th) {
                streamSubscriber.onError(th);
            }

            @Override
            public void onNext(List<ByteBuffer> bytes) {
                streamSubscriber.onNext(bytes);
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                streamSubscriber.onSubscribe(subscription);
            }

            @Override
            public CompletionStage<Void> getBody() {
                return streamSubscriber.getBody().thenCombine(unzipTask, (t, u) -> null);
            }
        };
    }

    private HttpResponse.BodySubscriber<Void> createNormalBodySubscriber() {
        HttpResponse.BodySubscriber<Void> normalBodySubscriber = HttpResponse.BodySubscribers.fromSubscriber((Flow.Subscriber<? super List<ByteBuffer>>)new Flow.Subscriber<List<ByteBuffer>>(){
            private Flow.Subscription subscription;
            private final AtomicBoolean subscribed = new AtomicBoolean();

            @Override
            public void onComplete() {
                HTTP2Loader.this.didFinishLoading();
            }

            @Override
            public void onError(Throwable th) {
            }

            @Override
            public void onNext(List<ByteBuffer> bytes) {
                HTTP2Loader.this.didReceiveData(bytes);
                this.requestIfNotCancelled();
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                if (!this.subscribed.compareAndSet(false, true)) {
                    subscription.cancel();
                } else {
                    this.subscription = subscription;
                    this.requestIfNotCancelled();
                }
            }

            private void requestIfNotCancelled() {
                if (HTTP2Loader.this.canceled) {
                    this.subscription.cancel();
                } else {
                    this.subscription.request(1L);
                }
            }
        });
        return normalBodySubscriber;
    }

    private HttpResponse.BodySubscriber<Void> getBodySubscriber(String contentEncoding) {
        return contentEncoding.isEmpty() ? this.createNormalBodySubscriber() : this.createZIPEncodedBodySubscriber(contentEncoding);
    }

    private HTTP2Loader(WebPage webPage, ByteBufferPool byteBufferPool, boolean asynchronous, String url, String method, String headers, FormDataElement[] formDataElements, long data) {
        CompletableFuture tmpResponse;
        URI uri;
        this.webPage = webPage;
        this.asynchronous = asynchronous;
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.formDataElements = formDataElements;
        this.data = data;
        try {
            uri = this.toURI();
        }
        catch (MalformedURLException e) {
            this.response = null;
            this.didFail(e);
            return;
        }
        HttpRequest request = HttpRequest.newBuilder().uri(uri).headers(this.getRequestHeaders()).headers(this.getCustomHeaders()).version(HttpClient.Version.HTTP_2).method(method, this.getFormDataPublisher()).build();
        HttpResponse.BodyHandler bodyHandler = rsp -> {
            if (!this.handleRedirectionIfNeeded(rsp)) {
                this.didReceiveResponse(rsp);
            }
            return this.getBodySubscriber(HTTP2Loader.getContentEncoding(rsp));
        };
        this.response = tmpResponse = AccessController.doPrivileged(() -> ((CompletableFuture)HTTP_CLIENT.sendAsync(request, bodyHandler).thenAccept($ -> {})).exceptionally(ex -> this.didFail(ex.getCause())), webPage.getAccessControlContext());
        if (!asynchronous) {
            this.waitForRequestToComplete();
        }
    }

    @Override
    public void fwkCancel() {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("data: [0x%016X]", this.data));
        }
        this.canceled = true;
    }

    private void callBackIfNotCanceled(Runnable r) {
        Invoker.getInvoker().invokeOnEventThread(() -> {
            if (!this.canceled) {
                r.run();
            }
        });
    }

    private void waitForRequestToComplete() {
        Object key = new Object();
        this.response.handle((r, th) -> {
            Invoker.getInvoker().invokeOnEventThread(() -> Toolkit.getToolkit().exitNestedEventLoop(key, null));
            return null;
        });
        Toolkit.getToolkit().enterNestedEventLoop(key);
    }

    private boolean handleRedirectionIfNeeded(HttpResponse.ResponseInfo rsp) {
        switch (rsp.statusCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                this.willSendRequest(rsp);
                return true;
            }
            case 304: {
                this.didReceiveResponse(rsp);
                this.didFinishLoading();
                return true;
            }
        }
        return false;
    }

    private static long getContentLength(HttpResponse.ResponseInfo rsp) {
        return rsp.headers().firstValueAsLong("content-length").orElse(-1L);
    }

    private static String getContentType(HttpResponse.ResponseInfo rsp) {
        return rsp.headers().firstValue("content-type").orElse("application/octet-stream");
    }

    private static String getContentEncoding(HttpResponse.ResponseInfo rsp) {
        return rsp.headers().firstValue("content-encoding").orElse("");
    }

    private static String getHeadersAsString(HttpResponse.ResponseInfo rsp) {
        return rsp.headers().map().entrySet().stream().map(e -> String.format("%s:%s", e.getKey(), ((List)e.getValue()).stream().collect(Collectors.joining(",")))).collect(Collectors.joining("\n")) + "\n";
    }

    private void willSendRequest(HttpResponse.ResponseInfo rsp) {
        this.callBackIfNotCanceled(() -> HTTP2Loader.twkWillSendRequest(rsp.statusCode(), HTTP2Loader.getContentType(rsp), "", HTTP2Loader.getContentLength(rsp), HTTP2Loader.getHeadersAsString(rsp), this.url, this.data));
    }

    private void didReceiveResponse(HttpResponse.ResponseInfo rsp) {
        this.callBackIfNotCanceled(() -> HTTP2Loader.twkDidReceiveResponse(rsp.statusCode(), HTTP2Loader.getContentType(rsp), "", HTTP2Loader.getContentLength(rsp), HTTP2Loader.getHeadersAsString(rsp), this.url, this.data));
    }

    private ByteBuffer getDirectBuffer(int size) {
        ByteBuffer dbb = BUFFER;
        if (size > dbb.capacity()) {
            dbb = ByteBuffer.allocateDirect(size);
        }
        return dbb.clear();
    }

    private ByteBuffer copyToDirectBuffer(ByteBuffer bb) {
        return this.getDirectBuffer(bb.limit()).put(bb).flip();
    }

    private void didReceiveData(byte[] bytes, int size) {
        this.callBackIfNotCanceled(() -> this.notifyDidReceiveData(this.getDirectBuffer(size).put(bytes, 0, size).flip()));
    }

    private void didReceiveData(List<ByteBuffer> bytes) {
        this.callBackIfNotCanceled(() -> bytes.stream().map(this::copyToDirectBuffer).forEach(this::notifyDidReceiveData));
    }

    private void notifyDidReceiveData(ByteBuffer byteBuffer) {
        Invoker.getInvoker().checkEventThread();
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("byteBuffer: [%s], position: [%s], remaining: [%s], data: [0x%016X]", byteBuffer, byteBuffer.position(), byteBuffer.remaining(), this.data));
        }
        HTTP2Loader.twkDidReceiveData(byteBuffer, byteBuffer.position(), byteBuffer.remaining(), this.data);
    }

    private void didFinishLoading() {
        this.callBackIfNotCanceled(this::notifyDidFinishLoading);
    }

    private void notifyDidFinishLoading() {
        Invoker.getInvoker().checkEventThread();
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("data: [0x%016X]", this.data));
        }
        HTTP2Loader.twkDidFinishLoading(this.data);
    }

    private Void didFail(Throwable th) {
        this.callBackIfNotCanceled(() -> {
            int errorCode;
            try {
                throw th;
            }
            catch (MalformedURLException ex) {
                errorCode = 2;
            }
            catch (AccessControlException ex) {
                errorCode = 8;
            }
            catch (UnknownHostException ex) {
                errorCode = 1;
            }
            catch (NoRouteToHostException ex) {
                errorCode = 6;
            }
            catch (ConnectException ex) {
                errorCode = 4;
            }
            catch (SocketException ex) {
                errorCode = 5;
            }
            catch (SSLHandshakeException ex) {
                errorCode = 3;
            }
            catch (SocketTimeoutException | HttpTimeoutException ex) {
                errorCode = 7;
            }
            catch (FileNotFoundException ex) {
                errorCode = 11;
            }
            catch (Throwable ex) {
                errorCode = 99;
            }
            this.notifyDidFail(errorCode, this.url, th.getMessage());
        });
        return null;
    }

    private void notifyDidFail(int errorCode, String url, String message) {
        Invoker.getInvoker().checkEventThread();
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("errorCode: [%d], url: [%s], message: [%s], data: [0x%016X]", errorCode, url, message, this.data));
        }
        HTTP2Loader.twkDidFail(errorCode, url, message, this.data);
    }

    private void didSendData(long totalBytesSent, long totalBytesToBeSent) {
        this.callBackIfNotCanceled(() -> this.notifyDidSendData(totalBytesSent, totalBytesToBeSent));
    }

    private void notifyDidSendData(long totalBytesSent, long totalBytesToBeSent) {
        Invoker.getInvoker().checkEventThread();
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("totalBytesSent: [%d], totalBytesToBeSent: [%d], data: [0x%016X]", totalBytesSent, totalBytesToBeSent, this.data));
        }
        HTTP2Loader.twkDidSendData(totalBytesSent, totalBytesToBeSent, this.data);
    }

    static {
        int bufSize = AccessController.doPrivileged(() -> Integer.valueOf(System.getProperty("jdk.httpclient.bufsize", Integer.toString(40960))));
        BUFFER = ByteBuffer.allocateDirect(bufSize);
    }
}

