/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.webkit.Invoker;
import com.sun.webkit.WebPage;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.List;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;

final class SocketStreamHandle {
    private static final Pattern FIRST_LINE_PATTERN = Pattern.compile("^HTTP/1.[01]\\s+(\\d{3})(?:\\s.*)?$");
    private static final PlatformLogger logger = PlatformLogger.getLogger((String)SocketStreamHandle.class.getName());
    private static final ThreadPoolExecutor threadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new CustomThreadFactory());
    private final String host;
    private final int port;
    private final boolean ssl;
    private final WebPage webPage;
    private final long data;
    private volatile Socket socket;
    private volatile State state = State.ACTIVE;
    private volatile boolean connected;

    private SocketStreamHandle(String host, int port, boolean ssl, WebPage webPage, long data) {
        this.host = host;
        this.port = port;
        this.ssl = ssl;
        this.webPage = webPage;
        this.data = data;
    }

    private static SocketStreamHandle fwkCreate(String host, int port, boolean ssl, WebPage webPage, long data) {
        SocketStreamHandle ssh = new SocketStreamHandle(host, port, ssl, webPage, data);
        logger.finest("Starting {0}", new Object[]{ssh});
        threadPool.submit(() -> ssh.run());
        return ssh;
    }

    private void run() {
        if (this.webPage == null) {
            logger.finest("{0} is not associated with any web page, aborted", new Object[]{this});
            this.didFail(0, "Web socket is not associated with any web page");
            this.didClose();
            return;
        }
        AccessController.doPrivileged(() -> {
            this.doRun();
            return null;
        }, this.webPage.getAccessControlContext());
    }

    private void doRun() {
        Throwable error = null;
        String errorDescription = null;
        try {
            byte[] buffer;
            int n;
            logger.finest("{0} started", new Object[]{this});
            this.connect();
            this.connected = true;
            logger.finest("{0} connected", new Object[]{this});
            this.didOpen();
            InputStream is = this.socket.getInputStream();
            while ((n = is.read(buffer = new byte[8192])) > 0) {
                if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
                    logger.finest(String.format("%s received len: [%d], data:%s", this, n, SocketStreamHandle.dump(buffer, n)));
                }
                this.didReceiveData(buffer, n);
            }
            logger.finest("{0} connection closed by remote host", new Object[]{this});
        }
        catch (UnknownHostException ex) {
            error = ex;
            errorDescription = "Unknown host";
        }
        catch (ConnectException ex) {
            error = ex;
            errorDescription = "Unable to connect";
        }
        catch (NoRouteToHostException ex) {
            error = ex;
            errorDescription = "No route to host";
        }
        catch (PortUnreachableException ex) {
            error = ex;
            errorDescription = "Port unreachable";
        }
        catch (SocketException ex) {
            if (this.state != State.ACTIVE) {
                if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
                    logger.finest(String.format("%s exception (most likely caused by local close)", this), (Throwable)ex);
                }
            } else {
                error = ex;
                errorDescription = "Socket error";
            }
        }
        catch (SSLException ex) {
            error = ex;
            errorDescription = "SSL error";
        }
        catch (IOException ex) {
            error = ex;
            errorDescription = "I/O error";
        }
        catch (SecurityException ex) {
            error = ex;
            errorDescription = "Security error";
        }
        catch (Throwable th) {
            error = th;
        }
        if (error != null) {
            if (errorDescription == null) {
                errorDescription = "Unknown error";
                logger.warning(String.format("%s unexpected error", this), error);
            } else {
                logger.finest(String.format("%s exception", this), error);
            }
            this.didFail(0, errorDescription);
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.didClose();
        logger.finest("{0} finished", new Object[]{this});
    }

    private void connect() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.host, this.port);
        }
        boolean success = false;
        IOException lastException = null;
        boolean triedDirectConnection = false;
        ProxySelector proxySelector = AccessController.doPrivileged(() -> ProxySelector.getDefault());
        if (proxySelector != null) {
            URI uri;
            try {
                uri = new URI((this.ssl ? "https" : "http") + "://" + this.host);
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
            if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
                logger.finest(String.format("%s selecting proxies for: [%s]", this, uri));
            }
            List<Proxy> proxies = proxySelector.select(uri);
            if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
                logger.finest(String.format("%s selected proxies: %s", this, proxies));
            }
            for (Proxy proxy : proxies) {
                if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
                    logger.finest(String.format("%s trying proxy: [%s]", this, proxy));
                }
                if (proxy.type() == Proxy.Type.DIRECT) {
                    triedDirectConnection = true;
                }
                try {
                    this.connect(proxy);
                    success = true;
                    break;
                }
                catch (IOException ex) {
                    logger.finest(String.format("%s exception", this), (Throwable)ex);
                    lastException = ex;
                    if (proxy.address() == null) continue;
                    proxySelector.connectFailed(uri, proxy.address(), ex);
                }
            }
        }
        if (!success && !triedDirectConnection) {
            logger.finest("{0} trying direct connection", new Object[]{this});
            this.connect(Proxy.NO_PROXY);
            success = true;
        }
        if (!success) {
            throw lastException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(Proxy proxy) throws IOException {
        SocketStreamHandle socketStreamHandle = this;
        synchronized (socketStreamHandle) {
            if (this.state != State.ACTIVE) {
                throw new SocketException("Close requested");
            }
            this.socket = new Socket(proxy);
        }
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("%s connecting to: [%s:%d]", this, this.host, this.port));
        }
        this.socket.connect(new InetSocketAddress(this.host, this.port));
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("%s connected to: [%s:%d]", this, this.host, this.port));
        }
        if (this.ssl) {
            socketStreamHandle = this;
            synchronized (socketStreamHandle) {
                if (this.state != State.ACTIVE) {
                    throw new SocketException("Close requested");
                }
                logger.finest("{0} starting SSL handshake", new Object[]{this});
                this.socket = HttpsURLConnection.getDefaultSSLSocketFactory().createSocket(this.socket, this.host, this.port, true);
            }
            ((SSLSocket)this.socket).startHandshake();
        }
    }

    private int fwkSend(byte[] buffer) {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("%s sending len: [%d], data:%s", this, buffer.length, SocketStreamHandle.dump(buffer, buffer.length)));
        }
        if (this.connected) {
            try {
                this.socket.getOutputStream().write(buffer);
                return buffer.length;
            }
            catch (IOException ex) {
                logger.finest(String.format("%s exception", this), (Throwable)ex);
                this.didFail(0, "I/O error");
                return 0;
            }
        }
        logger.finest("{0} not connected", new Object[]{this});
        this.didFail(0, "Not connected");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fwkClose() {
        SocketStreamHandle socketStreamHandle = this;
        synchronized (socketStreamHandle) {
            logger.finest("{0}", new Object[]{this});
            this.state = State.CLOSE_REQUESTED;
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void fwkNotifyDisposed() {
        logger.finest("{0}", new Object[]{this});
        this.state = State.DISPOSED;
    }

    private void didOpen() {
        Invoker.getInvoker().postOnEventThread(() -> {
            if (this.state == State.ACTIVE) {
                this.notifyDidOpen();
            }
        });
    }

    private void didReceiveData(byte[] buffer, int len) {
        Invoker.getInvoker().postOnEventThread(() -> {
            if (this.state == State.ACTIVE) {
                this.notifyDidReceiveData(buffer, len);
            }
        });
    }

    private void didFail(int errorCode, String errorDescription) {
        Invoker.getInvoker().postOnEventThread(() -> {
            if (this.state == State.ACTIVE) {
                this.notifyDidFail(errorCode, errorDescription);
            }
        });
    }

    private void didClose() {
        Invoker.getInvoker().postOnEventThread(() -> {
            if (this.state != State.DISPOSED) {
                this.notifyDidClose();
            }
        });
    }

    private void notifyDidOpen() {
        logger.finest("{0}", new Object[]{this});
        SocketStreamHandle.twkDidOpen(this.data);
    }

    private void notifyDidReceiveData(byte[] buffer, int len) {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("%s, len: [%d], data:%s", this, len, SocketStreamHandle.dump(buffer, len)));
        }
        SocketStreamHandle.twkDidReceiveData(buffer, len, this.data);
    }

    private void notifyDidFail(int errorCode, String errorDescription) {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("%s, errorCode: %d, errorDescription: %s", this, errorCode, errorDescription));
        }
        SocketStreamHandle.twkDidFail(errorCode, errorDescription, this.data);
    }

    private void notifyDidClose() {
        logger.finest("{0}", new Object[]{this});
        SocketStreamHandle.twkDidClose(this.data);
    }

    private static native void twkDidOpen(long var0);

    private static native void twkDidReceiveData(byte[] var0, int var1, long var2);

    private static native void twkDidFail(int var0, String var1, long var2);

    private static native void twkDidClose(long var0);

    private static String dump(byte[] buffer, int len) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < len) {
            StringBuilder c1 = new StringBuilder();
            StringBuilder c2 = new StringBuilder();
            int k = 0;
            while (k < 16) {
                if (i < len) {
                    int b = buffer[i] & 0xFF;
                    c1.append(String.format("%02x ", b));
                    c2.append(b >= 32 && b <= 126 ? (char)b : (char)'.');
                } else {
                    c1.append("   ");
                }
                ++k;
                ++i;
            }
            sb.append(String.format("%n  ", new Object[0])).append((CharSequence)c1).append(' ').append((CharSequence)c2);
        }
        return sb.toString();
    }

    public String toString() {
        return String.format("SocketStreamHandle{host=%s, port=%d, ssl=%s, data=0x%016X, state=%s, connected=%s}", new Object[]{this.host, this.port, this.ssl, this.data, this.state, this.connected});
    }

    private static enum State {
        ACTIVE,
        CLOSE_REQUESTED,
        DISPOSED;

    }

    private static final class CustomThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger index = new AtomicInteger(1);

        private CustomThreadFactory() {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm != null ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, "SocketStreamHandle-" + this.index.getAndIncrement());
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

