/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.perf;

import com.sun.javafx.logging.PlatformLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class PerfLogger {
    private static Thread shutdownHook;
    private static Map<PlatformLogger, PerfLogger> loggers;
    private final HashMap<String, ProbeStat> probes = new HashMap();
    private final PlatformLogger log;
    private final boolean isEnabled;
    private final Comparator timeComparator = (arg0, arg1) -> {
        long t0 = this.probes.get((Object)((String)arg0)).totalTime;
        long t1 = this.probes.get((Object)((String)arg1)).totalTime;
        if (t0 > t1) {
            return 1;
        }
        if (t0 < t1) {
            return -1;
        }
        return 0;
    };
    private final Comparator countComparator = (arg0, arg1) -> {
        long c0 = this.probes.get((Object)((String)arg0)).count;
        long c1 = this.probes.get((Object)((String)arg1)).count;
        if (c0 > c1) {
            return 1;
        }
        if (c0 < c1) {
            return -1;
        }
        return 0;
    };

    public static synchronized PerfLogger getLogger(PlatformLogger log) {
        PerfLogger l;
        if (loggers == null) {
            loggers = new HashMap<PlatformLogger, PerfLogger>();
        }
        if ((l = loggers.get(log)) == null) {
            l = new PerfLogger(log);
            loggers.put(log, l);
        }
        if (l.isEnabled() && shutdownHook == null) {
            shutdownHook = new Thread(){

                @Override
                public void run() {
                    for (PerfLogger l : loggers.values()) {
                        if (!l.isEnabled()) continue;
                        l.log(false);
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        return l;
    }

    public static synchronized PerfLogger getLogger(String name) {
        return PerfLogger.getLogger(PlatformLogger.getLogger((String)("com.sun.webkit.perf." + name)));
    }

    private PerfLogger(PlatformLogger log) {
        this.log = log;
        this.isEnabled = log.isLoggable(PlatformLogger.Level.FINE);
        this.startCount("TOTALTIME");
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private synchronized String fullName(String probe) {
        return this.log.getName() + "." + probe;
    }

    public synchronized void reset() {
        for (Map.Entry<String, ProbeStat> entry : this.probes.entrySet()) {
            entry.getValue().reset();
        }
        this.startCount("TOTALTIME");
    }

    public static synchronized void resetAll() {
        for (PerfLogger l : loggers.values()) {
            l.reset();
        }
    }

    private synchronized ProbeStat registerProbe(String probe) {
        String p = probe.intern();
        if (this.probes.containsKey(p)) {
            this.log.fine("Warning: \"" + this.fullName(p) + "\" probe already exists");
        } else {
            this.log.fine("Registering \"" + this.fullName(p) + "\" probe");
        }
        ProbeStat stat = new ProbeStat(p);
        this.probes.put(p, stat);
        return stat;
    }

    public synchronized ProbeStat getProbeStat(String probe) {
        String p = probe.intern();
        ProbeStat s = this.probes.get(p);
        if (s != null) {
            s.snapshot();
        }
        return s;
    }

    public synchronized void startCount(String probe) {
        if (!this.isEnabled()) {
            return;
        }
        String p = probe.intern();
        ProbeStat stat = this.probes.get(p);
        if (stat == null) {
            stat = this.registerProbe(p);
        }
        stat.reset();
        stat.resume();
    }

    public synchronized void suspendCount(String probe) {
        if (!this.isEnabled()) {
            return;
        }
        String p = probe.intern();
        ProbeStat stat = this.probes.get(p);
        if (stat != null) {
            stat.suspend();
        } else {
            this.log.fine("Warning: \"" + this.fullName(p) + "\" probe is not registered");
        }
    }

    public synchronized void resumeCount(String probe) {
        if (!this.isEnabled()) {
            return;
        }
        String p = probe.intern();
        ProbeStat stat = this.probes.get(p);
        if (stat == null) {
            stat = this.registerProbe(p);
        }
        stat.resume();
    }

    public synchronized void log(StringBuffer buf) {
        if (!this.isEnabled()) {
            return;
        }
        buf.append("=========== Performance Statistics =============\n");
        ProbeStat total = this.getProbeStat("TOTALTIME");
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.probes.keySet());
        buf.append("\nTime:\n");
        Collections.sort(list, this.timeComparator);
        for (String p : list) {
            ProbeStat s = this.getProbeStat(p);
            buf.append(String.format("%s: %dms", this.fullName(p), s.totalTime));
            if (total.totalTime > 0L) {
                buf.append(String.format(", %.2f%%%n", Float.valueOf(100.0f * (float)s.totalTime / (float)total.totalTime)));
                continue;
            }
            buf.append("\n");
        }
        buf.append("\nInvocations count:\n");
        Collections.sort(list, this.countComparator);
        for (String p : list) {
            buf.append(String.format("%s: %d%n", this.fullName(p), this.getProbeStat((String)p).count));
        }
        buf.append("================================================\n");
    }

    public synchronized void log() {
        this.log(true);
    }

    private synchronized void log(boolean useLogger) {
        StringBuffer buf = new StringBuffer();
        this.log(buf);
        if (useLogger) {
            this.log.fine(buf.toString());
        } else {
            System.out.println(buf.toString());
            System.out.flush();
        }
    }

    public static synchronized void logAll() {
        for (PerfLogger l : loggers.values()) {
            l.log();
        }
    }

    public static final class ProbeStat {
        private final String probe;
        private int count;
        private long totalTime;
        private long startTime;
        private boolean isRunning = false;

        private ProbeStat(String probe) {
            this.probe = probe;
        }

        public String getProbe() {
            return this.probe;
        }

        public int getCount() {
            return this.count;
        }

        public long getTotalTime() {
            return this.totalTime;
        }

        private void reset() {
            this.count = 0;
            this.startTime = 0L;
            this.totalTime = 0L;
        }

        private void suspend() {
            if (this.isRunning) {
                this.totalTime += System.currentTimeMillis() - this.startTime;
                this.isRunning = false;
            }
        }

        private void resume() {
            this.isRunning = true;
            ++this.count;
            this.startTime = System.currentTimeMillis();
        }

        private void snapshot() {
            if (this.isRunning) {
                this.totalTime += System.currentTimeMillis() - this.startTime;
                this.startTime = System.currentTimeMillis();
            }
        }

        public String toString() {
            return super.toString() + "[count=" + this.count + ", time=" + this.totalTime + "]";
        }
    }
}

