/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.text;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;

final class TextCodec {
    private final Charset charset;
    private static final Map<String, String> RE_MAP = Map.of("ISO-10646-UCS-2", "UTF-16");

    private TextCodec(String encoding) {
        this.charset = Charset.forName(encoding);
    }

    private byte[] encode(char[] data) {
        ByteBuffer bb = this.charset.encode(CharBuffer.wrap(data));
        byte[] encoded = new byte[bb.remaining()];
        bb.get(encoded);
        return encoded;
    }

    private String decode(byte[] data) {
        CharBuffer cb = this.charset.decode(ByteBuffer.wrap(data));
        char[] decoded = new char[cb.remaining()];
        cb.get(decoded);
        return new String(decoded);
    }

    private static String[] getEncodings() {
        ArrayList<String> encodings = new ArrayList<String>();
        SortedMap<String, Charset> ac = Charset.availableCharsets();
        for (Map.Entry entry : ac.entrySet()) {
            String e = (String)entry.getKey();
            encodings.add(e);
            encodings.add(e);
            Charset c = (Charset)entry.getValue();
            for (String a : c.aliases()) {
                if (a.equals("8859_1")) continue;
                encodings.add(a);
                String r = RE_MAP.get(a);
                encodings.add(r == null ? e : r);
            }
        }
        return encodings.toArray(new String[0]);
    }
}

