/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalMethod;
import com.sun.javafx.util.Utils;
import com.sun.javafx.webkit.Accessor;
import com.sun.javafx.webkit.WebConsoleListener;
import com.sun.webkit.CursorManager;
import com.sun.webkit.WebPageClient;
import com.sun.webkit.graphics.WCGraphicsManager;
import com.sun.webkit.graphics.WCPageBackBuffer;
import com.sun.webkit.graphics.WCPoint;
import com.sun.webkit.graphics.WCRectangle;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Tooltip;
import javafx.scene.web.WebView;
import javafx.stage.Screen;
import javafx.stage.Window;

public final class WebPageClientImpl
implements WebPageClient<WebView> {
    private static final boolean backBufferSupported = Boolean.valueOf(AccessController.doPrivileged(() -> System.getProperty("com.sun.webkit.pagebackbuffer", "true")));
    private static WebConsoleListener consoleListener = null;
    private final Accessor accessor;
    private WeakReference<Tooltip> tooltipRef;
    private boolean isTooltipRegistered = false;
    private String oldTooltipText = "";

    static void setConsoleListener(WebConsoleListener consoleListener) {
        WebPageClientImpl.consoleListener = consoleListener;
    }

    public WebPageClientImpl(Accessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void setFocus(boolean focus) {
        WebView view = this.accessor.getView();
        if (view != null && focus) {
            view.requestFocus();
        }
    }

    @Override
    public void setCursor(long cursorID) {
        WebView view = this.accessor.getView();
        if (view != null) {
            Object cursor = CursorManager.getCursorManager().getCursor(cursorID);
            view.setCursor(cursor instanceof Cursor ? (Cursor)cursor : Cursor.DEFAULT);
        }
    }

    @Override
    public void setTooltip(String tooltipText) {
        WebView view = this.accessor.getView();
        if (tooltipText != null) {
            Tooltip tooltip;
            Tooltip tooltip2 = tooltip = this.tooltipRef == null ? null : (Tooltip)this.tooltipRef.get();
            if (tooltip == null) {
                tooltip = new Tooltip(tooltipText);
                this.tooltipRef = new WeakReference<Tooltip>(tooltip);
            } else {
                tooltip.setText(tooltipText);
                if (!this.oldTooltipText.equals(tooltipText)) {
                    Tooltip.uninstall((Node)view, (Tooltip)tooltip);
                    this.isTooltipRegistered = false;
                }
            }
            this.oldTooltipText = tooltipText;
            if (!this.isTooltipRegistered) {
                Tooltip.install((Node)view, (Tooltip)tooltip);
                this.isTooltipRegistered = true;
            }
        } else if (this.isTooltipRegistered) {
            Tooltip tooltip = (Tooltip)this.tooltipRef.get();
            if (tooltip != null) {
                Tooltip.uninstall((Node)view, (Tooltip)tooltip);
            }
            this.isTooltipRegistered = false;
        }
    }

    @Override
    public void transferFocus(boolean forward) {
        NodeHelper.traverse((Node)this.accessor.getView(), (Direction)(forward ? Direction.NEXT : Direction.PREVIOUS), (TraversalMethod)TraversalMethod.DEFAULT);
    }

    @Override
    public WCRectangle getScreenBounds(boolean available) {
        WebView view = this.accessor.getView();
        Screen screen = Utils.getScreen((Object)((Object)view));
        if (screen != null) {
            Rectangle2D r = available ? screen.getVisualBounds() : screen.getBounds();
            return new WCRectangle((float)r.getMinX(), (float)r.getMinY(), (float)r.getWidth(), (float)r.getHeight());
        }
        return null;
    }

    @Override
    public int getScreenDepth() {
        return 24;
    }

    @Override
    public WebView getContainer() {
        return this.accessor.getView();
    }

    @Override
    public WCPoint screenToWindow(WCPoint ptScreen) {
        WebView view = this.accessor.getView();
        Scene scene = view.getScene();
        Window window = null;
        if (scene != null && (window = scene.getWindow()) != null) {
            Point2D pt = view.sceneToLocal((double)ptScreen.getX() - window.getX() - scene.getX(), (double)ptScreen.getY() - window.getY() - scene.getY());
            return new WCPoint((float)pt.getX(), (float)pt.getY());
        }
        return new WCPoint(0.0f, 0.0f);
    }

    @Override
    public WCPoint windowToScreen(WCPoint ptWindow) {
        WebView view = this.accessor.getView();
        Scene scene = view.getScene();
        Window window = null;
        if (scene != null && (window = scene.getWindow()) != null) {
            Point2D pt = view.localToScene(ptWindow.getX(), ptWindow.getY());
            return new WCPoint((float)(pt.getX() + scene.getX() + window.getX()), (float)(pt.getY() + scene.getY() + window.getY()));
        }
        return new WCPoint(0.0f, 0.0f);
    }

    @Override
    public WCPageBackBuffer createBackBuffer() {
        if (this.isBackBufferSupported()) {
            return WCGraphicsManager.getGraphicsManager().createPageBackBuffer();
        }
        return null;
    }

    @Override
    public boolean isBackBufferSupported() {
        return backBufferSupported;
    }

    @Override
    public void addMessageToConsole(String message, int lineNumber, String sourceId) {
        if (consoleListener != null) {
            try {
                consoleListener.messageAdded(this.accessor.getView(), message, lineNumber, sourceId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void didClearWindowObject(long context, long windowObject) {
    }
}

