/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.webkit.prism.PrismGraphicsManager;
import com.sun.javafx.webkit.prism.PrismImage;
import com.sun.javafx.webkit.prism.PrismInvoker;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

final class RTImage
extends PrismImage
implements ResourceFactoryListener {
    private RTTexture txt;
    private final int width;
    private final int height;
    private WeakReference<ResourceFactory> registeredWithFactory = null;
    private ByteBuffer pixelBuffer;
    private float pixelScale;
    private static final PlatformLogger log = PlatformLogger.getLogger((String)RTImage.class.getName());

    RTImage(int w, int h, float pixelScale) {
        if (Float.isNaN(pixelScale) || pixelScale <= 0.0f || Math.ceil(pixelScale) >= 2.147483647E9) {
            throw new IllegalArgumentException("pixelScale out of range");
        }
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("image size must be positive");
        }
        int ps = (int)Math.ceil(pixelScale);
        int scale = Math.max(ps, 4);
        int maxSize = Integer.MAX_VALUE / scale;
        if (maxSize / w <= h) {
            throw new IllegalArgumentException("image size out of range");
        }
        this.width = w;
        this.height = h;
        this.pixelScale = pixelScale;
    }

    @Override
    Image getImage() {
        return Image.fromByteBgraPreData((ByteBuffer)this.getPixelBuffer(), (int)this.getWidth(), (int)this.getHeight());
    }

    @Override
    Graphics getGraphics() {
        RTTexture texture = this.getTexture();
        if (texture == null) {
            return null;
        }
        Graphics g = texture.createGraphics();
        g.transform(PrismGraphicsManager.getPixelScaleTransform());
        return g;
    }

    private RTTexture getTexture() {
        ResourceFactory f;
        if (this.txt != null && this.txt.isSurfaceLost()) {
            log.fine("RTImage::getTexture : surface lost: " + this);
        }
        if ((f = GraphicsPipeline.getDefaultResourceFactory()) == null || f.isDisposed()) {
            log.fine("RTImage::getTexture : return null because device disposed or not ready");
            return null;
        }
        if (this.txt == null) {
            this.txt = f.createRTTexture((int)Math.ceil((float)this.width * this.pixelScale), (int)Math.ceil((float)this.height * this.pixelScale), Texture.WrapMode.CLAMP_NOT_NEEDED);
            this.txt.contentsUseful();
            this.txt.makePermanent();
            if (this.registeredWithFactory == null || this.registeredWithFactory.get() != f) {
                f.addFactoryListener((ResourceFactoryListener)this);
                this.registeredWithFactory = new WeakReference<ResourceFactory>(f);
            }
        }
        return this.txt;
    }

    @Override
    void draw(Graphics g, int dstx1, int dsty1, int dstx2, int dsty2, int srcx1, int srcy1, int srcx2, int srcy2) {
        if (this.txt == null && g.getCompositeMode() == CompositeMode.SRC_OVER) {
            return;
        }
        if (g.getResourceFactory().isDisposed()) {
            log.fine("RTImage::draw : skip because device has been disposed");
            return;
        }
        if (g instanceof PrinterGraphics) {
            int w = srcx2 - srcx1;
            int h = srcy2 - srcy1;
            IntBuffer pixels = IntBuffer.allocate(w * h);
            PrismInvoker.runOnRenderThread(() -> this.getTexture().readPixels((Buffer)pixels));
            Image img = Image.fromIntArgbPreData((IntBuffer)pixels, (int)w, (int)h);
            Texture t = g.getResourceFactory().createTexture(img, Texture.Usage.STATIC, Texture.WrapMode.CLAMP_NOT_NEEDED);
            g.drawTexture(t, (float)dstx1, (float)dsty1, (float)dstx2, (float)dsty2, 0.0f, 0.0f, (float)w, (float)h);
            t.dispose();
        } else if (this.txt == null) {
            Paint p = g.getPaint();
            g.setPaint((Paint)Color.TRANSPARENT);
            g.fillQuad((float)dstx1, (float)dsty1, (float)dstx2, (float)dsty2);
            g.setPaint(p);
        } else {
            g.drawTexture((Texture)this.txt, (float)dstx1, (float)dsty1, (float)dstx2, (float)dsty2, (float)srcx1 * this.pixelScale, (float)srcy1 * this.pixelScale, (float)srcx2 * this.pixelScale, (float)srcy2 * this.pixelScale);
        }
    }

    @Override
    void dispose() {
        PrismInvoker.invokeOnRenderThread(() -> {
            if (this.txt != null) {
                this.txt.dispose();
                this.txt = null;
            }
        });
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getPixelBuffer() {
        boolean isNew = false;
        if (this.pixelBuffer == null) {
            this.pixelBuffer = ByteBuffer.allocateDirect(this.width * this.height * 4);
            if (this.pixelBuffer != null) {
                this.pixelBuffer.order(ByteOrder.nativeOrder());
                isNew = true;
            }
        }
        if (isNew || this.isDirty()) {
            PrismInvoker.runOnRenderThread(() -> {
                ResourceFactory f = GraphicsPipeline.getDefaultResourceFactory();
                if (f == null || f.isDisposed()) {
                    log.fine("RTImage::getPixelBuffer : skip because device disposed or not ready");
                    return;
                }
                this.flushRQ();
                if (this.txt != null && this.pixelBuffer != null) {
                    PixelFormat pf = this.txt.getPixelFormat();
                    if (pf != PixelFormat.INT_ARGB_PRE && pf != PixelFormat.BYTE_BGRA_PRE) {
                        throw new AssertionError((Object)("Unexpected pixel format: " + pf));
                    }
                    RTTexture t = this.txt;
                    if (this.pixelScale != 1.0f) {
                        t = f.createRTTexture(this.width, this.height, Texture.WrapMode.CLAMP_NOT_NEEDED);
                        Graphics g = t.createGraphics();
                        g.drawTexture((Texture)this.txt, 0.0f, 0.0f, (float)this.width, (float)this.height, 0.0f, 0.0f, (float)this.width * this.pixelScale, (float)this.height * this.pixelScale);
                    }
                    this.pixelBuffer.rewind();
                    int[] pixels = t.getPixels();
                    if (pixels != null) {
                        this.pixelBuffer.asIntBuffer().put(pixels);
                    } else {
                        t.readPixels((Buffer)this.pixelBuffer);
                    }
                    if (t != this.txt) {
                        t.dispose();
                    }
                }
            });
        }
        return this.pixelBuffer;
    }

    @Override
    protected void drawPixelBuffer() {
        PrismInvoker.invokeOnRenderThread(new Runnable(){

            @Override
            public void run() {
                Graphics g = RTImage.this.getGraphics();
                if (g != null && RTImage.this.pixelBuffer != null) {
                    RTImage.this.pixelBuffer.rewind();
                    Image img = Image.fromByteBgraPreData((ByteBuffer)RTImage.this.pixelBuffer, (int)RTImage.this.width, (int)RTImage.this.height);
                    Texture txt = g.getResourceFactory().createTexture(img, Texture.Usage.DEFAULT, Texture.WrapMode.CLAMP_NOT_NEEDED);
                    g.clear();
                    g.drawTexture(txt, 0.0f, 0.0f, (float)RTImage.this.width, (float)RTImage.this.height);
                    txt.dispose();
                }
            }
        });
    }

    public void factoryReset() {
        if (this.txt != null) {
            this.txt.dispose();
            this.txt = null;
        }
    }

    public void factoryReleased() {
        if (this.txt != null) {
            this.txt.dispose();
            this.txt = null;
        }
    }

    @Override
    public float getPixelScale() {
        return this.pixelScale;
    }
}

