/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.webkit.prism.PrismImage;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.image.CompoundCoords;
import com.sun.prism.image.CompoundImage;
import com.sun.prism.image.CompoundTexture;
import com.sun.prism.image.Coords;
import com.sun.prism.image.ViewPort;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javafx.scene.image.PixelFormat;

final class WCImageImpl
extends PrismImage {
    private static final PlatformLogger log = PlatformLogger.getLogger((String)WCImageImpl.class.getName());
    private final Image img;
    private Texture texture;
    private CompoundTexture compoundTexture;

    WCImageImpl(int w, int h) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Creating empty image({0},{1})", new Object[]{w, h});
        }
        this.img = Image.fromIntArgbPreData((int[])new int[w * h], (int)w, (int)h);
    }

    WCImageImpl(int[] buffer, int w, int h) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Creating image({0},{1}) from buffer", new Object[]{w, h});
        }
        this.img = Image.fromIntArgbPreData((int[])buffer, (int)w, (int)h);
    }

    WCImageImpl(ImageFrame frame) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Creating image {0}x{1} of type {2} from buffer", new Object[]{frame.getWidth(), frame.getHeight(), frame.getImageType()});
        }
        this.img = Image.convertImageFrame((ImageFrame)frame);
    }

    @Override
    Image getImage() {
        return this.img;
    }

    @Override
    Graphics getGraphics() {
        return null;
    }

    @Override
    void draw(Graphics g, int dstx1, int dsty1, int dstx2, int dsty2, int srcx1, int srcy1, int srcx2, int srcy2) {
        ResourceFactory resourceFactory = g.getResourceFactory();
        if (resourceFactory.isDisposed()) {
            log.fine("WCImageImpl::draw : skip because device disposed or not ready");
            return;
        }
        if (g instanceof PrinterGraphics) {
            Texture t = resourceFactory.createTexture(this.img, Texture.Usage.STATIC, Texture.WrapMode.CLAMP_NOT_NEEDED);
            g.drawTexture(t, (float)dstx1, (float)dsty1, (float)dstx2, (float)dsty2, (float)srcx1, (float)srcy1, (float)srcx2, (float)srcy2);
            t.dispose();
            return;
        }
        if (this.texture != null) {
            this.texture.lock();
            if (this.texture.isSurfaceLost()) {
                this.texture = null;
            }
        }
        if (this.texture == null && this.compoundTexture == null) {
            int maxSize = resourceFactory.getMaximumTextureSize();
            if (this.img.getWidth() <= maxSize && this.img.getHeight() <= maxSize) {
                this.texture = resourceFactory.createTexture(this.img, Texture.Usage.DEFAULT, Texture.WrapMode.CLAMP_TO_EDGE);
                assert (this.texture != null);
            } else {
                this.compoundTexture = new CompoundTexture(this.img, maxSize);
            }
        }
        if (this.texture != null) {
            assert (this.compoundTexture == null);
            g.drawTexture(this.texture, (float)dstx1, (float)dsty1, (float)dstx2, (float)dsty2, (float)srcx1, (float)srcy1, (float)srcx2, (float)srcy2);
            this.texture.unlock();
        } else {
            assert (this.compoundTexture != null);
            ViewPort viewPort = new ViewPort((float)srcx1, (float)srcy1, (float)(srcx2 - srcx1), (float)(srcy2 - srcy1));
            Coords coords = new Coords((float)(dstx2 - dstx1), (float)(dsty2 - dsty1), viewPort);
            CompoundCoords compoundCoords = new CompoundCoords((CompoundImage)this.compoundTexture, coords);
            compoundCoords.draw(g, (CompoundImage)this.compoundTexture, (float)dstx1, (float)dsty1);
        }
    }

    @Override
    void dispose() {
        if (this.texture != null) {
            this.texture.dispose();
            this.texture = null;
        }
        if (this.compoundTexture != null) {
            this.compoundTexture.dispose();
            this.compoundTexture = null;
        }
    }

    @Override
    public int getWidth() {
        return this.img.getWidth();
    }

    @Override
    public int getHeight() {
        return this.img.getHeight();
    }

    @Override
    public ByteBuffer getPixelBuffer() {
        int w = this.img.getWidth();
        int h = this.img.getHeight();
        int s = w * 4;
        ByteBuffer pixels = ByteBuffer.allocate(s * h);
        this.img.getPixels(0, 0, w, h, PixelFormat.getByteBgraInstance(), (Buffer)pixels, s);
        return pixels;
    }

    @Override
    public float getPixelScale() {
        return this.img.getPixelScale();
    }
}

