/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.theme;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.webkit.theme.PopupMenuImpl;
import com.sun.webkit.ContextMenu;
import com.sun.webkit.ContextMenuItem;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;

public final class ContextMenuImpl
extends ContextMenu {
    private static final PlatformLogger log = PlatformLogger.getLogger((String)ContextMenuImpl.class.getName());
    private final ObservableList<ContextMenuItem> items = FXCollections.observableArrayList();

    @Override
    protected void show(ContextMenu.ShowContext showContext, int x, int y) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("show at [{0}, {1}]", new Object[]{x, y});
        }
        javafx.scene.control.ContextMenu popupMenu = new javafx.scene.control.ContextMenu();
        popupMenu.setOnAction(t -> {
            MenuItem item = (MenuItem)t.getTarget();
            log.fine("onAction: item={0}", new Object[]{item});
            showContext.notifyItemSelected(((MenuItemPeer)item).getItemPeer().getAction());
        });
        popupMenu.getItems().addAll(this.fillMenu());
        PopupMenuImpl.doShow(popupMenu, showContext.getPage(), x, y);
    }

    @Override
    protected void appendItem(ContextMenuItem item) {
        this.insertItem(item, this.items.size());
    }

    @Override
    protected void insertItem(ContextMenuItem item, int index) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("item={0}, index={1}", new Object[]{item, index});
        }
        if (item == null) {
            return;
        }
        this.items.remove((Object)item);
        if (this.items.size() == 0) {
            this.items.add((Object)item);
        } else {
            this.items.add(index, (Object)item);
        }
    }

    @Override
    protected int getItemCount() {
        return this.items.size();
    }

    private MenuItem createMenuItem(ContextMenuItem item) {
        log.fine("item={0}", new Object[]{item});
        if (item.getType() == 2) {
            MenuImpl menu = new MenuImpl(item.getTitle());
            if (item.getSubmenu() != null) {
                menu.getItems().addAll(((ContextMenuImpl)item.getSubmenu()).fillMenu());
            }
            return menu;
        }
        if (item.getType() == 0) {
            MenuItemPeer mi = null;
            mi = item.isChecked() ? new CheckMenuItemImpl(item) : new MenuItemImpl(item);
            mi.setDisable(!item.isEnabled());
            return mi;
        }
        if (item.getType() == 1) {
            return new SeparatorImpl(item);
        }
        throw new IllegalArgumentException("unexpected item type");
    }

    private ObservableList<MenuItem> fillMenu() {
        ObservableList s = FXCollections.observableArrayList();
        for (ContextMenuItem item : this.items) {
            s.add((Object)this.createMenuItem(item));
        }
        return s;
    }

    private static final class MenuImpl
    extends Menu {
        private MenuImpl(String text) {
            super(text);
        }
    }

    private static final class CheckMenuItemImpl
    extends CheckMenuItem
    implements MenuItemPeer {
        private final ContextMenuItem itemPeer;

        private CheckMenuItemImpl(ContextMenuItem itemPeer) {
            this.itemPeer = itemPeer;
        }

        @Override
        public ContextMenuItem getItemPeer() {
            return this.itemPeer;
        }
    }

    private static final class MenuItemImpl
    extends MenuItem
    implements MenuItemPeer {
        private final ContextMenuItem itemPeer;

        private MenuItemImpl(ContextMenuItem itemPeer) {
            super(itemPeer.getTitle());
            this.itemPeer = itemPeer;
        }

        @Override
        public ContextMenuItem getItemPeer() {
            return this.itemPeer;
        }
    }

    static final class SeparatorImpl
    extends MenuItem
    implements MenuItemPeer {
        private final ContextMenuItem itemPeer;

        SeparatorImpl(ContextMenuItem itemPeer) {
            this.itemPeer = itemPeer;
            this.setGraphic((Node)new Separator());
            this.setDisable(true);
        }

        @Override
        public ContextMenuItem getItemPeer() {
            return this.itemPeer;
        }
    }

    private static interface MenuItemPeer {
        public ContextMenuItem getItemPeer();
    }
}

