/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.theme;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.webkit.Accessor;
import com.sun.javafx.webkit.theme.RenderThemeImpl;
import com.sun.javafx.webkit.theme.Renderer;
import com.sun.javafx.webkit.theme.ScrollBarWidget;
import com.sun.webkit.graphics.Ref;
import com.sun.webkit.graphics.ScrollBarTheme;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCSize;
import java.lang.ref.WeakReference;
import javafx.beans.Observable;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;

public final class ScrollBarThemeImpl
extends ScrollBarTheme {
    private static final PlatformLogger log = PlatformLogger.getLogger((String)ScrollBarThemeImpl.class.getName());
    private WeakReference<ScrollBar> testSBRef = new WeakReference<Object>(null);
    private final Accessor accessor;
    private final RenderThemeImpl.Pool<ScrollBarWidget> pool;

    public ScrollBarThemeImpl(final Accessor accessor) {
        this.accessor = accessor;
        this.pool = new RenderThemeImpl.Pool<ScrollBarWidget>(sb -> accessor.removeChild((Node)sb), ScrollBarWidget.class);
        accessor.addViewListener(new RenderThemeImpl.ViewListener(this.pool, accessor){

            @Override
            public void invalidated(Observable ov) {
                super.invalidated(ov);
                ScrollBarWidget testSB = new ScrollBarWidget(ScrollBarThemeImpl.this);
                accessor.addChild((Node)testSB);
                ScrollBarThemeImpl.this.testSBRef = new WeakReference<ScrollBarWidget>(testSB);
            }
        });
    }

    ScrollBar getTestSBRef() {
        return (ScrollBar)this.testSBRef.get();
    }

    private static Orientation convertOrientation(int orientation) {
        return orientation == 1 ? Orientation.VERTICAL : Orientation.HORIZONTAL;
    }

    private void adjustScrollBar(ScrollBar sb, int w, int h, int orientation) {
        Orientation current = ScrollBarThemeImpl.convertOrientation(orientation);
        if (current != sb.getOrientation()) {
            sb.setOrientation(current);
        }
        if (current == Orientation.VERTICAL) {
            w = ScrollBarTheme.getThickness();
        } else {
            h = ScrollBarTheme.getThickness();
        }
        if ((double)w != sb.getWidth() || (double)h != sb.getHeight()) {
            sb.resize((double)w, (double)h);
        }
    }

    private void adjustScrollBar(ScrollBar sb, int w, int h, int orientation, int value, int visibleSize, int totalSize) {
        this.adjustScrollBar(sb, w, h, orientation);
        boolean disable = totalSize <= visibleSize;
        sb.setDisable(disable);
        if (disable) {
            return;
        }
        if (value < 0) {
            value = 0;
        } else if (value > totalSize - visibleSize) {
            value = totalSize - visibleSize;
        }
        if (sb.getMax() != (double)totalSize || sb.getVisibleAmount() != (double)visibleSize) {
            sb.setValue(0.0);
            sb.setMax((double)totalSize);
            sb.setVisibleAmount((double)visibleSize);
        }
        if (totalSize > visibleSize) {
            float factor = (float)totalSize / (float)(totalSize - visibleSize);
            if (sb.getValue() != (double)((float)value * factor)) {
                sb.setValue((double)((float)value * factor));
            }
        }
    }

    @Override
    protected Ref createWidget(long id, int w, int h, int orientation, int value, int visibleSize, int totalSize) {
        ScrollBarWidget sb = this.pool.get(id);
        if (sb == null) {
            sb = new ScrollBarWidget(this);
            this.pool.put(id, sb, this.accessor.getPage().getUpdateContentCycleID());
            this.accessor.addChild((Node)sb);
        }
        this.adjustScrollBar(sb, w, h, orientation, value, visibleSize, totalSize);
        return new ScrollBarRef(sb);
    }

    @Override
    public void paint(WCGraphicsContext g, Ref sbRef, int x, int y, int pressedPart, int hoveredPart) {
        ScrollBar sb = (ScrollBar)((ScrollBarRef)sbRef).asControl();
        if (sb == null) {
            return;
        }
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("[{0}, {1} {2}x{3}], {4}", new Object[]{x, y, sb.getWidth(), sb.getHeight(), sb.getOrientation() == Orientation.VERTICAL ? "VERTICAL" : "HORIZONTAL"});
        }
        g.saveState();
        g.translate(x, y);
        Renderer.getRenderer().render((Control)sb, g);
        g.restoreState();
    }

    @Override
    public WCSize getWidgetSize(Ref widget) {
        ScrollBar sb = (ScrollBar)((ScrollBarRef)widget).asControl();
        if (sb != null) {
            return new WCSize((float)sb.getWidth(), (float)sb.getHeight());
        }
        return new WCSize(0.0f, 0.0f);
    }

    @Override
    protected void getScrollBarPartRect(long id, int part, int[] rect) {
        ScrollBar sb = this.pool.get(id);
        if (sb == null) {
            return;
        }
        Node node = null;
        if (part == 2) {
            node = ScrollBarThemeImpl.getIncButton(sb);
        } else if (part == 1) {
            node = ScrollBarThemeImpl.getDecButton(sb);
        } else if (part == 256) {
            node = ScrollBarThemeImpl.getTrack(sb);
        }
        assert (rect.length >= 4);
        if (node != null) {
            Bounds bounds = node.getBoundsInParent();
            rect[0] = (int)bounds.getMinX();
            rect[1] = (int)bounds.getMinY();
            rect[2] = (int)bounds.getWidth();
            rect[3] = (int)bounds.getHeight();
        } else {
            rect[3] = 0;
            rect[2] = 0;
            rect[1] = 0;
            rect[0] = 0;
        }
        log.finest("id {0} part {1} bounds {2},{3} {4}x{5}", new Object[]{String.valueOf(id), String.valueOf(part), rect[0], rect[1], rect[2], rect[3]});
    }

    private static Node getTrack(ScrollBar scrollBar) {
        return ScrollBarThemeImpl.findNode(scrollBar, "track");
    }

    private static Node getIncButton(ScrollBar scrollBar) {
        return ScrollBarThemeImpl.findNode(scrollBar, "increment-button");
    }

    private static Node getDecButton(ScrollBar scrollBar) {
        return ScrollBarThemeImpl.findNode(scrollBar, "decrement-button");
    }

    private static Node findNode(ScrollBar scrollBar, String styleclass) {
        for (Node n : scrollBar.getChildrenUnmodifiable()) {
            if (!n.getStyleClass().contains((Object)styleclass)) continue;
            return n;
        }
        return null;
    }

    private static final class ScrollBarRef
    extends Ref {
        private final WeakReference<ScrollBarWidget> sbRef;

        private ScrollBarRef(ScrollBarWidget sb) {
            this.sbRef = new WeakReference<ScrollBarWidget>(sb);
        }

        private Control asControl() {
            return (Control)this.sbRef.get();
        }
    }
}

