/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class CookieJar {
    private CookieJar() {
    }

    private static void fwkPut(String url, String cookie) {
        CookieHandler handler = AccessController.doPrivileged(CookieHandler::getDefault);
        if (handler != null) {
            URI uri = null;
            try {
                uri = new URI(url);
                uri = CookieJar.rewriteToFilterOutHttpOnlyCookies(uri);
            }
            catch (URISyntaxException e) {
                return;
            }
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            ArrayList<String> val = new ArrayList<String>();
            val.add(cookie);
            headers.put("Set-Cookie", val);
            try {
                handler.put(uri, headers);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String fwkGet(String url, boolean includeHttpOnlyCookies) {
        CookieHandler handler = AccessController.doPrivileged(CookieHandler::getDefault);
        if (handler != null) {
            URI uri = null;
            try {
                uri = new URI(url);
                if (!includeHttpOnlyCookies) {
                    uri = CookieJar.rewriteToFilterOutHttpOnlyCookies(uri);
                }
            }
            catch (URISyntaxException e) {
                return null;
            }
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            Map<String, List<String>> val = null;
            try {
                val = handler.get(uri, headers);
            }
            catch (IOException e) {
                return null;
            }
            if (val != null) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, List<String>> entry : val.entrySet()) {
                    String key = entry.getKey();
                    if (!"Cookie".equalsIgnoreCase(key)) continue;
                    for (String s : entry.getValue()) {
                        if (sb.length() > 0) {
                            sb.append("; ");
                        }
                        sb.append(s);
                    }
                }
                return sb.toString();
            }
        }
        return null;
    }

    private static URI rewriteToFilterOutHttpOnlyCookies(URI uri) throws URISyntaxException {
        return new URI(uri.getScheme().equalsIgnoreCase("https") ? "javascripts" : "javascript", uri.getRawSchemeSpecificPart(), uri.getRawFragment());
    }
}

