/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.javafx.logging.PlatformLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.IDN;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

final class PublicSuffixes {
    private static final PlatformLogger logger = PlatformLogger.getLogger((String)PublicSuffixes.class.getName());
    private static final Map<String, Rules> rulesCache = new ConcurrentHashMap<String, Rules>();
    private static final File pslFile = AccessController.doPrivileged(() -> new File(System.getProperty("java.home"), "lib/security/public_suffix_list.dat"));
    private static final boolean pslFileExists = AccessController.doPrivileged(() -> {
        if (!pslFile.exists()) {
            logger.warning("Resource not found: lib/security/public_suffix_list.dat");
            return false;
        }
        return true;
    });

    private PublicSuffixes() {
        throw new AssertionError();
    }

    static boolean pslFileExists() {
        return pslFileExists;
    }

    static boolean isPublicSuffix(String domain) {
        if (domain.length() == 0) {
            return false;
        }
        if (!PublicSuffixes.pslFileExists()) {
            return false;
        }
        Rules rules = Rules.getRules(domain);
        return rules == null ? false : rules.match(domain);
    }

    private static String toLogString(Map<String, Rule> rules) {
        if (rules.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Rule> entry : rules.entrySet()) {
            sb.append(String.format("%n    ", new Object[0]));
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append((Object)entry.getValue());
        }
        return sb.toString();
    }

    private static class Rules {
        private final Map<String, Rule> rules = new HashMap<String, Rule>();

        private Rules(InputStream is) throws IOException {
            String line;
            InputStreamReader isr = new InputStreamReader(is, "UTF-8");
            BufferedReader reader = new BufferedReader(isr);
            int type = reader.read();
            while (type != -1 && (line = reader.readLine()) != null) {
                Rule rule;
                if (line.startsWith("!")) {
                    line = line.substring(1);
                    rule = Rule.EXCEPTION_RULE;
                } else if (line.startsWith("*.")) {
                    line = line.substring(2);
                    rule = Rule.WILDCARD_RULE;
                } else {
                    rule = Rule.SIMPLE_RULE;
                }
                try {
                    line = IDN.toASCII(line, 1);
                }
                catch (Exception ex) {
                    logger.warning(String.format("Error parsing rule: [%s]", line), (Throwable)ex);
                    continue;
                }
                this.rules.put(line, rule);
                type = reader.read();
            }
            if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
                logger.finest("rules: {0}", new Object[]{PublicSuffixes.toLogString(this.rules)});
            }
        }

        static Rules getRules(String domain) {
            String tld = Rules.getTopLevelDomain(domain);
            if (tld.isEmpty()) {
                return null;
            }
            return rulesCache.computeIfAbsent(tld, k -> Rules.createRules(tld));
        }

        private static String getTopLevelDomain(String domain) {
            int n = (domain = IDN.toUnicode(domain, 1)).lastIndexOf(46);
            if (n == -1) {
                return domain;
            }
            return domain.substring(n + 1);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static Rules createRules(String tld) {
            try (InputStream pubSuffixStream = Rules.getPubSuffixStream();){
                if (pubSuffixStream == null) {
                    Rules rules = null;
                    return rules;
                }
                ZipInputStream zis = new ZipInputStream(pubSuffixStream);
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    if (ze.getName().equals(tld)) {
                        Rules rules = new Rules(zis);
                        return rules;
                    }
                    ze = zis.getNextEntry();
                }
                return null;
            }
            catch (IOException ex) {
                logger.warning("Unexpected error", (Throwable)ex);
            }
            return null;
        }

        private static InputStream getPubSuffixStream() {
            InputStream is = AccessController.doPrivileged(() -> {
                try {
                    return new FileInputStream(pslFile);
                }
                catch (FileNotFoundException ex) {
                    logger.warning("Resource not found: lib/security/public_suffix_list.dat");
                    return null;
                }
            });
            return is;
        }

        boolean match(String domain) {
            String parent;
            Rule rule = this.rules.get(domain);
            if (rule == Rule.EXCEPTION_RULE) {
                return false;
            }
            if (rule == Rule.SIMPLE_RULE || rule == Rule.WILDCARD_RULE) {
                return true;
            }
            int pos = domain.indexOf(46) + 1;
            if (pos == 0) {
                pos = domain.length();
            }
            return this.rules.get(parent = domain.substring(pos)) == Rule.WILDCARD_RULE;
        }
    }

    private static enum Rule {
        SIMPLE_RULE,
        WILDCARD_RULE,
        EXCEPTION_RULE;

    }
}

