/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.webkit.Invoker;
import com.sun.webkit.WebPage;
import com.sun.webkit.network.ByteBufferAllocator;
import com.sun.webkit.network.ByteBufferPool;
import com.sun.webkit.network.DirectoryURLConnection;
import com.sun.webkit.network.FormDataElement;
import com.sun.webkit.network.URLLoaderBase;
import com.sun.webkit.network.URLs;
import com.sun.webkit.network.Util;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLHandshakeException;

final class URLLoader
extends URLLoaderBase
implements Runnable {
    private static final PlatformLogger logger = PlatformLogger.getLogger((String)URLLoader.class.getName());
    private static final int MAX_BUF_COUNT = 3;
    private static final String GET = "GET";
    private static final String HEAD = "HEAD";
    private static final String DELETE = "DELETE";
    private final WebPage webPage;
    private final ByteBufferPool byteBufferPool;
    private final boolean asynchronous;
    private String url;
    private String method;
    private final String headers;
    private FormDataElement[] formDataElements;
    private final long data;
    private volatile boolean canceled = false;

    URLLoader(WebPage webPage, ByteBufferPool byteBufferPool, boolean asynchronous, String url, String method, String headers, FormDataElement[] formDataElements, long data) {
        this.webPage = webPage;
        this.byteBufferPool = byteBufferPool;
        this.asynchronous = asynchronous;
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.formDataElements = formDataElements;
        this.data = data;
    }

    @Override
    public void fwkCancel() {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("data: [0x%016X]", this.data));
        }
        this.canceled = true;
    }

    @Override
    public void run() {
        AccessController.doPrivileged(() -> {
            this.doRun();
            return null;
        }, this.webPage.getAccessControlContext());
    }

    private void doRun() {
        Throwable error = null;
        int errorCode = 0;
        try {
            boolean streaming = true;
            boolean connectionResetRetry = true;
            while (true) {
                int questionMarkPosition;
                String actualUrl = this.url;
                if (this.url.startsWith("file:") && (questionMarkPosition = this.url.indexOf(63)) != -1) {
                    actualUrl = this.url.substring(0, questionMarkPosition);
                }
                URL urlObject = URLs.newURL(actualUrl);
                URLLoader.workaround7177996(urlObject);
                URLConnection c = urlObject.openConnection();
                this.prepareConnection(c);
                try {
                    this.sendRequest(c, streaming);
                    this.receiveResponse(c);
                }
                catch (HttpRetryException ex) {
                    if (streaming) {
                        streaming = false;
                        continue;
                    }
                    throw ex;
                }
                catch (SocketException ex) {
                    if ("Connection reset".equals(ex.getMessage()) && connectionResetRetry) {
                        connectionResetRetry = false;
                        continue;
                    }
                    throw ex;
                }
                finally {
                    URLLoader.close(c);
                    continue;
                }
                break;
            }
        }
        catch (MalformedURLException ex) {
            error = ex;
            errorCode = 2;
        }
        catch (AccessControlException ex) {
            error = ex;
            errorCode = 8;
        }
        catch (UnknownHostException ex) {
            error = ex;
            errorCode = 1;
        }
        catch (NoRouteToHostException ex) {
            error = ex;
            errorCode = 6;
        }
        catch (ConnectException ex) {
            error = ex;
            errorCode = 4;
        }
        catch (SocketException ex) {
            error = ex;
            errorCode = 5;
        }
        catch (SSLHandshakeException ex) {
            error = ex;
            errorCode = 3;
        }
        catch (SocketTimeoutException ex) {
            error = ex;
            errorCode = 7;
        }
        catch (InvalidResponseException ex) {
            error = ex;
            errorCode = 9;
        }
        catch (FileNotFoundException ex) {
            error = ex;
            errorCode = 11;
        }
        catch (Throwable th) {
            error = th;
            errorCode = 99;
        }
        if (error != null) {
            if (errorCode == 99) {
                logger.warning("Unexpected error", error);
            } else {
                logger.finest("Load error", error);
            }
            this.didFail(errorCode, error.getMessage());
        }
    }

    private static void workaround7177996(URL url) throws FileNotFoundException {
        if (!url.getProtocol().equals("file")) {
            return;
        }
        String host = url.getHost();
        if (host == null || host.equals("") || host.equals("~") || host.equalsIgnoreCase("localhost")) {
            return;
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            String path = null;
            try {
                path = URLDecoder.decode(url.getPath(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            path = path.replace('/', '\\');
            path = path.replace('|', ':');
            File file = new File("\\\\" + host + path);
            if (!file.exists()) {
                throw new FileNotFoundException("File not found: " + url);
            }
        } else {
            throw new FileNotFoundException("File not found: " + url);
        }
    }

    private void prepareConnection(URLConnection c) throws IOException {
        c.setConnectTimeout(30000);
        c.setReadTimeout(3600000);
        c.setUseCaches(false);
        Locale loc = Locale.getDefault();
        Object lang = "";
        if (!loc.equals(Locale.US) && !loc.equals(Locale.ENGLISH)) {
            lang = loc.getCountry().isEmpty() ? loc.getLanguage() + "," : loc.getLanguage() + "-" + loc.getCountry() + ",";
        }
        c.setRequestProperty("Accept-Language", ((String)lang).toLowerCase() + "en-us;q=0.8,en;q=0.7");
        c.setRequestProperty("Accept-Encoding", "gzip");
        c.setRequestProperty("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
        if (this.headers != null && this.headers.length() > 0) {
            for (String h : this.headers.split("\n")) {
                int i = h.indexOf(58);
                if (i <= 0) continue;
                c.addRequestProperty(h.substring(0, i), h.substring(i + 2));
            }
        }
        if (c instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)c;
            httpConnection.setRequestMethod(this.method);
            httpConnection.setInstanceFollowRedirects(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(URLConnection c, boolean streaming) throws IOException {
        OutputStream out = null;
        try {
            boolean isGetOrHead;
            long bytesToBeSent = 0L;
            boolean sendFormData = this.formDataElements != null && c instanceof HttpURLConnection && !this.method.equals(DELETE);
            boolean bl = isGetOrHead = this.method.equals(GET) || this.method.equals(HEAD);
            if (sendFormData) {
                c.setDoOutput(true);
                for (FormDataElement formDataElement : this.formDataElements) {
                    formDataElement.open();
                    bytesToBeSent += formDataElement.getSize();
                }
                if (streaming) {
                    HttpURLConnection http = (HttpURLConnection)c;
                    if (bytesToBeSent <= Integer.MAX_VALUE) {
                        http.setFixedLengthStreamingMode((int)bytesToBeSent);
                    } else {
                        http.setChunkedStreamingMode(0);
                    }
                }
            } else if (!isGetOrHead && c instanceof HttpURLConnection) {
                c.setRequestProperty("Content-Length", "0");
            }
            int maxTryCount = isGetOrHead ? 3 : 1;
            c.setConnectTimeout(c.getConnectTimeout() / maxTryCount);
            int tryCount = 0;
            while (!this.canceled) {
                try {
                    c.connect();
                    break;
                }
                catch (SocketTimeoutException ex) {
                    if (++tryCount < maxTryCount) continue;
                    throw ex;
                }
                catch (IllegalArgumentException ex) {
                    throw new MalformedURLException(this.url);
                }
            }
            if (sendFormData) {
                out = c.getOutputStream();
                byte[] buffer = new byte[4096];
                long bytesSent = 0L;
                for (FormDataElement formDataElement : this.formDataElements) {
                    int count;
                    InputStream in = formDataElement.getInputStream();
                    while ((count = in.read(buffer)) > 0) {
                        out.write(buffer, 0, count);
                        this.didSendData(bytesSent += (long)count, bytesToBeSent);
                    }
                    formDataElement.close();
                }
                out.flush();
                out.close();
                out = null;
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (this.formDataElements != null && c instanceof HttpURLConnection) {
                for (FormDataElement formDataElement : this.formDataElements) {
                    try {
                        formDataElement.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveResponse(URLConnection c) throws IOException, InterruptedException {
        InputStream inputStream;
        block38: {
            block37: {
                if (this.canceled) {
                    return;
                }
                InputStream errorStream = null;
                if (c instanceof HttpURLConnection) {
                    HttpURLConnection http = (HttpURLConnection)c;
                    int code = http.getResponseCode();
                    if (code == -1) {
                        throw new InvalidResponseException();
                    }
                    if (this.canceled) {
                        return;
                    }
                    switch (code) {
                        case 301: 
                        case 302: 
                        case 303: 
                        case 307: {
                            this.willSendRequest(c);
                            break;
                        }
                        case 304: {
                            this.didReceiveResponse(c);
                            this.didFinishLoading();
                            return;
                        }
                    }
                    if (code >= 400 && !this.method.equals(HEAD)) {
                        errorStream = http.getErrorStream();
                    }
                }
                if (this.url.startsWith("ftp:") || this.url.startsWith("ftps:")) {
                    boolean dir = false;
                    boolean notsure = false;
                    String path = c.getURL().getPath();
                    if (path == null || path.isEmpty() || path.endsWith("/") || path.contains(";type=d")) {
                        dir = true;
                    } else {
                        String type = c.getContentType();
                        if ("text/plain".equalsIgnoreCase(type) || "text/html".equalsIgnoreCase(type)) {
                            dir = true;
                            notsure = true;
                        }
                    }
                    if (dir) {
                        c = new DirectoryURLConnection(c, notsure);
                    }
                }
                if (this.url.startsWith("file:") && "text/plain".equals(c.getContentType()) && c.getHeaderField("content-length") == null) {
                    c = new DirectoryURLConnection(c);
                }
                this.didReceiveResponse(c);
                if (this.method.equals(HEAD)) {
                    this.didFinishLoading();
                    return;
                }
                inputStream = null;
                try {
                    inputStream = errorStream == null ? c.getInputStream() : errorStream;
                }
                catch (HttpRetryException ex) {
                    throw ex;
                }
                catch (IOException e) {
                    if (!logger.isLoggable(PlatformLogger.Level.FINE)) break block37;
                    logger.fine(String.format("Exception caught: [%s], %s", e.getClass().getSimpleName(), e.getMessage()));
                }
            }
            String encoding = c.getContentEncoding();
            if (inputStream != null) {
                try {
                    if ("gzip".equalsIgnoreCase(encoding)) {
                        inputStream = new GZIPInputStream(inputStream);
                    } else if ("deflate".equalsIgnoreCase(encoding)) {
                        inputStream = new InflaterInputStream(inputStream);
                    }
                }
                catch (IOException e) {
                    if (!logger.isLoggable(PlatformLogger.Level.FINE)) break block38;
                    logger.fine(String.format("Exception caught: [%s], %s", e.getClass().getSimpleName(), e.getMessage()));
                }
            }
        }
        ByteBufferAllocator allocator = this.byteBufferPool.newAllocator(3);
        Buffer byteBuffer = null;
        try {
            if (inputStream != null) {
                byte[] buffer = new byte[8192];
                while (!this.canceled) {
                    int remaining;
                    int count;
                    try {
                        count = inputStream.read(buffer);
                    }
                    catch (EOFException ex) {
                        count = -1;
                    }
                    if (count == -1) break;
                    if (byteBuffer == null) {
                        byteBuffer = allocator.allocate();
                    }
                    if (count < (remaining = byteBuffer.remaining())) {
                        ((ByteBuffer)byteBuffer).put(buffer, 0, count);
                        continue;
                    }
                    ((ByteBuffer)byteBuffer).put(buffer, 0, remaining);
                    ((ByteBuffer)byteBuffer).flip();
                    this.didReceiveData((ByteBuffer)byteBuffer, allocator);
                    byteBuffer = null;
                    int outstanding = count - remaining;
                    if (outstanding <= 0) continue;
                    byteBuffer = allocator.allocate();
                    ((ByteBuffer)byteBuffer).put(buffer, remaining, outstanding);
                }
            }
            if (!this.canceled) {
                if (byteBuffer != null && byteBuffer.position() > 0) {
                    ((ByteBuffer)byteBuffer).flip();
                    this.didReceiveData((ByteBuffer)byteBuffer, allocator);
                    byteBuffer = null;
                }
                this.didFinishLoading();
            }
            if (byteBuffer != null) {
                allocator.release((ByteBuffer)byteBuffer);
            }
        }
        catch (Throwable throwable) {
            if (byteBuffer != null) {
                allocator.release((ByteBuffer)byteBuffer);
            }
            throw throwable;
        }
    }

    private static void close(URLConnection c) {
        InputStream errorStream;
        if (c instanceof HttpURLConnection && (errorStream = ((HttpURLConnection)c).getErrorStream()) != null) {
            try {
                errorStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            c.getInputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void didSendData(long totalBytesSent, long totalBytesToBeSent) {
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyDidSendData(totalBytesSent, totalBytesToBeSent);
            }
        });
    }

    private void notifyDidSendData(long totalBytesSent, long totalBytesToBeSent) {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("totalBytesSent: [%d], totalBytesToBeSent: [%d], data: [0x%016X]", totalBytesSent, totalBytesToBeSent, this.data));
        }
        URLLoader.twkDidSendData(totalBytesSent, totalBytesToBeSent, this.data);
    }

    private void willSendRequest(URLConnection c) throws InterruptedException {
        int status = URLLoader.extractStatus(c);
        String contentType = c.getContentType();
        String contentEncoding = URLLoader.extractContentEncoding(c);
        long contentLength = URLLoader.extractContentLength(c);
        String responseHeaders = URLLoader.extractHeaders(c);
        String adjustedUrl = URLLoader.adjustUrlForWebKit(this.url);
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyWillSendRequest(status, contentType, contentEncoding, contentLength, responseHeaders, adjustedUrl);
            }
        });
    }

    private void notifyWillSendRequest(int status, String contentType, String contentEncoding, long contentLength, String headers, String url) {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("status: [%d], contentType: [%s], contentEncoding: [%s], contentLength: [%d], url: [%s], data: [0x%016X], headers:%n%s", status, contentType, contentEncoding, contentLength, url, this.data, Util.formatHeaders(headers)));
        }
        URLLoader.twkWillSendRequest(status, contentType, contentEncoding, contentLength, headers, url, this.data);
    }

    private void didReceiveResponse(URLConnection c) {
        int status = URLLoader.extractStatus(c);
        String contentType = c.getContentType();
        String contentEncoding = URLLoader.extractContentEncoding(c);
        long contentLength = URLLoader.extractContentLength(c);
        String responseHeaders = URLLoader.extractHeaders(c);
        String adjustedUrl = URLLoader.adjustUrlForWebKit(this.url);
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyDidReceiveResponse(status, contentType, contentEncoding, contentLength, responseHeaders, adjustedUrl);
            }
        });
    }

    private void notifyDidReceiveResponse(int status, String contentType, String contentEncoding, long contentLength, String headers, String url) {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("status: [%d], contentType: [%s], contentEncoding: [%s], contentLength: [%d], url: [%s], data: [0x%016X], headers:%n%s", status, contentType, contentEncoding, contentLength, url, this.data, Util.formatHeaders(headers)));
        }
        URLLoader.twkDidReceiveResponse(status, contentType, contentEncoding, contentLength, headers, url, this.data);
    }

    private void didReceiveData(ByteBuffer byteBuffer, ByteBufferAllocator allocator) {
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyDidReceiveData(byteBuffer, byteBuffer.position(), byteBuffer.remaining());
            }
            allocator.release(byteBuffer);
        });
    }

    private void notifyDidReceiveData(ByteBuffer byteBuffer, int position, int remaining) {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("byteBuffer: [%s], position: [%s], remaining: [%s], data: [0x%016X]", byteBuffer, position, remaining, this.data));
        }
        URLLoader.twkDidReceiveData(byteBuffer, position, remaining, this.data);
    }

    private void didFinishLoading() {
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyDidFinishLoading();
            }
        });
    }

    private void notifyDidFinishLoading() {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("data: [0x%016X]", this.data));
        }
        URLLoader.twkDidFinishLoading(this.data);
    }

    private void didFail(int errorCode, String message) {
        String adjustedUrl = URLLoader.adjustUrlForWebKit(this.url);
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyDidFail(errorCode, adjustedUrl, message);
            }
        });
    }

    private void notifyDidFail(int errorCode, String url, String message) {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("errorCode: [%d], url: [%s], message: [%s], data: [0x%016X]", errorCode, url, message, this.data));
        }
        URLLoader.twkDidFail(errorCode, url, message, this.data);
    }

    private void callBack(Runnable runnable) {
        if (this.asynchronous) {
            Invoker.getInvoker().invokeOnEventThread(runnable);
        } else {
            runnable.run();
        }
    }

    private static int extractStatus(URLConnection c) {
        int status = 0;
        if (c instanceof HttpURLConnection) {
            try {
                status = ((HttpURLConnection)c).getResponseCode();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return status;
    }

    private static String extractContentEncoding(URLConnection c) {
        String contentEncoding = c.getContentEncoding();
        if ("gzip".equalsIgnoreCase(contentEncoding) || "deflate".equalsIgnoreCase(contentEncoding)) {
            int i;
            contentEncoding = null;
            String contentType = c.getContentType();
            if (contentType != null && (i = contentType.indexOf("charset=")) >= 0 && (i = (contentEncoding = contentType.substring(i + 8)).indexOf(";")) > 0) {
                contentEncoding = contentEncoding.substring(0, i);
            }
        }
        return contentEncoding;
    }

    private static long extractContentLength(URLConnection c) {
        try {
            return Long.parseLong(c.getHeaderField("content-length"));
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    private static String extractHeaders(URLConnection c) {
        StringBuilder sb = new StringBuilder();
        if (c instanceof HttpURLConnection) {
            Map<String, List<String>> headers = c.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String key = entry.getKey();
                List<String> values = entry.getValue();
                for (String value : values) {
                    sb.append(key != null ? key : "");
                    sb.append(':').append(value).append('\n');
                }
            }
        }
        return sb.toString();
    }

    private static String adjustUrlForWebKit(String url) {
        try {
            url = Util.adjustUrlForWebKit(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    private static final class InvalidResponseException
    extends IOException {
        private InvalidResponseException() {
            super("Invalid server response");
        }
    }
}

