/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.web;

import com.sun.javafx.logging.PlatformLogger;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.HashMap;
import java.util.Map;

final class DirectoryLock {
    private static final PlatformLogger logger = PlatformLogger.getLogger((String)DirectoryLock.class.getName());
    private static final Map<File, Descriptor> descriptors = new HashMap<File, Descriptor>();
    private Descriptor descriptor;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DirectoryLock(File directory) throws IOException, DirectoryAlreadyInUseException {
        block10: {
            directory = DirectoryLock.canonicalize(directory);
            this.descriptor = descriptors.get(directory);
            if (this.descriptor == null) {
                File lockFile = DirectoryLock.lockFile(directory);
                RandomAccessFile lockRaf = new RandomAccessFile(lockFile, "rw");
                try {
                    FileLock lock = lockRaf.getChannel().tryLock();
                    if (lock == null) {
                        throw new DirectoryAlreadyInUseException(directory.toString(), null);
                    }
                    this.descriptor = new Descriptor(directory, lockRaf, lock);
                    descriptors.put(directory, this.descriptor);
                    if (this.descriptor != null) break block10;
                }
                catch (OverlappingFileLockException ex) {
                    try {
                        throw new DirectoryAlreadyInUseException(directory.toString(), ex);
                    }
                    catch (Throwable throwable) {
                        if (this.descriptor != null) throw throwable;
                        try {
                            lockRaf.close();
                            throw throwable;
                        }
                        catch (IOException ex2) {
                            logger.warning(String.format("Error closing [%s]", lockFile), (Throwable)ex2);
                        }
                        throw throwable;
                    }
                }
                try {
                    lockRaf.close();
                }
                catch (IOException ex) {
                    logger.warning(String.format("Error closing [%s]", lockFile), (Throwable)ex);
                }
            }
        }
        ++this.descriptor.referenceCount;
    }

    void close() {
        if (this.descriptor == null) {
            return;
        }
        --this.descriptor.referenceCount;
        if (this.descriptor.referenceCount == 0) {
            try {
                this.descriptor.lock.release();
            }
            catch (IOException ex) {
                logger.warning(String.format("Error releasing lock on [%s]", DirectoryLock.lockFile(this.descriptor.directory)), (Throwable)ex);
            }
            try {
                this.descriptor.lockRaf.close();
            }
            catch (IOException ex) {
                logger.warning(String.format("Error closing [%s]", DirectoryLock.lockFile(this.descriptor.directory)), (Throwable)ex);
            }
            descriptors.remove(this.descriptor.directory);
        }
        this.descriptor = null;
    }

    static int referenceCount(File directory) throws IOException {
        Descriptor d = descriptors.get(DirectoryLock.canonicalize(directory));
        return d == null ? 0 : d.referenceCount;
    }

    static File canonicalize(File directory) throws IOException {
        Object path = directory.getCanonicalPath();
        if (((String)path).length() > 0 && ((String)path).charAt(((String)path).length() - 1) != File.separatorChar) {
            path = (String)path + File.separatorChar;
        }
        return new File((String)path);
    }

    private static File lockFile(File directory) {
        return new File(directory, ".lock");
    }

    private static class Descriptor {
        private final File directory;
        private final RandomAccessFile lockRaf;
        private final FileLock lock;
        private int referenceCount;

        private Descriptor(File directory, RandomAccessFile lockRaf, FileLock lock) {
            this.directory = directory;
            this.lockRaf = lockRaf;
            this.lock = lock;
        }
    }

    final class DirectoryAlreadyInUseException
    extends Exception {
        DirectoryAlreadyInUseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

