/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.web;

import com.sun.glass.ui.Application;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.web.Debugger;
import com.sun.javafx.scene.web.Printable;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.webkit.Accessor;
import com.sun.javafx.webkit.CursorManagerImpl;
import com.sun.javafx.webkit.EventLoopImpl;
import com.sun.javafx.webkit.ThemeClientImpl;
import com.sun.javafx.webkit.UIClientImpl;
import com.sun.javafx.webkit.UtilitiesImpl;
import com.sun.javafx.webkit.WebPageClientImpl;
import com.sun.javafx.webkit.prism.PrismGraphicsManager;
import com.sun.javafx.webkit.prism.PrismInvoker;
import com.sun.javafx.webkit.prism.theme.PrismRenderer;
import com.sun.javafx.webkit.theme.RenderThemeImpl;
import com.sun.javafx.webkit.theme.Renderer;
import com.sun.webkit.CursorManager;
import com.sun.webkit.Disposer;
import com.sun.webkit.DisposerRecord;
import com.sun.webkit.EventLoop;
import com.sun.webkit.InspectorClient;
import com.sun.webkit.Invoker;
import com.sun.webkit.LoadListenerClient;
import com.sun.webkit.ThemeClient;
import com.sun.webkit.Timer;
import com.sun.webkit.Utilities;
import com.sun.webkit.WebPage;
import com.sun.webkit.graphics.WCGraphicsManager;
import com.sun.webkit.network.URLs;
import com.sun.webkit.network.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Objects;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.concurrent.Worker;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Rectangle2D;
import javafx.print.JobSettings;
import javafx.print.PageLayout;
import javafx.print.PageRange;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.web.DirectoryLock;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebErrorEvent;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import org.w3c.dom.Document;

public final class WebEngine {
    private static final PlatformLogger logger;
    private static int instanceCount;
    private final ObjectProperty<WebView> view = new SimpleObjectProperty((Object)this, "view");
    private final LoadWorker loadWorker = new LoadWorker();
    private final WebPage page;
    private final SelfDisposer disposer;
    private final DebuggerImpl debugger = new DebuggerImpl();
    private boolean userDataDirectoryApplied = false;
    private final DocumentProperty document = new DocumentProperty();
    private final ReadOnlyStringWrapper location = new ReadOnlyStringWrapper((Object)this, "location");
    private final ReadOnlyStringWrapper title = new ReadOnlyStringWrapper((Object)this, "title");
    private BooleanProperty javaScriptEnabled;
    private StringProperty userStyleSheetLocation;
    private final ObjectProperty<File> userDataDirectory = new SimpleObjectProperty((Object)this, "userDataDirectory");
    private StringProperty userAgent;
    private final ObjectProperty<EventHandler<WebEvent<String>>> onAlert = new SimpleObjectProperty((Object)this, "onAlert");
    private final ObjectProperty<EventHandler<WebEvent<String>>> onStatusChanged = new SimpleObjectProperty((Object)this, "onStatusChanged");
    private final ObjectProperty<EventHandler<WebEvent<Rectangle2D>>> onResized = new SimpleObjectProperty((Object)this, "onResized");
    private final ObjectProperty<EventHandler<WebEvent<Boolean>>> onVisibilityChanged = new SimpleObjectProperty((Object)this, "onVisibilityChanged");
    private final ObjectProperty<Callback<PopupFeatures, WebEngine>> createPopupHandler = new SimpleObjectProperty((Object)this, "createPopupHandler", p -> this);
    private final ObjectProperty<Callback<String, Boolean>> confirmHandler = new SimpleObjectProperty((Object)this, "confirmHandler");
    private final ObjectProperty<Callback<PromptData, String>> promptHandler = new SimpleObjectProperty((Object)this, "promptHandler");
    private final ObjectProperty<EventHandler<WebErrorEvent>> onError = new SimpleObjectProperty((Object)this, "onError");
    private final WebHistory history;

    public final Worker<Void> getLoadWorker() {
        return this.loadWorker;
    }

    public final Document getDocument() {
        return (Document)this.document.getValue();
    }

    public final ReadOnlyObjectProperty<Document> documentProperty() {
        return this.document;
    }

    public final String getLocation() {
        return this.location.getValue();
    }

    public final ReadOnlyStringProperty locationProperty() {
        return this.location.getReadOnlyProperty();
    }

    private void updateLocation(String value) {
        this.location.set(value);
        this.document.invalidate(false);
        this.title.set(null);
    }

    public final String getTitle() {
        return this.title.getValue();
    }

    public final ReadOnlyStringProperty titleProperty() {
        return this.title.getReadOnlyProperty();
    }

    private void updateTitle() {
        this.title.set(this.page.getTitle(this.page.getMainFrame()));
    }

    public final void setJavaScriptEnabled(boolean value) {
        this.javaScriptEnabledProperty().set(value);
    }

    public final boolean isJavaScriptEnabled() {
        return this.javaScriptEnabled == null ? true : this.javaScriptEnabled.get();
    }

    public final BooleanProperty javaScriptEnabledProperty() {
        if (this.javaScriptEnabled == null) {
            this.javaScriptEnabled = new BooleanPropertyBase(true){

                public void invalidated() {
                    WebEngine.checkThread();
                    WebEngine.this.page.setJavaScriptEnabled(this.get());
                }

                public Object getBean() {
                    return WebEngine.this;
                }

                public String getName() {
                    return "javaScriptEnabled";
                }
            };
        }
        return this.javaScriptEnabled;
    }

    public final void setUserStyleSheetLocation(String value) {
        this.userStyleSheetLocationProperty().set((Object)value);
    }

    public final String getUserStyleSheetLocation() {
        return this.userStyleSheetLocation == null ? null : (String)this.userStyleSheetLocation.get();
    }

    private byte[] readFully(BufferedInputStream in) throws IOException {
        int nBytes;
        int BUF_SIZE = 4096;
        int outSize = 0;
        ArrayList<byte[]> outList = new ArrayList<byte[]>();
        byte[] buffer = new byte[4096];
        while ((nBytes = in.read(buffer)) >= 0) {
            byte[] chunk;
            if (nBytes == buffer.length) {
                chunk = buffer;
                buffer = new byte[4096];
            } else {
                chunk = new byte[nBytes];
                System.arraycopy(buffer, 0, chunk, 0, nBytes);
            }
            outList.add(chunk);
            outSize += nBytes;
        }
        byte[] out = new byte[outSize];
        int outPos = 0;
        for (byte[] chunk : outList) {
            System.arraycopy(chunk, 0, out, outPos, chunk.length);
            outPos += chunk.length;
        }
        return out;
    }

    public final StringProperty userStyleSheetLocationProperty() {
        if (this.userStyleSheetLocation == null) {
            this.userStyleSheetLocation = new StringPropertyBase(null){
                private static final String DATA_PREFIX = "data:text/css;charset=utf-8;base64,";

                public void invalidated() {
                    Object dataUrl;
                    WebEngine.checkThread();
                    String url = this.get();
                    if (url == null || url.length() <= 0) {
                        dataUrl = null;
                    } else if (url.startsWith(DATA_PREFIX)) {
                        dataUrl = url;
                    } else if (url.startsWith("file:") || url.startsWith("jar:") || url.startsWith("jrt:") || url.startsWith("data:")) {
                        try {
                            URLConnection conn = URLs.newURL(url).openConnection();
                            conn.connect();
                            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                            byte[] inBytes = WebEngine.this.readFully(in);
                            String out = Base64.getMimeEncoder().encodeToString(inBytes);
                            dataUrl = DATA_PREFIX + out;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        throw new IllegalArgumentException("Invalid stylesheet URL");
                    }
                    WebEngine.this.page.setUserStyleSheetLocation((String)dataUrl);
                }

                public Object getBean() {
                    return WebEngine.this;
                }

                public String getName() {
                    return "userStyleSheetLocation";
                }
            };
        }
        return this.userStyleSheetLocation;
    }

    public final File getUserDataDirectory() {
        return (File)this.userDataDirectory.get();
    }

    public final void setUserDataDirectory(File value) {
        this.userDataDirectory.set((Object)value);
    }

    public final ObjectProperty<File> userDataDirectoryProperty() {
        return this.userDataDirectory;
    }

    public final void setUserAgent(String value) {
        this.userAgentProperty().set((Object)value);
    }

    public final String getUserAgent() {
        return this.userAgent == null ? this.page.getUserAgent() : (String)this.userAgent.get();
    }

    public final StringProperty userAgentProperty() {
        if (this.userAgent == null) {
            this.userAgent = new StringPropertyBase(this.page.getUserAgent()){

                public void invalidated() {
                    WebEngine.checkThread();
                    WebEngine.this.page.setUserAgent(this.get());
                }

                public Object getBean() {
                    return WebEngine.this;
                }

                public String getName() {
                    return "userAgent";
                }
            };
        }
        return this.userAgent;
    }

    public final EventHandler<WebEvent<String>> getOnAlert() {
        return (EventHandler)this.onAlert.get();
    }

    public final void setOnAlert(EventHandler<WebEvent<String>> handler) {
        this.onAlert.set(handler);
    }

    public final ObjectProperty<EventHandler<WebEvent<String>>> onAlertProperty() {
        return this.onAlert;
    }

    public final EventHandler<WebEvent<String>> getOnStatusChanged() {
        return (EventHandler)this.onStatusChanged.get();
    }

    public final void setOnStatusChanged(EventHandler<WebEvent<String>> handler) {
        this.onStatusChanged.set(handler);
    }

    public final ObjectProperty<EventHandler<WebEvent<String>>> onStatusChangedProperty() {
        return this.onStatusChanged;
    }

    public final EventHandler<WebEvent<Rectangle2D>> getOnResized() {
        return (EventHandler)this.onResized.get();
    }

    public final void setOnResized(EventHandler<WebEvent<Rectangle2D>> handler) {
        this.onResized.set(handler);
    }

    public final ObjectProperty<EventHandler<WebEvent<Rectangle2D>>> onResizedProperty() {
        return this.onResized;
    }

    public final EventHandler<WebEvent<Boolean>> getOnVisibilityChanged() {
        return (EventHandler)this.onVisibilityChanged.get();
    }

    public final void setOnVisibilityChanged(EventHandler<WebEvent<Boolean>> handler) {
        this.onVisibilityChanged.set(handler);
    }

    public final ObjectProperty<EventHandler<WebEvent<Boolean>>> onVisibilityChangedProperty() {
        return this.onVisibilityChanged;
    }

    public final Callback<PopupFeatures, WebEngine> getCreatePopupHandler() {
        return (Callback)this.createPopupHandler.get();
    }

    public final void setCreatePopupHandler(Callback<PopupFeatures, WebEngine> handler) {
        this.createPopupHandler.set(handler);
    }

    public final ObjectProperty<Callback<PopupFeatures, WebEngine>> createPopupHandlerProperty() {
        return this.createPopupHandler;
    }

    public final Callback<String, Boolean> getConfirmHandler() {
        return (Callback)this.confirmHandler.get();
    }

    public final void setConfirmHandler(Callback<String, Boolean> handler) {
        this.confirmHandler.set(handler);
    }

    public final ObjectProperty<Callback<String, Boolean>> confirmHandlerProperty() {
        return this.confirmHandler;
    }

    public final Callback<PromptData, String> getPromptHandler() {
        return (Callback)this.promptHandler.get();
    }

    public final void setPromptHandler(Callback<PromptData, String> handler) {
        this.promptHandler.set(handler);
    }

    public final ObjectProperty<Callback<PromptData, String>> promptHandlerProperty() {
        return this.promptHandler;
    }

    public final EventHandler<WebErrorEvent> getOnError() {
        return (EventHandler)this.onError.get();
    }

    public final void setOnError(EventHandler<WebErrorEvent> handler) {
        this.onError.set(handler);
    }

    public final ObjectProperty<EventHandler<WebErrorEvent>> onErrorProperty() {
        return this.onError;
    }

    public WebEngine() {
        this(null, false);
    }

    public WebEngine(String url) {
        this(url, true);
    }

    private WebEngine(String url, boolean callLoad) {
        WebEngine.checkThread();
        AccessorImpl accessor = new AccessorImpl(this);
        this.page = new WebPage(new WebPageClientImpl(accessor), new UIClientImpl(accessor), null, new InspectorClientImpl(this), new ThemeClientImpl(accessor), false);
        this.page.addLoadListenerClient(new PageLoadListener(this));
        this.history = new WebHistory(this.page);
        this.disposer = new SelfDisposer(this.page);
        Disposer.addRecord(this, this.disposer);
        if (callLoad) {
            this.load(url);
        }
        if (instanceCount == 0 && Timer.getMode() == Timer.Mode.PLATFORM_TICKS) {
            PulseTimer.start();
        }
        ++instanceCount;
    }

    public void load(String url) {
        WebEngine.checkThread();
        this.loadWorker.cancelAndReset();
        if (url == null || url.equals("") || url.equals("about:blank")) {
            url = "";
        } else {
            try {
                url = Util.adjustUrlForWebKit(url);
            }
            catch (MalformedURLException e) {
                this.loadWorker.dispatchLoadEvent(this.getMainFrame(), 0, url, null, 0.0, 0);
                this.loadWorker.dispatchLoadEvent(this.getMainFrame(), 5, url, null, 0.0, 2);
                return;
            }
        }
        this.applyUserDataDirectory();
        this.page.open(this.page.getMainFrame(), url);
    }

    public void loadContent(String content) {
        this.loadContent(content, "text/html");
    }

    public void loadContent(String content, String contentType) {
        WebEngine.checkThread();
        this.loadWorker.cancelAndReset();
        this.applyUserDataDirectory();
        this.page.load(this.page.getMainFrame(), content, contentType);
    }

    public void reload() {
        WebEngine.checkThread();
        this.page.refresh(this.page.getMainFrame());
    }

    public WebHistory getHistory() {
        return this.history;
    }

    public Object executeScript(String script) {
        WebEngine.checkThread();
        this.applyUserDataDirectory();
        return this.page.executeScript(this.page.getMainFrame(), script);
    }

    private long getMainFrame() {
        return this.page.getMainFrame();
    }

    WebPage getPage() {
        return this.page;
    }

    void setView(WebView view) {
        this.view.setValue((Object)view);
    }

    private void stop() {
        WebEngine.checkThread();
        this.page.stop(this.page.getMainFrame());
    }

    private void applyUserDataDirectory() {
        if (this.userDataDirectoryApplied) {
            return;
        }
        this.userDataDirectoryApplied = true;
        File nominalUserDataDir = this.getUserDataDirectory();
        while (true) {
            Exception error;
            EventType<WebErrorEvent> errorType;
            String errorMessage;
            String displayString;
            File userDataDir;
            if (nominalUserDataDir == null) {
                userDataDir = WebEngine.defaultUserDataDirectory();
                displayString = String.format("null (%s)", userDataDir);
            } else {
                userDataDir = nominalUserDataDir;
                displayString = userDataDir.toString();
            }
            logger.fine("Trying to apply user data directory [{0}]", new Object[]{displayString});
            try {
                File[] dirs;
                userDataDir = DirectoryLock.canonicalize(userDataDir);
                File localStorageDir = new File(userDataDir, "localstorage");
                for (File dir : dirs = new File[]{userDataDir, localStorageDir}) {
                    WebEngine.createDirectories(dir);
                    File test = new File(dir, ".test");
                    if (!test.createNewFile()) continue;
                    test.delete();
                }
                this.disposer.userDataDirectoryLock = new DirectoryLock(userDataDir);
                this.page.setLocalStorageDatabasePath(localStorageDir.getPath());
                this.page.setLocalStorageEnabled(true);
                logger.fine("User data directory [{0}] has been applied successfully", new Object[]{displayString});
                return;
            }
            catch (DirectoryLock.DirectoryAlreadyInUseException ex) {
                errorMessage = "User data directory [%s] is already in use";
                errorType = WebErrorEvent.USER_DATA_DIRECTORY_ALREADY_IN_USE;
                error = ex;
            }
            catch (IOException ex) {
                errorMessage = "An I/O error occurred while setting up user data directory [%s]";
                errorType = WebErrorEvent.USER_DATA_DIRECTORY_IO_ERROR;
                error = ex;
            }
            catch (SecurityException ex) {
                errorMessage = "A security error occurred while setting up user data directory [%s]";
                errorType = WebErrorEvent.USER_DATA_DIRECTORY_SECURITY_ERROR;
                error = ex;
            }
            errorMessage = String.format(errorMessage, displayString);
            logger.fine("{0}, calling error handler", new Object[]{errorMessage});
            File oldNominalUserDataDir = nominalUserDataDir;
            this.fireError(errorType, errorMessage, error);
            nominalUserDataDir = this.getUserDataDirectory();
            if (Objects.equals(nominalUserDataDir, oldNominalUserDataDir)) {
                logger.fine("Error handler did not modify user data directory, continuing without user data directory");
                return;
            }
            logger.fine("Error handler has set user data directory to [{0}], retrying", new Object[]{nominalUserDataDir});
        }
    }

    private static File defaultUserDataDirectory() {
        return new File(Application.GetApplication().getDataDirectory(), "webview");
    }

    private static void createDirectories(File directory) throws IOException {
        Path path = directory.toPath();
        try {
            Files.createDirectories(path, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------")));
        }
        catch (UnsupportedOperationException ex) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    private void fireError(EventType<WebErrorEvent> eventType, String message, Throwable exception) {
        EventHandler<WebErrorEvent> handler = this.getOnError();
        if (handler != null) {
            handler.handle((Event)new WebErrorEvent(this, eventType, message, exception));
        }
    }

    void dispose() {
        this.disposer.dispose();
    }

    static void checkThread() {
        Toolkit.getToolkit().checkFxUserThread();
    }

    Debugger getDebugger() {
        return this.debugger;
    }

    private static final boolean printStatusOK(PrinterJob job) {
        switch (job.getJobStatus()) {
            case NOT_STARTED: 
            case PRINTING: {
                return true;
            }
        }
        return false;
    }

    public void print(PrinterJob job) {
        if (!WebEngine.printStatusOK(job)) {
            return;
        }
        PageLayout pl = job.getJobSettings().getPageLayout();
        float width = (float)pl.getPrintableWidth();
        float height = (float)pl.getPrintableHeight();
        int pageCount = this.page.beginPrinting(width, height);
        JobSettings jobSettings = job.getJobSettings();
        if (jobSettings.getPageRanges() != null) {
            PageRange[] pageRanges;
            for (PageRange p : pageRanges = jobSettings.getPageRanges()) {
                for (int i = p.getStartPage(); i <= p.getEndPage() && i <= pageCount; ++i) {
                    if (!WebEngine.printStatusOK(job)) continue;
                    Printable printable = new Printable(this.page, i - 1, width);
                    job.printPage((Node)printable);
                }
            }
        } else {
            for (int i = 0; i < pageCount; ++i) {
                if (!WebEngine.printStatusOK(job)) continue;
                Printable printable = new Printable(this.page, i, width);
                job.printPage((Node)printable);
            }
        }
        this.page.endPrinting();
    }

    static {
        Accessor.setPageAccessor(w -> w == null ? null : w.getPage());
        Invoker.setInvoker(new PrismInvoker());
        Renderer.setRenderer(new PrismRenderer());
        WCGraphicsManager.setGraphicsManager(new PrismGraphicsManager());
        CursorManager.setCursorManager(new CursorManagerImpl());
        EventLoop.setEventLoop(new EventLoopImpl());
        ThemeClient.setDefaultRenderTheme(new RenderThemeImpl());
        Utilities.setUtilities(new UtilitiesImpl());
        logger = PlatformLogger.getLogger((String)WebEngine.class.getName());
        instanceCount = 0;
    }

    private final class LoadWorker
    implements Worker<Void> {
        private final ReadOnlyObjectWrapper<Worker.State> state = new ReadOnlyObjectWrapper((Object)this, "state", (Object)Worker.State.READY);
        private final ReadOnlyObjectWrapper<Void> value = new ReadOnlyObjectWrapper((Object)this, "value", null);
        private final ReadOnlyObjectWrapper<Throwable> exception = new ReadOnlyObjectWrapper((Object)this, "exception");
        private final ReadOnlyDoubleWrapper workDone = new ReadOnlyDoubleWrapper((Object)this, "workDone", -1.0);
        private final ReadOnlyDoubleWrapper totalWorkToBeDone = new ReadOnlyDoubleWrapper((Object)this, "totalWork", -1.0);
        private final ReadOnlyDoubleWrapper progress = new ReadOnlyDoubleWrapper((Object)this, "progress", -1.0);
        private final ReadOnlyBooleanWrapper running = new ReadOnlyBooleanWrapper((Object)this, "running", false);
        private final ReadOnlyStringWrapper message = new ReadOnlyStringWrapper((Object)this, "message", "");
        private final ReadOnlyStringWrapper title = new ReadOnlyStringWrapper((Object)this, "title", "WebEngine Loader");

        private LoadWorker() {
        }

        public final Worker.State getState() {
            WebEngine.checkThread();
            return (Worker.State)this.state.get();
        }

        public final ReadOnlyObjectProperty<Worker.State> stateProperty() {
            WebEngine.checkThread();
            return this.state.getReadOnlyProperty();
        }

        private void updateState(Worker.State value) {
            WebEngine.checkThread();
            this.state.set((Object)value);
            this.running.set(value == Worker.State.SCHEDULED || value == Worker.State.RUNNING);
        }

        public final Void getValue() {
            WebEngine.checkThread();
            return (Void)this.value.get();
        }

        public final ReadOnlyObjectProperty<Void> valueProperty() {
            WebEngine.checkThread();
            return this.value.getReadOnlyProperty();
        }

        public final Throwable getException() {
            WebEngine.checkThread();
            return (Throwable)this.exception.get();
        }

        public final ReadOnlyObjectProperty<Throwable> exceptionProperty() {
            WebEngine.checkThread();
            return this.exception.getReadOnlyProperty();
        }

        public final double getWorkDone() {
            WebEngine.checkThread();
            return this.workDone.get();
        }

        public final ReadOnlyDoubleProperty workDoneProperty() {
            WebEngine.checkThread();
            return this.workDone.getReadOnlyProperty();
        }

        public final double getTotalWork() {
            WebEngine.checkThread();
            return this.totalWorkToBeDone.get();
        }

        public final ReadOnlyDoubleProperty totalWorkProperty() {
            WebEngine.checkThread();
            return this.totalWorkToBeDone.getReadOnlyProperty();
        }

        public final double getProgress() {
            WebEngine.checkThread();
            return this.progress.get();
        }

        public final ReadOnlyDoubleProperty progressProperty() {
            WebEngine.checkThread();
            return this.progress.getReadOnlyProperty();
        }

        private void updateProgress(double p) {
            this.totalWorkToBeDone.set(100.0);
            this.workDone.set(p * 100.0);
            this.progress.set(p);
        }

        public final boolean isRunning() {
            WebEngine.checkThread();
            return this.running.get();
        }

        public final ReadOnlyBooleanProperty runningProperty() {
            WebEngine.checkThread();
            return this.running.getReadOnlyProperty();
        }

        public final String getMessage() {
            return this.message.get();
        }

        public final ReadOnlyStringProperty messageProperty() {
            return this.message.getReadOnlyProperty();
        }

        public final String getTitle() {
            return this.title.get();
        }

        public final ReadOnlyStringProperty titleProperty() {
            return this.title.getReadOnlyProperty();
        }

        public boolean cancel() {
            if (this.isRunning()) {
                WebEngine.this.stop();
                return true;
            }
            return false;
        }

        private void cancelAndReset() {
            this.cancel();
            this.exception.set(null);
            this.message.set("");
            this.totalWorkToBeDone.set(-1.0);
            this.workDone.set(-1.0);
            this.progress.set(-1.0);
            this.updateState(Worker.State.READY);
            this.running.set(false);
        }

        private void dispatchLoadEvent(long frame, int state, String url, String contentType, double workDone, int errorCode) {
            if (frame != WebEngine.this.getMainFrame()) {
                return;
            }
            switch (state) {
                case 0: {
                    this.message.set("Loading " + url);
                    WebEngine.this.updateLocation(url);
                    this.updateProgress(0.0);
                    this.updateState(Worker.State.SCHEDULED);
                    this.updateState(Worker.State.RUNNING);
                    break;
                }
                case 2: {
                    this.message.set("Loading " + url);
                    WebEngine.this.updateLocation(url);
                    break;
                }
                case 3: {
                    this.message.set("Replaced " + url);
                    WebEngine.this.location.set(url);
                    break;
                }
                case 1: {
                    this.message.set("Loading complete");
                    this.updateProgress(1.0);
                    this.updateState(Worker.State.SUCCEEDED);
                    break;
                }
                case 5: {
                    this.message.set("Loading failed");
                    this.exception.set((Object)this.describeError(errorCode));
                    this.updateState(Worker.State.FAILED);
                    break;
                }
                case 6: {
                    this.message.set("Loading stopped");
                    this.updateState(Worker.State.CANCELLED);
                    break;
                }
                case 30: {
                    this.updateProgress(workDone);
                    break;
                }
                case 11: {
                    WebEngine.this.updateTitle();
                    break;
                }
                case 14: {
                    if (this.state.get() != Worker.State.RUNNING) {
                        this.dispatchLoadEvent(frame, 0, url, contentType, workDone, errorCode);
                    }
                    WebEngine.this.document.invalidate(true);
                }
            }
        }

        private Throwable describeError(int errorCode) {
            String reason = "Unknown error";
            switch (errorCode) {
                case 1: {
                    reason = "Unknown host";
                    break;
                }
                case 2: {
                    reason = "Malformed URL";
                    break;
                }
                case 3: {
                    reason = "SSL handshake failed";
                    break;
                }
                case 4: {
                    reason = "Connection refused by server";
                    break;
                }
                case 5: {
                    reason = "Connection reset by server";
                    break;
                }
                case 6: {
                    reason = "No route to host";
                    break;
                }
                case 7: {
                    reason = "Connection timed out";
                    break;
                }
                case 8: {
                    reason = "Permission denied";
                    break;
                }
                case 9: {
                    reason = "Invalid response from server";
                    break;
                }
                case 10: {
                    reason = "Too many redirects";
                    break;
                }
                case 11: {
                    reason = "File not found";
                }
            }
            return new Throwable(reason);
        }
    }

    private final class DocumentProperty
    extends ReadOnlyObjectPropertyBase<Document> {
        private boolean available;
        private Document document;

        private DocumentProperty() {
        }

        private void invalidate(boolean available) {
            if (this.available || available) {
                this.available = available;
                this.document = null;
                this.fireValueChangedEvent();
            }
        }

        public Document get() {
            if (!this.available) {
                return null;
            }
            if (this.document == null) {
                this.document = WebEngine.this.page.getDocument(WebEngine.this.page.getMainFrame());
                if (this.document == null) {
                    this.available = false;
                }
            }
            return this.document;
        }

        public Object getBean() {
            return WebEngine.this;
        }

        public String getName() {
            return "document";
        }
    }

    private final class DebuggerImpl
    implements Debugger {
        private boolean enabled;
        private Callback<String, Void> messageCallback;

        private DebuggerImpl() {
        }

        @Override
        public boolean isEnabled() {
            WebEngine.checkThread();
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean enabled) {
            WebEngine.checkThread();
            if (enabled != this.enabled) {
                if (enabled) {
                    WebEngine.this.page.setDeveloperExtrasEnabled(true);
                    WebEngine.this.page.connectInspectorFrontend();
                } else {
                    WebEngine.this.page.disconnectInspectorFrontend();
                    WebEngine.this.page.setDeveloperExtrasEnabled(false);
                }
                this.enabled = enabled;
            }
        }

        @Override
        public void sendMessage(String message) {
            WebEngine.checkThread();
            if (!this.enabled) {
                throw new IllegalStateException("Debugger is not enabled");
            }
            if (message == null) {
                throw new NullPointerException("message is null");
            }
            WebEngine.this.page.dispatchInspectorMessageFromFrontend(message);
        }

        @Override
        public Callback<String, Void> getMessageCallback() {
            WebEngine.checkThread();
            return this.messageCallback;
        }

        @Override
        public void setMessageCallback(Callback<String, Void> callback) {
            WebEngine.checkThread();
            this.messageCallback = callback;
        }
    }

    private static final class AccessorImpl
    extends Accessor {
        private final WeakReference<WebEngine> engine;

        private AccessorImpl(WebEngine w) {
            this.engine = new WeakReference<WebEngine>(w);
        }

        @Override
        public WebEngine getEngine() {
            return (WebEngine)this.engine.get();
        }

        @Override
        public WebPage getPage() {
            WebEngine w = this.getEngine();
            return w == null ? null : w.page;
        }

        @Override
        public WebView getView() {
            WebEngine w = this.getEngine();
            return w == null ? null : (WebView)((Object)w.view.get());
        }

        @Override
        public void addChild(Node child) {
            WebView view = this.getView();
            if (view != null) {
                view.getChildren().add((Object)child);
            }
        }

        @Override
        public void removeChild(Node child) {
            WebView view = this.getView();
            if (view != null) {
                view.getChildren().remove((Object)child);
            }
        }

        @Override
        public void addViewListener(InvalidationListener l) {
            WebEngine w = this.getEngine();
            if (w != null) {
                w.view.addListener(l);
            }
        }
    }

    private static final class InspectorClientImpl
    implements InspectorClient {
        private final WeakReference<WebEngine> engine;

        private InspectorClientImpl(WebEngine engine) {
            this.engine = new WeakReference<WebEngine>(engine);
        }

        @Override
        public boolean sendMessageToFrontend(String message) {
            Callback<String, Void> messageCallback;
            boolean result = false;
            WebEngine webEngine = (WebEngine)this.engine.get();
            if (webEngine != null && (messageCallback = webEngine.debugger.messageCallback) != null) {
                AccessController.doPrivileged(() -> {
                    messageCallback.call((Object)message);
                    return null;
                }, webEngine.page.getAccessControlContext());
                result = true;
            }
            return result;
        }
    }

    private static final class PageLoadListener
    implements LoadListenerClient {
        private final WeakReference<WebEngine> engine;

        private PageLoadListener(WebEngine engine) {
            this.engine = new WeakReference<WebEngine>(engine);
        }

        @Override
        public void dispatchLoadEvent(long frame, int state, String url, String contentType, double progress, int errorCode) {
            WebEngine w = (WebEngine)this.engine.get();
            if (w != null) {
                w.loadWorker.dispatchLoadEvent(frame, state, url, contentType, progress, errorCode);
            }
        }

        @Override
        public void dispatchResourceLoadEvent(long frame, int state, String url, String contentType, double progress, int errorCode) {
        }
    }

    private static final class SelfDisposer
    implements DisposerRecord {
        private WebPage page;
        private DirectoryLock userDataDirectoryLock;

        private SelfDisposer(WebPage page) {
            this.page = page;
        }

        @Override
        public void dispose() {
            if (this.page == null) {
                return;
            }
            this.page.dispose();
            this.page = null;
            if (this.userDataDirectoryLock != null) {
                this.userDataDirectoryLock.close();
            }
            if (--instanceCount == 0 && Timer.getMode() == Timer.Mode.PLATFORM_TICKS) {
                PulseTimer.stop();
            }
        }
    }

    private static final class PulseTimer {
        private static final AnimationTimer animation = new AnimationTimer(){

            public void handle(long l) {
            }
        };
        private static final TKPulseListener listener = () -> Platform.runLater(() -> Timer.getTimer().notifyTick());

        private PulseTimer() {
        }

        private static void start() {
            Toolkit.getToolkit().addSceneTkPulseListener(listener);
            animation.start();
        }

        private static void stop() {
            Toolkit.getToolkit().removeSceneTkPulseListener(listener);
            animation.stop();
        }
    }
}

