/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.web;

import com.sun.java.scene.web.WebViewHelper;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.web.NGWebView;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.webkit.InputMethodClientImpl;
import com.sun.javafx.webkit.KeyCodeMap;
import com.sun.webkit.WebPage;
import com.sun.webkit.event.WCFocusEvent;
import com.sun.webkit.event.WCInputMethodEvent;
import com.sun.webkit.event.WCKeyEvent;
import com.sun.webkit.event.WCMouseEvent;
import com.sun.webkit.event.WCMouseWheelEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.ColorConverter;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.paint.Color;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.web.WebEngine;
import javafx.stage.Stage;
import javafx.stage.Window;

public final class WebView
extends Parent {
    private static final Map<Object, Integer> ID_MAP = Map.ofEntries(Map.entry(MouseButton.NONE, 0), Map.entry(MouseButton.PRIMARY, 1), Map.entry(MouseButton.MIDDLE, 2), Map.entry(MouseButton.SECONDARY, 4), Map.entry(MouseEvent.MOUSE_PRESSED, 0), Map.entry(MouseEvent.MOUSE_RELEASED, 1), Map.entry(MouseEvent.MOUSE_MOVED, 2), Map.entry(MouseEvent.MOUSE_DRAGGED, 3), Map.entry(KeyEvent.KEY_PRESSED, 1), Map.entry(KeyEvent.KEY_RELEASED, 2), Map.entry(KeyEvent.KEY_TYPED, 0));
    private static final boolean DEFAULT_CONTEXT_MENU_ENABLED = true;
    private static final FontSmoothingType DEFAULT_FONT_SMOOTHING_TYPE = FontSmoothingType.LCD;
    private static final Color DEFAULT_PAGE_FILL = Color.WHITE;
    private static final double DEFAULT_ZOOM = 1.0;
    private static final double DEFAULT_FONT_SCALE = 1.0;
    private static final double DEFAULT_MIN_WIDTH = 0.0;
    private static final double DEFAULT_MIN_HEIGHT = 0.0;
    private static final double DEFAULT_PREF_WIDTH = 800.0;
    private static final double DEFAULT_PREF_HEIGHT = 600.0;
    private static final double DEFAULT_MAX_WIDTH = Double.MAX_VALUE;
    private static final double DEFAULT_MAX_HEIGHT = Double.MAX_VALUE;
    private final WebPage page;
    private final WebEngine engine;
    private volatile InputMethodClientImpl imClient;
    private final TKPulseListener stagePulseListener;
    private final ReadOnlyDoubleWrapper width = new ReadOnlyDoubleWrapper((Object)this, "width");
    private final ReadOnlyDoubleWrapper height = new ReadOnlyDoubleWrapper((Object)this, "height");
    private DoubleProperty zoom;
    private DoubleProperty fontScale;
    private DoubleProperty minWidth;
    private DoubleProperty minHeight;
    private DoubleProperty prefWidth;
    private DoubleProperty prefHeight;
    private DoubleProperty maxWidth;
    private DoubleProperty maxHeight;
    private ObjectProperty<FontSmoothingType> fontSmoothingType;
    private ObjectProperty<Color> pageFill;
    private BooleanProperty contextMenuEnabled;
    private static final int WK_DND_ACTION_NONE = 0;
    private static final int WK_DND_ACTION_COPY = 1;
    private static final int WK_DND_ACTION_MOVE = 2;
    private static final int WK_DND_ACTION_LINK = 0x40000000;
    private LinkedList<String> mimes;
    private LinkedList<String> values;

    public final WebEngine getEngine() {
        return this.engine;
    }

    public final double getWidth() {
        return this.width.get();
    }

    public ReadOnlyDoubleProperty widthProperty() {
        return this.width.getReadOnlyProperty();
    }

    public final double getHeight() {
        return this.height.get();
    }

    public ReadOnlyDoubleProperty heightProperty() {
        return this.height.getReadOnlyProperty();
    }

    public final void setZoom(double value) {
        WebEngine.checkThread();
        this.zoomProperty().set(value);
    }

    public final double getZoom() {
        return this.zoom != null ? this.zoom.get() : 1.0;
    }

    public final DoubleProperty zoomProperty() {
        if (this.zoom == null) {
            this.zoom = new StyleableDoubleProperty(1.0){

                public void invalidated() {
                    Toolkit.getToolkit().checkFxUserThread();
                    WebView.this.page.setZoomFactor((float)this.get(), false);
                }

                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.ZOOM;
                }

                public Object getBean() {
                    return WebView.this;
                }

                public String getName() {
                    return "zoom";
                }
            };
        }
        return this.zoom;
    }

    public final void setFontScale(double value) {
        WebEngine.checkThread();
        this.fontScaleProperty().set(value);
    }

    public final double getFontScale() {
        return this.fontScale != null ? this.fontScale.get() : 1.0;
    }

    public DoubleProperty fontScaleProperty() {
        if (this.fontScale == null) {
            this.fontScale = new StyleableDoubleProperty(1.0){

                public void invalidated() {
                    Toolkit.getToolkit().checkFxUserThread();
                    WebView.this.page.setZoomFactor((float)this.get(), true);
                }

                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.FONT_SCALE;
                }

                public Object getBean() {
                    return WebView.this;
                }

                public String getName() {
                    return "fontScale";
                }
            };
        }
        return this.fontScale;
    }

    public WebView() {
        WebViewHelper.initHelper(this);
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.getStyleClass().add((Object)"web-view");
        this.engine = new WebEngine();
        this.engine.setView(this);
        this.page = this.engine.getPage();
        this.page.setFontSmoothingType(DEFAULT_FONT_SMOOTHING_TYPE.ordinal());
        this.page.setBackgroundColor(DEFAULT_PAGE_FILL);
        this.registerEventHandlers();
        this.stagePulseListener = () -> this.handleStagePulse();
        this.focusedProperty().addListener((ov, t, t1) -> {
            if (this.page != null) {
                WCFocusEvent focusEvent = new WCFocusEvent(this.isFocused() ? 2 : 3, -1);
                this.page.dispatchFocusEvent(focusEvent);
            }
        });
        this.setFocusTraversable(true);
        Toolkit.getToolkit().addStageTkPulseListener(this.stagePulseListener);
    }

    public boolean isResizable() {
        return true;
    }

    public void resize(double width, double height) {
        if (width != this.width.get() || height != this.height.get()) {
            this.width.set(width);
            this.height.set(height);
            NodeHelper.markDirty((Node)this, (DirtyBits)DirtyBits.NODE_GEOMETRY);
            NodeHelper.geomChanged((Node)this);
        }
    }

    public final double minWidth(double height) {
        double result = this.getMinWidth();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    public final double minHeight(double width) {
        double result = this.getMinHeight();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    public final double prefWidth(double height) {
        double result = this.getPrefWidth();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    public final double prefHeight(double width) {
        double result = this.getPrefHeight();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    public final double maxWidth(double height) {
        double result = this.getMaxWidth();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    public final double maxHeight(double width) {
        double result = this.getMaxHeight();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    public DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new StyleableDoubleProperty(0.0){

                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.MIN_WIDTH;
                }

                public Object getBean() {
                    return WebView.this;
                }

                public String getName() {
                    return "minWidth";
                }
            };
        }
        return this.minWidth;
    }

    public final void setMinWidth(double value) {
        this.minWidthProperty().set(value);
    }

    public final double getMinWidth() {
        return this.minWidth != null ? this.minWidth.get() : 0.0;
    }

    public DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new StyleableDoubleProperty(0.0){

                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.MIN_HEIGHT;
                }

                public Object getBean() {
                    return WebView.this;
                }

                public String getName() {
                    return "minHeight";
                }
            };
        }
        return this.minHeight;
    }

    public final void setMinHeight(double value) {
        this.minHeightProperty().set(value);
    }

    public final double getMinHeight() {
        return this.minHeight != null ? this.minHeight.get() : 0.0;
    }

    public void setMinSize(double minWidth, double minHeight) {
        this.setMinWidth(minWidth);
        this.setMinHeight(minHeight);
    }

    public DoubleProperty prefWidthProperty() {
        if (this.prefWidth == null) {
            this.prefWidth = new StyleableDoubleProperty(800.0){

                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.PREF_WIDTH;
                }

                public Object getBean() {
                    return WebView.this;
                }

                public String getName() {
                    return "prefWidth";
                }
            };
        }
        return this.prefWidth;
    }

    public final void setPrefWidth(double value) {
        this.prefWidthProperty().set(value);
    }

    public final double getPrefWidth() {
        return this.prefWidth != null ? this.prefWidth.get() : 800.0;
    }

    public DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new StyleableDoubleProperty(600.0){

                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.PREF_HEIGHT;
                }

                public Object getBean() {
                    return WebView.this;
                }

                public String getName() {
                    return "prefHeight";
                }
            };
        }
        return this.prefHeight;
    }

    public final void setPrefHeight(double value) {
        this.prefHeightProperty().set(value);
    }

    public final double getPrefHeight() {
        return this.prefHeight != null ? this.prefHeight.get() : 600.0;
    }

    public void setPrefSize(double prefWidth, double prefHeight) {
        this.setPrefWidth(prefWidth);
        this.setPrefHeight(prefHeight);
    }

    public DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new StyleableDoubleProperty(Double.MAX_VALUE){

                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.MAX_WIDTH;
                }

                public Object getBean() {
                    return WebView.this;
                }

                public String getName() {
                    return "maxWidth";
                }
            };
        }
        return this.maxWidth;
    }

    public final void setMaxWidth(double value) {
        this.maxWidthProperty().set(value);
    }

    public final double getMaxWidth() {
        return this.maxWidth != null ? this.maxWidth.get() : Double.MAX_VALUE;
    }

    public DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new StyleableDoubleProperty(Double.MAX_VALUE){

                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.MAX_HEIGHT;
                }

                public Object getBean() {
                    return WebView.this;
                }

                public String getName() {
                    return "maxHeight";
                }
            };
        }
        return this.maxHeight;
    }

    public final void setMaxHeight(double value) {
        this.maxHeightProperty().set(value);
    }

    public final double getMaxHeight() {
        return this.maxHeight != null ? this.maxHeight.get() : Double.MAX_VALUE;
    }

    public void setMaxSize(double maxWidth, double maxHeight) {
        this.setMaxWidth(maxWidth);
        this.setMaxHeight(maxHeight);
    }

    public final void setFontSmoothingType(FontSmoothingType value) {
        this.fontSmoothingTypeProperty().set((Object)value);
    }

    public final FontSmoothingType getFontSmoothingType() {
        return this.fontSmoothingType != null ? (FontSmoothingType)this.fontSmoothingType.get() : DEFAULT_FONT_SMOOTHING_TYPE;
    }

    public final ObjectProperty<FontSmoothingType> fontSmoothingTypeProperty() {
        if (this.fontSmoothingType == null) {
            this.fontSmoothingType = new StyleableObjectProperty<FontSmoothingType>(DEFAULT_FONT_SMOOTHING_TYPE){

                public void invalidated() {
                    Toolkit.getToolkit().checkFxUserThread();
                    WebView.this.page.setFontSmoothingType(((FontSmoothingType)this.get()).ordinal());
                }

                public CssMetaData<WebView, FontSmoothingType> getCssMetaData() {
                    return StyleableProperties.FONT_SMOOTHING_TYPE;
                }

                public Object getBean() {
                    return WebView.this;
                }

                public String getName() {
                    return "fontSmoothingType";
                }
            };
        }
        return this.fontSmoothingType;
    }

    public final void setPageFill(Color value) {
        this.pageFillProperty().set((Object)value);
    }

    public final Color getPageFill() {
        return this.pageFill == null ? DEFAULT_PAGE_FILL : (Color)this.pageFill.get();
    }

    public final ObjectProperty<Color> pageFillProperty() {
        if (this.pageFill == null) {
            this.pageFill = new StyleableObjectProperty<Color>(DEFAULT_PAGE_FILL){

                protected void invalidated() {
                    Toolkit.getToolkit().checkFxUserThread();
                    Color color = (Color)this.get();
                    WebView.this.page.setBackgroundColor(color);
                }

                public CssMetaData<WebView, Color> getCssMetaData() {
                    return StyleableProperties.PAGE_FILL;
                }

                public Object getBean() {
                    return WebView.this;
                }

                public String getName() {
                    return "pageFill";
                }
            };
        }
        return this.pageFill;
    }

    public final void setContextMenuEnabled(boolean value) {
        this.contextMenuEnabledProperty().set(value);
    }

    public final boolean isContextMenuEnabled() {
        return this.contextMenuEnabled == null ? true : this.contextMenuEnabled.get();
    }

    public final BooleanProperty contextMenuEnabledProperty() {
        if (this.contextMenuEnabled == null) {
            this.contextMenuEnabled = new StyleableBooleanProperty(true){

                public void invalidated() {
                    Toolkit.getToolkit().checkFxUserThread();
                    WebView.this.page.setContextMenuEnabled(this.get());
                }

                public CssMetaData<WebView, Boolean> getCssMetaData() {
                    return StyleableProperties.CONTEXT_MENU_ENABLED;
                }

                public Object getBean() {
                    return WebView.this;
                }

                public String getName() {
                    return "contextMenuEnabled";
                }
            };
        }
        return this.contextMenuEnabled;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return WebView.getClassCssMetaData();
    }

    private boolean isTreeReallyVisible() {
        if (this.getScene() == null) {
            return false;
        }
        Window window = this.getScene().getWindow();
        if (window == null) {
            return false;
        }
        boolean iconified = window instanceof Stage ? ((Stage)window).isIconified() : false;
        return NodeHelper.isTreeVisible((Node)this) && window.isShowing() && window.getWidth() > 0.0 && window.getHeight() > 0.0 && !iconified;
    }

    private void handleStagePulse() {
        if (this.page == null) {
            return;
        }
        boolean reallyVisible = this.isTreeReallyVisible();
        if (reallyVisible) {
            if (this.page.isDirty()) {
                SceneHelper.setAllowPGAccess((boolean)true);
                NGWebView peer = (NGWebView)NodeHelper.getPeer((Node)this);
                peer.update();
                if (this.page.isRepaintPending()) {
                    NodeHelper.markDirty((Node)this, (DirtyBits)DirtyBits.WEBVIEW_VIEW);
                }
                SceneHelper.setAllowPGAccess((boolean)false);
            }
        } else {
            this.page.dropRenderFrames();
        }
    }

    private void processMouseEvent(MouseEvent ev) {
        if (this.page == null) {
            return;
        }
        EventType type = ev.getEventType();
        double x = ev.getX();
        double y = ev.getY();
        double screenX = ev.getScreenX();
        double screenY = ev.getScreenY();
        if (type == MouseEvent.MOUSE_EXITED) {
            type = MouseEvent.MOUSE_MOVED;
            x = -32768.0;
            y = -32768.0;
            Point2D screenPoint = this.localToScreen(x, y);
            if (screenPoint == null) {
                return;
            }
            screenX = screenPoint.getX();
            screenY = screenPoint.getY();
        }
        Integer id = ID_MAP.get(type);
        Integer button = ID_MAP.get(ev.getButton());
        if (id == null || button == null) {
            return;
        }
        int buttonMask = (ev.isPrimaryButtonDown() ? 1 : 0) | (ev.isMiddleButtonDown() ? 2 : 0) | (ev.isSecondaryButtonDown() ? 4 : 0);
        WCMouseEvent mouseEvent = new WCMouseEvent(id, button, ev.getClickCount(), (int)x, (int)y, (int)screenX, (int)screenY, System.currentTimeMillis(), ev.isShiftDown(), ev.isControlDown(), ev.isAltDown(), ev.isMetaDown(), ev.isPopupTrigger(), buttonMask);
        this.page.dispatchMouseEvent(mouseEvent);
        ev.consume();
    }

    private void processScrollEvent(ScrollEvent ev) {
        if (this.page == null) {
            return;
        }
        double dx = -ev.getDeltaX() * this.getFontScale() * this.getScaleX();
        double dy = -ev.getDeltaY() * this.getFontScale() * this.getScaleY();
        WCMouseWheelEvent wheelEvent = new WCMouseWheelEvent((int)ev.getX(), (int)ev.getY(), (int)ev.getScreenX(), (int)ev.getScreenY(), System.currentTimeMillis(), ev.isShiftDown(), ev.isControlDown(), ev.isAltDown(), ev.isMetaDown(), (float)dx, (float)dy);
        this.page.dispatchMouseWheelEvent(wheelEvent);
        ev.consume();
    }

    private void processKeyEvent(KeyEvent ev) {
        if (this.page == null) {
            return;
        }
        String text = null;
        String keyIdentifier = null;
        int windowsVirtualKeyCode = 0;
        if (ev.getEventType() == KeyEvent.KEY_TYPED) {
            text = ev.getCharacter();
        } else {
            KeyCodeMap.Entry keyCodeEntry = KeyCodeMap.lookup(ev.getCode());
            keyIdentifier = keyCodeEntry.getKeyIdentifier();
            windowsVirtualKeyCode = keyCodeEntry.getWindowsVirtualKeyCode();
        }
        WCKeyEvent keyEvent = new WCKeyEvent(ID_MAP.get(ev.getEventType()), text, keyIdentifier, windowsVirtualKeyCode, ev.isShiftDown(), ev.isControlDown(), ev.isAltDown(), ev.isMetaDown(), System.currentTimeMillis());
        if (this.page.dispatchKeyEvent(keyEvent)) {
            ev.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputMethodClientImpl getInputMethodClient() {
        if (this.imClient == null) {
            WebView webView = this;
            synchronized (webView) {
                if (this.imClient == null) {
                    this.imClient = new InputMethodClientImpl(this, this.page);
                }
            }
        }
        return this.imClient;
    }

    private void processInputMethodEvent(InputMethodEvent ie) {
        if (this.page == null) {
            return;
        }
        if (!this.getInputMethodClient().getInputMethodState()) {
            ie.consume();
            return;
        }
        WCInputMethodEvent imEvent = InputMethodClientImpl.convertToWCInputMethodEvent(ie);
        if (this.page.dispatchInputMethodEvent(imEvent)) {
            ie.consume();
            return;
        }
    }

    private static int getWKDndEventType(EventType et) {
        int commandId = 0;
        if (et == DragEvent.DRAG_ENTERED) {
            commandId = 0;
        } else if (et == DragEvent.DRAG_EXITED) {
            commandId = 3;
        } else if (et == DragEvent.DRAG_OVER) {
            commandId = 1;
        } else if (et == DragEvent.DRAG_DROPPED) {
            commandId = 4;
        }
        return commandId;
    }

    private static int getWKDndAction(TransferMode ... tms) {
        int dndActionId = 0;
        for (TransferMode tm : tms) {
            if (tm == TransferMode.COPY) {
                dndActionId |= 1;
                continue;
            }
            if (tm == TransferMode.MOVE) {
                dndActionId |= 2;
                continue;
            }
            if (tm != TransferMode.LINK) continue;
            dndActionId |= 0x40000000;
        }
        return dndActionId;
    }

    private static TransferMode[] getFXDndAction(int wkDndAction) {
        LinkedList<TransferMode> tms = new LinkedList<TransferMode>();
        if ((wkDndAction & 1) != 0) {
            tms.add(TransferMode.COPY);
        }
        if ((wkDndAction & 2) != 0) {
            tms.add(TransferMode.MOVE);
        }
        if ((wkDndAction & 0x40000000) != 0) {
            tms.add(TransferMode.LINK);
        }
        return tms.toArray(new TransferMode[0]);
    }

    private void registerEventHandlers() {
        this.addEventHandler(KeyEvent.ANY, event -> this.processKeyEvent((KeyEvent)event));
        this.addEventHandler(MouseEvent.ANY, event -> {
            this.processMouseEvent((MouseEvent)event);
            if (event.isDragDetect() && !this.page.isDragConfirmed()) {
                event.setDragDetect(false);
            }
        });
        this.addEventHandler(ScrollEvent.SCROLL, event -> this.processScrollEvent((ScrollEvent)event));
        this.setOnInputMethodTextChanged(event -> this.processInputMethodEvent((InputMethodEvent)event));
        EventHandler destHandler = event -> {
            try {
                Dragboard db = event.getDragboard();
                if (this.mimes == null || this.values == null) {
                    this.mimes = new LinkedList();
                    this.values = new LinkedList();
                    for (DataFormat df : db.getContentTypes()) {
                        Object content = db.getContent(df);
                        if (content == null) continue;
                        for (String mime : df.getIdentifiers()) {
                            this.mimes.add(mime);
                            this.values.add(content.toString());
                        }
                    }
                }
                if (!this.mimes.isEmpty()) {
                    int wkDndEventType = WebView.getWKDndEventType(event.getEventType());
                    int wkDndAction = this.page.dispatchDragOperation(wkDndEventType, this.mimes.toArray(new String[0]), this.values.toArray(new String[0]), (int)event.getX(), (int)event.getY(), (int)event.getScreenX(), (int)event.getScreenY(), WebView.getWKDndAction(db.getTransferModes().toArray(new TransferMode[0])));
                    if (wkDndEventType != 4 || wkDndAction != 0) {
                        event.acceptTransferModes(WebView.getFXDndAction(wkDndAction));
                    }
                    event.consume();
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        };
        this.setOnDragEntered(destHandler);
        this.setOnDragExited(destHandler);
        this.setOnDragOver(destHandler);
        this.setOnDragDropped(destHandler);
        this.setOnDragDetected(event -> {
            if (this.page.isDragConfirmed()) {
                this.mimes = null;
                this.values = null;
                this.page.confirmStartDrag();
                event.consume();
            }
        });
        this.setOnDragDone(event -> {
            this.mimes = null;
            this.values = null;
            this.page.dispatchDragOperation(104, null, null, (int)event.getX(), (int)event.getY(), (int)event.getScreenX(), (int)event.getScreenY(), WebView.getWKDndAction(event.getAcceptedTransferMode()));
            event.consume();
        });
        this.setInputMethodRequests((InputMethodRequests)this.getInputMethodClient());
    }

    private void doPickNodeLocal(PickRay pickRay, PickResultChooser result) {
        NodeHelper.intersects((Node)this, (PickRay)pickRay, (PickResultChooser)result);
    }

    protected ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    private NGNode doCreatePeer() {
        return new NGWebView();
    }

    private BaseBounds doComputeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        bounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), 0.0f);
        tx.transform(bounds, bounds);
        return bounds;
    }

    private void doTransformsChanged() {
    }

    private boolean doComputeContains(double localX, double localY) {
        return true;
    }

    private void doUpdatePeer() {
        NGWebView peer = (NGWebView)NodeHelper.getPeer((Node)this);
        if (NodeHelper.isDirty((Node)this, (DirtyBits)DirtyBits.NODE_CONTENTS)) {
            peer.setPage(this.page);
        }
        if (NodeHelper.isDirty((Node)this, (DirtyBits)DirtyBits.NODE_GEOMETRY)) {
            peer.resize((float)this.getWidth(), (float)this.getHeight());
        }
        if (NodeHelper.isDirty((Node)this, (DirtyBits)DirtyBits.WEBVIEW_VIEW)) {
            peer.requestRender();
        }
    }

    static {
        WebViewHelper.setWebViewAccessor(new WebViewHelper.WebViewAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((WebView)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((WebView)node).doUpdatePeer();
            }

            @Override
            public void doTransformsChanged(Node node) {
                ((WebView)node).doTransformsChanged();
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds bounds, BaseTransform tx) {
                return ((WebView)node).doComputeGeomBounds(bounds, tx);
            }

            @Override
            public boolean doComputeContains(Node node, double localX, double localY) {
                return ((WebView)node).doComputeContains(localX, localY);
            }

            @Override
            public void doPickNodeLocal(Node node, PickRay localPickRay, PickResultChooser result) {
                ((WebView)node).doPickNodeLocal(localPickRay, result);
            }
        });
    }

    private static final class StyleableProperties {
        private static final CssMetaData<WebView, Boolean> CONTEXT_MENU_ENABLED = new CssMetaData<WebView, Boolean>("-fx-context-menu-enabled", BooleanConverter.getInstance(), Boolean.valueOf(true)){

            public boolean isSettable(WebView view) {
                return view.contextMenuEnabled == null || !view.contextMenuEnabled.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(WebView view) {
                return (StyleableProperty)view.contextMenuEnabledProperty();
            }
        };
        private static final CssMetaData<WebView, FontSmoothingType> FONT_SMOOTHING_TYPE = new CssMetaData<WebView, FontSmoothingType>("-fx-font-smoothing-type", (StyleConverter)new EnumConverter(FontSmoothingType.class), DEFAULT_FONT_SMOOTHING_TYPE){

            public boolean isSettable(WebView view) {
                return view.fontSmoothingType == null || !view.fontSmoothingType.isBound();
            }

            public StyleableProperty<FontSmoothingType> getStyleableProperty(WebView view) {
                return (StyleableProperty)view.fontSmoothingTypeProperty();
            }
        };
        private static final CssMetaData<WebView, Color> PAGE_FILL = new CssMetaData<WebView, Color>("-fx-page-fill", ColorConverter.getInstance(), DEFAULT_PAGE_FILL){

            public boolean isSettable(WebView n) {
                return n.pageFill == null || !n.pageFill.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(WebView n) {
                return (StyleableProperty)n.pageFillProperty();
            }
        };
        private static final CssMetaData<WebView, Number> ZOOM = new CssMetaData<WebView, Number>("-fx-zoom", SizeConverter.getInstance(), (Number)1.0){

            public boolean isSettable(WebView view) {
                return view.zoom == null || !view.zoom.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)view.zoomProperty();
            }
        };
        private static final CssMetaData<WebView, Number> FONT_SCALE = new CssMetaData<WebView, Number>("-fx-font-scale", SizeConverter.getInstance(), (Number)1.0){

            public boolean isSettable(WebView view) {
                return view.fontScale == null || !view.fontScale.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)view.fontScaleProperty();
            }
        };
        private static final CssMetaData<WebView, Number> MIN_WIDTH = new CssMetaData<WebView, Number>("-fx-min-width", SizeConverter.getInstance(), (Number)0.0){

            public boolean isSettable(WebView view) {
                return view.minWidth == null || !view.minWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)view.minWidthProperty();
            }
        };
        private static final CssMetaData<WebView, Number> MIN_HEIGHT = new CssMetaData<WebView, Number>("-fx-min-height", SizeConverter.getInstance(), (Number)0.0){

            public boolean isSettable(WebView view) {
                return view.minHeight == null || !view.minHeight.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)view.minHeightProperty();
            }
        };
        private static final CssMetaData<WebView, Number> MAX_WIDTH = new CssMetaData<WebView, Number>("-fx-max-width", SizeConverter.getInstance(), (Number)Double.MAX_VALUE){

            public boolean isSettable(WebView view) {
                return view.maxWidth == null || !view.maxWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)view.maxWidthProperty();
            }
        };
        private static final CssMetaData<WebView, Number> MAX_HEIGHT = new CssMetaData<WebView, Number>("-fx-max-height", SizeConverter.getInstance(), (Number)Double.MAX_VALUE){

            public boolean isSettable(WebView view) {
                return view.maxHeight == null || !view.maxHeight.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)view.maxHeightProperty();
            }
        };
        private static final CssMetaData<WebView, Number> PREF_WIDTH = new CssMetaData<WebView, Number>("-fx-pref-width", SizeConverter.getInstance(), (Number)800.0){

            public boolean isSettable(WebView view) {
                return view.prefWidth == null || !view.prefWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)view.prefWidthProperty();
            }
        };
        private static final CssMetaData<WebView, Number> PREF_HEIGHT = new CssMetaData<WebView, Number>("-fx-pref-height", SizeConverter.getInstance(), (Number)600.0){

            public boolean isSettable(WebView view) {
                return view.prefHeight == null || !view.prefHeight.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)view.prefHeightProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(Parent.getClassCssMetaData());
            styleables.add(CONTEXT_MENU_ENABLED);
            styleables.add(FONT_SMOOTHING_TYPE);
            styleables.add(PAGE_FILL);
            styleables.add(ZOOM);
            styleables.add(FONT_SCALE);
            styleables.add(MIN_WIDTH);
            styleables.add(PREF_WIDTH);
            styleables.add(MAX_WIDTH);
            styleables.add(MIN_HEIGHT);
            styleables.add(PREF_HEIGHT);
            styleables.add(MAX_HEIGHT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

