/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.jimage;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;

class ImageBufferCache {
    private static final int MAX_CACHED_BUFFERS = 3;
    private static final int LARGE_BUFFER = 65536;
    private static final ThreadLocal<Map.Entry<WeakReference<ByteBuffer>, Integer>[]> CACHE = ThreadLocal.withInitial(() -> new Map.Entry[4]);
    private static final Comparator<Map.Entry<WeakReference<ByteBuffer>, Integer>> DECREASING_CAPACITY_NULLS_LAST = Comparator.comparingInt(ImageBufferCache::getCapacity);

    ImageBufferCache() {
    }

    private static ByteBuffer allocateBuffer(long size) {
        return ByteBuffer.allocateDirect((int)(size + 4095L & 0xFFFFFFFFFFFFF000L));
    }

    static ByteBuffer getBuffer(long size) {
        if (size < 0L || Integer.MAX_VALUE < size) {
            throw new IndexOutOfBoundsException("size");
        }
        ByteBuffer result = null;
        if (size > 65536L) {
            result = ImageBufferCache.allocateBuffer(size);
        } else {
            Map.Entry<WeakReference<ByteBuffer>, Integer>[] cache = CACHE.get();
            for (int i = 2; i >= 0; --i) {
                ByteBuffer buffer;
                Map.Entry<WeakReference<ByteBuffer>, Integer> reference = cache[i];
                if (reference == null || (buffer = ImageBufferCache.getByteBuffer(reference)) == null || size > (long)buffer.capacity()) continue;
                cache[i] = null;
                result = buffer;
                result.rewind();
                break;
            }
            if (result == null) {
                result = ImageBufferCache.allocateBuffer(size);
            }
        }
        result.limit((int)size);
        return result;
    }

    static void releaseBuffer(ByteBuffer buffer) {
        if (buffer.capacity() > 65536) {
            return;
        }
        Map.Entry<WeakReference<ByteBuffer>, Integer>[] cache = CACHE.get();
        for (int i = 0; i < 3; ++i) {
            Map.Entry<WeakReference<ByteBuffer>, Integer> reference = cache[i];
            if (reference == null || ImageBufferCache.getByteBuffer(reference) != null) continue;
            cache[i] = null;
        }
        cache[3] = ImageBufferCache.newCacheEntry(buffer);
        Arrays.sort(cache, DECREASING_CAPACITY_NULLS_LAST);
        cache[3] = null;
    }

    private static Map.Entry<WeakReference<ByteBuffer>, Integer> newCacheEntry(ByteBuffer bb) {
        return new AbstractMap.SimpleEntry<WeakReference<ByteBuffer>, Integer>(new WeakReference<ByteBuffer>(bb), bb.capacity());
    }

    private static int getCapacity(Map.Entry<WeakReference<ByteBuffer>, Integer> e) {
        return e == null ? 0 : e.getValue();
    }

    private static ByteBuffer getByteBuffer(Map.Entry<WeakReference<ByteBuffer>, Integer> e) {
        return e == null ? null : (ByteBuffer)e.getKey().get();
    }
}

