/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.jimage;

import java.lang.invoke.StringConcatFactory;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.glavo.jimage.BasicImageReader;
import org.glavo.jimage.ImageStream;
import org.glavo.jimage.ImageStrings;
import org.glavo.jimage.ImageStringsReader;

public class ImageLocation {
    public static final int ATTRIBUTE_END = 0;
    public static final int ATTRIBUTE_MODULE = 1;
    public static final int ATTRIBUTE_PARENT = 2;
    public static final int ATTRIBUTE_BASE = 3;
    public static final int ATTRIBUTE_EXTENSION = 4;
    public static final int ATTRIBUTE_OFFSET = 5;
    public static final int ATTRIBUTE_COMPRESSED = 6;
    public static final int ATTRIBUTE_UNCOMPRESSED = 7;
    public static final int ATTRIBUTE_COUNT = 8;
    protected final long[] attributes;
    protected final ImageStrings strings;

    public ImageLocation(long[] attributes, ImageStrings strings) {
        this.attributes = Objects.requireNonNull(attributes);
        this.strings = Objects.requireNonNull(strings);
    }

    ImageStrings getStrings() {
        return this.strings;
    }

    static long[] decompress(ByteBuffer bytes, int offset) {
        int data;
        Objects.requireNonNull(bytes);
        long[] attributes = new long[8];
        int limit = bytes.limit();
        while (offset < limit && (data = bytes.get(offset++) & 0xFF) > 7) {
            int kind = data >>> 3;
            if (8 <= kind) {
                throw new InternalError((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Invalid jimage attribute kind: \u0001"}, (int)kind)));
            }
            int length = (data & 7) + 1;
            attributes[kind] = ImageLocation.readValue(length, bytes, offset, limit);
            offset += length;
        }
        return attributes;
    }

    public static byte[] compress(long[] attributes) {
        Objects.requireNonNull(attributes);
        ImageStream stream = new ImageStream(16);
        for (int kind = 1; kind < 8; ++kind) {
            long value = attributes[kind];
            if (value == 0L) continue;
            int n = 63 - Long.numberOfLeadingZeros(value) >> 3;
            stream.put(kind << 3 | n);
            for (int i = n; i >= 0; --i) {
                stream.put((int)(value >> (i << 3)));
            }
        }
        stream.put(0);
        return stream.toArray();
    }

    public boolean verify(String name) {
        return ImageLocation.verify(name, this.attributes, this.strings);
    }

    static boolean verify(String name, long[] attributes, ImageStrings strings) {
        Objects.requireNonNull(name);
        int length = name.length();
        int index = 0;
        int moduleOffset = (int)attributes[1];
        if (moduleOffset != 0 && length >= 1) {
            int moduleLen = strings.match(moduleOffset, name, 1);
            index = moduleLen + 1;
            if (moduleLen < 0 || length <= index || name.charAt(0) != '/' || name.charAt(index++) != '/') {
                return false;
            }
        }
        return ImageLocation.verifyName(null, name, index, length, 0, (int)attributes[2], (int)attributes[3], (int)attributes[4], strings);
    }

    static boolean verify(String module, String name, ByteBuffer locations, int locationOffset, ImageStrings strings) {
        int data;
        int moduleOffset = 0;
        int parentOffset = 0;
        int baseOffset = 0;
        int extOffset = 0;
        int limit = locations.limit();
        while (locationOffset < limit && (data = locations.get(locationOffset++) & 0xFF) > 7) {
            int kind = data >>> 3;
            if (8 <= kind) {
                throw new InternalError((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Invalid jimage attribute kind: \u0001"}, (int)kind)));
            }
            int length = (data & 7) + 1;
            switch (kind) {
                case 1: {
                    moduleOffset = (int)ImageLocation.readValue(length, locations, locationOffset, limit);
                    break;
                }
                case 3: {
                    baseOffset = (int)ImageLocation.readValue(length, locations, locationOffset, limit);
                    break;
                }
                case 2: {
                    parentOffset = (int)ImageLocation.readValue(length, locations, locationOffset, limit);
                    break;
                }
                case 4: {
                    extOffset = (int)ImageLocation.readValue(length, locations, locationOffset, limit);
                }
            }
            locationOffset += length;
        }
        return ImageLocation.verifyName(module, name, 0, name.length(), moduleOffset, parentOffset, baseOffset, extOffset, strings);
    }

    private static long readValue(int length, ByteBuffer buffer, int offset, int limit) {
        long value = 0L;
        for (int j = 0; j < length; ++j) {
            value <<= 8;
            if (offset >= limit) {
                throw new InternalError("Missing jimage attribute data");
            }
            value |= (long)(buffer.get(offset++) & 0xFF);
        }
        return value;
    }

    static boolean verify(String module, String name, long[] attributes, ImageStrings strings) {
        Objects.requireNonNull(module);
        Objects.requireNonNull(name);
        return ImageLocation.verifyName(module, name, 0, name.length(), (int)attributes[1], (int)attributes[2], (int)attributes[3], (int)attributes[4], strings);
    }

    private static boolean verifyName(String module, String name, int index, int length, int moduleOffset, int parentOffset, int baseOffset, int extOffset, ImageStrings strings) {
        int baseLen;
        if (moduleOffset != 0 && strings.match(moduleOffset, module, 0) != module.length()) {
            return false;
        }
        if (parentOffset != 0) {
            int parentLen = strings.match(parentOffset, name, index);
            if (parentLen < 0) {
                return false;
            }
            if (length <= (index += parentLen) || name.charAt(index++) != '/') {
                return false;
            }
        }
        if ((baseLen = strings.match(baseOffset, name, index)) < 0) {
            return false;
        }
        index += baseLen;
        if (extOffset != 0) {
            if (length <= index || name.charAt(index++) != '.') {
                return false;
            }
            int extLen = strings.match(extOffset, name, index);
            if (extLen < 0) {
                return false;
            }
            index += extLen;
        }
        return length == index;
    }

    long getAttribute(int kind) {
        if (kind < 0 || 8 <= kind) {
            throw new InternalError((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Invalid jimage attribute kind: \u0001"}, (int)kind)));
        }
        return this.attributes[kind];
    }

    String getAttributeString(int kind) {
        if (kind < 0 || 8 <= kind) {
            throw new InternalError((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Invalid jimage attribute kind: \u0001"}, (int)kind)));
        }
        return this.getStrings().get((int)this.attributes[kind]);
    }

    public String getModule() {
        return this.getAttributeString(1);
    }

    public int getModuleOffset() {
        return (int)this.getAttribute(1);
    }

    public String getBase() {
        return this.getAttributeString(3);
    }

    public int getBaseOffset() {
        return (int)this.getAttribute(3);
    }

    public String getParent() {
        return this.getAttributeString(2);
    }

    public int getParentOffset() {
        return (int)this.getAttribute(2);
    }

    public String getExtension() {
        return this.getAttributeString(4);
    }

    public int getExtensionOffset() {
        return (int)this.getAttribute(4);
    }

    public String getFullName() {
        return this.getFullName(false);
    }

    public String getFullName(boolean modulesPrefix) {
        StringBuilder builder = new StringBuilder();
        if (this.getModuleOffset() != 0) {
            if (modulesPrefix) {
                builder.append("/modules");
            }
            builder.append('/');
            builder.append(this.getModule());
            builder.append('/');
        }
        if (this.getParentOffset() != 0) {
            builder.append(this.getParent());
            builder.append('/');
        }
        builder.append(this.getBase());
        if (this.getExtensionOffset() != 0) {
            builder.append('.');
            builder.append(this.getExtension());
        }
        return builder.toString();
    }

    String buildName(boolean includeModule, boolean includeParent, boolean includeName) {
        StringBuilder builder = new StringBuilder();
        if (includeModule && this.getModuleOffset() != 0) {
            builder.append("/modules/");
            builder.append(this.getModule());
        }
        if (includeParent && this.getParentOffset() != 0) {
            builder.append('/');
            builder.append(this.getParent());
        }
        if (includeName) {
            if (includeModule || includeParent) {
                builder.append('/');
            }
            builder.append(this.getBase());
            if (this.getExtensionOffset() != 0) {
                builder.append('.');
                builder.append(this.getExtension());
            }
        }
        return builder.toString();
    }

    public long getContentOffset() {
        return this.getAttribute(5);
    }

    public long getCompressedSize() {
        return this.getAttribute(6);
    }

    public long getUncompressedSize() {
        return this.getAttribute(7);
    }

    static ImageLocation readFrom(BasicImageReader reader, int offset) {
        Objects.requireNonNull(reader);
        long[] attributes = reader.getAttributes(offset);
        ImageStringsReader strings = reader.getStrings();
        return new ImageLocation(attributes, strings);
    }
}

