/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.jimage;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.StringConcatFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.glavo.jimage.BasicImageReader;
import org.glavo.jimage.ImageHeader;
import org.glavo.jimage.ImageLocation;
import org.glavo.jimage.ImageStringsReader;

public final class ImageReader
implements AutoCloseable {
    private final SharedImageReader reader;
    private volatile boolean closed;

    private ImageReader(SharedImageReader reader) {
        this.reader = reader;
    }

    public static ImageReader open(Path imagePath, ByteOrder byteOrder) throws IOException {
        Objects.requireNonNull(imagePath);
        Objects.requireNonNull(byteOrder);
        return SharedImageReader.open(imagePath, byteOrder);
    }

    public static ImageReader open(Path imagePath) throws IOException {
        return ImageReader.open(imagePath, ByteOrder.nativeOrder());
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("image file already closed");
        }
        this.reader.close(this);
        this.closed = true;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("image file closed");
        }
    }

    private void requireOpen() {
        if (this.closed) {
            throw new IllegalStateException("image file closed");
        }
    }

    public Directory getRootDirectory() throws IOException {
        this.ensureOpen();
        return this.reader.getRootDirectory();
    }

    public Node findNode(String name) throws IOException {
        this.ensureOpen();
        return this.reader.findNode(name);
    }

    public byte[] getResource(Node node) throws IOException {
        this.ensureOpen();
        return this.reader.getResource(node);
    }

    public byte[] getResource(Resource rs) throws IOException {
        this.ensureOpen();
        return this.reader.getResource(rs);
    }

    public ImageHeader getHeader() {
        this.requireOpen();
        return this.reader.getHeader();
    }

    public static void releaseByteBuffer(ByteBuffer buffer) {
        BasicImageReader.releaseByteBuffer(buffer);
    }

    public String getName() {
        this.requireOpen();
        return this.reader.getName();
    }

    public ByteOrder getByteOrder() {
        this.requireOpen();
        return this.reader.getByteOrder();
    }

    public Path getImagePath() {
        this.requireOpen();
        return this.reader.getImagePath();
    }

    public ImageStringsReader getStrings() {
        this.requireOpen();
        return this.reader.getStrings();
    }

    public ImageLocation findLocation(String mn, String rn) {
        this.requireOpen();
        return this.reader.findLocation(mn, rn);
    }

    public boolean verifyLocation(String mn, String rn) {
        this.requireOpen();
        return this.reader.verifyLocation(mn, rn);
    }

    public ImageLocation findLocation(String name) {
        this.requireOpen();
        return this.reader.findLocation(name);
    }

    public String[] getEntryNames() {
        this.requireOpen();
        return this.reader.getEntryNames();
    }

    public String[] getModuleNames() {
        this.requireOpen();
        int off = "/modules/".length();
        return (String[])this.reader.findNode("/modules").getChildren().stream().map(Node::getNameString).map(s -> s.substring(off)).toArray(String[]::new);
    }

    public long[] getAttributes(int offset) {
        this.requireOpen();
        return this.reader.getAttributes(offset);
    }

    public String getString(int offset) {
        this.requireOpen();
        return this.reader.getString(offset);
    }

    public byte[] getResource(String name) {
        this.requireOpen();
        return this.reader.getResource(name);
    }

    public byte[] getResource(ImageLocation loc) {
        this.requireOpen();
        return this.reader.getResource(loc);
    }

    public ByteBuffer getResourceBuffer(ImageLocation loc) {
        this.requireOpen();
        return this.reader.getResourceBuffer(loc);
    }

    public InputStream getResourceStream(ImageLocation loc) {
        this.requireOpen();
        return this.reader.getResourceStream(loc);
    }

    private static final class SharedImageReader
    extends BasicImageReader {
        static final int SIZE_OF_OFFSET = 4;
        static final Map<Path, SharedImageReader> OPEN_FILES = new HashMap<Path, SharedImageReader>();
        final Set<ImageReader> openers = new HashSet<ImageReader>();
        BasicFileAttributes imageFileAttributes;
        final HashMap<String, Node> nodes = new HashMap();
        volatile Directory rootDir;
        Directory packagesDir;
        Directory modulesDir;

        private SharedImageReader(Path imagePath, ByteOrder byteOrder) throws IOException {
            super(imagePath, byteOrder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ImageReader open(Path imagePath, ByteOrder byteOrder) throws IOException {
            Objects.requireNonNull(imagePath);
            Objects.requireNonNull(byteOrder);
            Map<Path, SharedImageReader> map = OPEN_FILES;
            synchronized (map) {
                SharedImageReader reader = OPEN_FILES.get(imagePath);
                if (reader == null) {
                    reader = new SharedImageReader(imagePath, byteOrder);
                    OPEN_FILES.put(imagePath, reader);
                } else if (reader.getByteOrder() != byteOrder) {
                    throw new IOException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\"\u0001\" is not an image file"}, (String)reader.getName())));
                }
                ImageReader image = new ImageReader(reader);
                reader.openers.add(image);
                return image;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(ImageReader image) throws IOException {
            Objects.requireNonNull(image);
            Map<Path, SharedImageReader> map = OPEN_FILES;
            synchronized (map) {
                if (!this.openers.remove(image)) {
                    throw new IOException("image file already closed");
                }
                if (this.openers.isEmpty()) {
                    this.close();
                    this.nodes.clear();
                    this.rootDir = null;
                    if (!OPEN_FILES.remove(this.getImagePath(), this)) {
                        throw new IOException("image file not found in open list");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addOpener(ImageReader reader) {
            Map<Path, SharedImageReader> map = OPEN_FILES;
            synchronized (map) {
                this.openers.add(reader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeOpener(ImageReader reader) {
            Map<Path, SharedImageReader> map = OPEN_FILES;
            synchronized (map) {
                return this.openers.remove(reader);
            }
        }

        Directory getRootDirectory() {
            return this.buildRootDirectory();
        }

        synchronized Node buildNode(String name) {
            boolean isModules;
            boolean isPackages = name.startsWith("/packages");
            boolean bl = isModules = !isPackages && name.startsWith("/modules");
            if (!isModules && !isPackages) {
                return null;
            }
            ImageLocation loc = this.findLocation(name);
            Node n = loc != null ? (isPackages ? this.handlePackages(name, loc) : this.handleModulesSubTree(name, loc)) : (isModules ? this.handleResource(name) : this.handleModuleLink(name));
            return n;
        }

        synchronized Directory buildRootDirectory() {
            Directory root = this.rootDir;
            if (root != null) {
                return root;
            }
            root = this.newDirectory(null, "/");
            root.setIsRootDir();
            this.packagesDir = this.newDirectory(root, "/packages");
            this.packagesDir.setIsPackagesDir();
            this.modulesDir = this.newDirectory(root, "/modules");
            this.modulesDir.setIsModulesDir();
            root.setCompleted(true);
            this.rootDir = root;
            return this.rootDir;
        }

        void visitLocation(ImageLocation loc, LocationVisitor visitor) {
            byte[] offsets = this.getResource(loc);
            ByteBuffer buffer = ByteBuffer.wrap(offsets);
            buffer.order(this.getByteOrder());
            IntBuffer intBuffer = buffer.asIntBuffer();
            for (int i = 0; i < offsets.length / 4; ++i) {
                int offset = intBuffer.get(i);
                ImageLocation pkgLoc = this.getLocation(offset);
                visitor.visit(pkgLoc);
            }
        }

        void visitPackageLocation(ImageLocation loc) {
            String pkgName = this.getBaseExt(loc);
            byte[] stringsOffsets = this.getResource(loc);
            ByteBuffer buffer = ByteBuffer.wrap(stringsOffsets);
            buffer.order(this.getByteOrder());
            IntBuffer intBuffer = buffer.asIntBuffer();
            for (int i = 0; i < stringsOffsets.length / 4; ++i) {
                intBuffer.get(i);
                int offset = intBuffer.get(++i);
                String moduleName = this.getString(offset);
                Node targetNode = this.findNode((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"/modules/\u0001"}, (String)moduleName)));
                if (targetNode == null) continue;
                CallSite pkgDirName = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001/\u0001"}, (String)this.packagesDir.getName(), pkgName);
                Directory pkgDir = (Directory)this.nodes.get(pkgDirName);
                this.newLinkNode(pkgDir, (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001/\u0001"}, (String)pkgDir.getName(), moduleName)), targetNode);
            }
        }

        Node handlePackages(String name, ImageLocation loc) {
            long size = loc.getUncompressedSize();
            Node n = null;
            if (name.equals("/packages")) {
                this.visitLocation(loc, childloc -> this.findNode(childloc.getFullName()));
                this.packagesDir.setCompleted(true);
                n = this.packagesDir;
            } else if (size != 0L) {
                String pkgName = this.getBaseExt(loc);
                Directory pkgDir = this.newDirectory(this.packagesDir, (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001/\u0001"}, (String)this.packagesDir.getName(), pkgName)));
                this.visitPackageLocation(loc);
                pkgDir.setCompleted(true);
                n = pkgDir;
            } else {
                String pkgName = loc.getParent();
                String modName = this.getBaseExt(loc);
                Node targetNode = this.findNode((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"/modules/\u0001"}, (String)modName)));
                if (targetNode != null) {
                    CallSite pkgDirName = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001/\u0001"}, (String)this.packagesDir.getName(), pkgName);
                    Directory pkgDir = (Directory)this.nodes.get(pkgDirName);
                    LinkNode linkNode = this.newLinkNode(pkgDir, (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001/\u0001"}, (String)pkgDir.getName(), modName)), targetNode);
                    n = linkNode;
                }
            }
            return n;
        }

        Node handleModuleLink(String name) {
            int start;
            int pkgEnd;
            Node ret = null;
            String path = name;
            String radical = "/packages/";
            if (path.startsWith(radical) && (pkgEnd = path.indexOf(47, start = radical.length())) != -1) {
                String pkg = path.substring(start, pkgEnd);
                CallSite pkgPath = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0001"}, (String)radical, pkg);
                Node n = this.findNode((String)((Object)pkgPath));
                for (Node child : n.getChildren()) {
                    if (!child.name.equals(name)) continue;
                    ret = child;
                    break;
                }
            }
            return ret;
        }

        Node handleModulesSubTree(String name, ImageLocation loc) {
            assert (name.equals(loc.getFullName()));
            Directory dir = this.makeDirectories(name);
            this.visitLocation(loc, childloc -> {
                String path = childloc.getFullName();
                if (path.startsWith("/modules")) {
                    this.makeDirectories(path);
                } else {
                    this.makeDirectories(childloc.buildName(true, true, false));
                    this.newResource(dir, childloc);
                }
            });
            dir.setCompleted(true);
            Directory n = dir;
            return n;
        }

        Node handleResource(String name) {
            Resource n = null;
            if (!name.startsWith("/modules/")) {
                return null;
            }
            int moduleEndIndex = name.indexOf(47, "/modules/".length());
            if (moduleEndIndex == -1) {
                return null;
            }
            ImageLocation moduleLoc = this.findLocation(name.substring(0, moduleEndIndex));
            if (moduleLoc == null || moduleLoc.getModuleOffset() == 0) {
                return null;
            }
            String locationPath = name.substring("/modules".length());
            ImageLocation resourceLoc = this.findLocation(locationPath);
            if (resourceLoc != null) {
                Resource res;
                Directory dir = this.makeDirectories(resourceLoc.buildName(true, true, false));
                n = res = this.newResource(dir, resourceLoc);
            }
            return n;
        }

        String getBaseExt(ImageLocation loc) {
            Object base = loc.getBase();
            String ext = loc.getExtension();
            if (ext != null && !ext.isEmpty()) {
                base = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001.\u0001"}, (String)base, ext);
            }
            return base;
        }

        synchronized Node findNode(String name) {
            this.buildRootDirectory();
            Node n = this.nodes.get(name);
            if (n == null || !n.isCompleted()) {
                n = this.buildNode(name);
            }
            return n;
        }

        BasicFileAttributes imageFileAttributes() {
            BasicFileAttributes attrs = this.imageFileAttributes;
            if (attrs == null) {
                try {
                    Path file = this.getImagePath();
                    attrs = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
                this.imageFileAttributes = attrs;
            }
            return attrs;
        }

        Directory newDirectory(Directory parent, String name) {
            Directory dir = Directory.create(parent, name, this.imageFileAttributes());
            this.nodes.put(dir.getName(), dir);
            return dir;
        }

        Resource newResource(Directory parent, ImageLocation loc) {
            Resource res = Resource.create(parent, loc, this.imageFileAttributes());
            this.nodes.put(res.getName(), res);
            return res;
        }

        LinkNode newLinkNode(Directory dir, String name, Node link) {
            LinkNode linkNode = LinkNode.create(dir, name, link);
            this.nodes.put(linkNode.getName(), linkNode);
            return linkNode;
        }

        Directory makeDirectories(String parent) {
            Directory last = this.rootDir;
            int offset = parent.indexOf(47, 1);
            while (offset != -1) {
                String dir = parent.substring(0, offset);
                last = this.makeDirectory(dir, last);
                offset = parent.indexOf(47, offset + 1);
            }
            return this.makeDirectory(parent, last);
        }

        Directory makeDirectory(String dir, Directory last) {
            Directory nextDir = (Directory)this.nodes.get(dir);
            if (nextDir == null) {
                nextDir = this.newDirectory(last, dir);
            }
            return nextDir;
        }

        byte[] getResource(Node node) throws IOException {
            if (node.isResource()) {
                return super.getResource(node.getLocation());
            }
            throw new IOException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Not a resource: \u0001"}, (Node)node)));
        }

        byte[] getResource(Resource rs) throws IOException {
            return super.getResource(rs.getLocation());
        }

        static interface LocationVisitor {
            public void visit(ImageLocation var1);
        }
    }

    static final class Directory
    extends Node {
        private final List<Node> children = new ArrayList<Node>();

        private Directory(String name, BasicFileAttributes fileAttrs) {
            super(name, fileAttrs);
        }

        static Directory create(Directory parent, String name, BasicFileAttributes fileAttrs) {
            Directory d = new Directory(name, fileAttrs);
            if (parent != null) {
                parent.addChild(d);
            }
            return d;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public List<Node> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        void addChild(Node node) {
            this.children.add(node);
        }

        public void walk(Consumer<? super Node> consumer) {
            consumer.accept(this);
            for (Node child : this.children) {
                if (child.isDirectory()) {
                    ((Directory)child).walk(consumer);
                    continue;
                }
                consumer.accept(child);
            }
        }
    }

    public static abstract class Node {
        private static final int ROOT_DIR = 1;
        private static final int PACKAGES_DIR = 2;
        private static final int MODULES_DIR = 4;
        private int flags;
        private final String name;
        private final BasicFileAttributes fileAttrs;
        private boolean completed;

        protected Node(String name, BasicFileAttributes fileAttrs) {
            this.name = Objects.requireNonNull(name);
            this.fileAttrs = Objects.requireNonNull(fileAttrs);
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void setCompleted(boolean completed) {
            this.completed = completed;
        }

        public final void setIsRootDir() {
            this.flags |= 1;
        }

        public final boolean isRootDir() {
            return (this.flags & 1) != 0;
        }

        public final void setIsPackagesDir() {
            this.flags |= 2;
        }

        public final boolean isPackagesDir() {
            return (this.flags & 2) != 0;
        }

        public final void setIsModulesDir() {
            this.flags |= 4;
        }

        public final boolean isModulesDir() {
            return (this.flags & 4) != 0;
        }

        public final String getName() {
            return this.name;
        }

        public final BasicFileAttributes getFileAttributes() {
            return this.fileAttrs;
        }

        public final Node resolveLink() {
            return this.resolveLink(false);
        }

        public Node resolveLink(boolean recursive) {
            return this;
        }

        public boolean isLink() {
            return false;
        }

        public boolean isDirectory() {
            return false;
        }

        public List<Node> getChildren() {
            throw new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"not a directory: \u0001"}, (String)this.getNameString())));
        }

        public boolean isResource() {
            return false;
        }

        public ImageLocation getLocation() {
            throw new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"not a resource: \u0001"}, (String)this.getNameString())));
        }

        public long size() {
            return 0L;
        }

        public long compressedSize() {
            return 0L;
        }

        public String extension() {
            return null;
        }

        public long contentOffset() {
            return 0L;
        }

        public final FileTime creationTime() {
            return this.fileAttrs.creationTime();
        }

        public final FileTime lastAccessTime() {
            return this.fileAttrs.lastAccessTime();
        }

        public final FileTime lastModifiedTime() {
            return this.fileAttrs.lastModifiedTime();
        }

        public final String getNameString() {
            return this.name;
        }

        public final String toString() {
            return this.getNameString();
        }

        public final int hashCode() {
            return this.name.hashCode();
        }

        public final boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Node) {
                return this.name.equals(((Node)other).name);
            }
            return false;
        }
    }

    static class Resource
    extends Node {
        private final ImageLocation loc;

        private Resource(ImageLocation loc, BasicFileAttributes fileAttrs) {
            super(loc.getFullName(true), fileAttrs);
            this.loc = loc;
        }

        static Resource create(Directory parent, ImageLocation loc, BasicFileAttributes fileAttrs) {
            Resource rs = new Resource(loc, fileAttrs);
            parent.addChild(rs);
            return rs;
        }

        @Override
        public boolean isCompleted() {
            return true;
        }

        @Override
        public boolean isResource() {
            return true;
        }

        @Override
        public ImageLocation getLocation() {
            return this.loc;
        }

        @Override
        public long size() {
            return this.loc.getUncompressedSize();
        }

        @Override
        public long compressedSize() {
            return this.loc.getCompressedSize();
        }

        @Override
        public String extension() {
            return this.loc.getExtension();
        }

        @Override
        public long contentOffset() {
            return this.loc.getContentOffset();
        }
    }

    static class LinkNode
    extends Node {
        private final Node link;

        private LinkNode(String name, Node link) {
            super(name, link.getFileAttributes());
            this.link = link;
        }

        static LinkNode create(Directory parent, String name, Node link) {
            LinkNode ln = new LinkNode(name, link);
            parent.addChild(ln);
            return ln;
        }

        @Override
        public boolean isCompleted() {
            return true;
        }

        @Override
        public Node resolveLink(boolean recursive) {
            return recursive && this.link instanceof LinkNode ? ((LinkNode)this.link).resolveLink(true) : this.link;
        }

        @Override
        public boolean isLink() {
            return true;
        }
    }
}

