/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.jimage;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.glavo.jimage.ImageReader;

public class ImageReaderFactory {
    private static final String JAVA_HOME = System.getProperty("java.home");
    private static final Path BOOT_MODULES_JIMAGE = Paths.get(JAVA_HOME, "lib", "modules");
    private static final Map<Path, ImageReader> readers = new ConcurrentHashMap<Path, ImageReader>();
    private static Function<Path, ImageReader> OPENER = new Function<Path, ImageReader>(){

        @Override
        public ImageReader apply(Path path) {
            try {
                return ImageReader.open(path);
            }
            catch (IOException io) {
                throw new UncheckedIOException(io);
            }
        }
    };

    private ImageReaderFactory() {
    }

    public static ImageReader get(Path jimage) throws IOException {
        Objects.requireNonNull(jimage);
        try {
            return readers.computeIfAbsent(jimage, OPENER);
        }
        catch (UncheckedIOException io) {
            throw io.getCause();
        }
    }

    public static ImageReader getImageReader() {
        try {
            return ImageReaderFactory.get(BOOT_MODULES_JIMAGE);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }
}

