/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.jimage;

import java.lang.invoke.StringConcatFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;

public class ImageStream {
    private ByteBuffer buffer;

    public ImageStream() {
        this(1024, ByteOrder.nativeOrder());
    }

    public ImageStream(int size) {
        this(size, ByteOrder.nativeOrder());
    }

    public ImageStream(byte[] bytes) {
        this(bytes, ByteOrder.nativeOrder());
    }

    public ImageStream(ByteOrder byteOrder) {
        this(1024, byteOrder);
    }

    public ImageStream(int size, ByteOrder byteOrder) {
        this.buffer = ByteBuffer.allocate(size);
        this.buffer.order(Objects.requireNonNull(byteOrder));
    }

    public ImageStream(byte[] bytes, ByteOrder byteOrder) {
        this.buffer = ByteBuffer.wrap(Objects.requireNonNull(bytes));
        this.buffer.order(Objects.requireNonNull(byteOrder));
    }

    public ImageStream(ByteBuffer buffer) {
        this.buffer = Objects.requireNonNull(buffer);
    }

    public ImageStream align(int alignment) {
        int padding = this.getSize() - 1 & (1 << alignment) - 1;
        for (int i = 0; i < padding; ++i) {
            this.put((byte)0);
        }
        return this;
    }

    public void ensure(int needs) {
        if (needs < 0) {
            throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Bad value: \u0001"}, (int)needs)));
        }
        if (needs > this.buffer.remaining()) {
            byte[] bytes = this.buffer.array();
            ByteOrder byteOrder = this.buffer.order();
            int position = this.buffer.position();
            int newSize = needs <= bytes.length ? bytes.length << 1 : position + needs;
            this.buffer = ByteBuffer.allocate(newSize);
            this.buffer.order(byteOrder);
            this.buffer.put(bytes, 0, position);
        }
    }

    public boolean hasByte() {
        return this.buffer.remaining() != 0;
    }

    public boolean hasBytes(int needs) {
        return needs <= this.buffer.remaining();
    }

    public void skip(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"skip value = \u0001"}, (int)n)));
        }
        this.buffer.position(this.buffer.position() + n);
    }

    public int get() {
        return this.buffer.get() & 0xFF;
    }

    public void get(byte[] bytes, int offset, int size) {
        this.buffer.get(bytes, offset, size);
    }

    public int getShort() {
        return this.buffer.getShort();
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public long getLong() {
        return this.buffer.getLong();
    }

    public ImageStream put(byte byt) {
        this.ensure(1);
        this.buffer.put(byt);
        return this;
    }

    public ImageStream put(int byt) {
        return this.put((byte)byt);
    }

    public ImageStream put(byte[] bytes, int offset, int size) {
        this.ensure(size);
        this.buffer.put(bytes, offset, size);
        return this;
    }

    public ImageStream put(ImageStream stream) {
        this.put(stream.buffer.array(), 0, stream.buffer.position());
        return this;
    }

    public ImageStream putShort(short value) {
        this.ensure(2);
        this.buffer.putShort(value);
        return this;
    }

    public ImageStream putShort(int value) {
        return this.putShort((short)value);
    }

    public ImageStream putInt(int value) {
        this.ensure(4);
        this.buffer.putInt(value);
        return this;
    }

    public ImageStream putLong(long value) {
        this.ensure(8);
        this.buffer.putLong(value);
        return this;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getPosition() {
        return this.buffer.position();
    }

    public int getSize() {
        return this.buffer.position();
    }

    public byte[] getBytes() {
        return this.buffer.array();
    }

    public void setPosition(int offset) {
        this.buffer.position(offset);
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.buffer.array(), this.buffer.position());
    }
}

