/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.jimage.decompressor;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.glavo.jimage.decompressor.ResourceDecompressor;

public final class CompressedResourceHeader {
    private static final int SIZE = 29;
    public static final int MAGIC = -889259270;
    private final long uncompressedSize;
    private final long compressedSize;
    private final int decompressorNameOffset;
    private final int contentOffset;
    private final boolean isTerminal;

    public CompressedResourceHeader(long compressedSize, long uncompressedSize, int decompressorNameOffset, int contentOffset, boolean isTerminal) {
        this.compressedSize = compressedSize;
        this.uncompressedSize = uncompressedSize;
        this.decompressorNameOffset = decompressorNameOffset;
        this.contentOffset = contentOffset;
        this.isTerminal = isTerminal;
    }

    public boolean isTerminal() {
        return this.isTerminal;
    }

    public int getDecompressorNameOffset() {
        return this.decompressorNameOffset;
    }

    public int getContentOffset() {
        return this.contentOffset;
    }

    public String getStoredContent(ResourceDecompressor.StringsProvider provider) {
        Objects.requireNonNull(provider);
        if (this.contentOffset == -1) {
            return null;
        }
        return provider.getString(this.contentOffset);
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public long getResourceSize() {
        return this.compressedSize;
    }

    public byte[] getBytes(ByteOrder order) {
        Objects.requireNonNull(order);
        ByteBuffer buffer = ByteBuffer.allocate(29);
        buffer.order(order);
        buffer.putInt(-889259270);
        buffer.putLong(this.compressedSize);
        buffer.putLong(this.uncompressedSize);
        buffer.putInt(this.decompressorNameOffset);
        buffer.putInt(this.contentOffset);
        buffer.put(this.isTerminal ? (byte)1 : 0);
        return buffer.array();
    }

    public static int getSize() {
        return 29;
    }

    public static CompressedResourceHeader readFromResource(ByteOrder order, byte[] resource) {
        Objects.requireNonNull(order);
        Objects.requireNonNull(resource);
        if (resource.length < CompressedResourceHeader.getSize()) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(resource, 0, 29);
        buffer.order(order);
        int magic = buffer.getInt();
        if (magic != -889259270) {
            return null;
        }
        long size = buffer.getLong();
        long uncompressedSize = buffer.getLong();
        int decompressorNameOffset = buffer.getInt();
        int contentIndex = buffer.getInt();
        byte isTerminal = buffer.get();
        return new CompressedResourceHeader(size, uncompressedSize, decompressorNameOffset, contentIndex, isTerminal == 1);
    }
}

