/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.jimage.decompressor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.glavo.jimage.decompressor.CompressedResourceHeader;
import org.glavo.jimage.decompressor.ResourceDecompressor;
import org.glavo.jimage.decompressor.ResourceDecompressorRepository;

public final class Decompressor {
    private final Map<Integer, ResourceDecompressor> pluginsCache = new HashMap<Integer, ResourceDecompressor>();

    public byte[] decompressResource(ByteOrder order, ResourceDecompressor.StringsProvider provider, byte[] content) throws IOException {
        CompressedResourceHeader header;
        Objects.requireNonNull(order);
        Objects.requireNonNull(provider);
        Objects.requireNonNull(content);
        do {
            if ((header = CompressedResourceHeader.readFromResource(order, content)) == null) continue;
            ResourceDecompressor decompressor = this.pluginsCache.get(header.getDecompressorNameOffset());
            if (decompressor == null) {
                String pluginName = provider.getString(header.getDecompressorNameOffset());
                if (pluginName == null) {
                    throw new IOException("Plugin name not found");
                }
                String storedContent = header.getStoredContent(provider);
                Properties props = new Properties();
                if (storedContent != null) {
                    try (ByteArrayInputStream stream = new ByteArrayInputStream(storedContent.getBytes(StandardCharsets.UTF_8));){
                        props.loadFromXML(stream);
                    }
                }
                if ((decompressor = ResourceDecompressorRepository.newResourceDecompressor(props, pluginName)) == null) {
                    throw new IOException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Plugin not found: \u0001"}, (String)pluginName)));
                }
                this.pluginsCache.put(header.getDecompressorNameOffset(), decompressor);
            }
            try {
                content = decompressor.decompress(provider, content, CompressedResourceHeader.getSize(), header.getUncompressedSize());
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        } while (header != null);
        return content;
    }
}

