/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.jimage.decompressor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glavo.jimage.decompressor.ResourceDecompressor;
import org.glavo.jimage.decompressor.ResourceDecompressorFactory;
import org.glavo.jimage.decompressor.StringSharingDecompressorFactory;
import org.glavo.jimage.decompressor.ZipDecompressorFactory;

public final class ResourceDecompressorRepository {
    private static final Map<String, ResourceDecompressorFactory> factories = new HashMap<String, ResourceDecompressorFactory>();

    private ResourceDecompressorRepository() {
    }

    public static ResourceDecompressor newResourceDecompressor(Properties properties, String name) throws IOException {
        ResourceDecompressorFactory fact = factories.get(name);
        if (fact != null) {
            return fact.newDecompressor(properties);
        }
        return null;
    }

    private static void registerReaderProvider(ResourceDecompressorFactory factory) {
        factories.put(factory.getName(), factory);
    }

    static {
        ResourceDecompressorRepository.registerReaderProvider(new ZipDecompressorFactory());
        ResourceDecompressorRepository.registerReaderProvider(new StringSharingDecompressorFactory());
    }
}

