/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.materialfx.adapter.skin;

import javafx.scene.Scene;
import javafx.scene.layout.Region;
import javafx.stage.Window;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SnapUtils {
    private static final double EPSILON = 1.0E-14;

    private SnapUtils() {
    }

    private static double scaledCeil(double value, double scale) {
        return Math.ceil(value * scale - 1.0E-14) / scale;
    }

    private static double scaledRound(double value, double scale) {
        return (double)Math.round(value * scale) / scale;
    }

    private static double snapSizeX(Region region, double value, boolean snapToPixel) {
        return snapToPixel ? SnapUtils.scaledCeil(value, SnapUtils.getSnapScale(region)) : value;
    }

    private static double snapSizeY(Region region, double value, boolean snapToPixel) {
        return snapToPixel ? SnapUtils.scaledCeil(value, SnapUtils.getSnapScale(region)) : value;
    }

    private static double snapPositionX(Region region, double value, boolean snapToPixel) {
        return snapToPixel ? SnapUtils.scaledRound(value, SnapUtils.getSnapScale(region)) : value;
    }

    private static double snapPositionY(Region region, double value, boolean snapToPixel) {
        return snapToPixel ? SnapUtils.scaledRound(value, SnapUtils.getSnapScale(region)) : value;
    }

    private static double getSnapScale(Region region) {
        Scene scene = region.getScene();
        if (scene == null) {
            return 1.0;
        }
        Window window = scene.getWindow();
        if (window == null) {
            return 1.0;
        }
        return window.impl_getPeer().getRenderScale();
    }

    private static double snapSpaceX(Region region, double value, boolean snapToPixel) {
        return snapToPixel ? SnapUtils.scaledRound(value, SnapUtils.getSnapScale(region)) : value;
    }

    private static double snapSpaceY(Region region, double value, boolean snapToPixel) {
        return snapToPixel ? SnapUtils.scaledRound(value, SnapUtils.getSnapScale(region)) : value;
    }

    public static double snapSizeX(Region region, double value) {
        return SnapUtils.snapSizeX(region, value, region.isSnapToPixel());
    }

    public static double snapSizeY(Region region, double value) {
        return SnapUtils.snapSizeY(region, value, region.isSnapToPixel());
    }

    public static double snapPositionX(Region region, double value) {
        return SnapUtils.snapPositionX(region, value, region.isSnapToPixel());
    }

    public static double snapPositionY(Region region, double value) {
        return SnapUtils.snapPositionY(region, value, region.isSnapToPixel());
    }

    public static double snapSpaceX(Region region, double value) {
        return SnapUtils.snapSpaceX(region, value, region.isSnapToPixel());
    }

    public static double snapSpaceY(Region region, double value) {
        return SnapUtils.snapSpaceY(region, value, region.isSnapToPixel());
    }
}

