/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.flow.base;

import io.github.palexdev.virtualizedfx.flow.base.VirtualFlow;
import io.github.palexdev.virtualizedfx.flow.simple.SimpleVirtualFlowContainer;
import io.github.palexdev.virtualizedfx.utils.NumberUtils;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.layout.Region;
import org.glavo.materialfx.adapter.skin.SnapUtils;

public interface OrientationHelper {
    public int firstVisible();

    public int lastVisible();

    public int computeCellsNumber();

    public double computeEstimatedHeight(double var1);

    public double computeEstimatedWidth(double var1);

    public double getHeight(Node var1);

    public double getWidth(Node var1);

    public void resizeRelocate(Node var1, double var2, double var4, double var6);

    public void layout(Node var1, int var2, double var3, double var5);

    public static double boundSize(double pref, double min, double max) {
        return NumberUtils.clamp(pref, min, max);
    }

    public static double boundWidth(Node node) {
        return OrientationHelper.boundSize(node.prefWidth(-1.0), node.minWidth(-1.0), node.maxWidth(-1.0));
    }

    public static double boundHeight(Node node) {
        return OrientationHelper.boundSize(node.prefHeight(-1.0), node.minHeight(-1.0), node.maxHeight(-1.0));
    }

    public void scrollBy(double var1);

    public void scrollTo(int var1);

    public void scrollToFirst();

    public void scrollToLast();

    public void scrollToPixel(double var1);

    public void dispose();

    public static class VerticalHelper
    implements OrientationHelper {
        private final VirtualFlow<?, ?> virtualFlow;
        private final SimpleVirtualFlowContainer<?, ?> container;
        private ChangeListener<? super Number> widthChanged;
        private ChangeListener<? super Number> heightChanged;
        private ChangeListener<? super Number> vPosChanged;
        private ChangeListener<? super Number> hPosChanged;

        public VerticalHelper(VirtualFlow<?, ?> virtualFlow, SimpleVirtualFlowContainer<?, ?> container) {
            this.virtualFlow = virtualFlow;
            this.container = container;
            this.widthChanged = (observable, oldValue, newValue) -> {
                container.recomputeCellsSize();
                container.requestCellsLayout();
            };
            this.heightChanged = (observable, oldValue, newValue) -> container.reset();
            this.vPosChanged = (observable, oldValue, newValue) -> {
                container.setLayoutY(-newValue.doubleValue() % container.getCellHeight());
                container.update(newValue.doubleValue());
            };
            this.hPosChanged = (observable, oldValue, newValue) -> container.setLayoutX(-newValue.doubleValue() % container.getCellWidth());
        }

        public void initialize() {
            this.virtualFlow.getVirtualFlow().widthProperty().addListener(this.widthChanged);
            this.virtualFlow.getVirtualFlow().heightProperty().addListener(this.heightChanged);
            this.virtualFlow.verticalPositionProperty().addListener(this.vPosChanged);
            this.virtualFlow.horizontalPositionProperty().addListener(this.hPosChanged);
        }

        @Override
        public int firstVisible() {
            return NumberUtils.clamp((int)Math.floor(this.container.getScrolled() / this.container.getCellHeight()), 0, this.virtualFlow.getItems().size() - 1);
        }

        @Override
        public int lastVisible() {
            return NumberUtils.clamp((int)Math.ceil((this.container.getScrolled() + this.virtualFlow.getVirtualFlow().getHeight()) / this.container.getCellHeight() - 1.0), 0, this.virtualFlow.getItems().size() - 1);
        }

        @Override
        public int computeCellsNumber() {
            return (int)Math.ceil(this.virtualFlow.getVirtualFlow().getHeight() / this.container.getCellHeight()) + 1;
        }

        @Override
        public double computeEstimatedHeight(double cellHeight) {
            return (double)this.virtualFlow.getItems().size() * cellHeight;
        }

        @Override
        public double computeEstimatedWidth(double cellWidth) {
            Region vf = this.virtualFlow.getVirtualFlow();
            if (this.virtualFlow.isFitToWidth()) {
                return vf.getWidth();
            }
            return Math.max(vf.getWidth(), this.container.getWidth());
        }

        @Override
        public double getHeight(Node node) {
            return node.prefHeight(-1.0);
        }

        @Override
        public double getWidth(Node node) {
            Region vf = this.virtualFlow.getVirtualFlow();
            double max = node.maxWidth(-1.0);
            double pref = node.prefWidth(-1.0);
            return this.virtualFlow.isFitToWidth() ? (max == Double.MAX_VALUE ? vf.getWidth() : OrientationHelper.boundWidth(node)) : Math.max(pref, this.container.getWidth());
        }

        @Override
        public void resizeRelocate(Node node, double pos, double w, double h) {
            node.resizeRelocate(0.0, pos, w, h);
        }

        @Override
        public void layout(Node node, int index, double cellW, double cellH) {
            double pos = SnapUtils.snapPositionY(this.container, (double)(cellH * (double)index));
            this.resizeRelocate(node, pos, cellW, cellH);
        }

        @Override
        public void scrollBy(double pixels) {
            ScrollBar vBar = this.virtualFlow.getVBar();
            double currVal = vBar.getValue();
            double newVal = NumberUtils.clamp(currVal + pixels, 0.0, vBar.getMax());
            this.virtualFlow.setVerticalPosition(newVal);
        }

        @Override
        public void scrollTo(int index) {
            this.scrollToPixel(this.container.getCellHeight() * (double)index);
        }

        @Override
        public void scrollToFirst() {
            this.scrollTo(0);
        }

        @Override
        public void scrollToLast() {
            this.scrollTo(this.virtualFlow.getItems().size() - 1);
        }

        @Override
        public void scrollToPixel(double pixel) {
            ScrollBar vBar = this.virtualFlow.getVBar();
            double val = NumberUtils.clamp(pixel, 0.0, vBar.getMax());
            this.virtualFlow.setVerticalPosition(val);
        }

        @Override
        public void dispose() {
            this.virtualFlow.getVirtualFlow().widthProperty().removeListener(this.widthChanged);
            this.virtualFlow.getVirtualFlow().heightProperty().removeListener(this.heightChanged);
            this.virtualFlow.verticalPositionProperty().removeListener(this.vPosChanged);
            this.virtualFlow.horizontalPositionProperty().removeListener(this.hPosChanged);
            this.widthChanged = null;
            this.heightChanged = null;
            this.vPosChanged = null;
            this.hPosChanged = null;
        }
    }

    public static class HorizontalHelper
    implements OrientationHelper {
        private final VirtualFlow<?, ?> virtualFlow;
        private final SimpleVirtualFlowContainer<?, ?> container;
        private ChangeListener<? super Number> widthChanged;
        private ChangeListener<? super Number> heightChanged;
        private ChangeListener<? super Number> vPosChanged;
        private ChangeListener<? super Number> hPosChanged;

        public HorizontalHelper(VirtualFlow<?, ?> virtualFlow, SimpleVirtualFlowContainer<?, ?> container) {
            this.virtualFlow = virtualFlow;
            this.container = container;
            this.widthChanged = (observable, oldValue, newValue) -> container.reset();
            this.heightChanged = (observable, oldValue, newValue) -> {
                container.recomputeCellsSize();
                container.requestCellsLayout();
            };
            this.vPosChanged = (observable, oldValue, newValue) -> container.setLayoutY((double)(-newValue.floatValue()) % container.getCellHeight());
            this.hPosChanged = (observable, oldValue, newValue) -> {
                container.setLayoutX(-newValue.doubleValue() % container.getCellWidth());
                container.update(newValue.doubleValue());
            };
        }

        public void initialize() {
            this.virtualFlow.getVirtualFlow().widthProperty().addListener(this.widthChanged);
            this.virtualFlow.getVirtualFlow().heightProperty().addListener(this.heightChanged);
            this.virtualFlow.verticalPositionProperty().addListener(this.vPosChanged);
            this.virtualFlow.horizontalPositionProperty().addListener(this.hPosChanged);
        }

        @Override
        public int firstVisible() {
            return NumberUtils.clamp((int)Math.floor(this.container.getScrolled() / this.container.getCellWidth()), 0, this.virtualFlow.getItems().size() - 1);
        }

        @Override
        public int lastVisible() {
            return NumberUtils.clamp((int)Math.ceil((this.container.getScrolled() + this.virtualFlow.getVirtualFlow().getWidth()) / this.container.getCellWidth() - 1.0), 0, this.virtualFlow.getItems().size() - 1);
        }

        @Override
        public int computeCellsNumber() {
            return (int)Math.ceil(this.virtualFlow.getVirtualFlow().getWidth() / this.container.getCellWidth()) + 1;
        }

        @Override
        public double computeEstimatedHeight(double cellHeight) {
            Region vf = this.virtualFlow.getVirtualFlow();
            if (this.virtualFlow.isFitToHeight()) {
                return vf.getHeight();
            }
            return Math.max(vf.getHeight(), this.container.getHeight());
        }

        @Override
        public double computeEstimatedWidth(double cellWidth) {
            return (double)this.virtualFlow.getItems().size() * cellWidth;
        }

        @Override
        public double getHeight(Node node) {
            Region vf = this.virtualFlow.getVirtualFlow();
            double max = node.maxHeight(-1.0);
            double pref = node.prefHeight(-1.0);
            return this.virtualFlow.isFitToHeight() ? (max == Double.MAX_VALUE ? vf.getHeight() : OrientationHelper.boundHeight(node)) : Math.max(pref, this.container.getHeight());
        }

        @Override
        public double getWidth(Node node) {
            return node.prefWidth(-1.0);
        }

        @Override
        public void resizeRelocate(Node node, double pos, double w, double h) {
            node.resizeRelocate(pos, 0.0, w, h);
        }

        @Override
        public void layout(Node node, int index, double cellW, double cellH) {
            double pos = SnapUtils.snapPositionX(this.container, (double)(cellW * (double)index));
            this.resizeRelocate(node, pos, cellW, cellH);
        }

        @Override
        public void scrollBy(double pixels) {
            ScrollBar hBar = this.virtualFlow.getHBar();
            double currVal = hBar.getValue();
            double newVal = NumberUtils.clamp(currVal + pixels, 0.0, hBar.getMax());
            this.virtualFlow.setHorizontalPosition(newVal);
        }

        @Override
        public void scrollTo(int index) {
            this.scrollToPixel(this.container.getCellWidth() * (double)index);
        }

        @Override
        public void scrollToFirst() {
            this.scrollTo(0);
        }

        @Override
        public void scrollToLast() {
            this.scrollTo(this.virtualFlow.getItems().size() - 1);
        }

        @Override
        public void scrollToPixel(double pixel) {
            ScrollBar hBar = this.virtualFlow.getHBar();
            double val = NumberUtils.clamp(pixel, 0.0, hBar.getMax());
            this.virtualFlow.setHorizontalPosition(val);
        }

        @Override
        public void dispose() {
            this.virtualFlow.getVirtualFlow().widthProperty().removeListener(this.widthChanged);
            this.virtualFlow.getVirtualFlow().heightProperty().removeListener(this.heightChanged);
            this.virtualFlow.verticalPositionProperty().removeListener(this.vPosChanged);
            this.virtualFlow.horizontalPositionProperty().removeListener(this.hPosChanged);
            this.widthChanged = null;
            this.heightChanged = null;
            this.vPosChanged = null;
            this.hPosChanged = null;
        }
    }
}

