/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javafx.application.Platform;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class ExecutionUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAndWaitEx(Runnable run) throws InterruptedException, ExecutionException {
        if (Platform.isFxApplicationThread()) {
            try {
                run.run();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        ThrowableWrapper throwableWrapper = new ThrowableWrapper();
        lock.lock();
        try {
            Platform.runLater(() -> {
                lock.lock();
                try {
                    run.run();
                }
                catch (Throwable e) {
                    throwableWrapper.t = e;
                }
                finally {
                    try {
                        condition.signal();
                    }
                    finally {
                        lock.unlock();
                    }
                }
            });
            condition.await();
            if (throwableWrapper.t != null) {
                throw new ExecutionException(throwableWrapper.t);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void runAndWait(Runnable runnable) {
        try {
            ExecutionUtils.runAndWaitEx(runnable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <V> V tryCallableAndPrint(Callable<V> callable) {
        try {
            return callable.call();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <V> V tryCallableAndIgnore(Callable<V> callable) {
        try {
            return callable.call();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static <T> void executeWhen(final ObservableValue<? extends T> property, final BiConsumer<T, T> consumer, boolean executeNow, final BiFunction<T, T, Boolean> executionCondition, final boolean isOneShot) {
        if (executeNow) {
            consumer.accept(null, property.getValue());
        }
        property.addListener(new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                if (((Boolean)executionCondition.apply(oldValue, newValue)).booleanValue()) {
                    consumer.accept(oldValue, newValue);
                    if (isOneShot) {
                        property.removeListener((ChangeListener)this);
                    }
                }
            }
        });
    }

    public static void executeWhen(final BooleanExpression booleanExpression, final Runnable action, boolean executeNow, boolean addListenerIfTrue, final boolean isOneShot) {
        if (booleanExpression.get() && executeNow) {
            action.run();
        }
        if (!booleanExpression.get() || addListenerIfTrue) {
            booleanExpression.addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        action.run();
                        if (isOneShot) {
                            booleanExpression.removeListener((ChangeListener)this);
                        }
                    }
                }
            });
        }
    }

    public static void executeWhen(final BooleanExpression booleanExpression, final Runnable trueAction, final Runnable falseAction, boolean executeTrueNow, boolean executeFalseNow, boolean addListenerIfTrue, final boolean isOneShot) {
        if (booleanExpression.get() && executeTrueNow) {
            trueAction.run();
        } else if (!booleanExpression.get() && executeFalseNow) {
            falseAction.run();
        }
        if (!booleanExpression.get() || addListenerIfTrue) {
            booleanExpression.addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        trueAction.run();
                    } else {
                        falseAction.run();
                    }
                    if (isOneShot) {
                        booleanExpression.removeListener((ChangeListener)this);
                    }
                }
            });
        }
    }

    private static class ThrowableWrapper {
        Throwable t;

        private ThrowableWrapper() {
        }
    }
}

