/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.utils;

import io.github.palexdev.virtualizedfx.beans.NumberRange;
import io.github.palexdev.virtualizedfx.utils.NumberUtils;
import io.github.palexdev.virtualizedfx.utils.TriConsumer;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javafx.collections.ListChangeListener;

public class ListChangeHelper {
    public static <T> Change processChange(ListChangeListener.Change<? extends T> change, NumberRange<Integer> indexes) {
        HashSet<ChangeBean> added = new HashSet<ChangeBean>();
        HashSet<ChangeBean> removed = new HashSet<ChangeBean>();
        HashSet<ReplaceBean> replaced = new HashSet<ReplaceBean>();
        int removeFrom = -1;
        int removeTo = -1;
        HashSet<Integer> removedAccumulator = new HashSet<Integer>();
        int removedSize = 0;
        while (change.next()) {
            NumberRange<Integer> range;
            if (change.wasReplaced()) {
                range = NumberRange.of(change.getFrom(), change.getTo() - 1);
                Set<Integer> changed = NumberRange.expandRangeToSet(range).stream().filter(i -> NumberRange.inRangeOf((int)i, indexes)).collect(Collectors.toSet());
                removeFrom = change.getTo();
                removeTo = NumberUtils.clamp(change.getRemovedSize() - 1, 0, indexes.getMax());
                removedAccumulator.addAll(NumberRange.expandRangeToSet(NumberRange.of(removeFrom, removeTo)));
                removedAccumulator.removeAll(changed);
                replaced.add(new ReplaceBean(range, changed, removedAccumulator));
                continue;
            }
            if (change.wasAdded()) {
                range = NumberRange.of(change.getFrom(), change.getTo() - 1);
                added.add(new ChangeBean(range, NumberRange.expandRangeToSet(range)));
                continue;
            }
            if (!change.wasRemoved()) continue;
            range = ListChangeHelper.computeRemovedIndexes(change, removedSize);
            if (removeFrom == -1) {
                removeFrom = range.getMin();
            }
            removeTo = range.getMax();
            removedAccumulator.addAll(NumberRange.expandRangeToSet(range));
            removedSize += change.getRemovedSize();
        }
        removed.add(new ChangeBean(NumberRange.of(removeFrom, removeTo), removedAccumulator));
        return new Change(added, removed, replaced);
    }

    private static <T> NumberRange<Integer> computeRemovedIndexes(ListChangeListener.Change<? extends T> change, int toOffset) {
        int size = change.getList().size();
        if (size == 0) {
            return NumberRange.of(0, change.getRemovedSize() - 1);
        }
        int from = change.getTo() + toOffset;
        int to = change.getFrom() + (change.getRemovedSize() - 1) + toOffset;
        return NumberRange.of(from, to);
    }

    public static class ReplaceBean {
        private final NumberRange<Integer> range;
        private final Set<Integer> changed;
        private final Set<Integer> removed;

        public ReplaceBean(NumberRange<Integer> range, Set<Integer> changed, Set<Integer> removed) {
            this.range = range;
            this.changed = changed;
            this.removed = removed;
        }

        public int gerFrom() {
            return this.range.getMin();
        }

        public int getTo() {
            return this.range.getMax();
        }

        public boolean isEmpty() {
            return this.changed.isEmpty() && this.removed.isEmpty();
        }
    }

    public static class ChangeBean {
        private final NumberRange<Integer> range;
        private final Set<Integer> changed;

        public ChangeBean(NumberRange<Integer> range, Set<Integer> added) {
            this.range = range;
            this.changed = added;
        }

        public int gerFrom() {
            return this.range.getMin();
        }

        public int getTo() {
            return this.range.getMax();
        }
    }

    public static class Change {
        private boolean wasReplacement;
        private final Set<ChangeBean> added;
        private final Set<ChangeBean> removed;
        private final Set<ReplaceBean> replaced;

        private Change(Set<ChangeBean> added, Set<ChangeBean> removed, Set<ReplaceBean> replaced) {
            this.added = added;
            this.removed = removed;
            this.replaced = replaced;
        }

        public void processAddition(TriConsumer<Integer, Integer, Set<Integer>> action) {
            if (this.added.isEmpty()) {
                return;
            }
            for (ChangeBean changeBean : this.added) {
                if (changeBean.changed.isEmpty()) continue;
                action.accept(changeBean.gerFrom(), changeBean.getTo(), changeBean.changed);
            }
        }

        public void processRemoval(TriConsumer<Integer, Integer, Set<Integer>> action) {
            if (this.removed.isEmpty() || this.wasReplacement) {
                return;
            }
            for (ChangeBean changeBean : this.removed) {
                if (changeBean.changed.isEmpty()) continue;
                action.accept(changeBean.gerFrom(), changeBean.getTo(), changeBean.changed);
            }
        }

        public void processReplacement(BiConsumer<Set<Integer>, Set<Integer>> action) {
            if (this.replaced.isEmpty()) {
                return;
            }
            for (ReplaceBean replaceBean : this.replaced) {
                if (replaceBean.isEmpty()) continue;
                action.accept(replaceBean.changed, replaceBean.removed);
            }
            this.wasReplacement = true;
        }

        public Set<ChangeBean> getAdded() {
            return this.added;
        }

        public Set<ChangeBean> getRemoved() {
            return this.removed;
        }

        public Set<ReplaceBean> getReplaced() {
            return this.replaced;
        }
    }
}

