/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.flow.simple;

import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.flow.simple.SimpleVirtualFlow;
import io.github.palexdev.virtualizedfx.flow.simple.SimpleVirtualFlowContainer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;

public class LayoutManager<T, C extends Cell<T>> {
    private final SimpleVirtualFlow<T, C> virtualFlow;
    private final SimpleVirtualFlowContainer<T, C> container;
    private boolean initialized;
    private double scrolled;
    private final DoubleProperty estimatedHeight = new SimpleDoubleProperty();
    private final DoubleProperty estimatedWidth = new SimpleDoubleProperty();
    private double cellHeight;
    private double cellWidth;
    private DoubleBinding heightBinding;
    private DoubleBinding widthBinding;

    public LayoutManager(SimpleVirtualFlowContainer<T, C> container) {
        this.virtualFlow = container.getVirtualFlow();
        this.container = container;
    }

    protected void initialize() {
        if (this.virtualFlow.getItems().isEmpty()) {
            return;
        }
        Cell cell = (Cell)this.virtualFlow.getCellFactory().apply(this.virtualFlow.getItems().get(0));
        this.retrieveCellsSizes(cell);
        this.initFlow();
        this.setInitialized(true);
    }

    protected void initFlow() {
        this.bindings();
        int num = this.virtualFlow.getOrientationHelper().computeCellsNumber();
        this.container.initCells(num);
    }

    private void bindings() {
        this.estimatedHeight.unbind();
        this.estimatedHeight.unbind();
        this.heightBinding = Bindings.createDoubleBinding(() -> this.virtualFlow.getOrientationHelper().computeEstimatedHeight(this.cellHeight), (Observable[])new Observable[]{this.virtualFlow.getItems(), this.virtualFlow.heightProperty(), this.virtualFlow.orientationProperty(), this.virtualFlow.fitToHeightProperty(), this.container.heightProperty()});
        this.widthBinding = Bindings.createDoubleBinding(() -> this.virtualFlow.getOrientationHelper().computeEstimatedWidth(this.cellWidth), (Observable[])new Observable[]{this.virtualFlow.getItems(), this.virtualFlow.widthProperty(), this.virtualFlow.orientationProperty(), this.virtualFlow.fitToWidthProperty(), this.container.widthProperty()});
        this.estimatedHeight.bind((ObservableValue)this.heightBinding);
        this.estimatedWidth.bind((ObservableValue)this.widthBinding);
    }

    public void update(double scrolled) {
        this.scrolled = scrolled;
        int start = this.firstVisible();
        this.container.updateCells(start);
    }

    public int firstVisible() {
        return this.virtualFlow.getOrientationHelper().firstVisible();
    }

    public int lastVisible() {
        return this.virtualFlow.getOrientationHelper().lastVisible();
    }

    protected void retrieveCellsSizes(C cell) {
        Node node = cell.getNode();
        Group group = new Group();
        group.getChildren().add((Object)node);
        new Scene((Parent)group);
        group.applyCss();
        group.layout();
        this.cellHeight = this.virtualFlow.getOrientationHelper().getHeight(node);
        this.cellWidth = this.virtualFlow.getOrientationHelper().getWidth(node);
    }

    public double getEstimatedHeight() {
        return this.estimatedHeight.get();
    }

    public DoubleProperty estimatedHeightProperty() {
        return this.estimatedHeight;
    }

    public double getEstimatedWidth() {
        return this.estimatedWidth.get();
    }

    public DoubleProperty estimatedWidthProperty() {
        return this.estimatedWidth;
    }

    public double getCellHeight() {
        return this.cellHeight;
    }

    public double getCellWidth() {
        return this.cellWidth;
    }

    public double getScrolled() {
        return this.scrolled;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

