/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.utils;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class NodeUtils {
    public static void waitForSkin(final Control control, final Runnable action, boolean addListenerIfNotNull, final boolean isOneShot) {
        if (control.getSkin() != null) {
            action.run();
        }
        if (control.getSkin() == null || addListenerIfNotNull) {
            control.skinProperty().addListener(new ChangeListener<Skin<?>>(){

                public void changed(ObservableValue<? extends Skin<?>> observable, Skin<?> oldValue, Skin<?> newValue) {
                    if (newValue != null) {
                        action.run();
                        if (isOneShot) {
                            control.skinProperty().removeListener((ChangeListener)this);
                        }
                    }
                }
            });
        }
    }

    public static void waitForScene(final Node node, final Runnable action, boolean addListenerIfNotNull, final boolean isOneShot) {
        if (node.getScene() != null) {
            action.run();
        }
        if (node.getScene() == null || addListenerIfNotNull) {
            node.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

                public void changed(ObservableValue<? extends Scene> observable, Scene oldValue, Scene newValue) {
                    if (newValue != null) {
                        action.run();
                        if (isOneShot) {
                            node.sceneProperty().removeListener((ChangeListener)this);
                        }
                    }
                }
            });
        }
    }
}

