/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.utils;

import javafx.geometry.Orientation;

public class ScrollUtils {
    private ScrollUtils() {
    }

    public static boolean isTrackPad(double delta) {
        return Math.abs(delta) < 10.0;
    }

    public static ScrollDirection determineScrollDirection(Orientation orientation, double delta) {
        return orientation == Orientation.VERTICAL ? ScrollUtils.upOrDown(delta) : ScrollUtils.leftOrRight(delta);
    }

    public static ScrollDirection leftOrRight(double delta) {
        return delta < 0.0 ? ScrollDirection.LEFT : ScrollDirection.RIGHT;
    }

    public static ScrollDirection upOrDown(double delta) {
        return delta < 0.0 ? ScrollDirection.DOWN : ScrollDirection.UP;
    }

    public static enum ScrollDirection {
        UP(-1),
        RIGHT(-1),
        DOWN(1),
        LEFT(1);

        final int intDirection;

        private ScrollDirection(int intDirection) {
            this.intDirection = intDirection;
        }

        public int intDirection() {
            return this.intDirection;
        }
    }
}

