/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.pack200.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.glavo.pack200.impl.Attribute;
import org.glavo.pack200.impl.BandStructure;
import org.glavo.pack200.impl.Code;
import org.glavo.pack200.impl.ConstantPool;
import org.glavo.pack200.impl.Constants;
import org.glavo.pack200.impl.Fixups;
import org.glavo.pack200.impl.PropMap;
import org.glavo.pack200.impl.Utils;

class Package {
    int verbose;
    final int magic = -889270259;
    int default_modtime;
    int default_options;
    Version defaultClassVersion;
    final Version minClassVersion;
    final Version maxClassVersion;
    final Version packageVersion;
    Version observedHighestClassVersion;
    ConstantPool.IndexGroup cp;
    public static final Attribute.Layout attrCodeEmpty;
    public static final Attribute.Layout attrBootstrapMethodsEmpty;
    public static final Attribute.Layout attrInnerClassesEmpty;
    public static final Attribute.Layout attrSourceFileSpecial;
    public static final Map<Attribute.Layout, Attribute> attrDefs;
    ArrayList<Class> classes;
    ArrayList<File> files;
    List<InnerClass> allInnerClasses;
    Map<ConstantPool.ClassEntry, InnerClass> allInnerClassesByThis;
    private static final int SLASH_MIN = 46;
    private static final int SLASH_MAX = 47;
    private static final int DOLLAR_MIN = 0;
    private static final int DOLLAR_MAX = 45;
    static final List<Object> noObjects;
    static final List<Class.Field> noFields;
    static final List<Class.Method> noMethods;
    static final List<InnerClass> noInnerClasses;

    public Package() {
        PropMap pmap = Utils.currentPropMap();
        if (pmap != null) {
            this.verbose = pmap.getInteger("org.glavo.pack200.verbose");
        }
        this.magic = -889270259;
        this.default_modtime = 0;
        this.default_options = 0;
        this.defaultClassVersion = null;
        this.observedHighestClassVersion = null;
        this.cp = new ConstantPool.IndexGroup();
        this.classes = new ArrayList();
        this.files = new ArrayList();
        this.allInnerClasses = new ArrayList<InnerClass>();
        this.minClassVersion = Constants.JAVA_MIN_CLASS_VERSION;
        this.maxClassVersion = Constants.JAVA_MAX_CLASS_VERSION;
        this.packageVersion = null;
    }

    public Package(Version minClassVersion, Version maxClassVersion, Version packageVersion) {
        PropMap pmap = Utils.currentPropMap();
        if (pmap != null) {
            this.verbose = pmap.getInteger("org.glavo.pack200.verbose");
        }
        this.magic = -889270259;
        this.default_modtime = 0;
        this.default_options = 0;
        this.defaultClassVersion = null;
        this.observedHighestClassVersion = null;
        this.cp = new ConstantPool.IndexGroup();
        this.classes = new ArrayList();
        this.files = new ArrayList();
        this.allInnerClasses = new ArrayList<InnerClass>();
        this.minClassVersion = minClassVersion == null ? Constants.JAVA_MIN_CLASS_VERSION : minClassVersion;
        this.maxClassVersion = maxClassVersion == null ? Constants.JAVA_MAX_CLASS_VERSION : maxClassVersion;
        this.packageVersion = packageVersion;
    }

    public void reset() {
        this.cp = new ConstantPool.IndexGroup();
        this.classes.clear();
        this.files.clear();
        BandStructure.nextSeqForDebug = 0;
        this.observedHighestClassVersion = null;
    }

    Version getDefaultClassVersion() {
        return this.defaultClassVersion;
    }

    private void setHighestClassVersion() {
        if (this.observedHighestClassVersion != null) {
            return;
        }
        Version res = Constants.JAVA_MIN_CLASS_VERSION;
        for (Class cls : this.classes) {
            Version ver = cls.getVersion();
            if (!res.lessThan(ver)) continue;
            res = ver;
        }
        this.observedHighestClassVersion = res;
    }

    Version getHighestClassVersion() {
        this.setHighestClassVersion();
        return this.observedHighestClassVersion;
    }

    public List<Class> getClasses() {
        return this.classes;
    }

    void addClass(Class c) {
        assert (c.getPackage() == this);
        boolean added = this.classes.add(c);
        assert (added);
        if (c.file == null) {
            c.initFile(null);
        }
        this.addFile(c.file);
    }

    public List<File> getFiles() {
        return this.files;
    }

    public List<File> getClassStubs() {
        ArrayList<File> classStubs = new ArrayList<File>(this.classes.size());
        for (Class cls : this.classes) {
            assert (cls.file.isClassStub());
            classStubs.add(cls.file);
        }
        return classStubs;
    }

    File newStub(String classFileNameString) {
        File stub = new File(classFileNameString);
        stub.options |= 2;
        stub.prepend = null;
        stub.append = null;
        return stub;
    }

    private static String fixupFileName(String name) {
        String fname = name.replace(java.io.File.separatorChar, '/');
        if (fname.startsWith("/")) {
            throw new IllegalArgumentException("absolute file name " + fname);
        }
        return fname;
    }

    void addFile(File file) {
        boolean added = this.files.add(file);
        assert (added);
    }

    public List<InnerClass> getAllInnerClasses() {
        return this.allInnerClasses;
    }

    public void setAllInnerClasses(Collection<InnerClass> ics) {
        assert (ics != this.allInnerClasses);
        this.allInnerClasses.clear();
        this.allInnerClasses.addAll(ics);
        this.allInnerClassesByThis = new HashMap<ConstantPool.ClassEntry, InnerClass>(this.allInnerClasses.size());
        for (InnerClass ic : this.allInnerClasses) {
            InnerClass pic = this.allInnerClassesByThis.put(ic.thisClass, ic);
            assert (pic == null);
        }
    }

    public InnerClass getGlobalInnerClass(ConstantPool.Entry thisClass) {
        assert (thisClass instanceof ConstantPool.ClassEntry);
        return this.allInnerClassesByThis.get(thisClass);
    }

    private static void visitInnerClassRefs(Collection<InnerClass> innerClasses, int mode, Collection<ConstantPool.Entry> refs) {
        if (innerClasses == null) {
            return;
        }
        if (mode == 0) {
            refs.add(Package.getRefString("InnerClasses"));
        }
        if (innerClasses.size() > 0) {
            for (InnerClass c : innerClasses) {
                c.visitRefs(mode, refs);
            }
        }
    }

    static String[] parseInnerClassName(String n) {
        int dollar1;
        String name;
        String number;
        int nlen = n.length();
        int pkglen = Package.lastIndexOf(46, 47, n, n.length()) + 1;
        int dollar2 = Package.lastIndexOf(0, 45, n, n.length());
        if (dollar2 < pkglen) {
            return null;
        }
        if (Package.isDigitString(n, dollar2 + 1, nlen)) {
            number = n.substring(dollar2 + 1, nlen);
            name = null;
            dollar1 = dollar2;
        } else {
            dollar1 = Package.lastIndexOf(0, 45, n, dollar2 - 1);
            if (dollar1 > pkglen && Package.isDigitString(n, dollar1 + 1, dollar2)) {
                number = n.substring(dollar1 + 1, dollar2);
                name = n.substring(dollar2 + 1, nlen).intern();
            } else {
                dollar1 = dollar2;
                number = null;
                name = n.substring(dollar2 + 1, nlen).intern();
            }
        }
        String pkgOuter = number == null ? n.substring(0, dollar1).intern() : null;
        return new String[]{pkgOuter, number, name};
    }

    private static int lastIndexOf(int chMin, int chMax, String str, int pos) {
        int i = pos;
        while (--i >= 0) {
            char ch = str.charAt(i);
            if (ch < chMin || ch > chMax) continue;
            return i;
        }
        return -1;
    }

    private static boolean isDigitString(String x, int beg, int end) {
        if (beg == end) {
            return false;
        }
        for (int i = beg; i < end; ++i) {
            char ch = x.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    static String getObviousSourceFile(String className) {
        int dollar2;
        String n = className;
        int pkglen = Package.lastIndexOf(46, 47, n, n.length()) + 1;
        n = n.substring(pkglen);
        int cutoff = n.length();
        while ((dollar2 = Package.lastIndexOf(0, 45, n, cutoff - 1)) >= 0 && (cutoff = dollar2) != 0) {
        }
        String obvious = n.substring(0, cutoff) + ".java";
        return obvious;
    }

    static ConstantPool.Utf8Entry getRefString(String s) {
        return ConstantPool.getUtf8Entry(s);
    }

    static ConstantPool.LiteralEntry getRefLiteral(Comparable<?> s) {
        return ConstantPool.getLiteralEntry(s);
    }

    void stripAttributeKind(String what) {
        if (this.verbose > 0) {
            Utils.log.info("Stripping " + what.toLowerCase() + " data and attributes...");
        }
        switch (what) {
            case "Debug": {
                this.strip("SourceFile");
                this.strip("LineNumberTable");
                this.strip("LocalVariableTable");
                this.strip("LocalVariableTypeTable");
                break;
            }
            case "Compile": {
                this.strip("Deprecated");
                this.strip("Synthetic");
                break;
            }
            case "Exceptions": {
                this.strip("Exceptions");
                break;
            }
            case "Constant": {
                this.stripConstantFields();
            }
        }
    }

    public void trimToSize() {
        this.classes.trimToSize();
        for (Class c : this.classes) {
            c.trimToSize();
        }
        this.files.trimToSize();
    }

    public void strip(String attrName) {
        for (Class c : this.classes) {
            c.strip(attrName);
        }
    }

    public void stripConstantFields() {
        for (Class c : this.classes) {
            Iterator<Class.Field> j = c.fields.iterator();
            while (j.hasNext()) {
                Class.Field f = j.next();
                if (!Modifier.isFinal(f.flags) || !Modifier.isStatic(f.flags) || f.getAttribute("ConstantValue") == null || f.getName().startsWith("serial") || this.verbose <= 2) continue;
                Utils.log.fine(">> Strip " + this + " ConstantValue");
                j.remove();
            }
        }
    }

    protected void visitRefs(int mode, Collection<ConstantPool.Entry> refs) {
        for (Class c : this.classes) {
            c.visitRefs(mode, refs);
        }
        if (mode != 0) {
            for (File f : this.files) {
                f.visitRefs(mode, refs);
            }
            Package.visitInnerClassRefs(this.allInnerClasses, mode, refs);
        }
    }

    void reorderFiles(boolean keepClassOrder, boolean stripDirectories) {
        if (!keepClassOrder) {
            Collections.sort(this.classes);
        }
        List<File> stubs = this.getClassStubs();
        Iterator<File> i = this.files.iterator();
        while (i.hasNext()) {
            File file = i.next();
            if (!file.isClassStub() && (!stripDirectories || !file.isDirectory())) continue;
            i.remove();
        }
        Collections.sort(this.files, new Comparator<File>(){

            @Override
            public int compare(File r0, File r1) {
                String x1;
                String f0 = r0.nameString;
                String f1 = r1.nameString;
                if (f0.equals(f1)) {
                    return 0;
                }
                if ("META-INF/MANIFEST.MF".equals(f0)) {
                    return -1;
                }
                if ("META-INF/MANIFEST.MF".equals(f1)) {
                    return 1;
                }
                String n0 = f0.substring(1 + f0.lastIndexOf(47));
                String n1 = f1.substring(1 + f1.lastIndexOf(47));
                String x0 = n0.substring(1 + n0.lastIndexOf(46));
                int r = x0.compareTo(x1 = n1.substring(1 + n1.lastIndexOf(46)));
                if (r != 0) {
                    return r;
                }
                r = f0.compareTo(f1);
                return r;
            }
        });
        this.files.addAll(stubs);
    }

    void trimStubs() {
        ListIterator<File> i = this.files.listIterator(this.files.size());
        while (i.hasPrevious()) {
            File file = i.previous();
            if (!file.isTrivialClassStub()) {
                if (this.verbose <= 1) break;
                Utils.log.fine("Keeping last non-trivial " + file);
                break;
            }
            if (this.verbose > 2) {
                Utils.log.fine("Removing trivial " + file);
            }
            i.remove();
        }
        if (this.verbose > 0) {
            Utils.log.info("Transmitting " + this.files.size() + " files, including per-file data for " + this.getClassStubs().size() + " classes out of " + this.classes.size());
        }
    }

    void buildGlobalConstantPool(Set<ConstantPool.Entry> requiredEntries) {
        ConstantPool.Index ix;
        int i;
        if (this.verbose > 1) {
            Utils.log.fine("Checking for unused CP entries");
        }
        requiredEntries.add(Package.getRefString(""));
        this.visitRefs(1, requiredEntries);
        ConstantPool.completeReferencesIn(requiredEntries, false);
        if (this.verbose > 1) {
            Utils.log.fine("Sorting CP entries");
        }
        ConstantPool.Index cpAllU = ConstantPool.makeIndex("unsorted", requiredEntries);
        ConstantPool.Index[] byTagU = ConstantPool.partitionByTag(cpAllU);
        for (i = 0; i < ConstantPool.TAGS_IN_ORDER.length; ++i) {
            byte tag = ConstantPool.TAGS_IN_ORDER[i];
            ix = byTagU[tag];
            if (ix == null) continue;
            ConstantPool.sort(ix);
            this.cp.initIndexByTag(tag, ix);
            byTagU[tag] = null;
        }
        for (i = 0; i < byTagU.length; ++i) {
            ConstantPool.Index ix2 = byTagU[i];
            assert (ix2 == null);
        }
        for (i = 0; i < ConstantPool.TAGS_IN_ORDER.length; ++i) {
            byte tag = ConstantPool.TAGS_IN_ORDER[i];
            ix = this.cp.getIndexByTag(tag);
            assert (ix.assertIsSorted());
            if (this.verbose <= 2) continue;
            Utils.log.fine(ix.dumpString());
        }
    }

    void ensureAllClassFiles() {
        HashSet<File> fileSet = new HashSet<File>(this.files);
        for (Class cls : this.classes) {
            if (fileSet.contains(cls.file)) continue;
            this.files.add(cls.file);
        }
    }

    static {
        HashMap<Attribute.Layout, Attribute> ad = new HashMap<Attribute.Layout, Attribute>(3);
        attrCodeEmpty = Attribute.define(ad, 2, "Code", "").layout();
        attrBootstrapMethodsEmpty = Attribute.define(ad, 0, "BootstrapMethods", "").layout();
        attrInnerClassesEmpty = Attribute.define(ad, 0, "InnerClasses", "").layout();
        attrSourceFileSpecial = Attribute.define(ad, 0, "SourceFile", "RUNH").layout();
        attrDefs = Collections.unmodifiableMap(ad);
        assert (Package.lastIndexOf(0, 45, "x$$y$", 4) == 2);
        assert (Package.lastIndexOf(46, 47, "x//y/", 4) == 2);
        noObjects = Arrays.asList(new Object[0]);
        noFields = Arrays.asList(new Class.Field[0]);
        noMethods = Arrays.asList(new Class.Method[0]);
        noInnerClasses = Arrays.asList(new InnerClass[0]);
    }

    protected static final class Version {
        public final short major;
        public final short minor;

        private Version(short major, short minor) {
            this.major = major;
            this.minor = minor;
        }

        public String toString() {
            return this.major + "." + this.minor;
        }

        public boolean equals(Object that) {
            return that instanceof Version && this.major == ((Version)that).major && this.minor == ((Version)that).minor;
        }

        public int intValue() {
            return (this.major << 16) + this.minor;
        }

        public int hashCode() {
            return (this.major << 16) + 7 + this.minor;
        }

        public static Version of(int major, int minor) {
            return new Version((short)major, (short)minor);
        }

        public static Version of(byte[] bytes) {
            int minor = (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
            int major = (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
            return new Version((short)major, (short)minor);
        }

        public static Version of(int major_minor) {
            short minor = (short)major_minor;
            short major = (short)(major_minor >>> 16);
            return new Version(major, minor);
        }

        public static Version makeVersion(PropMap props, String partialKey) {
            int min = props.getInteger("org.glavo.pack200." + partialKey + ".minver", -1);
            int maj = props.getInteger("org.glavo.pack200." + partialKey + ".majver", -1);
            return min >= 0 && maj >= 0 ? Version.of(maj, min) : null;
        }

        public byte[] asBytes() {
            byte[] bytes = new byte[]{(byte)(this.minor >> 8), (byte)this.minor, (byte)(this.major >> 8), (byte)this.major};
            return bytes;
        }

        public int compareTo(Version that) {
            return this.intValue() - that.intValue();
        }

        public boolean lessThan(Version that) {
            return this.compareTo(that) < 0;
        }

        public boolean greaterThan(Version that) {
            return this.compareTo(that) > 0;
        }
    }

    public final class Class
    extends Attribute.Holder
    implements Comparable<Class> {
        File file;
        int magic;
        Version version;
        ConstantPool.Entry[] cpMap;
        ConstantPool.ClassEntry thisClass;
        ConstantPool.ClassEntry superClass;
        ConstantPool.ClassEntry[] interfaces;
        ArrayList<Field> fields;
        ArrayList<Method> methods;
        ArrayList<InnerClass> innerClasses;
        ArrayList<ConstantPool.BootstrapMethodEntry> bootstrapMethods;

        public Package getPackage() {
            return Package.this;
        }

        Class(int flags, ConstantPool.ClassEntry thisClass, ConstantPool.ClassEntry superClass, ConstantPool.ClassEntry[] interfaces) {
            this.magic = -889275714;
            this.version = Package.this.defaultClassVersion;
            this.flags = flags;
            this.thisClass = thisClass;
            this.superClass = superClass;
            this.interfaces = interfaces;
            boolean added = Package.this.classes.add(this);
            assert (added);
        }

        Class(String classFile) {
            this.initFile(Package.this.newStub(classFile));
        }

        List<Field> getFields() {
            return this.fields == null ? noFields : this.fields;
        }

        List<Method> getMethods() {
            return this.methods == null ? noMethods : this.methods;
        }

        public String getName() {
            return this.thisClass.stringValue();
        }

        Version getVersion() {
            return this.version;
        }

        @Override
        public int compareTo(Class that) {
            String n0 = this.getName();
            String n1 = that.getName();
            return n0.compareTo(n1);
        }

        String getObviousSourceFile() {
            return Package.getObviousSourceFile(this.getName());
        }

        private void transformSourceFile(boolean minimize) {
            Attribute olda = this.getAttribute(attrSourceFileSpecial);
            if (olda == null) {
                return;
            }
            String obvious = this.getObviousSourceFile();
            ArrayList<ConstantPool.Entry> ref = new ArrayList<ConstantPool.Entry>(1);
            olda.visitRefs(this, 1, ref);
            ConstantPool.Utf8Entry sfName = (ConstantPool.Utf8Entry)ref.get(0);
            Attribute a = olda;
            if (sfName == null) {
                if (minimize) {
                    a = Attribute.find(0, "SourceFile", "H");
                    a = a.addContent(new byte[2]);
                } else {
                    byte[] bytes = new byte[2];
                    sfName = Package.getRefString(obvious);
                    Object f = null;
                    f = Fixups.addRefWithBytes(f, bytes, sfName);
                    a = attrSourceFileSpecial.addContent(bytes, f);
                }
            } else if (obvious.equals(sfName.stringValue())) {
                if (minimize) {
                    a = attrSourceFileSpecial.addContent(new byte[2]);
                } else assert (false);
            }
            if (a != olda) {
                if (Package.this.verbose > 2) {
                    Utils.log.fine("recoding obvious SourceFile=" + obvious);
                }
                ArrayList<Attribute> newAttrs = new ArrayList<Attribute>(this.getAttributes());
                int where = newAttrs.indexOf(olda);
                newAttrs.set(where, a);
                this.setAttributes(newAttrs);
            }
        }

        void minimizeSourceFile() {
            this.transformSourceFile(true);
        }

        void expandSourceFile() {
            this.transformSourceFile(false);
        }

        @Override
        protected ConstantPool.Entry[] getCPMap() {
            return this.cpMap;
        }

        protected void setCPMap(ConstantPool.Entry[] cpMap) {
            this.cpMap = cpMap;
        }

        boolean hasBootstrapMethods() {
            return this.bootstrapMethods != null && !this.bootstrapMethods.isEmpty();
        }

        List<ConstantPool.BootstrapMethodEntry> getBootstrapMethods() {
            return this.bootstrapMethods;
        }

        ConstantPool.BootstrapMethodEntry[] getBootstrapMethodMap() {
            return this.hasBootstrapMethods() ? this.bootstrapMethods.toArray(new ConstantPool.BootstrapMethodEntry[this.bootstrapMethods.size()]) : null;
        }

        void setBootstrapMethods(Collection<ConstantPool.BootstrapMethodEntry> bsms) {
            assert (this.bootstrapMethods == null);
            this.bootstrapMethods = new ArrayList<ConstantPool.BootstrapMethodEntry>(bsms);
        }

        boolean hasInnerClasses() {
            return this.innerClasses != null;
        }

        List<InnerClass> getInnerClasses() {
            return this.innerClasses;
        }

        public void setInnerClasses(Collection<InnerClass> ics) {
            this.innerClasses = ics == null ? null : new ArrayList<InnerClass>(ics);
            Attribute a = this.getAttribute(attrInnerClassesEmpty);
            if (this.innerClasses != null && a == null) {
                this.addAttribute(attrInnerClassesEmpty.canonicalInstance());
            } else if (this.innerClasses == null && a != null) {
                this.removeAttribute(a);
            }
        }

        public List<InnerClass> computeGloballyImpliedICs() {
            HashSet<ConstantPool.Entry> cpRefs = new HashSet<ConstantPool.Entry>();
            ArrayList<InnerClass> innerClassesSaved = this.innerClasses;
            this.innerClasses = null;
            this.visitRefs(0, cpRefs);
            this.innerClasses = innerClassesSaved;
            ConstantPool.completeReferencesIn(cpRefs, true);
            HashSet<ConstantPool.Entry> icRefs = new HashSet<ConstantPool.Entry>();
            for (ConstantPool.Entry e : cpRefs) {
                InnerClass ic;
                if (!(e instanceof ConstantPool.ClassEntry)) continue;
                while (e != null && (ic = Package.this.getGlobalInnerClass(e)) != null && icRefs.add(e)) {
                    e = ic.outerClass;
                }
            }
            ArrayList<InnerClass> impliedICs = new ArrayList<InnerClass>();
            for (InnerClass ic : Package.this.allInnerClasses) {
                if (!icRefs.contains(ic.thisClass) && ic.outerClass != this.thisClass) continue;
                if (Package.this.verbose > 1) {
                    Utils.log.fine("Relevant IC: " + ic);
                }
                impliedICs.add(ic);
            }
            return impliedICs;
        }

        private List<InnerClass> computeICdiff() {
            List<InnerClass> impliedICs = this.computeGloballyImpliedICs();
            List<InnerClass> actualICs = this.getInnerClasses();
            if (actualICs == null) {
                actualICs = Collections.emptyList();
            }
            if (actualICs.isEmpty()) {
                return impliedICs;
            }
            if (impliedICs.isEmpty()) {
                return actualICs;
            }
            HashSet<InnerClass> center = new HashSet<InnerClass>(actualICs);
            center.retainAll(new HashSet<InnerClass>(impliedICs));
            impliedICs.addAll(actualICs);
            impliedICs.removeAll(center);
            return impliedICs;
        }

        void minimizeLocalICs() {
            List<Object> localICs;
            List<InnerClass> diff = this.computeICdiff();
            ArrayList<InnerClass> actualICs = this.innerClasses;
            if (diff.isEmpty()) {
                localICs = null;
                if (actualICs != null && actualICs.isEmpty() && Package.this.verbose > 0) {
                    Utils.log.info("Warning: Dropping empty InnerClasses attribute from " + this);
                }
            } else {
                localICs = actualICs == null ? Collections.emptyList() : diff;
            }
            this.setInnerClasses(localICs);
            if (Package.this.verbose > 1 && localICs != null) {
                Utils.log.fine("keeping local ICs in " + this + ": " + localICs);
            }
        }

        int expandLocalICs() {
            int changed;
            List<InnerClass> actualICs;
            ArrayList<InnerClass> localICs = this.innerClasses;
            if (localICs == null) {
                List<InnerClass> impliedICs = this.computeGloballyImpliedICs();
                if (impliedICs.isEmpty()) {
                    actualICs = null;
                    changed = 0;
                } else {
                    actualICs = impliedICs;
                    changed = 1;
                }
            } else if (localICs.isEmpty()) {
                actualICs = null;
                changed = -1;
            } else {
                actualICs = this.computeICdiff();
                changed = actualICs.containsAll(localICs) ? 1 : -1;
            }
            this.setInnerClasses(actualICs);
            return changed;
        }

        @Override
        public void trimToSize() {
            super.trimToSize();
            for (int isM = 0; isM <= 1; ++isM) {
                ArrayList<Member> members;
                ArrayList<Member> arrayList = members = isM == 0 ? this.fields : this.methods;
                if (members == null) continue;
                members.trimToSize();
                for (Member m : members) {
                    m.trimToSize();
                }
            }
            if (this.innerClasses != null) {
                this.innerClasses.trimToSize();
            }
        }

        @Override
        public void strip(String attrName) {
            if ("InnerClass".equals(attrName)) {
                this.innerClasses = null;
            }
            for (int isM = 0; isM <= 1; ++isM) {
                ArrayList<Member> members;
                ArrayList<Member> arrayList = members = isM == 0 ? this.fields : this.methods;
                if (members == null) continue;
                for (Member m : members) {
                    m.strip(attrName);
                }
            }
            super.strip(attrName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void visitRefs(int mode, Collection<ConstantPool.Entry> refs) {
            if (Package.this.verbose > 2) {
                Utils.log.fine("visitRefs " + this);
            }
            refs.add(this.thisClass);
            refs.add(this.superClass);
            refs.addAll(Arrays.asList(this.interfaces));
            for (int isM = 0; isM <= 1; ++isM) {
                ArrayList<Member> members;
                ArrayList<Member> arrayList = members = isM == 0 ? this.fields : this.methods;
                if (members == null) continue;
                for (Member m : members) {
                    boolean ok = false;
                    try {
                        m.visitRefs(mode, refs);
                        ok = true;
                    }
                    finally {
                        if (ok) continue;
                        Utils.log.warning("Error scanning " + m);
                    }
                }
            }
            this.visitInnerClassRefs(mode, refs);
            super.visitRefs(mode, refs);
        }

        protected void visitInnerClassRefs(int mode, Collection<ConstantPool.Entry> refs) {
            Package.visitInnerClassRefs(this.innerClasses, mode, refs);
        }

        void finishReading() {
            this.trimToSize();
            this.maybeChooseFileName();
        }

        public void initFile(File file) {
            assert (this.file == null);
            if (file == null) {
                file = Package.this.newStub(this.canonicalFileName());
            }
            this.file = file;
            assert (file.isClassStub());
            file.stubClass = this;
            this.maybeChooseFileName();
        }

        public void maybeChooseFileName() {
            if (this.thisClass == null) {
                return;
            }
            String canonName = this.canonicalFileName();
            if (this.file.nameString.isEmpty()) {
                this.file.nameString = canonName;
            }
            if (this.file.nameString.equals(canonName)) {
                this.file.name = Package.getRefString("");
                return;
            }
            if (this.file.name == null) {
                this.file.name = Package.getRefString(this.file.nameString);
            }
        }

        public String canonicalFileName() {
            if (this.thisClass == null) {
                return null;
            }
            return this.thisClass.stringValue() + ".class";
        }

        public java.io.File getFileName(java.io.File parent) {
            String name = this.file.name.stringValue();
            if (name.isEmpty()) {
                name = this.canonicalFileName();
            }
            String fname = name.replace('/', java.io.File.separatorChar);
            return new java.io.File(parent, fname);
        }

        public java.io.File getFileName() {
            return this.getFileName(null);
        }

        public String toString() {
            return this.thisClass.stringValue();
        }

        public abstract class Member
        extends Attribute.Holder
        implements Comparable<Member> {
            ConstantPool.DescriptorEntry descriptor;

            protected Member(int flags, ConstantPool.DescriptorEntry descriptor) {
                this.flags = flags;
                this.descriptor = descriptor;
            }

            public Class thisClass() {
                return Class.this;
            }

            public ConstantPool.DescriptorEntry getDescriptor() {
                return this.descriptor;
            }

            public String getName() {
                return this.descriptor.nameRef.stringValue();
            }

            public String getType() {
                return this.descriptor.typeRef.stringValue();
            }

            @Override
            protected ConstantPool.Entry[] getCPMap() {
                return Class.this.cpMap;
            }

            @Override
            protected void visitRefs(int mode, Collection<ConstantPool.Entry> refs) {
                if (Package.this.verbose > 2) {
                    Utils.log.fine("visitRefs " + this);
                }
                if (mode == 0) {
                    refs.add(this.descriptor.nameRef);
                    refs.add(this.descriptor.typeRef);
                } else {
                    refs.add(this.descriptor);
                }
                super.visitRefs(mode, refs);
            }

            public String toString() {
                return Class.this + "." + this.descriptor.prettyString();
            }
        }

        public class Method
        extends Member {
            Code code;

            public Method(int flags, ConstantPool.DescriptorEntry descriptor) {
                super(flags, descriptor);
                assert (descriptor.isMethod());
                if (Class.this.methods == null) {
                    Class.this.methods = new ArrayList();
                }
                boolean added = Class.this.methods.add(this);
                assert (added);
            }

            @Override
            public void trimToSize() {
                super.trimToSize();
                if (this.code != null) {
                    this.code.trimToSize();
                }
            }

            public int getArgumentSize() {
                int argSize = this.descriptor.typeRef.computeSize(true);
                int thisSize = Modifier.isStatic(this.flags) ? 0 : 1;
                return thisSize + argSize;
            }

            @Override
            public int compareTo(Member o) {
                Method that = (Method)o;
                return this.getDescriptor().compareTo(that.getDescriptor());
            }

            @Override
            public void strip(String attrName) {
                if ("Code".equals(attrName)) {
                    this.code = null;
                }
                if (this.code != null) {
                    this.code.strip(attrName);
                }
                super.strip(attrName);
            }

            @Override
            protected void visitRefs(int mode, Collection<ConstantPool.Entry> refs) {
                super.visitRefs(mode, refs);
                if (this.code != null) {
                    if (mode == 0) {
                        refs.add(Package.getRefString("Code"));
                    }
                    this.code.visitRefs(mode, refs);
                }
            }
        }

        public class Field
        extends Member {
            int order;

            public Field(int flags, ConstantPool.DescriptorEntry descriptor) {
                super(flags, descriptor);
                assert (!descriptor.isMethod());
                if (Class.this.fields == null) {
                    Class.this.fields = new ArrayList();
                }
                boolean added = Class.this.fields.add(this);
                assert (added);
                this.order = Class.this.fields.size();
            }

            public byte getLiteralTag() {
                return this.descriptor.getLiteralTag();
            }

            @Override
            public int compareTo(Member o) {
                Field that = (Field)o;
                return this.order - that.order;
            }
        }
    }

    public final class File
    implements Comparable<File> {
        String nameString;
        ConstantPool.Utf8Entry name;
        int modtime = 0;
        int options = 0;
        Class stubClass;
        ArrayList<byte[]> prepend = new ArrayList();
        ByteArrayOutputStream append = new ByteArrayOutputStream();

        File(ConstantPool.Utf8Entry name) {
            this.name = name;
            this.nameString = name.stringValue();
        }

        File(String nameString) {
            nameString = Package.fixupFileName(nameString);
            this.name = Package.getRefString(nameString);
            this.nameString = this.name.stringValue();
        }

        public boolean isDirectory() {
            return this.nameString.endsWith("/");
        }

        public boolean isClassStub() {
            return (this.options & 2) != 0;
        }

        public Class getStubClass() {
            assert (this.isClassStub());
            assert (this.stubClass != null);
            return this.stubClass;
        }

        public boolean isTrivialClassStub() {
            return this.isClassStub() && this.name.stringValue().isEmpty() && (this.modtime == 0 || this.modtime == Package.this.default_modtime) && (this.options & 0xFFFFFFFD) == 0;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != File.class) {
                return false;
            }
            File that = (File)o;
            return that.nameString.equals(this.nameString);
        }

        public int hashCode() {
            return this.nameString.hashCode();
        }

        @Override
        public int compareTo(File that) {
            return this.nameString.compareTo(that.nameString);
        }

        public String toString() {
            return this.nameString + "{" + (this.isClassStub() ? "*" : "") + (BandStructure.testBit(this.options, 1) ? "@" : "") + (this.modtime == 0 ? "" : "M" + this.modtime) + (this.getFileLength() == 0L ? "" : "[" + this.getFileLength() + "]") + "}";
        }

        public java.io.File getFileName() {
            return this.getFileName(null);
        }

        public java.io.File getFileName(java.io.File parent) {
            String lname = this.nameString;
            String fname = lname.replace('/', java.io.File.separatorChar);
            return new java.io.File(parent, fname);
        }

        public void addBytes(byte[] bytes) {
            this.addBytes(bytes, 0, bytes.length);
        }

        public void addBytes(byte[] bytes, int off, int len) {
            if ((this.append.size() | len) << 2 < 0) {
                this.prepend.add(this.append.toByteArray());
                this.append.reset();
            }
            this.append.write(bytes, off, len);
        }

        public long getFileLength() {
            long len = 0L;
            if (this.prepend == null || this.append == null) {
                return 0L;
            }
            for (byte[] block : this.prepend) {
                len += (long)block.length;
            }
            return len += (long)this.append.size();
        }

        public void writeTo(OutputStream out) throws IOException {
            if (this.prepend == null || this.append == null) {
                return;
            }
            for (byte[] block : this.prepend) {
                out.write(block);
            }
            this.append.writeTo(out);
        }

        public void readFrom(InputStream in) throws IOException {
            int nr;
            byte[] buf = new byte[65536];
            while ((nr = in.read(buf)) > 0) {
                this.addBytes(buf, 0, nr);
            }
        }

        public InputStream getInputStream() {
            ByteArrayInputStream in = new ByteArrayInputStream(this.append.toByteArray());
            if (this.prepend.isEmpty()) {
                return in;
            }
            ArrayList<ByteArrayInputStream> isa = new ArrayList<ByteArrayInputStream>(this.prepend.size() + 1);
            for (byte[] bytes : this.prepend) {
                isa.add(new ByteArrayInputStream(bytes));
            }
            isa.add(in);
            return new SequenceInputStream(Collections.enumeration(isa));
        }

        protected void visitRefs(int mode, Collection<ConstantPool.Entry> refs) {
            assert (this.name != null);
            refs.add(this.name);
        }
    }

    static class InnerClass
    implements Comparable<InnerClass> {
        final ConstantPool.ClassEntry thisClass;
        final ConstantPool.ClassEntry outerClass;
        final ConstantPool.Utf8Entry name;
        final int flags;
        final boolean predictable;

        InnerClass(ConstantPool.ClassEntry thisClass, ConstantPool.ClassEntry outerClass, ConstantPool.Utf8Entry name, int flags) {
            this.thisClass = thisClass;
            this.outerClass = outerClass;
            this.name = name;
            this.flags = flags;
            this.predictable = this.computePredictable();
        }

        private boolean computePredictable() {
            String[] parse = Package.parseInnerClassName(this.thisClass.stringValue());
            if (parse == null) {
                return false;
            }
            String pkgOuter = parse[0];
            String lname = parse[2];
            String haveName = this.name == null ? null : this.name.stringValue();
            String haveOuter = this.outerClass == null ? null : this.outerClass.stringValue();
            boolean lpredictable = lname == haveName && pkgOuter == haveOuter;
            return lpredictable;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != InnerClass.class) {
                return false;
            }
            InnerClass that = (InnerClass)o;
            return InnerClass.eq(this.thisClass, that.thisClass) && InnerClass.eq(this.outerClass, that.outerClass) && InnerClass.eq(this.name, that.name) && this.flags == that.flags;
        }

        private static boolean eq(Object x, Object y) {
            return x == null ? y == null : x.equals(y);
        }

        public int hashCode() {
            return this.thisClass.hashCode();
        }

        @Override
        public int compareTo(InnerClass that) {
            return this.thisClass.compareTo(that.thisClass);
        }

        protected void visitRefs(int mode, Collection<ConstantPool.Entry> refs) {
            refs.add(this.thisClass);
            if (mode == 0 || !this.predictable) {
                refs.add(this.outerClass);
                refs.add(this.name);
            }
        }

        public String toString() {
            return this.thisClass.stringValue();
        }
    }
}

