/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.pack200.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glavo.pack200.impl.Attribute;
import org.glavo.pack200.impl.BandStructure;
import org.glavo.pack200.impl.Code;
import org.glavo.pack200.impl.Coding;
import org.glavo.pack200.impl.CodingChooser;
import org.glavo.pack200.impl.CodingMethod;
import org.glavo.pack200.impl.ConstantPool;
import org.glavo.pack200.impl.Constants;
import org.glavo.pack200.impl.FixedList;
import org.glavo.pack200.impl.Instruction;
import org.glavo.pack200.impl.Package;
import org.glavo.pack200.impl.Utils;

class PackageWriter
extends BandStructure {
    Package pkg;
    OutputStream finalOut;
    Package.Version packageVersion;
    Set<ConstantPool.Entry> requiredEntries;
    Map<Attribute.Layout, int[]> backCountTable;
    int[][] attrCounts;
    int[] maxFlags;
    List<Map<Attribute.Layout, int[]>> allLayouts;
    Attribute.Layout[] attrDefsWritten;
    private Code curCode;
    private Package.Class curClass;
    private ConstantPool.Entry[] curCPMap;
    int[] codeHist = new int[256];
    int[] ldcHist = new int[20];

    PackageWriter(Package pkg, OutputStream out) throws IOException {
        this.pkg = pkg;
        this.finalOut = out;
        this.initHighestClassVersion(pkg.getHighestClassVersion());
    }

    void write() throws IOException {
        boolean ok = false;
        try {
            if (this.verbose > 0) {
                Utils.log.info("Setting up constant pool...");
            }
            this.setup();
            if (this.verbose > 0) {
                Utils.log.info("Packing...");
            }
            this.writeConstantPool();
            this.writeFiles();
            this.writeAttrDefs();
            this.writeInnerClasses();
            this.writeClassesAndByteCodes();
            this.writeAttrCounts();
            if (this.verbose > 1) {
                this.printCodeHist();
            }
            if (this.verbose > 0) {
                Utils.log.info("Coding...");
            }
            this.all_bands.chooseBandCodings();
            this.writeFileHeader();
            this.writeAllBandsTo(this.finalOut);
            ok = true;
        }
        catch (Exception ee) {
            Utils.log.warning("Error on output: " + ee, ee);
            if (this.verbose > 0) {
                this.finalOut.close();
            }
            if (ee instanceof IOException) {
                throw (IOException)ee;
            }
            if (ee instanceof RuntimeException) {
                throw (RuntimeException)ee;
            }
            throw new Error("error packing", ee);
        }
    }

    void setup() {
        this.requiredEntries = new HashSet<ConstantPool.Entry>();
        this.setArchiveOptions();
        this.trimClassAttributes();
        this.collectAttributeLayouts();
        this.pkg.buildGlobalConstantPool(this.requiredEntries);
        this.setBandIndexes();
        this.makeNewAttributeBands();
        this.collectInnerClasses();
    }

    void chooseDefaultPackageVersion() throws IOException {
        if (this.pkg.packageVersion != null) {
            this.packageVersion = this.pkg.packageVersion;
            if (this.verbose > 0) {
                Utils.log.info("package version overridden with: " + this.packageVersion);
            }
            return;
        }
        Package.Version highV = this.getHighestClassVersion();
        this.packageVersion = highV.lessThan(Constants.JAVA6_MAX_CLASS_VERSION) ? Constants.JAVA5_PACKAGE_VERSION : (highV.equals(Constants.JAVA6_MAX_CLASS_VERSION) || highV.equals(Constants.JAVA7_MAX_CLASS_VERSION) && !this.pkg.cp.haveExtraTags() ? Constants.JAVA6_PACKAGE_VERSION : (highV.equals(Constants.JAVA7_MAX_CLASS_VERSION) ? Constants.JAVA7_PACKAGE_VERSION : Constants.JAVA8_PACKAGE_VERSION));
        if (this.verbose > 0) {
            Utils.log.info("Highest version class file: " + highV + " package version: " + this.packageVersion);
        }
    }

    void checkVersion() throws IOException {
        assert (this.packageVersion != null);
        if (this.packageVersion.lessThan(Constants.JAVA7_PACKAGE_VERSION) && PackageWriter.testBit(this.archiveOptions, 8)) {
            throw new IOException("Format bits for Java 7 must be zero in previous releases");
        }
        if (PackageWriter.testBit(this.archiveOptions, -8192)) {
            throw new IOException("High archive option bits are reserved and must be zero: " + Integer.toHexString(this.archiveOptions));
        }
    }

    void setArchiveOptions() {
        int minModtime = this.pkg.default_modtime;
        int maxModtime = this.pkg.default_modtime;
        int minOptions = -1;
        int maxOptions = 0;
        this.archiveOptions |= this.pkg.default_options;
        for (Package.File file : this.pkg.files) {
            int modtime = file.modtime;
            int options = file.options;
            if (minModtime == 0) {
                minModtime = maxModtime = modtime;
            } else {
                if (minModtime > modtime) {
                    minModtime = modtime;
                }
                if (maxModtime < modtime) {
                    maxModtime = modtime;
                }
            }
            minOptions &= options;
            maxOptions |= options;
        }
        if (this.pkg.default_modtime == 0) {
            this.pkg.default_modtime = minModtime;
        }
        if (minModtime != 0 && minModtime != maxModtime) {
            this.archiveOptions |= 0x40;
        }
        if (!PackageWriter.testBit(this.archiveOptions, 32) && minOptions != -1) {
            if (PackageWriter.testBit(minOptions, 1)) {
                this.archiveOptions |= 0x20;
                --minOptions;
                --maxOptions;
            }
            this.pkg.default_options |= minOptions;
            if (minOptions != maxOptions || minOptions != this.pkg.default_options) {
                this.archiveOptions |= 0x80;
            }
        }
        HashMap<Package.Version, int[]> verCounts = new HashMap<Package.Version, int[]>();
        int bestCount = 0;
        Package.Version bestVersion = null;
        for (Package.Class cls : this.pkg.classes) {
            int count;
            Package.Version version = cls.getVersion();
            int[] var = (int[])verCounts.get(version);
            if (var == null) {
                var = new int[1];
                verCounts.put(version, var);
            }
            if (bestCount >= (count = (var[0] = var[0] + 1))) continue;
            bestCount = count;
            bestVersion = version;
        }
        verCounts.clear();
        if (bestVersion == null) {
            bestVersion = Constants.JAVA_MIN_CLASS_VERSION;
        }
        this.pkg.defaultClassVersion = bestVersion;
        if (this.verbose > 0) {
            Utils.log.info("Consensus version number in segment is " + bestVersion);
        }
        if (this.verbose > 0) {
            Utils.log.info("Highest version number in segment is " + this.pkg.getHighestClassVersion());
        }
        for (Package.Class cls : this.pkg.classes) {
            if (cls.getVersion().equals(bestVersion)) continue;
            Attribute a = this.makeClassFileVersionAttr(cls.getVersion());
            if (this.verbose > 1) {
                Utils.log.fine("Version " + cls.getVersion() + " of " + cls + " doesn't match package version " + bestVersion);
            }
            cls.addAttribute(a);
        }
        for (Package.File file : this.pkg.files) {
            long len = file.getFileLength();
            if (len == (long)((int)len)) continue;
            this.archiveOptions |= 0x100;
            if (this.verbose <= 0) break;
            Utils.log.info("Note: Huge resource file " + file.getFileName() + " forces 64-bit sizing");
            break;
        }
        int cost0 = 0;
        int cost1 = 0;
        for (Package.Class cls : this.pkg.classes) {
            for (Package.Class.Method m : cls.getMethods()) {
                if (m.code == null) continue;
                if (m.code.attributeSize() == 0) {
                    ++cost1;
                    continue;
                }
                if (PackageWriter.shortCodeHeader(m.code) == 0) continue;
                cost0 += 3;
            }
        }
        if (cost0 > cost1) {
            this.archiveOptions |= 4;
        }
        if (this.verbose > 0) {
            Utils.log.info("archiveOptions = 0b" + Integer.toBinaryString(this.archiveOptions));
        }
    }

    void writeFileHeader() throws IOException {
        this.chooseDefaultPackageVersion();
        this.writeArchiveMagic();
        this.writeArchiveHeader();
    }

    private void putMagicInt32(int val) throws IOException {
        int res = val;
        for (int i = 0; i < 4; ++i) {
            this.archive_magic.putByte(0xFF & res >>> 24);
            res <<= 8;
        }
    }

    void writeArchiveMagic() throws IOException {
        this.putMagicInt32(this.pkg.magic);
    }

    void writeArchiveHeader() throws IOException {
        boolean haveCPExtra;
        boolean haveNumbers;
        boolean haveFiles;
        int headerSizeForDebug = 15;
        boolean haveSpecial = PackageWriter.testBit(this.archiveOptions, 1);
        if (!haveSpecial) {
            haveSpecial |= this.band_headers.length() != 0;
            if (haveSpecial |= this.attrDefsWritten.length != 0) {
                this.archiveOptions |= 1;
            }
        }
        if (haveSpecial) {
            headerSizeForDebug += 2;
        }
        if (!(haveFiles = PackageWriter.testBit(this.archiveOptions, 16))) {
            haveFiles |= this.archiveNextCount > 0;
            if (haveFiles |= this.pkg.default_modtime != 0) {
                this.archiveOptions |= 0x10;
            }
        }
        if (haveFiles) {
            headerSizeForDebug += 5;
        }
        if (!(haveNumbers = PackageWriter.testBit(this.archiveOptions, 2)) && (haveNumbers |= this.pkg.cp.haveNumbers())) {
            this.archiveOptions |= 2;
        }
        if (haveNumbers) {
            headerSizeForDebug += 4;
        }
        if (!(haveCPExtra = PackageWriter.testBit(this.archiveOptions, 8)) && (haveCPExtra |= this.pkg.cp.haveExtraTags())) {
            this.archiveOptions |= 8;
        }
        if (haveCPExtra) {
            headerSizeForDebug += 4;
        }
        this.checkVersion();
        this.archive_header_0.putInt(this.packageVersion.minor);
        this.archive_header_0.putInt(this.packageVersion.major);
        if (this.verbose > 0) {
            Utils.log.info("Package Version for this segment:" + this.packageVersion);
        }
        this.archive_header_0.putInt(this.archiveOptions);
        assert (this.archive_header_0.length() == 3);
        boolean DUMMY = false;
        if (haveFiles) {
            assert (this.archive_header_S.length() == 0);
            this.archive_header_S.putInt(0);
            assert (this.archive_header_S.length() == 1);
            this.archive_header_S.putInt(0);
            assert (this.archive_header_S.length() == 2);
        }
        if (haveFiles) {
            this.archive_header_1.putInt(this.archiveNextCount);
            this.archive_header_1.putInt(this.pkg.default_modtime);
            this.archive_header_1.putInt(this.pkg.files.size());
        } else assert (this.pkg.files.isEmpty());
        if (haveSpecial) {
            this.archive_header_1.putInt(this.band_headers.length());
            this.archive_header_1.putInt(this.attrDefsWritten.length);
        } else {
            assert (this.band_headers.length() == 0);
            assert (this.attrDefsWritten.length == 0);
        }
        this.writeConstantPoolCounts(haveNumbers, haveCPExtra);
        this.archive_header_1.putInt(this.pkg.getAllInnerClasses().size());
        this.archive_header_1.putInt(this.pkg.defaultClassVersion.minor);
        this.archive_header_1.putInt(this.pkg.defaultClassVersion.major);
        this.archive_header_1.putInt(this.pkg.classes.size());
        assert (this.archive_header_0.length() + this.archive_header_S.length() + this.archive_header_1.length() == headerSizeForDebug);
        this.archiveSize0 = 0L;
        this.archiveSize1 = this.all_bands.outputSize();
        this.archiveSize0 += this.archive_magic.outputSize();
        this.archiveSize0 += this.archive_header_0.outputSize();
        this.archiveSize0 += this.archive_header_S.outputSize();
        this.archiveSize1 -= this.archiveSize0;
        if (haveFiles) {
            int archiveSizeHi = (int)(this.archiveSize1 >>> 32);
            int archiveSizeLo = (int)(this.archiveSize1 >>> 0);
            this.archive_header_S.patchValue(0, archiveSizeHi);
            this.archive_header_S.patchValue(1, archiveSizeLo);
            int zeroLen = UNSIGNED5.getLength(0);
            this.archiveSize0 += (long)(UNSIGNED5.getLength(archiveSizeHi) - zeroLen);
            this.archiveSize0 += (long)(UNSIGNED5.getLength(archiveSizeLo) - zeroLen);
        }
        if (this.verbose > 1) {
            Utils.log.fine("archive sizes: " + this.archiveSize0 + "+" + this.archiveSize1);
        }
        assert (this.all_bands.outputSize() == this.archiveSize0 + this.archiveSize1);
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeConstantPoolCounts(boolean haveNumbers, boolean haveCPExtra) throws IOException {
        byte[] byArray = ConstantPool.TAGS_IN_ORDER;
        int n = byArray.length;
        int n2 = 0;
        while (true) {
            block10: {
                if (n2 >= n) {
                    return;
                }
                byte tag = byArray[n2];
                int count = this.pkg.cp.getIndexByTag(tag).size();
                switch (tag) {
                    case 1: {
                        if (count > 0) assert (this.pkg.cp.getIndexByTag(tag).get(0) == ConstantPool.getUtf8Entry(""));
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        if (haveNumbers) break;
                        assert (count == 0);
                        break block10;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        if (haveCPExtra) break;
                        assert (count == 0);
                        break block10;
                    }
                }
                this.archive_header_1.putInt(count);
            }
            ++n2;
        }
    }

    @Override
    protected ConstantPool.Index getCPIndex(byte tag) {
        return this.pkg.cp.getIndexByTag(tag);
    }

    void writeConstantPool() throws IOException {
        ConstantPool.IndexGroup cp = this.pkg.cp;
        if (this.verbose > 0) {
            Utils.log.info("Writing CP");
        }
        block28: for (byte tag : ConstantPool.TAGS_IN_ORDER) {
            ConstantPool.Index index = cp.getIndexByTag(tag);
            ConstantPool.Entry[] cpMap = index.cpMap;
            if (this.verbose > 0) {
                Utils.log.info("Writing " + cpMap.length + " " + ConstantPool.tagName(tag) + " entries...");
            }
            if (this.optDumpBands) {
                try (PrintStream ps = new PrintStream(PackageWriter.getDumpStream(index, ".idx"));){
                    PackageWriter.printArrayTo(ps, cpMap, 0, cpMap.length);
                }
            }
            switch (tag) {
                case 1: {
                    this.writeUtf8Bands(cpMap);
                    continue block28;
                }
                case 3: {
                    ConstantPool.Entry e;
                    for (int i = 0; i < cpMap.length; ++i) {
                        e = (ConstantPool.NumberEntry)cpMap[i];
                        int x = (Integer)((ConstantPool.NumberEntry)e).numberValue();
                        this.cp_Int.putInt(x);
                    }
                    continue block28;
                }
                case 4: {
                    ConstantPool.Entry e;
                    for (int i = 0; i < cpMap.length; ++i) {
                        e = (ConstantPool.NumberEntry)cpMap[i];
                        float fx = ((Float)((ConstantPool.NumberEntry)e).numberValue()).floatValue();
                        int x = Float.floatToIntBits(fx);
                        this.cp_Float.putInt(x);
                    }
                    continue block28;
                }
                case 5: {
                    ConstantPool.Entry e;
                    for (int i = 0; i < cpMap.length; ++i) {
                        e = (ConstantPool.NumberEntry)cpMap[i];
                        long x = (Long)((ConstantPool.NumberEntry)e).numberValue();
                        this.cp_Long_hi.putInt((int)(x >>> 32));
                        this.cp_Long_lo.putInt((int)(x >>> 0));
                    }
                    continue block28;
                }
                case 6: {
                    ConstantPool.Entry e;
                    for (int i = 0; i < cpMap.length; ++i) {
                        e = (ConstantPool.NumberEntry)cpMap[i];
                        double dx = (Double)((ConstantPool.NumberEntry)e).numberValue();
                        long x = Double.doubleToLongBits(dx);
                        this.cp_Double_hi.putInt((int)(x >>> 32));
                        this.cp_Double_lo.putInt((int)(x >>> 0));
                    }
                    continue block28;
                }
                case 8: {
                    ConstantPool.Entry e;
                    for (int i = 0; i < cpMap.length; ++i) {
                        e = (ConstantPool.StringEntry)cpMap[i];
                        this.cp_String.putRef(((ConstantPool.StringEntry)e).ref);
                    }
                    continue block28;
                }
                case 7: {
                    ConstantPool.Entry e;
                    for (int i = 0; i < cpMap.length; ++i) {
                        e = (ConstantPool.ClassEntry)cpMap[i];
                        this.cp_Class.putRef(((ConstantPool.ClassEntry)e).ref);
                    }
                    continue block28;
                }
                case 13: {
                    this.writeSignatureBands(cpMap);
                    continue block28;
                }
                case 12: {
                    ConstantPool.Entry e;
                    for (int i = 0; i < cpMap.length; ++i) {
                        e = (ConstantPool.DescriptorEntry)cpMap[i];
                        this.cp_Descr_name.putRef(((ConstantPool.DescriptorEntry)e).nameRef);
                        this.cp_Descr_type.putRef(((ConstantPool.DescriptorEntry)e).typeRef);
                    }
                    continue block28;
                }
                case 9: {
                    this.writeMemberRefs(tag, cpMap, this.cp_Field_class, this.cp_Field_desc);
                    continue block28;
                }
                case 10: {
                    this.writeMemberRefs(tag, cpMap, this.cp_Method_class, this.cp_Method_desc);
                    continue block28;
                }
                case 11: {
                    this.writeMemberRefs(tag, cpMap, this.cp_Imethod_class, this.cp_Imethod_desc);
                    continue block28;
                }
                case 15: {
                    ConstantPool.Entry e;
                    for (int i = 0; i < cpMap.length; ++i) {
                        e = (ConstantPool.MethodHandleEntry)cpMap[i];
                        this.cp_MethodHandle_refkind.putInt(((ConstantPool.MethodHandleEntry)e).refKind);
                        this.cp_MethodHandle_member.putRef(((ConstantPool.MethodHandleEntry)e).memRef);
                    }
                    continue block28;
                }
                case 16: {
                    ConstantPool.Entry e;
                    for (int i = 0; i < cpMap.length; ++i) {
                        e = (ConstantPool.MethodTypeEntry)cpMap[i];
                        this.cp_MethodType.putRef(((ConstantPool.MethodTypeEntry)e).typeRef);
                    }
                    continue block28;
                }
                case 18: {
                    ConstantPool.Entry e;
                    for (int i = 0; i < cpMap.length; ++i) {
                        e = (ConstantPool.InvokeDynamicEntry)cpMap[i];
                        this.cp_InvokeDynamic_spec.putRef(((ConstantPool.InvokeDynamicEntry)e).bssRef);
                        this.cp_InvokeDynamic_desc.putRef(((ConstantPool.InvokeDynamicEntry)e).descRef);
                    }
                    continue block28;
                }
                case 17: {
                    ConstantPool.Entry e;
                    for (int i = 0; i < cpMap.length; ++i) {
                        e = (ConstantPool.BootstrapMethodEntry)cpMap[i];
                        this.cp_BootstrapMethod_ref.putRef(((ConstantPool.BootstrapMethodEntry)e).bsmRef);
                        this.cp_BootstrapMethod_arg_count.putInt(((ConstantPool.BootstrapMethodEntry)e).argRefs.length);
                        for (ConstantPool.Entry argRef : ((ConstantPool.BootstrapMethodEntry)e).argRefs) {
                            this.cp_BootstrapMethod_arg.putRef(argRef);
                        }
                    }
                    continue block28;
                }
                default: {
                    throw new AssertionError((Object)"unexpected CP tag in package");
                }
            }
        }
        if (this.optDumpBands || this.verbose > 1) {
            for (byte tag = 50; tag < 54; tag = (byte)(tag + 1)) {
                ConstantPool.Index index = cp.getIndexByTag(tag);
                if (index == null || index.isEmpty()) continue;
                ConstantPool.Entry[] cpMap = index.cpMap;
                if (this.verbose > 1) {
                    Utils.log.info("Index group " + ConstantPool.tagName(tag) + " contains " + cpMap.length + " entries.");
                }
                if (!this.optDumpBands) continue;
                try (PrintStream ps = new PrintStream(PackageWriter.getDumpStream(index.debugName, tag, ".gidx", index));){
                    PackageWriter.printArrayTo(ps, cpMap, 0, cpMap.length, true);
                    continue;
                }
            }
        }
    }

    void writeUtf8Bands(ConstantPool.Entry[] cpMap) throws IOException {
        int i;
        if (cpMap.length == 0) {
            return;
        }
        assert (cpMap[0].stringValue().isEmpty());
        boolean SUFFIX_SKIP_1 = true;
        int PREFIX_SKIP_2 = 2;
        char[][] chars = new char[cpMap.length][];
        for (int i2 = 0; i2 < chars.length; ++i2) {
            chars[i2] = cpMap[i2].stringValue().toCharArray();
        }
        int[] prefixes = new int[cpMap.length];
        char[] prevChars = new char[]{};
        for (i = 0; i < chars.length; ++i) {
            int prefix;
            char[] curChars = chars[i];
            int limit = Math.min(curChars.length, prevChars.length);
            for (prefix = 0; prefix < limit && curChars[prefix] == prevChars[prefix]; ++prefix) {
            }
            prefixes[i] = prefix;
            if (i >= 2) {
                this.cp_Utf8_prefix.putInt(prefix);
            } else assert (prefix == 0);
            prevChars = curChars;
        }
        for (i = 0; i < chars.length; ++i) {
            char[] str = chars[i];
            int prefix = prefixes[i];
            int suffix = str.length - prefixes[i];
            boolean isPacked = false;
            if (suffix == 0) {
                isPacked = i >= 1;
            } else if (this.optBigStrings && this.effort > 1 && suffix > 100) {
                int numWide = 0;
                for (int n = 0; n < suffix; ++n) {
                    if (str[prefix + n] <= '\u007f') continue;
                    ++numWide;
                }
                if (numWide > 100) {
                    isPacked = this.tryAlternateEncoding(i, numWide, str, prefix);
                }
            }
            if (i < 1) {
                assert (!isPacked);
                assert (suffix == 0);
                continue;
            }
            if (isPacked) {
                this.cp_Utf8_suffix.putInt(0);
                this.cp_Utf8_big_suffix.putInt(suffix);
                continue;
            }
            assert (suffix != 0);
            this.cp_Utf8_suffix.putInt(suffix);
            for (int n = 0; n < suffix; ++n) {
                char ch = str[prefix + n];
                this.cp_Utf8_chars.putInt(ch);
            }
        }
        if (this.verbose > 0) {
            int normCharCount = this.cp_Utf8_chars.length();
            int packCharCount = this.cp_Utf8_big_chars.length();
            int charCount = normCharCount + packCharCount;
            Utils.log.info("Utf8string #CHARS=" + charCount + " #PACKEDCHARS=" + packCharCount);
        }
    }

    private boolean tryAlternateEncoding(int i, int numWide, char[] str, int prefix) {
        int suffix = str.length - prefix;
        int[] cvals = new int[suffix];
        for (int n = 0; n < suffix; ++n) {
            cvals[n] = str[prefix + n];
        }
        CodingChooser cc = this.getCodingChooser();
        Coding bigRegular = this.cp_Utf8_big_chars.regularCoding;
        String bandName = "(Utf8_big_" + i + ")";
        int[] sizes = new int[]{0, 0};
        boolean BYTE_SIZE = false;
        boolean ZIP_SIZE = true;
        if (this.verbose > 1 || cc.verbose > 1) {
            Utils.log.fine("--- chooseCoding " + bandName);
        }
        CodingMethod special = cc.choose(cvals, bigRegular, sizes);
        Coding charRegular = this.cp_Utf8_chars.regularCoding;
        if (this.verbose > 1) {
            Utils.log.fine("big string[" + i + "] len=" + suffix + " #wide=" + numWide + " size=" + sizes[0] + "/z=" + sizes[1] + " coding " + special);
        }
        if (special != charRegular) {
            int specialZipSize = sizes[1];
            int[] normalSizes = cc.computeSize(charRegular, cvals);
            int normalZipSize = normalSizes[1];
            int minWin = Math.max(5, normalZipSize / 1000);
            if (this.verbose > 1) {
                Utils.log.fine("big string[" + i + "] normalSize=" + normalSizes[0] + "/z=" + normalSizes[1] + " win=" + (specialZipSize < normalZipSize - minWin));
            }
            if (specialZipSize < normalZipSize - minWin) {
                BandStructure.IntBand big = this.cp_Utf8_big_chars.newIntBand(bandName);
                big.initializeValues(cvals);
                return true;
            }
        }
        return false;
    }

    void writeSignatureBands(ConstantPool.Entry[] cpMap) throws IOException {
        for (int i = 0; i < cpMap.length; ++i) {
            ConstantPool.SignatureEntry e = (ConstantPool.SignatureEntry)cpMap[i];
            this.cp_Signature_form.putRef(e.formRef);
            for (int j = 0; j < e.classRefs.length; ++j) {
                this.cp_Signature_classes.putRef(e.classRefs[j]);
            }
        }
    }

    void writeMemberRefs(byte tag, ConstantPool.Entry[] cpMap, BandStructure.CPRefBand cp_class, BandStructure.CPRefBand cp_desc) throws IOException {
        for (int i = 0; i < cpMap.length; ++i) {
            ConstantPool.MemberEntry e = (ConstantPool.MemberEntry)cpMap[i];
            cp_class.putRef(e.classRef);
            cp_desc.putRef(e.descRef);
        }
    }

    void writeFiles() throws IOException {
        int numFiles = this.pkg.files.size();
        if (numFiles == 0) {
            return;
        }
        int options = this.archiveOptions;
        boolean haveSizeHi = PackageWriter.testBit(options, 256);
        boolean haveModtime = PackageWriter.testBit(options, 64);
        boolean haveOptions = PackageWriter.testBit(options, 128);
        if (!haveOptions) {
            for (Package.File file : this.pkg.files) {
                if (!file.isClassStub()) continue;
                haveOptions = true;
                this.archiveOptions = options |= 0x80;
                break;
            }
        }
        if (haveSizeHi || haveModtime || haveOptions || !this.pkg.files.isEmpty()) {
            this.archiveOptions = options |= 0x10;
        }
        for (Package.File file : this.pkg.files) {
            this.file_name.putRef(file.name);
            long len = file.getFileLength();
            this.file_size_lo.putInt((int)len);
            if (haveSizeHi) {
                this.file_size_hi.putInt((int)(len >>> 32));
            }
            if (haveModtime) {
                this.file_modtime.putInt(file.modtime - this.pkg.default_modtime);
            }
            if (haveOptions) {
                this.file_options.putInt(file.options);
            }
            file.writeTo(this.file_bits.collectorStream());
            if (this.verbose <= 1) continue;
            Utils.log.fine("Wrote " + len + " bytes of " + file.name.stringValue());
        }
        if (this.verbose > 0) {
            Utils.log.info("Wrote " + numFiles + " resource files");
        }
    }

    void collectAttributeLayouts() {
        int i;
        this.maxFlags = new int[4];
        this.allLayouts = new FixedList<Map<Attribute.Layout, int[]>>(4);
        for (int i2 = 0; i2 < 4; ++i2) {
            this.allLayouts.set(i2, new HashMap());
        }
        for (Package.Class cls : this.pkg.classes) {
            this.visitAttributeLayoutsIn(0, cls);
            for (Package.Class.Field f : cls.getFields()) {
                this.visitAttributeLayoutsIn(1, f);
            }
            for (Package.Class.Method m : cls.getMethods()) {
                this.visitAttributeLayoutsIn(2, m);
                if (m.code == null) continue;
                this.visitAttributeLayoutsIn(3, m.code);
            }
        }
        for (i = 0; i < 4; ++i) {
            int nl = this.allLayouts.get(i).size();
            boolean haveLongFlags = this.haveFlagsHi(i);
            int TOO_MANY_ATTRS = 24;
            if (nl >= 24) {
                int mask = 1 << 9 + i;
                this.archiveOptions |= mask;
                haveLongFlags = true;
                if (this.verbose > 0) {
                    Utils.log.info("Note: Many " + Attribute.contextName(i) + " attributes forces 63-bit flags");
                }
            }
            if (this.verbose > 1) {
                Utils.log.fine(Attribute.contextName(i) + ".maxFlags = 0x" + Integer.toHexString(this.maxFlags[i]));
                Utils.log.fine(Attribute.contextName(i) + ".#layouts = " + nl);
            }
            assert (this.haveFlagsHi(i) == haveLongFlags);
        }
        this.initAttrIndexLimit();
        for (i = 0; i < 4; ++i) {
            assert ((this.attrFlagMask[i] & (long)this.maxFlags[i]) == 0L);
        }
        this.backCountTable = new HashMap<Attribute.Layout, int[]>();
        this.attrCounts = new int[4][];
        for (i = 0; i < 4; ++i) {
            long avHiBits = ((long)this.maxFlags[i] | this.attrFlagMask[i]) ^ 0xFFFFFFFFFFFFFFFFL;
            assert (this.attrIndexLimit[i] > 0);
            assert (this.attrIndexLimit[i] < 64);
            avHiBits &= (1L << this.attrIndexLimit[i]) - 1L;
            int nextLoBit = 0;
            Map<Attribute.Layout, int[]> defMap = this.allLayouts.get(i);
            Map.Entry[] layoutsAndCounts = new Map.Entry[defMap.size()];
            defMap.entrySet().toArray(layoutsAndCounts);
            Arrays.sort(layoutsAndCounts, (e0, e1) -> {
                int r = -(((int[])e0.getValue())[0] - ((int[])e1.getValue())[0]);
                if (r != 0) {
                    return r;
                }
                return ((Attribute.Layout)e0.getKey()).compareTo((Attribute.Layout)e1.getKey());
            });
            this.attrCounts[i] = new int[this.attrIndexLimit[i] + layoutsAndCounts.length];
            for (int j = 0; j < layoutsAndCounts.length; ++j) {
                int index;
                Map.Entry e = layoutsAndCounts[j];
                Attribute.Layout def = (Attribute.Layout)e.getKey();
                int count = ((int[])e.getValue())[0];
                Integer predefIndex = (Integer)this.attrIndexTable.get(def);
                if (predefIndex != null) {
                    index = predefIndex;
                } else if (avHiBits != 0L) {
                    while ((avHiBits & 1L) == 0L) {
                        avHiBits >>>= 1;
                        ++nextLoBit;
                    }
                    --avHiBits;
                    index = this.setAttributeLayoutIndex(def, nextLoBit);
                } else {
                    index = this.setAttributeLayoutIndex(def, -1);
                }
                this.attrCounts[i][index] = count;
                Attribute.Layout.Element[] cbles = def.getCallables();
                int[] bc = new int[cbles.length];
                for (int k = 0; k < cbles.length; ++k) {
                    assert (cbles[k].kind == 10);
                    if (cbles[k].flagTest((byte)8)) continue;
                    bc[k] = -1;
                }
                this.backCountTable.put(def, bc);
                if (predefIndex != null) continue;
                ConstantPool.Utf8Entry ne = ConstantPool.getUtf8Entry(def.name());
                String layout = def.layoutForClassVersion(this.getHighestClassVersion());
                ConstantPool.Utf8Entry le = ConstantPool.getUtf8Entry(layout);
                this.requiredEntries.add(ne);
                this.requiredEntries.add(le);
                if (this.verbose <= 0) continue;
                if (index < this.attrIndexLimit[i]) {
                    Utils.log.info("Using free flag bit 1<<" + index + " for " + count + " occurrences of " + def);
                    continue;
                }
                Utils.log.info("Using overflow index " + index + " for " + count + " occurrences of " + def);
            }
        }
        this.maxFlags = null;
        this.allLayouts = null;
    }

    void visitAttributeLayoutsIn(int ctype, Attribute.Holder h) {
        int n = ctype;
        this.maxFlags[n] = this.maxFlags[n] | h.flags;
        for (Attribute a : h.getAttributes()) {
            Attribute.Layout def = a.layout();
            Map<Attribute.Layout, int[]> defMap = this.allLayouts.get(ctype);
            int[] count = defMap.get(def);
            if (count == null) {
                count = new int[1];
                defMap.put(def, count);
            }
            if (count[0] >= Integer.MAX_VALUE) continue;
            count[0] = count[0] + 1;
        }
    }

    void writeAttrDefs() throws IOException {
        ArrayList<Object[]> defList = new ArrayList<Object[]>();
        for (int i = 0; i < 4; ++i) {
            int limit = ((List)this.attrDefs.get(i)).size();
            for (int j = 0; j < limit; ++j) {
                int header = i;
                if (j < this.attrIndexLimit[i]) {
                    assert ((header |= j + 1 << 2) < 256);
                    if (!PackageWriter.testBit(this.attrDefSeen[i], 1L << j)) continue;
                }
                Attribute.Layout def = (Attribute.Layout)((List)this.attrDefs.get(i)).get(j);
                defList.add(new Object[]{header, def});
                assert (Integer.valueOf(j).equals(this.attrIndexTable.get(def)));
            }
        }
        int numAttrDefs = defList.size();
        Object[][] defs = new Object[numAttrDefs][];
        defList.toArray((T[])defs);
        Arrays.sort(defs, (a0, a1) -> {
            int r = ((Comparable)a0[0]).compareTo(a1[0]);
            if (r != 0) {
                return r;
            }
            Integer ind0 = (Integer)this.attrIndexTable.get(a0[1]);
            Integer ind1 = (Integer)this.attrIndexTable.get(a1[1]);
            assert (ind0 != null);
            assert (ind1 != null);
            return ind0.compareTo(ind1);
        });
        this.attrDefsWritten = new Attribute.Layout[numAttrDefs];
        try (PrintStream dump = !this.optDumpBands ? null : new PrintStream(PackageWriter.getDumpStream(this.attr_definition_headers, ".def"));){
            int[] indexForDebug = Arrays.copyOf(this.attrIndexLimit, 4);
            for (int i = 0; i < defs.length; ++i) {
                Attribute.Layout def;
                int header = (Integer)defs[i][0];
                this.attrDefsWritten[i] = def = (Attribute.Layout)defs[i][1];
                assert ((header & 3) == def.ctype());
                this.attr_definition_headers.putByte(header);
                this.attr_definition_name.putRef(ConstantPool.getUtf8Entry(def.name()));
                String layout = def.layoutForClassVersion(this.getHighestClassVersion());
                this.attr_definition_layout.putRef(ConstantPool.getUtf8Entry(layout));
                boolean debug = false;
                if (!$assertionsDisabled) {
                    debug = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (debug) {
                    int hdrIndex = (header >> 2) - 1;
                    if (hdrIndex < 0) {
                        int n = def.ctype();
                        int n2 = indexForDebug[n];
                        indexForDebug[n] = n2 + 1;
                        hdrIndex = n2;
                    }
                    int realIndex = (Integer)this.attrIndexTable.get(def);
                    assert (hdrIndex == realIndex);
                }
                if (dump == null) continue;
                int index = (header >> 2) - 1;
                dump.println(index + " " + def);
            }
        }
    }

    void writeAttrCounts() throws IOException {
        block0: for (int ctype = 0; ctype < 4; ++ctype) {
            BandStructure.MultiBand xxx_attr_bands = this.attrBands[ctype];
            BandStructure.IntBand xxx_attr_calls = PackageWriter.getAttrBand(xxx_attr_bands, 4);
            Attribute.Layout[] defs = new Attribute.Layout[((List)this.attrDefs.get(ctype)).size()];
            ((List)this.attrDefs.get(ctype)).toArray(defs);
            boolean predef = true;
            while (true) {
                for (int ai = 0; ai < defs.length; ++ai) {
                    int totalCount;
                    Attribute.Layout def = defs[ai];
                    if (def == null || predef != this.isPredefinedAttr(ctype, ai) || (totalCount = this.attrCounts[ctype][ai]) == 0) continue;
                    int[] bc = this.backCountTable.get(def);
                    for (int j = 0; j < bc.length; ++j) {
                        if (bc[j] >= 0) {
                            int backCount = bc[j];
                            bc[j] = -1;
                            xxx_attr_calls.putInt(backCount);
                            assert (def.getCallables()[j].flagTest((byte)8));
                            continue;
                        }
                        assert (!def.getCallables()[j].flagTest((byte)8));
                    }
                }
                if (!predef) continue block0;
                predef = false;
            }
        }
    }

    void trimClassAttributes() {
        for (Package.Class cls : this.pkg.classes) {
            cls.minimizeSourceFile();
            assert (cls.getAttribute(Package.attrBootstrapMethodsEmpty) == null);
        }
    }

    void collectInnerClasses() {
        HashMap<ConstantPool.ClassEntry, Package.InnerClass> allICMap = new HashMap<ConstantPool.ClassEntry, Package.InnerClass>();
        for (Package.Class cls : this.pkg.classes) {
            if (!cls.hasInnerClasses()) continue;
            for (Package.InnerClass ic : cls.getInnerClasses()) {
                Package.InnerClass pic = allICMap.put(ic.thisClass, ic);
                if (pic == null || pic.equals(ic) || !pic.predictable) continue;
                allICMap.put(pic.thisClass, pic);
            }
        }
        Object[] allICs = new Package.InnerClass[allICMap.size()];
        allICMap.values().toArray(allICs);
        allICMap = null;
        Arrays.sort(allICs);
        this.pkg.setAllInnerClasses(Arrays.asList(allICs));
        for (Package.Class cls : this.pkg.classes) {
            cls.minimizeLocalICs();
        }
    }

    void writeInnerClasses() throws IOException {
        for (Package.InnerClass ic : this.pkg.getAllInnerClasses()) {
            int flags = ic.flags;
            assert ((flags & 0x10000) == 0);
            if (!ic.predictable) {
                flags |= 0x10000;
            }
            this.ic_this_class.putRef(ic.thisClass);
            this.ic_flags.putInt(flags);
            if (ic.predictable) continue;
            this.ic_outer_class.putRef(ic.outerClass);
            this.ic_name.putRef(ic.name);
        }
    }

    void writeLocalInnerClasses(Package.Class cls) throws IOException {
        List<Package.InnerClass> localICs = cls.getInnerClasses();
        this.class_InnerClasses_N.putInt(localICs.size());
        for (Package.InnerClass ic : localICs) {
            this.class_InnerClasses_RC.putRef(ic.thisClass);
            if (ic.equals(this.pkg.getGlobalInnerClass(ic.thisClass))) {
                this.class_InnerClasses_F.putInt(0);
                continue;
            }
            int flags = ic.flags;
            if (flags == 0) {
                flags = 65536;
            }
            this.class_InnerClasses_F.putInt(flags);
            this.class_InnerClasses_outer_RCN.putRef(ic.outerClass);
            this.class_InnerClasses_name_RUN.putRef(ic.name);
        }
    }

    void writeClassesAndByteCodes() throws IOException {
        Package.Class[] classes = new Package.Class[this.pkg.classes.size()];
        this.pkg.classes.toArray(classes);
        if (this.verbose > 0) {
            Utils.log.info("  ...scanning " + classes.length + " classes...");
        }
        int nwritten = 0;
        for (int i = 0; i < classes.length; ++i) {
            Package.Class cls = classes[i];
            if (this.verbose > 1) {
                Utils.log.fine("Scanning " + cls);
            }
            ConstantPool.ClassEntry thisClass = cls.thisClass;
            ConstantPool.ClassEntry superClass = cls.superClass;
            ConstantPool.ClassEntry[] interfaces = cls.interfaces;
            assert (superClass != thisClass);
            if (superClass == null) {
                superClass = thisClass;
            }
            this.class_this.putRef(thisClass);
            this.class_super.putRef(superClass);
            this.class_interface_count.putInt(cls.interfaces.length);
            for (int j = 0; j < interfaces.length; ++j) {
                this.class_interface.putRef(interfaces[j]);
            }
            this.writeMembers(cls);
            this.writeAttrs(0, cls, cls);
            if (this.verbose <= 0 || ++nwritten % 1000 != 0) continue;
            Utils.log.info("Have scanned " + nwritten + " classes...");
        }
    }

    void writeMembers(Package.Class cls) throws IOException {
        List<Package.Class.Field> fields = cls.getFields();
        this.class_field_count.putInt(fields.size());
        for (Package.Class.Field f : fields) {
            this.field_descr.putRef(f.getDescriptor());
            this.writeAttrs(1, f, cls);
        }
        List<Package.Class.Method> methods = cls.getMethods();
        this.class_method_count.putInt(methods.size());
        for (Package.Class.Method m : methods) {
            this.method_descr.putRef(m.getDescriptor());
            this.writeAttrs(2, m, cls);
            assert (m.code != null == (m.getAttribute(this.attrCodeEmpty) != null));
            if (m.code == null) continue;
            this.writeCodeHeader(m.code);
            this.writeByteCodes(m.code);
        }
    }

    void writeCodeHeader(Code c) throws IOException {
        boolean attrsOK = PackageWriter.testBit(this.archiveOptions, 4);
        int na = c.attributeSize();
        int sc = PackageWriter.shortCodeHeader(c);
        if (!attrsOK && na > 0) {
            sc = 0;
        }
        if (this.verbose > 2) {
            int siglen = c.getMethod().getArgumentSize();
            Utils.log.fine("Code sizes info " + c.max_stack + " " + c.max_locals + " " + c.getHandlerCount() + " " + siglen + " " + na + (sc > 0 ? " SHORT=" + sc : ""));
        }
        this.code_headers.putByte(sc);
        if (sc == 0) {
            this.code_max_stack.putInt(c.getMaxStack());
            this.code_max_na_locals.putInt(c.getMaxNALocals());
            this.code_handler_count.putInt(c.getHandlerCount());
        } else {
            assert (attrsOK || na == 0);
            assert (c.getHandlerCount() < this.shortCodeHeader_h_limit);
        }
        this.writeCodeHandlers(c);
        if (sc == 0 || attrsOK) {
            this.writeAttrs(3, c, c.thisClass());
        }
    }

    void writeCodeHandlers(Code c) throws IOException {
        int jmax = c.getHandlerCount();
        for (int j = 0; j < jmax; ++j) {
            this.code_handler_class_RCN.putRef(c.handler_class[j]);
            int sum = c.encodeBCI(c.handler_start[j]);
            this.code_handler_start_P.putInt(sum);
            int del = c.encodeBCI(c.handler_end[j]) - sum;
            this.code_handler_end_PO.putInt(del);
            sum += del;
            del = c.encodeBCI(c.handler_catch[j]) - sum;
            this.code_handler_catch_PO.putInt(del);
        }
    }

    void writeAttrs(int ctype, final Attribute.Holder h, Package.Class cls) throws IOException {
        BandStructure.MultiBand xxx_attr_bands = this.attrBands[ctype];
        BandStructure.IntBand xxx_flags_hi = PackageWriter.getAttrBand(xxx_attr_bands, 0);
        BandStructure.IntBand xxx_flags_lo = PackageWriter.getAttrBand(xxx_attr_bands, 1);
        boolean haveLongFlags = this.haveFlagsHi(ctype);
        assert (this.attrIndexLimit[ctype] == (haveLongFlags ? 63 : 32));
        if (h.attributes == null) {
            xxx_flags_lo.putInt(h.flags);
            if (haveLongFlags) {
                xxx_flags_hi.putInt(0);
            }
            return;
        }
        if (this.verbose > 3) {
            Utils.log.fine("Transmitting attrs for " + h + " flags=" + Integer.toHexString(h.flags));
        }
        long flagMask = this.attrFlagMask[ctype];
        long flagsToAdd = 0L;
        int overflowCount = 0;
        for (Attribute a : h.attributes) {
            boolean isCV;
            Attribute.Layout def = a.layout();
            int index = (Integer)this.attrIndexTable.get(def);
            assert (((List)this.attrDefs.get(ctype)).get(index) == def);
            if (this.verbose > 3) {
                Utils.log.fine("add attr @" + index + " " + a + " in " + h);
            }
            if (index < this.attrIndexLimit[ctype] && PackageWriter.testBit(flagMask, 1L << index)) {
                if (this.verbose > 3) {
                    Utils.log.fine("Adding flag bit 1<<" + index + " in " + Long.toHexString(flagMask));
                }
                assert (!PackageWriter.testBit((long)h.flags, 1L << index));
                flagsToAdd |= 1L << index;
                flagMask -= 1L << index;
            } else {
                flagsToAdd |= 0x10000L;
                ++overflowCount;
                if (this.verbose > 3) {
                    Utils.log.fine("Adding overflow attr #" + overflowCount);
                }
                BandStructure.IntBand xxx_attr_indexes = PackageWriter.getAttrBand(xxx_attr_bands, 3);
                xxx_attr_indexes.putInt(index);
            }
            if (def.bandCount == 0) {
                if (def != this.attrInnerClassesEmpty) continue;
                this.writeLocalInnerClasses((Package.Class)h);
                continue;
            }
            assert (a.fixups == null);
            final BandStructure.Band[] ab = (BandStructure.Band[])this.attrBandTable.get(def);
            assert (ab != null);
            assert (ab.length == def.bandCount);
            final int[] bc = this.backCountTable.get(def);
            assert (bc != null);
            assert (bc.length == def.getCallables().length);
            if (this.verbose > 2) {
                Utils.log.fine("writing " + a + " in " + h);
            }
            boolean bl = isCV = ctype == 1 && def == this.attrConstantValue;
            if (isCV) {
                this.setConstantValueIndex((Package.Class.Field)h);
            }
            a.parse(cls, a.bytes(), 0, a.size(), new Attribute.ValueStream(){

                @Override
                public void putInt(int bandIndex, int value) {
                    ((BandStructure.IntBand)ab[bandIndex]).putInt(value);
                }

                @Override
                public void putRef(int bandIndex, ConstantPool.Entry ref) {
                    ((BandStructure.CPRefBand)ab[bandIndex]).putRef(ref);
                }

                @Override
                public int encodeBCI(int bci) {
                    Code code = (Code)h;
                    return code.encodeBCI(bci);
                }

                @Override
                public void noteBackCall(int whichCallable) {
                    assert (bc[whichCallable] >= 0);
                    int n = whichCallable;
                    bc[n] = bc[n] + 1;
                }
            });
            if (!isCV) continue;
            this.setConstantValueIndex(null);
        }
        if (overflowCount > 0) {
            BandStructure.IntBand xxx_attr_count = PackageWriter.getAttrBand(xxx_attr_bands, 2);
            xxx_attr_count.putInt(overflowCount);
        }
        xxx_flags_lo.putInt(h.flags | (int)flagsToAdd);
        if (haveLongFlags) {
            xxx_flags_hi.putInt((int)(flagsToAdd >>> 32));
        } else assert (flagsToAdd >>> 32 == 0L);
        assert (((long)h.flags & flagsToAdd) == 0L) : h + ".flags=" + Integer.toHexString(h.flags) + "^" + Long.toHexString(flagsToAdd);
    }

    private void beginCode(Code c) {
        assert (this.curCode == null);
        this.curCode = c;
        this.curClass = c.m.thisClass();
        this.curCPMap = c.getCPMap();
    }

    private void endCode() {
        this.curCode = null;
        this.curClass = null;
        this.curCPMap = null;
    }

    private int initOpVariant(Instruction i, ConstantPool.Entry newClass) {
        if (i.getBC() != 183) {
            return -1;
        }
        ConstantPool.MemberEntry ref = (ConstantPool.MemberEntry)i.getCPRef(this.curCPMap);
        if (!"<init>".equals(ref.descRef.nameRef.stringValue())) {
            return -1;
        }
        ConstantPool.ClassEntry refClass = ref.classRef;
        if (refClass == this.curClass.thisClass) {
            return 230;
        }
        if (refClass == this.curClass.superClass) {
            return 231;
        }
        if (refClass == newClass) {
            return 232;
        }
        return -1;
    }

    private int selfOpVariant(Instruction i) {
        int bc = i.getBC();
        if (bc < 178 || bc > 184) {
            return -1;
        }
        ConstantPool.MemberEntry ref = (ConstantPool.MemberEntry)i.getCPRef(this.curCPMap);
        if ((bc == 183 || bc == 184) && ref.tagEquals(11)) {
            return -1;
        }
        ConstantPool.ClassEntry refClass = ref.classRef;
        int self_bc = 202 + (bc - 178);
        if (refClass == this.curClass.thisClass) {
            return self_bc;
        }
        if (refClass == this.curClass.superClass) {
            return self_bc + 14;
        }
        return -1;
    }

    void writeByteCodes(Code code) throws IOException {
        this.beginCode(code);
        ConstantPool.IndexGroup cp = this.pkg.cp;
        boolean prevAload = false;
        ConstantPool.Entry newClass = null;
        block44: for (Instruction i = code.instructionAt(0); i != null; i = i.next()) {
            Instruction ni;
            int bc;
            if (this.verbose > 3) {
                Utils.log.fine(i.toString());
            }
            if (i.isNonstandard()) {
                String complaint = code.getMethod() + " contains an unrecognized bytecode " + i + "; please use the pass-file option on this class.";
                Utils.log.warning(complaint);
                throw new IOException(complaint);
            }
            if (i.isWide()) {
                if (this.verbose > 1) {
                    Utils.log.fine("_wide opcode in " + code);
                    Utils.log.fine(i.toString());
                }
                this.bc_codes.putByte(196);
                this.codeHist[196] = this.codeHist[196] + 1;
            }
            if ((bc = i.getBC()) == 42 && this.selfOpVariant(ni = code.instructionAt(i.getNextPC())) >= 0) {
                prevAload = true;
                continue;
            }
            int init_bc = this.initOpVariant(i, newClass);
            if (init_bc >= 0) {
                if (prevAload) {
                    this.bc_codes.putByte(42);
                    this.codeHist[42] = this.codeHist[42] + 1;
                    prevAload = false;
                }
                this.bc_codes.putByte(init_bc);
                int n = init_bc;
                this.codeHist[n] = this.codeHist[n] + 1;
                ConstantPool.MemberEntry ref = (ConstantPool.MemberEntry)i.getCPRef(this.curCPMap);
                int coding = cp.getOverloadingIndex(ref);
                this.bc_initref.putInt(coding);
                continue;
            }
            int self_bc = this.selfOpVariant(i);
            if (self_bc >= 0) {
                boolean isField = Instruction.isFieldOp(bc);
                boolean isSuper = self_bc >= 216;
                boolean isAload = prevAload;
                prevAload = false;
                if (isAload) {
                    self_bc += 7;
                }
                this.bc_codes.putByte(self_bc);
                int n = self_bc;
                this.codeHist[n] = this.codeHist[n] + 1;
                ConstantPool.MemberEntry ref = (ConstantPool.MemberEntry)i.getCPRef(this.curCPMap);
                BandStructure.CPRefBand bc_which = this.selfOpRefBand(self_bc);
                ConstantPool.Index which_ix = cp.getMemberIndex(ref.tag, ref.classRef);
                bc_which.putRef((ConstantPool.Entry)ref, which_ix);
                continue;
            }
            assert (!prevAload);
            int n = bc;
            this.codeHist[n] = this.codeHist[n] + 1;
            switch (bc) {
                case 170: 
                case 171: {
                    int j;
                    this.bc_codes.putByte(bc);
                    Instruction.Switch isw = (Instruction.Switch)i;
                    int apc = isw.getAlignedPC();
                    int npc = isw.getNextPC();
                    int caseCount = isw.getCaseCount();
                    this.bc_case_count.putInt(caseCount);
                    this.putLabel(this.bc_label, code, i.getPC(), isw.getDefaultLabel());
                    for (j = 0; j < caseCount; ++j) {
                        this.putLabel(this.bc_label, code, i.getPC(), isw.getCaseLabel(j));
                    }
                    if (bc == 170) {
                        this.bc_case_value.putInt(isw.getCaseValue(0));
                        continue block44;
                    }
                    for (j = 0; j < caseCount; ++j) {
                        this.bc_case_value.putInt(isw.getCaseValue(j));
                    }
                    continue block44;
                }
                default: {
                    int branch = i.getBranchLabel();
                    if (branch >= 0) {
                        this.bc_codes.putByte(bc);
                        this.putLabel(this.bc_label, code, i.getPC(), branch);
                        continue block44;
                    }
                    ConstantPool.Entry ref = i.getCPRef(this.curCPMap);
                    if (ref != null) {
                        BandStructure.CPRefBand bc_which;
                        if (bc == 187) {
                            newClass = ref;
                        }
                        if (bc == 18) {
                            byte by = ref.tag;
                            this.ldcHist[by] = this.ldcHist[by] + 1;
                        }
                        int vbc = bc;
                        block3 : switch (i.getCPTag()) {
                            case 51: {
                                switch (ref.tag) {
                                    case 3: {
                                        bc_which = this.bc_intref;
                                        switch (bc) {
                                            case 18: {
                                                vbc = 234;
                                                break block3;
                                            }
                                            case 19: {
                                                vbc = 237;
                                                break block3;
                                            }
                                        }
                                        assert (false);
                                        break block3;
                                    }
                                    case 4: {
                                        bc_which = this.bc_floatref;
                                        switch (bc) {
                                            case 18: {
                                                vbc = 235;
                                                break block3;
                                            }
                                            case 19: {
                                                vbc = 238;
                                                break block3;
                                            }
                                        }
                                        assert (false);
                                        break block3;
                                    }
                                    case 5: {
                                        bc_which = this.bc_longref;
                                        assert (bc == 20);
                                        vbc = 20;
                                        break block3;
                                    }
                                    case 6: {
                                        bc_which = this.bc_doubleref;
                                        assert (bc == 20);
                                        vbc = 239;
                                        break block3;
                                    }
                                    case 8: {
                                        bc_which = this.bc_stringref;
                                        switch (bc) {
                                            case 18: {
                                                vbc = 18;
                                                break block3;
                                            }
                                            case 19: {
                                                vbc = 19;
                                                break block3;
                                            }
                                        }
                                        assert (false);
                                        break block3;
                                    }
                                    case 7: {
                                        bc_which = this.bc_classref;
                                        switch (bc) {
                                            case 18: {
                                                vbc = 233;
                                                break block3;
                                            }
                                            case 19: {
                                                vbc = 236;
                                                break block3;
                                            }
                                        }
                                        assert (false);
                                        break block3;
                                    }
                                    default: {
                                        if (this.getHighestClassVersion().lessThan(Constants.JAVA7_MAX_CLASS_VERSION)) {
                                            throw new IOException("bad class file major version for Java 7 ldc");
                                        }
                                        bc_which = this.bc_loadablevalueref;
                                        switch (bc) {
                                            case 18: {
                                                vbc = 240;
                                                break block3;
                                            }
                                            case 19: {
                                                vbc = 241;
                                                break block3;
                                            }
                                        }
                                        assert (false);
                                        break block3;
                                    }
                                }
                            }
                            case 7: {
                                if (ref == this.curClass.thisClass) {
                                    ref = null;
                                }
                                bc_which = this.bc_classref;
                                break;
                            }
                            case 9: {
                                bc_which = this.bc_fieldref;
                                break;
                            }
                            case 10: {
                                if (ref.tagEquals(11)) {
                                    if (bc == 183) {
                                        vbc = 242;
                                    }
                                    if (bc == 184) {
                                        vbc = 243;
                                    }
                                    bc_which = this.bc_imethodref;
                                    break;
                                }
                                bc_which = this.bc_methodref;
                                break;
                            }
                            case 11: {
                                bc_which = this.bc_imethodref;
                                break;
                            }
                            case 18: {
                                bc_which = this.bc_indyref;
                                break;
                            }
                            default: {
                                bc_which = null;
                                assert (false);
                                break;
                            }
                        }
                        if (ref != null && bc_which.index != null && !bc_which.index.contains(ref)) {
                            String complaint = code.getMethod() + " contains a bytecode " + i + " with an unsupported constant reference; please use the pass-file option on this class.";
                            Utils.log.warning(complaint);
                            throw new IOException(complaint);
                        }
                        this.bc_codes.putByte(vbc);
                        bc_which.putRef(ref);
                        if (bc == 197) {
                            assert (i.getConstant() == code.getByte(i.getPC() + 3));
                            this.bc_byte.putByte(0xFF & i.getConstant());
                            continue block44;
                        }
                        if (bc == 185) {
                            assert (i.getLength() == 5);
                            assert (i.getConstant() == 1 + ((ConstantPool.MemberEntry)ref).descRef.typeRef.computeSize(true) << 8);
                            continue block44;
                        }
                        if (bc == 186) {
                            if (this.getHighestClassVersion().lessThan(Constants.JAVA7_MAX_CLASS_VERSION)) {
                                throw new IOException("bad class major version for Java 7 invokedynamic");
                            }
                            assert (i.getLength() == 5);
                            assert (i.getConstant() == 0);
                            continue block44;
                        }
                        assert (i.getLength() == (bc == 18 ? 2 : 3));
                        continue block44;
                    }
                    int slot = i.getLocalSlot();
                    if (slot >= 0) {
                        this.bc_codes.putByte(bc);
                        this.bc_local.putInt(slot);
                        int con = i.getConstant();
                        if (bc == 132) {
                            if (!i.isWide()) {
                                this.bc_byte.putByte(0xFF & con);
                                continue block44;
                            }
                            this.bc_short.putInt(0xFFFF & con);
                            continue block44;
                        }
                        assert (con == 0);
                        continue block44;
                    }
                    this.bc_codes.putByte(bc);
                    int pc = i.getPC() + 1;
                    int npc = i.getNextPC();
                    if (pc >= npc) continue block44;
                    switch (bc) {
                        case 17: {
                            this.bc_short.putInt(0xFFFF & i.getConstant());
                            continue block44;
                        }
                        case 16: {
                            this.bc_byte.putByte(0xFF & i.getConstant());
                            continue block44;
                        }
                        case 188: {
                            this.bc_byte.putByte(0xFF & i.getConstant());
                            continue block44;
                        }
                    }
                    assert (false);
                    continue block44;
                }
            }
        }
        this.bc_codes.putByte(255);
        ++this.bc_codes.elementCountForDebug;
        this.codeHist[255] = this.codeHist[255] + 1;
        this.endCode();
    }

    void printCodeHist() {
        int bc;
        assert (this.verbose > 0);
        Object[] hist = new String[this.codeHist.length];
        int totalBytes = 0;
        for (bc = 0; bc < this.codeHist.length; ++bc) {
            totalBytes += this.codeHist[bc];
        }
        for (bc = 0; bc < this.codeHist.length; ++bc) {
            if (this.codeHist[bc] == 0) {
                hist[bc] = "";
                continue;
            }
            String iname = Instruction.byteName(bc);
            String count = "" + this.codeHist[bc];
            count = "         ".substring(count.length()) + count;
            String pct = "" + this.codeHist[bc] * 10000 / totalBytes;
            while (pct.length() < 4) {
                pct = "0" + pct;
            }
            pct = pct.substring(0, pct.length() - 2) + "." + pct.substring(pct.length() - 2);
            hist[bc] = count + "  " + pct + "%  " + iname;
        }
        Arrays.sort(hist);
        System.out.println("Bytecode histogram [" + totalBytes + "]");
        int i = hist.length;
        while (--i >= 0) {
            if ("".equals(hist[i])) continue;
            System.out.println((String)hist[i]);
        }
        for (int tag = 0; tag < this.ldcHist.length; ++tag) {
            int count = this.ldcHist[tag];
            if (count == 0) continue;
            System.out.println("ldc " + ConstantPool.tagName(tag) + " " + count);
        }
    }
}

