/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.pack200.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.glavo.pack200.impl.Constants;
import org.glavo.pack200.impl.PackerImpl;
import org.glavo.pack200.impl.PropMap;
import org.glavo.pack200.impl.TLGlobals;
import org.glavo.pack200.impl.UnpackerImpl;

class Utils {
    static final String COM_PREFIX = "org.glavo.pack200.";
    static final String METAINF = "META-INF";
    static final String DEBUG_VERBOSE = "org.glavo.pack200.verbose";
    static final String DEBUG_DISABLE_NATIVE = "org.glavo.pack200.disable.native";
    static final String UNPACK_MODIFICATION_TIME = "org.glavo.pack200.unpack.modification.time";
    static final String UNPACK_STRIP_DEBUG = "org.glavo.pack200.unpack.strip.debug";
    static final String UNPACK_REMOVE_PACKFILE = "org.glavo.pack200.unpack.remove.packfile";
    static final String NOW = "now";
    static final String PACK_KEEP_CLASS_ORDER = "org.glavo.pack200.keep.class.order";
    static final String PACK_ZIP_ARCHIVE_MARKER_COMMENT = "PACK200";
    static final String CLASS_FORMAT_ERROR = "org.glavo.pack200.class.format.error";
    static final ThreadLocal<TLGlobals> currentInstance = new ThreadLocal();
    static final boolean nolog = Boolean.getBoolean("org.glavo.pack200.nolog");
    static final boolean SORT_MEMBERS_DESCR_MAJOR = Boolean.getBoolean("org.glavo.pack200.sort.members.descr.major");
    static final boolean SORT_HANDLES_KIND_MAJOR = Boolean.getBoolean("org.glavo.pack200.sort.handles.kind.major");
    static final boolean SORT_INDY_BSS_MAJOR = Boolean.getBoolean("org.glavo.pack200.sort.indy.bss.major");
    static final boolean SORT_BSS_BSM_MAJOR = Boolean.getBoolean("org.glavo.pack200.sort.bss.bsm.major");
    static final Pack200Logger log = new Pack200Logger("org.glavo.pack200.Pack200");

    static TLGlobals getTLGlobals() {
        return currentInstance.get();
    }

    static PropMap currentPropMap() {
        TLGlobals obj = currentInstance.get();
        if (obj instanceof PackerImpl) {
            return ((PackerImpl)obj).props;
        }
        if (obj instanceof UnpackerImpl) {
            return ((UnpackerImpl)obj).props;
        }
        return null;
    }

    static String getVersionString() {
        return "Pack200, Vendor: " + System.getProperty("java.vendor") + ", Version: " + Constants.MAX_PACKAGE_VERSION;
    }

    static void markJarFile(JarOutputStream out) throws IOException {
        out.setComment(PACK_ZIP_ARCHIVE_MARKER_COMMENT);
    }

    static void copyJarFile(JarInputStream in, JarOutputStream out) throws IOException {
        JarEntry je;
        if (in.getManifest() != null) {
            ZipEntry me = new ZipEntry("META-INF/MANIFEST.MF");
            out.putNextEntry(me);
            in.getManifest().write(out);
            out.closeEntry();
        }
        byte[] buffer = new byte[16384];
        while ((je = in.getNextJarEntry()) != null) {
            int nr;
            out.putNextEntry(je);
            while (0 < (nr = in.read(buffer))) {
                out.write(buffer, 0, nr);
            }
        }
        in.close();
        Utils.markJarFile(out);
    }

    static void copyJarFile(JarFile in, JarOutputStream out) throws IOException {
        byte[] buffer = new byte[16384];
        for (JarEntry je : Collections.list(in.entries())) {
            int nr;
            out.putNextEntry(je);
            InputStream ein = in.getInputStream(je);
            while (0 < (nr = ein.read(buffer))) {
                out.write(buffer, 0, nr);
            }
        }
        in.close();
        Utils.markJarFile(out);
    }

    static void copyJarFile(JarInputStream in, OutputStream out) throws IOException {
        out = new BufferedOutputStream(out);
        out = new NonCloser(out);
        try (JarOutputStream jout = new JarOutputStream(out);){
            Utils.copyJarFile(in, jout);
        }
    }

    static void copyJarFile(JarFile in, OutputStream out) throws IOException {
        out = new BufferedOutputStream(out);
        out = new NonCloser(out);
        try (JarOutputStream jout = new JarOutputStream(out);){
            Utils.copyJarFile(in, jout);
        }
    }

    static String getJarEntryName(String name) {
        if (name == null) {
            return null;
        }
        return name.replace(File.separatorChar, '/');
    }

    static String zeString(ZipEntry ze) {
        int store = ze.getCompressedSize() > 0L ? (int)((1.0 - (double)ze.getCompressedSize() / (double)ze.getSize()) * 100.0) : 0;
        return ze.getSize() + "\t" + ze.getMethod() + "\t" + ze.getCompressedSize() + "\t" + store + "%\t" + new Date(ze.getTime()) + "\t" + Long.toHexString(ze.getCrc()) + "\t" + ze.getName();
    }

    static byte[] readMagic(BufferedInputStream in) throws IOException {
        in.mark(4);
        byte[] magic = new byte[4];
        for (int i = 0; i < magic.length && 1 == in.read(magic, i, 1); ++i) {
        }
        in.reset();
        return magic;
    }

    static boolean isJarMagic(byte[] magic) {
        return magic[0] == 80 && magic[1] == 75 && magic[2] >= 1 && magic[2] < 8 && magic[3] == magic[2] + 1;
    }

    static boolean isPackMagic(byte[] magic) {
        return magic[0] == -54 && magic[1] == -2 && magic[2] == -48 && magic[3] == 13;
    }

    static boolean isGZIPMagic(byte[] magic) {
        return magic[0] == 31 && magic[1] == -117 && magic[2] == 8;
    }

    private Utils() {
    }

    private static class NonCloser
    extends FilterOutputStream {
        NonCloser(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }

    static class Pack200Logger {
        private final String name;
        private Logger log;

        Pack200Logger(String name) {
            this.name = name;
        }

        private synchronized Logger getLogger() {
            if (this.log == null) {
                this.log = Logger.getLogger(this.name);
            }
            return this.log;
        }

        public void warning(String msg, Object param) {
            this.getLogger().log(Level.WARNING, msg, param);
        }

        public void warning(String msg) {
            this.warning(msg, null);
        }

        public void info(String msg) {
            int verbose = Utils.currentPropMap().getInteger(Utils.DEBUG_VERBOSE);
            if (verbose > 0) {
                if (nolog) {
                    System.out.println(msg);
                } else {
                    this.getLogger().info(msg);
                }
            }
        }

        public void fine(String msg) {
            int verbose = Utils.currentPropMap().getInteger(Utils.DEBUG_VERBOSE);
            if (verbose > 0) {
                System.out.println(msg);
            }
        }
    }
}

