/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.png.image;

import org.glavo.png.image.ArgbImage;

public final class ArgbImageBuffer
implements ArgbImage {
    private final int width;
    private final int height;
    private final int[] colors;

    public ArgbImageBuffer(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
        this.colors = new int[width * height];
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getArgb(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            throw new IllegalArgumentException();
        }
        return this.colors[x + y * this.width];
    }

    public void setArgb(int x, int y, int color) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            throw new IllegalArgumentException();
        }
        this.colors[x + y * this.width] = color;
    }

    public void setArgb(int x, int y, int a, int r, int g, int b) {
        this.setArgb(x, y, a << 24 | r << 16 | g << 8 | b);
    }
}

