package org.glowroot.api.internal;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ThrowableInfo}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableThrowableInfo.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ThrowableInfo"})
@Immutable
public final class ImmutableThrowableInfo extends ThrowableInfo {
  private final String display;
  private final ImmutableList<StackTraceElement> stackTrace;
  private final int framesInCommonWithCaused;
  private final @Nullable ThrowableInfo cause;

  private ImmutableThrowableInfo(ImmutableThrowableInfo.Builder builder) {
    this.display = builder.display;
    this.stackTrace = builder.stackTraceBuilder.build();
    this.framesInCommonWithCaused = builder.framesInCommonWithCaused;
    this.cause = builder.cause;
  }

  private ImmutableThrowableInfo(
      ImmutableThrowableInfo original,
      String display,
      ImmutableList<StackTraceElement> stackTrace,
      int framesInCommonWithCaused,
      @Nullable ThrowableInfo cause) {
    this.display = display;
    this.stackTrace = stackTrace;
    this.framesInCommonWithCaused = framesInCommonWithCaused;
    this.cause = cause;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code display} attribute
   */
  @Override
  public String display() {
    return display;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code stackTrace} attribute
   */
  @Override
  public ImmutableList<StackTraceElement> stackTrace() {
    return stackTrace;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code framesInCommonWithCaused} attribute
   */
  @Override
  public int framesInCommonWithCaused() {
    return framesInCommonWithCaused;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code cause} attribute
   */
  @Nullable
  @Override
  public ThrowableInfo cause() {
    return cause;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThrowableInfo#display() display}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for display
   * @return modified copy of the {@code this} object
   */
  public final ImmutableThrowableInfo withDisplay(String value) {
    if (this.display == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableThrowableInfo(this, newValue, this.stackTrace, this.framesInCommonWithCaused, this.cause);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ThrowableInfo#stackTrace() stackTrace}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableThrowableInfo withStackTrace(StackTraceElement... elements) {
    ImmutableList<StackTraceElement> newValue = ImmutableList.copyOf(elements);
    return new ImmutableThrowableInfo(this, this.display, newValue, this.framesInCommonWithCaused, this.cause);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ThrowableInfo#stackTrace() stackTrace}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of stackTrace elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableThrowableInfo withStackTrace(Iterable<? extends StackTraceElement> elements) {
    if (this.stackTrace == elements) {
      return this;
    }
    ImmutableList<StackTraceElement> newValue = ImmutableList.copyOf(elements);
    return new ImmutableThrowableInfo(this, this.display, newValue, this.framesInCommonWithCaused, this.cause);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThrowableInfo#framesInCommonWithCaused() framesInCommonWithCaused}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for framesInCommonWithCaused
   * @return modified copy of the {@code this} object
   */
  public final ImmutableThrowableInfo withFramesInCommonWithCaused(int value) {
    if (this.framesInCommonWithCaused == value) {
      return this;
    }
    int newValue = value;
    return new ImmutableThrowableInfo(this, this.display, this.stackTrace, newValue, this.cause);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThrowableInfo#cause() cause}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for cause, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ImmutableThrowableInfo withCause(@Nullable ThrowableInfo value) {
    if (this.cause == value) {
      return this;
    }
    @Nullable ThrowableInfo newValue = value;
    return new ImmutableThrowableInfo(this, this.display, this.stackTrace, this.framesInCommonWithCaused, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableThrowableInfo} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ImmutableThrowableInfo && equalTo((ImmutableThrowableInfo) another));
  }
  
  private boolean equalTo(ImmutableThrowableInfo another) {
    return display.equals(another.display)
        && stackTrace.equals(another.stackTrace)
        && framesInCommonWithCaused == another.framesInCommonWithCaused
        && Objects.equal(cause, another.cause);
  }
  
  /**
   * Computes hash code from attributes: {@code display}, {@code stackTrace}, {@code framesInCommonWithCaused}, {@code cause}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + display.hashCode();
    h = h * 17 + stackTrace.hashCode();
    h = h * 17 + framesInCommonWithCaused;
    h = h * 17 + Objects.hashCode(cause);
    return h;
  }
  
  /**
   * Prints immutable value {@code ThrowableInfo{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ThrowableInfo")
        .add("display", display)
        .add("stackTrace", stackTrace)
        .add("framesInCommonWithCaused", framesInCommonWithCaused)
        .add("cause", cause)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link ThrowableInfo}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable ThrowableInfo instance
   */
  public static ImmutableThrowableInfo copyOf(ThrowableInfo instance) {
    if (instance instanceof ImmutableThrowableInfo) {
      return (ImmutableThrowableInfo) instance;
    }
    return ImmutableThrowableInfo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.api.internal.ImmutableThrowableInfo}.
   * @return new ImmutableThrowableInfo builder
   */
  public static ImmutableThrowableInfo.Builder builder() {
    return new ImmutableThrowableInfo.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.api.internal.ImmutableThrowableInfo}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_DISPLAY = 0x1L;
    private static final long INITIALIZED_BIT_FRAMES_IN_COMMON_WITH_CAUSED = 0x2L;
    private long initializedBitset;
  
    private @Nullable String display;
    private ImmutableList.Builder<StackTraceElement> stackTraceBuilder = ImmutableList.builder();
    private int framesInCommonWithCaused;
    private @Nullable ThrowableInfo cause;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link ThrowableInfo} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(ThrowableInfo instance) {
      Preconditions.checkNotNull(instance);
      display(instance.display());
      addAllStackTrace(instance.stackTrace());
      framesInCommonWithCaused(instance.framesInCommonWithCaused());
      @Nullable ThrowableInfo causeValue = instance.cause();
      if (causeValue != null) {
        cause(causeValue);
      }
      return this;
    }
  
    /**
     * Initializes value for {@link ThrowableInfo#display() display}.
     * @param display value for display
     * @return {@code this} builder for chained invocation
     */
    public final Builder display(String display) {
      this.display = Preconditions.checkNotNull(display);
      initializedBitset |= INITIALIZED_BIT_DISPLAY;
      return this;
    }
  
    /**
     * Adds one element to {@link ThrowableInfo#stackTrace() stackTrace} list.
     * @param element stackTrace element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addStackTrace(StackTraceElement element) {
      stackTraceBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link ThrowableInfo#stackTrace() stackTrace} list.
     * @param elements array of stackTrace elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addStackTrace(StackTraceElement... elements) {
      stackTraceBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link ThrowableInfo#stackTrace() stackTrace} list.
     * @param elements iterable of stackTrace elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder stackTrace(Iterable<? extends StackTraceElement> elements) {
      stackTraceBuilder = ImmutableList.builder();
      return addAllStackTrace(elements);
    }
  
    /**
     * Adds elements to {@link ThrowableInfo#stackTrace() stackTrace} list.
     * @param elements iterable of stackTrace elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllStackTrace(Iterable<? extends StackTraceElement> elements) {
      stackTraceBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link ThrowableInfo#framesInCommonWithCaused() framesInCommonWithCaused}.
     * @param framesInCommonWithCaused value for framesInCommonWithCaused
     * @return {@code this} builder for chained invocation
     */
    public final Builder framesInCommonWithCaused(int framesInCommonWithCaused) {
      this.framesInCommonWithCaused = framesInCommonWithCaused;
      initializedBitset |= INITIALIZED_BIT_FRAMES_IN_COMMON_WITH_CAUSED;
      return this;
    }
  
    /**
     * Initializes value for {@link ThrowableInfo#cause() cause}.
     * @param cause value for cause, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder cause(@Nullable ThrowableInfo cause) {
      this.cause = cause;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.api.internal.ImmutableThrowableInfo}.
     * @return immutable instance of ThrowableInfo
     */
    public ImmutableThrowableInfo build() {
      checkRequiredAttributes();
      return new ImmutableThrowableInfo(this);
    }
  
    private boolean displayIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DISPLAY) != 0;
    }
  
    private boolean framesInCommonWithCausedIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FRAMES_IN_COMMON_WITH_CAUSED) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!displayIsSet()) {
        attributes.add("display");
      }
      if (!framesInCommonWithCausedIsSet()) {
        attributes.add("framesInCommonWithCaused");
      }
      return "Cannot build ThrowableInfo, some of required attributes are not set " + attributes;
    }
  }
}
