package org.glowroot.collector;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ErrorPointBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ErrorPoint.builder()}.
 * Use static factory method to create immutable instances:
 * {@code ErrorPoint.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ErrorPointBase"})
@Immutable
public final class ErrorPoint extends ErrorPointBase {
  private final long captureTime;
  private final long errorCount;
  private final long transactionCount;

  private ErrorPoint(long captureTime, long errorCount, long transactionCount) {
    this.captureTime = captureTime;
    this.errorCount = errorCount;
    this.transactionCount = transactionCount;
  }

  private ErrorPoint(ErrorPoint.Builder builder) {
    this.captureTime = builder.captureTime;
    this.errorCount = builder.errorCount;
    this.transactionCount = builder.transactionCount;
  }

  private ErrorPoint(ErrorPoint original, long captureTime, long errorCount, long transactionCount) {
    this.captureTime = captureTime;
    this.errorCount = errorCount;
    this.transactionCount = transactionCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code captureTime} attribute
   */
  @Override
  public long captureTime() {
    return captureTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code errorCount} attribute
   */
  @Override
  public long errorCount() {
    return errorCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionCount} attribute
   */
  @Override
  public long transactionCount() {
    return transactionCount;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorPointBase#captureTime() captureTime}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for captureTime
   * @return modified copy of the {@code this} object
   */
  public final ErrorPoint withCaptureTime(long value) {
    if (this.captureTime == value) {
      return this;
    }
    long newValue = value;
    return new ErrorPoint(this, newValue, this.errorCount, this.transactionCount);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorPointBase#errorCount() errorCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for errorCount
   * @return modified copy of the {@code this} object
   */
  public final ErrorPoint withErrorCount(long value) {
    if (this.errorCount == value) {
      return this;
    }
    long newValue = value;
    return new ErrorPoint(this, this.captureTime, newValue, this.transactionCount);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorPointBase#transactionCount() transactionCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionCount
   * @return modified copy of the {@code this} object
   */
  public final ErrorPoint withTransactionCount(long value) {
    if (this.transactionCount == value) {
      return this;
    }
    long newValue = value;
    return new ErrorPoint(this, this.captureTime, this.errorCount, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ErrorPoint} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ErrorPoint && equalTo((ErrorPoint) another));
  }
  
  private boolean equalTo(ErrorPoint another) {
    return captureTime == another.captureTime
        && errorCount == another.errorCount
        && transactionCount == another.transactionCount;
  }
  
  /**
   * Computes hash code from attributes: {@code captureTime}, {@code errorCount}, {@code transactionCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(captureTime);
    h = h * 17 + Longs.hashCode(errorCount);
    h = h * 17 + Longs.hashCode(transactionCount);
    return h;
  }
  
  /**
   * Prints immutable value {@code ErrorPoint{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ErrorPoint")
        .add("captureTime", captureTime)
        .add("errorCount", errorCount)
        .add("transactionCount", transactionCount)
        .toString();
  }

  /**
   * Construct new immutable {@code ErrorPoint} instance.
   * @param captureTime value for {@code captureTime}
   * @param errorCount value for {@code errorCount}
   * @param transactionCount value for {@code transactionCount}
   * @return immutable ErrorPoint instance
   */
  public static ErrorPoint of(long captureTime, long errorCount, long transactionCount) {
    return new ErrorPoint(captureTime, errorCount, transactionCount);
  }
  
  /**
   * Creates immutable copy of {@link ErrorPointBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable ErrorPoint instance
   */
  public static ErrorPoint copyOf(ErrorPointBase instance) {
    if (instance instanceof ErrorPoint) {
      return (ErrorPoint) instance;
    }
    return ErrorPoint.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.collector.ErrorPoint}.
   * @return new ErrorPoint builder
   */
  public static ErrorPoint.Builder builder() {
    return new ErrorPoint.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.collector.ErrorPoint}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_CAPTURE_TIME = 0x1L;
    private static final long INITIALIZED_BIT_ERROR_COUNT = 0x2L;
    private static final long INITIALIZED_BIT_TRANSACTION_COUNT = 0x4L;
    private long initializedBitset;
  
    private long captureTime;
    private long errorCount;
    private long transactionCount;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link ErrorPointBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(ErrorPointBase instance) {
      Preconditions.checkNotNull(instance);
      captureTime(instance.captureTime());
      errorCount(instance.errorCount());
      transactionCount(instance.transactionCount());
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorPointBase#captureTime() captureTime}.
     * @param captureTime value for captureTime
     * @return {@code this} builder for chained invocation
     */
    public final Builder captureTime(long captureTime) {
      this.captureTime = captureTime;
      initializedBitset |= INITIALIZED_BIT_CAPTURE_TIME;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorPointBase#errorCount() errorCount}.
     * @param errorCount value for errorCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder errorCount(long errorCount) {
      this.errorCount = errorCount;
      initializedBitset |= INITIALIZED_BIT_ERROR_COUNT;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorPointBase#transactionCount() transactionCount}.
     * @param transactionCount value for transactionCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionCount(long transactionCount) {
      this.transactionCount = transactionCount;
      initializedBitset |= INITIALIZED_BIT_TRANSACTION_COUNT;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.collector.ErrorPoint}.
     * @return immutable instance of ErrorPoint
     */
    public ErrorPoint build() {
      checkRequiredAttributes();
      return new ErrorPoint(this);
    }
  
    private boolean captureTimeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CAPTURE_TIME) != 0;
    }
  
    private boolean errorCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ERROR_COUNT) != 0;
    }
  
    private boolean transactionCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION_COUNT) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!captureTimeIsSet()) {
        attributes.add("captureTime");
      }
      if (!errorCountIsSet()) {
        attributes.add("errorCount");
      }
      if (!transactionCountIsSet()) {
        attributes.add("transactionCount");
      }
      return "Cannot build ErrorPoint, some of required attributes are not set " + attributes;
    }
  }
}
