package org.glowroot.collector;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.transaction.model.Transaction;

/**
 * Immutable implementation of {@link AggregateCollector.PendingTransactionBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code PendingTransaction.builder()}.
 * Use static factory method to create immutable instances:
 * {@code PendingTransaction.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AggregateCollector.PendingTransactionBase"})
@Immutable
final class PendingTransaction extends AggregateCollector.PendingTransactionBase {
  private final long captureTime;
  private final Transaction transaction;

  private PendingTransaction(long captureTime, Transaction transaction) {
    this.captureTime = captureTime;
    this.transaction = Preconditions.checkNotNull(transaction);
  }

  private PendingTransaction(PendingTransaction.Builder builder) {
    this.captureTime = builder.captureTime;
    this.transaction = builder.transaction;
  }

  private PendingTransaction(
      PendingTransaction original,
      long captureTime,
      Transaction transaction) {
    this.captureTime = captureTime;
    this.transaction = transaction;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code captureTime} attribute
   */
  @Override
  public long captureTime() {
    return captureTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transaction} attribute
   */
  @Override
  public Transaction transaction() {
    return transaction;
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateCollector.PendingTransactionBase#captureTime() captureTime}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for captureTime
   * @return modified copy of the {@code this} object
   */
  public final PendingTransaction withCaptureTime(long value) {
    if (this.captureTime == value) {
      return this;
    }
    long newValue = value;
    return new PendingTransaction(this, newValue, this.transaction);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateCollector.PendingTransactionBase#transaction() transaction}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transaction
   * @return modified copy of the {@code this} object
   */
  public final PendingTransaction withTransaction(Transaction value) {
    if (this.transaction == value) {
      return this;
    }
    Transaction newValue = Preconditions.checkNotNull(value);
    return new PendingTransaction(this, this.captureTime, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code PendingTransaction} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof PendingTransaction && equalTo((PendingTransaction) another));
  }
  
  private boolean equalTo(PendingTransaction another) {
    return captureTime == another.captureTime
        && transaction.equals(another.transaction);
  }
  
  /**
   * Computes hash code from attributes: {@code captureTime}, {@code transaction}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(captureTime);
    h = h * 17 + transaction.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code PendingTransaction{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PendingTransaction")
        .add("captureTime", captureTime)
        .add("transaction", transaction)
        .toString();
  }

  /**
   * Construct new immutable {@code PendingTransaction} instance.
   * @param captureTime value for {@code captureTime}
   * @param transaction value for {@code transaction}
   * @return immutable PendingTransaction instance
   */
  public static PendingTransaction of(long captureTime, Transaction transaction) {
    return new PendingTransaction(captureTime, transaction);
  }
  
  /**
   * Creates immutable copy of {@link AggregateCollector.PendingTransactionBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable PendingTransaction instance
   */
  static PendingTransaction copyOf(AggregateCollector.PendingTransactionBase instance) {
    if (instance instanceof PendingTransaction) {
      return (PendingTransaction) instance;
    }
    return PendingTransaction.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.collector.PendingTransaction}.
   * @return new PendingTransaction builder
   */
  static PendingTransaction.Builder builder() {
    return new PendingTransaction.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.collector.PendingTransaction}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_CAPTURE_TIME = 0x1L;
    private static final long INITIALIZED_BIT_TRANSACTION = 0x2L;
    private long initializedBitset;
  
    private long captureTime;
    private @Nullable Transaction transaction;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link AggregateCollector.PendingTransactionBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(AggregateCollector.PendingTransactionBase instance) {
      Preconditions.checkNotNull(instance);
      captureTime(instance.captureTime());
      transaction(instance.transaction());
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateCollector.PendingTransactionBase#captureTime() captureTime}.
     * @param captureTime value for captureTime
     * @return {@code this} builder for chained invocation
     */
    public final Builder captureTime(long captureTime) {
      this.captureTime = captureTime;
      initializedBitset |= INITIALIZED_BIT_CAPTURE_TIME;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateCollector.PendingTransactionBase#transaction() transaction}.
     * @param transaction value for transaction
     * @return {@code this} builder for chained invocation
     */
    public final Builder transaction(Transaction transaction) {
      this.transaction = Preconditions.checkNotNull(transaction);
      initializedBitset |= INITIALIZED_BIT_TRANSACTION;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.collector.PendingTransaction}.
     * @return immutable instance of PendingTransaction
     */
    public org.glowroot.collector.PendingTransaction build() {
      checkRequiredAttributes();
      return new PendingTransaction(this);
    }
  
    private boolean captureTimeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CAPTURE_TIME) != 0;
    }
  
    private boolean transactionIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!captureTimeIsSet()) {
        attributes.add("captureTime");
      }
      if (!transactionIsSet()) {
        attributes.add("transaction");
      }
      return "Cannot build PendingTransaction, some of required attributes are not set " + attributes;
    }
  }
}
