package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.primitives.Booleans;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link GeneralConfigBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code GeneralConfig.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "GeneralConfigBase"})
@Immutable
public final class GeneralConfig extends GeneralConfigBase {
  private final boolean enabled;
  private final int traceStoreThresholdMillis;
  private final int profilingIntervalMillis;
  private final String defaultDisplayedTransactionType;
  private final ImmutableList<Double> defaultDisplayedPercentiles;
  private final String version;

  private GeneralConfig(GeneralConfig.Builder builder) {
    this.enabled = builder.enabledIsSet()
        ? builder.enabled
        : super.enabled();
    this.traceStoreThresholdMillis = builder.traceStoreThresholdMillisIsSet()
        ? builder.traceStoreThresholdMillis
        : super.traceStoreThresholdMillis();
    this.profilingIntervalMillis = builder.profilingIntervalMillisIsSet()
        ? builder.profilingIntervalMillis
        : super.profilingIntervalMillis();
    this.defaultDisplayedTransactionType = builder.defaultDisplayedTransactionType != null
        ? builder.defaultDisplayedTransactionType
        : Preconditions.checkNotNull(super.defaultDisplayedTransactionType());
    this.defaultDisplayedPercentiles = builder.defaultDisplayedPercentiles != null
        ? builder.defaultDisplayedPercentiles
        : Preconditions.checkNotNull(super.defaultDisplayedPercentiles());
    this.version = Preconditions.checkNotNull(super.version());
  }

  private GeneralConfig(
      GeneralConfig original,
      boolean enabled,
      int traceStoreThresholdMillis,
      int profilingIntervalMillis,
      String defaultDisplayedTransactionType,
      ImmutableList<Double> defaultDisplayedPercentiles) {
    this.enabled = enabled;
    this.traceStoreThresholdMillis = traceStoreThresholdMillis;
    this.profilingIntervalMillis = profilingIntervalMillis;
    this.defaultDisplayedTransactionType = defaultDisplayedTransactionType;
    this.defaultDisplayedPercentiles = defaultDisplayedPercentiles;
    this.version = Preconditions.checkNotNull(super.version());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code enabled} attribute
   */
  @JsonProperty("enabled")
  @Override
  public boolean enabled() {
    return enabled;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceStoreThresholdMillis} attribute
   */
  @JsonProperty("traceStoreThresholdMillis")
  @Override
  public int traceStoreThresholdMillis() {
    return traceStoreThresholdMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code profilingIntervalMillis} attribute
   */
  @JsonProperty("profilingIntervalMillis")
  @Override
  public int profilingIntervalMillis() {
    return profilingIntervalMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code defaultDisplayedTransactionType} attribute
   */
  @JsonProperty("defaultDisplayedTransactionType")
  @Override
  public String defaultDisplayedTransactionType() {
    return defaultDisplayedTransactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code defaultDisplayedPercentiles} attribute
   */
  @JsonProperty("defaultDisplayedPercentiles")
  @Override
  public ImmutableList<Double> defaultDisplayedPercentiles() {
    return defaultDisplayedPercentiles;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code version} attribute
   */
  @JsonIgnore
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link GeneralConfigBase#enabled() enabled}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for enabled
   * @return modified copy of the {@code this} object
   */
  public final GeneralConfig withEnabled(boolean value) {
    if (this.enabled == value) {
      return this;
    }
    boolean newValue = value;
    return new GeneralConfig(
        this,
        newValue,
        this.traceStoreThresholdMillis,
        this.profilingIntervalMillis,
        this.defaultDisplayedTransactionType,
        this.defaultDisplayedPercentiles);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GeneralConfigBase#traceStoreThresholdMillis() traceStoreThresholdMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceStoreThresholdMillis
   * @return modified copy of the {@code this} object
   */
  public final GeneralConfig withTraceStoreThresholdMillis(int value) {
    if (this.traceStoreThresholdMillis == value) {
      return this;
    }
    int newValue = value;
    return new GeneralConfig(
        this,
        this.enabled,
        newValue,
        this.profilingIntervalMillis,
        this.defaultDisplayedTransactionType,
        this.defaultDisplayedPercentiles);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GeneralConfigBase#profilingIntervalMillis() profilingIntervalMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for profilingIntervalMillis
   * @return modified copy of the {@code this} object
   */
  public final GeneralConfig withProfilingIntervalMillis(int value) {
    if (this.profilingIntervalMillis == value) {
      return this;
    }
    int newValue = value;
    return new GeneralConfig(
        this,
        this.enabled,
        this.traceStoreThresholdMillis,
        newValue,
        this.defaultDisplayedTransactionType,
        this.defaultDisplayedPercentiles);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GeneralConfigBase#defaultDisplayedTransactionType() defaultDisplayedTransactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for defaultDisplayedTransactionType
   * @return modified copy of the {@code this} object
   */
  public final GeneralConfig withDefaultDisplayedTransactionType(String value) {
    if (this.defaultDisplayedTransactionType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new GeneralConfig(
        this,
        this.enabled,
        this.traceStoreThresholdMillis,
        this.profilingIntervalMillis,
        newValue,
        this.defaultDisplayedPercentiles);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GeneralConfigBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for defaultDisplayedPercentiles
   * @return modified copy of the {@code this} object
   */
  public final GeneralConfig withDefaultDisplayedPercentiles(ImmutableList<Double> value) {
    if (this.defaultDisplayedPercentiles == value) {
      return this;
    }
    ImmutableList<Double> newValue = Preconditions.checkNotNull(value);
    return new GeneralConfig(
        this,
        this.enabled,
        this.traceStoreThresholdMillis,
        this.profilingIntervalMillis,
        this.defaultDisplayedTransactionType,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code GeneralConfig} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof GeneralConfig && equalTo((GeneralConfig) another));
  }
  
  private boolean equalTo(GeneralConfig another) {
    return enabled == another.enabled
        && traceStoreThresholdMillis == another.traceStoreThresholdMillis
        && profilingIntervalMillis == another.profilingIntervalMillis
        && defaultDisplayedTransactionType.equals(another.defaultDisplayedTransactionType)
        && defaultDisplayedPercentiles.equals(another.defaultDisplayedPercentiles)
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code enabled}, {@code traceStoreThresholdMillis}, {@code profilingIntervalMillis}, {@code defaultDisplayedTransactionType}, {@code defaultDisplayedPercentiles}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Booleans.hashCode(enabled);
    h = h * 17 + traceStoreThresholdMillis;
    h = h * 17 + profilingIntervalMillis;
    h = h * 17 + defaultDisplayedTransactionType.hashCode();
    h = h * 17 + defaultDisplayedPercentiles.hashCode();
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code GeneralConfig{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GeneralConfig")
        .add("enabled", enabled)
        .add("traceStoreThresholdMillis", traceStoreThresholdMillis)
        .add("profilingIntervalMillis", profilingIntervalMillis)
        .add("defaultDisplayedTransactionType", defaultDisplayedTransactionType)
        .add("defaultDisplayedPercentiles", defaultDisplayedPercentiles)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static GeneralConfig fromAllAttributes(
      @JsonProperty("enabled") @Nullable Boolean enabled,
      @JsonProperty("traceStoreThresholdMillis") @Nullable Integer traceStoreThresholdMillis,
      @JsonProperty("profilingIntervalMillis") @Nullable Integer profilingIntervalMillis,
      @JsonProperty("defaultDisplayedTransactionType") @Nullable String defaultDisplayedTransactionType,
      @JsonProperty("defaultDisplayedPercentiles") @Nullable ImmutableList<Double> defaultDisplayedPercentiles) {
    GeneralConfig.Builder builder = GeneralConfig.builder();
    if (enabled != null) {
      builder.enabled(enabled);
    }
    if (traceStoreThresholdMillis != null) {
      builder.traceStoreThresholdMillis(traceStoreThresholdMillis);
    }
    if (profilingIntervalMillis != null) {
      builder.profilingIntervalMillis(profilingIntervalMillis);
    }
    if (defaultDisplayedTransactionType != null) {
      builder.defaultDisplayedTransactionType(defaultDisplayedTransactionType);
    }
    if (defaultDisplayedPercentiles != null) {
      builder.defaultDisplayedPercentiles(defaultDisplayedPercentiles);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link GeneralConfigBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable GeneralConfig instance
   */
  public static GeneralConfig copyOf(GeneralConfigBase instance) {
    if (instance instanceof GeneralConfig) {
      return (GeneralConfig) instance;
    }
    return GeneralConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.GeneralConfig}.
   * @return new GeneralConfig builder
   */
  public static GeneralConfig.Builder builder() {
    return new GeneralConfig.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.GeneralConfig}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long NONDEFAULT_BIT_ENABLED = 0x1L;
    private static final long NONDEFAULT_BIT_TRACE_STORE_THRESHOLD_MILLIS = 0x2L;
    private static final long NONDEFAULT_BIT_PROFILING_INTERVAL_MILLIS = 0x4L;
    private long nondefaultBitset;
  
    private boolean enabled;
    private int traceStoreThresholdMillis;
    private int profilingIntervalMillis;
    private @Nullable String defaultDisplayedTransactionType;
    private @Nullable ImmutableList<Double> defaultDisplayedPercentiles;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link GeneralConfigBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(GeneralConfigBase instance) {
      Preconditions.checkNotNull(instance);
      enabled(instance.enabled());
      traceStoreThresholdMillis(instance.traceStoreThresholdMillis());
      profilingIntervalMillis(instance.profilingIntervalMillis());
      defaultDisplayedTransactionType(instance.defaultDisplayedTransactionType());
      defaultDisplayedPercentiles(instance.defaultDisplayedPercentiles());
      return this;
    }
  
    /**
     * Initializes value for {@link GeneralConfigBase#enabled() enabled}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link GeneralConfigBase#enabled() enabled}.</em>
     * @param enabled value for enabled
     * @return {@code this} builder for chained invocation
     */
    public final Builder enabled(boolean enabled) {
      this.enabled = enabled;
      nondefaultBitset |= NONDEFAULT_BIT_ENABLED;
      return this;
    }
  
    /**
     * Initializes value for {@link GeneralConfigBase#traceStoreThresholdMillis() traceStoreThresholdMillis}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link GeneralConfigBase#traceStoreThresholdMillis() traceStoreThresholdMillis}.</em>
     * @param traceStoreThresholdMillis value for traceStoreThresholdMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceStoreThresholdMillis(int traceStoreThresholdMillis) {
      this.traceStoreThresholdMillis = traceStoreThresholdMillis;
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_STORE_THRESHOLD_MILLIS;
      return this;
    }
  
    /**
     * Initializes value for {@link GeneralConfigBase#profilingIntervalMillis() profilingIntervalMillis}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link GeneralConfigBase#profilingIntervalMillis() profilingIntervalMillis}.</em>
     * @param profilingIntervalMillis value for profilingIntervalMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder profilingIntervalMillis(int profilingIntervalMillis) {
      this.profilingIntervalMillis = profilingIntervalMillis;
      nondefaultBitset |= NONDEFAULT_BIT_PROFILING_INTERVAL_MILLIS;
      return this;
    }
  
    /**
     * Initializes value for {@link GeneralConfigBase#defaultDisplayedTransactionType() defaultDisplayedTransactionType}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link GeneralConfigBase#defaultDisplayedTransactionType() defaultDisplayedTransactionType}.</em>
     * @param defaultDisplayedTransactionType value for defaultDisplayedTransactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder defaultDisplayedTransactionType(String defaultDisplayedTransactionType) {
      this.defaultDisplayedTransactionType = Preconditions.checkNotNull(defaultDisplayedTransactionType);
      return this;
    }
  
    /**
     * Initializes value for {@link GeneralConfigBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link GeneralConfigBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles}.</em>
     * @param defaultDisplayedPercentiles value for defaultDisplayedPercentiles
     * @return {@code this} builder for chained invocation
     */
    public final Builder defaultDisplayedPercentiles(ImmutableList<Double> defaultDisplayedPercentiles) {
      this.defaultDisplayedPercentiles = Preconditions.checkNotNull(defaultDisplayedPercentiles);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.GeneralConfig}.
     * @return immutable instance of GeneralConfig
     */
    public GeneralConfig build() {
      return new GeneralConfig(this);
    }
  
    private boolean enabledIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_ENABLED) != 0;
    }
  
    private boolean traceStoreThresholdMillisIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRACE_STORE_THRESHOLD_MILLIS) != 0;
    }
  
    private boolean profilingIntervalMillisIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_PROFILING_INTERVAL_MILLIS) != 0;
    }
  }
}
