package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link GaugeJsonService.GaugeResponseBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code GaugeResponse.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "GaugeJsonService.GaugeResponseBase"})
@Immutable
final class GaugeResponse extends GaugeJsonService.GaugeResponseBase {
  private final GaugeConfigDto config;
  private final boolean mbeanUnavailable;
  private final boolean mbeanUnmatched;
  private final ImmutableList<String> mbeanAvailableAttributeNames;

  private GaugeResponse(GaugeResponse.Builder builder) {
    this.config = builder.config;
    this.mbeanAvailableAttributeNames = builder.mbeanAvailableAttributeNamesBuilder.build();
    this.mbeanUnavailable = builder.mbeanUnavailableIsSet()
        ? builder.mbeanUnavailable
        : super.mbeanUnavailable();
    this.mbeanUnmatched = builder.mbeanUnmatchedIsSet()
        ? builder.mbeanUnmatched
        : super.mbeanUnmatched();
  }

  private GaugeResponse(
      GaugeResponse original,
      GaugeConfigDto config,
      boolean mbeanUnavailable,
      boolean mbeanUnmatched,
      ImmutableList<String> mbeanAvailableAttributeNames) {
    this.config = config;
    this.mbeanUnavailable = mbeanUnavailable;
    this.mbeanUnmatched = mbeanUnmatched;
    this.mbeanAvailableAttributeNames = mbeanAvailableAttributeNames;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code config} attribute
   */
  @JsonProperty("config")
  @Override
  public GaugeConfigDto config() {
    return config;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code mbeanUnavailable} attribute
   */
  @JsonProperty("mbeanUnavailable")
  @Override
  public boolean mbeanUnavailable() {
    return mbeanUnavailable;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code mbeanUnmatched} attribute
   */
  @JsonProperty("mbeanUnmatched")
  @Override
  public boolean mbeanUnmatched() {
    return mbeanUnmatched;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code mbeanAvailableAttributeNames} attribute
   */
  @JsonProperty("mbeanAvailableAttributeNames")
  @Override
  public ImmutableList<String> mbeanAvailableAttributeNames() {
    return mbeanAvailableAttributeNames;
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeJsonService.GaugeResponseBase#config() config}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for config
   * @return modified copy of the {@code this} object
   */
  public final GaugeResponse withConfig(GaugeConfigDto value) {
    if (this.config == value) {
      return this;
    }
    GaugeConfigDto newValue = Preconditions.checkNotNull(value);
    return new GaugeResponse(this, newValue, this.mbeanUnavailable, this.mbeanUnmatched, this.mbeanAvailableAttributeNames);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeJsonService.GaugeResponseBase#mbeanUnavailable() mbeanUnavailable}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for mbeanUnavailable
   * @return modified copy of the {@code this} object
   */
  public final GaugeResponse withMbeanUnavailable(boolean value) {
    if (this.mbeanUnavailable == value) {
      return this;
    }
    boolean newValue = value;
    return new GaugeResponse(this, this.config, newValue, this.mbeanUnmatched, this.mbeanAvailableAttributeNames);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeJsonService.GaugeResponseBase#mbeanUnmatched() mbeanUnmatched}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for mbeanUnmatched
   * @return modified copy of the {@code this} object
   */
  public final GaugeResponse withMbeanUnmatched(boolean value) {
    if (this.mbeanUnmatched == value) {
      return this;
    }
    boolean newValue = value;
    return new GaugeResponse(this, this.config, this.mbeanUnavailable, newValue, this.mbeanAvailableAttributeNames);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link GaugeJsonService.GaugeResponseBase#mbeanAvailableAttributeNames() mbeanAvailableAttributeNames}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final GaugeResponse withMbeanAvailableAttributeNames(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new GaugeResponse(this, this.config, this.mbeanUnavailable, this.mbeanUnmatched, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link GaugeJsonService.GaugeResponseBase#mbeanAvailableAttributeNames() mbeanAvailableAttributeNames}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of mbeanAvailableAttributeNames elements to set
   * @return modified copy of {@code this} object
   */
  public final GaugeResponse withMbeanAvailableAttributeNames(Iterable<String> elements) {
    if (this.mbeanAvailableAttributeNames == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new GaugeResponse(this, this.config, this.mbeanUnavailable, this.mbeanUnmatched, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code GaugeResponse} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof GaugeResponse && equalTo((GaugeResponse) another));
  }
  
  private boolean equalTo(GaugeResponse another) {
    return config.equals(another.config)
        && mbeanUnavailable == another.mbeanUnavailable
        && mbeanUnmatched == another.mbeanUnmatched
        && mbeanAvailableAttributeNames.equals(another.mbeanAvailableAttributeNames);
  }
  
  /**
   * Computes hash code from attributes: {@code config}, {@code mbeanUnavailable}, {@code mbeanUnmatched}, {@code mbeanAvailableAttributeNames}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + config.hashCode();
    h = h * 17 + Booleans.hashCode(mbeanUnavailable);
    h = h * 17 + Booleans.hashCode(mbeanUnmatched);
    h = h * 17 + mbeanAvailableAttributeNames.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code GaugeResponse{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GaugeResponse")
        .add("config", config)
        .add("mbeanUnavailable", mbeanUnavailable)
        .add("mbeanUnmatched", mbeanUnmatched)
        .add("mbeanAvailableAttributeNames", mbeanAvailableAttributeNames)
        .toString();
  }
  
  @JsonCreator
  public static GaugeResponse fromAllAttributes(
      @JsonProperty("config") @Nullable GaugeConfigDto config,
      @JsonProperty("mbeanUnavailable") @Nullable Boolean mbeanUnavailable,
      @JsonProperty("mbeanUnmatched") @Nullable Boolean mbeanUnmatched,
      @JsonProperty("mbeanAvailableAttributeNames") @Nullable ImmutableList<String> mbeanAvailableAttributeNames) {
    GaugeResponse.Builder builder = GaugeResponse.builder();
    if (config != null) {
      builder.config(config);
    }
    if (mbeanUnavailable != null) {
      builder.mbeanUnavailable(mbeanUnavailable);
    }
    if (mbeanUnmatched != null) {
      builder.mbeanUnmatched(mbeanUnmatched);
    }
    if (mbeanAvailableAttributeNames != null) {
      builder.addAllMbeanAvailableAttributeNames(mbeanAvailableAttributeNames);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link GaugeJsonService.GaugeResponseBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable GaugeResponse instance
   */
  static GaugeResponse copyOf(GaugeJsonService.GaugeResponseBase instance) {
    if (instance instanceof GaugeResponse) {
      return (GaugeResponse) instance;
    }
    return GaugeResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.GaugeResponse}.
   * @return new GaugeResponse builder
   */
  static GaugeResponse.Builder builder() {
    return new GaugeResponse.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.GaugeResponse}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_CONFIG = 0x1L;
    private static final long NONDEFAULT_BIT_MBEAN_UNAVAILABLE = 0x1L;
    private static final long NONDEFAULT_BIT_MBEAN_UNMATCHED = 0x2L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private @Nullable GaugeConfigDto config;
    private boolean mbeanUnavailable;
    private boolean mbeanUnmatched;
    private ImmutableList.Builder<String> mbeanAvailableAttributeNamesBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link GaugeJsonService.GaugeResponseBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(GaugeJsonService.GaugeResponseBase instance) {
      Preconditions.checkNotNull(instance);
      config(instance.config());
      mbeanUnavailable(instance.mbeanUnavailable());
      mbeanUnmatched(instance.mbeanUnmatched());
      addAllMbeanAvailableAttributeNames(instance.mbeanAvailableAttributeNames());
      return this;
    }
  
    /**
     * Initializes value for {@link GaugeJsonService.GaugeResponseBase#config() config}.
     * @param config value for config
     * @return {@code this} builder for chained invocation
     */
    public final Builder config(GaugeConfigDto config) {
      this.config = Preconditions.checkNotNull(config);
      initializedBitset |= INITIALIZED_BIT_CONFIG;
      return this;
    }
  
    /**
     * Initializes value for {@link GaugeJsonService.GaugeResponseBase#mbeanUnavailable() mbeanUnavailable}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link GaugeJsonService.GaugeResponseBase#mbeanUnavailable() mbeanUnavailable}.</em>
     * @param mbeanUnavailable value for mbeanUnavailable
     * @return {@code this} builder for chained invocation
     */
    public final Builder mbeanUnavailable(boolean mbeanUnavailable) {
      this.mbeanUnavailable = mbeanUnavailable;
      nondefaultBitset |= NONDEFAULT_BIT_MBEAN_UNAVAILABLE;
      return this;
    }
  
    /**
     * Initializes value for {@link GaugeJsonService.GaugeResponseBase#mbeanUnmatched() mbeanUnmatched}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link GaugeJsonService.GaugeResponseBase#mbeanUnmatched() mbeanUnmatched}.</em>
     * @param mbeanUnmatched value for mbeanUnmatched
     * @return {@code this} builder for chained invocation
     */
    public final Builder mbeanUnmatched(boolean mbeanUnmatched) {
      this.mbeanUnmatched = mbeanUnmatched;
      nondefaultBitset |= NONDEFAULT_BIT_MBEAN_UNMATCHED;
      return this;
    }
  
    /**
     * Adds one element to {@link GaugeJsonService.GaugeResponseBase#mbeanAvailableAttributeNames() mbeanAvailableAttributeNames} list.
     * @param element mbeanAvailableAttributeNames element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMbeanAvailableAttributeNames(String element) {
      mbeanAvailableAttributeNamesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link GaugeJsonService.GaugeResponseBase#mbeanAvailableAttributeNames() mbeanAvailableAttributeNames} list.
     * @param elements array of mbeanAvailableAttributeNames elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMbeanAvailableAttributeNames(String... elements) {
      mbeanAvailableAttributeNamesBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link GaugeJsonService.GaugeResponseBase#mbeanAvailableAttributeNames() mbeanAvailableAttributeNames} list.
     * @param elements iterable of mbeanAvailableAttributeNames elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder mbeanAvailableAttributeNames(Iterable<String> elements) {
      mbeanAvailableAttributeNamesBuilder = ImmutableList.builder();
      return addAllMbeanAvailableAttributeNames(elements);
    }
  
    /**
     * Adds elements to {@link GaugeJsonService.GaugeResponseBase#mbeanAvailableAttributeNames() mbeanAvailableAttributeNames} list.
     * @param elements iterable of mbeanAvailableAttributeNames elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllMbeanAvailableAttributeNames(Iterable<String> elements) {
      mbeanAvailableAttributeNamesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.GaugeResponse}.
     * @return immutable instance of GaugeResponse
     */
    public org.glowroot.local.ui.GaugeResponse build() {
      checkRequiredAttributes();
      return new GaugeResponse(this);
    }
  
    private boolean mbeanUnavailableIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_MBEAN_UNAVAILABLE) != 0;
    }
  
    private boolean mbeanUnmatchedIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_MBEAN_UNMATCHED) != 0;
    }
  
    private boolean configIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CONFIG) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!configIsSet()) {
        attributes.add("config");
      }
      return "Cannot build GaugeResponse, some of required attributes are not set " + attributes;
    }
  }
}
